/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.jboogie.util;

import com.gentleware.jboogie.util.LockChecker;
import com.gentleware.openapi.jboogie.SmId;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class ConflictChecker {
    private static final Logger B = Logger.getLogger((String)"com.gentleware.jboogie.util.ConflictChecker");
    public static int CREATE;
    public static int CHANGE;
    public static int DELETE;
    private LockChecker C;
    private String D;
    private boolean A = true;

    public void activate() {
        B.info((Object)"Conflict-Checking activated");
        this.A = true;
    }

    public void deactivate() {
        B.info((Object)"Conflict-Checking deactivated");
        this.A = false;
    }

    public final boolean doesConflict(int n2, SmId smId) {
        if (!this.A) {
            return false;
        }
        return this.doesConflictInternal(n2, smId);
    }

    public boolean doesConflictWithCurrentModel(Set set) {
        LockChecker lockChecker = this.getLockChecker();
        if (lockChecker.indicatesLocks()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                SmId smId = (SmId)iterator.next();
                if (!smId.hasElement() || this.D == null || !lockChecker.isRemotelyLocked(this.D, smId)) continue;
                B.info((Object)("Command " + this + " can't be executed, because the element " + smId.getElement() + "is locked! "));
                return true;
            }
        }
        return false;
    }

    protected boolean doesConflictInternal(int n2, SmId smId) {
        if (smId != null && !smId.hasElement()) {
            B.info((Object)("smid " + smId + " has no element!" + smId.getXmiId()));
            return true;
        }
        if (this.C != null) {
            boolean bl = this.C.isRemotelyLocked(this.D, smId);
            if (bl) {
                B.info((Object)("Lock conflict detected: Modelelement " + smId.getElement() + " is locked! Requestor is " + this.D + ", but lockholder is someone else "));
            }
            return bl;
        }
        return false;
    }

    public void setLockChecker(LockChecker lockChecker) {
        this.C = lockChecker;
    }

    public LockChecker getLockChecker() {
        return this.C;
    }

    public void setParticipantId(String string) {
        this.D = string;
    }

    public String getParticipantId() {
        return this.D;
    }

    public boolean isActive() {
        return this.A;
    }

    static {
        CHANGE = 1;
        DELETE = 2;
    }
}

