/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.jboogie.util;

import com.gentleware.jboogie.layout.LayoutValidator;
import com.gentleware.jboogie.model_management.DiAccessory;
import com.gentleware.jboogie.renderer.SceneGraphValidator;
import com.gentleware.jboogie.util.DiPulizeHelpers;
import com.gentleware.mdr.RepositoryHelper;
import com.gentleware.openapi.jboogie.DiId;
import com.gentleware.openapi.jboogie.Project;
import com.gentleware.openapi.util.CollectionFactory;
import java.util.Collection;
import java.util.List;
import javax.jmi.reflect.InvalidObjectException;
import javax.jmi.reflect.RefBaseObject;
import javax.jmi.reflect.RefObject;
import org.apache.log4j.Logger;
import org.netbeans.jmiimpl.omg.uml2.diagraminterchange.DiagramElementImpl;
import org.netbeans.jmiimpl.omg.uml2.diagraminterchange.GraphElementImpl;
import org.omg.uml2.diagraminterchange.DiagramElement;

public abstract class DiPulizer {
    private static final Logger A = Logger.getLogger((String)"com.gentleware.jboogie.util.DiPulizer");
    final Project _project;

    public abstract boolean shouldCreateDi(DiagramElement var1, RefObject var2);

    public abstract void updateSingleDi(GraphElementImpl var1, boolean var2);

    public abstract DiPulizeHelpers getDiPulizeHelpers();

    protected DiPulizer(Project project) {
        this._project = project;
    }

    protected Project getProject() {
        return this._project;
    }

    public final void updateAllDi(RefObject refObject) {
        Collection collection = DiAccessory.getDiElementsToDiPulize(this._project, refObject);
        List list = CollectionFactory.createArrayList((Collection)collection);
        Object object = list.iterator();
        while (object.hasNext()) {
            try {
                GraphElementImpl graphElementImpl = (GraphElementImpl)object.next();
                boolean bl = this._project.getType().showDiagramElementAsName(graphElementImpl);
                if (bl) continue;
                this.updateSingleDi(graphElementImpl, false);
            }
            catch (InvalidObjectException invalidObjectException) {
                A.error((Object)"Trying to dipulize an invalid object!", (Throwable)invalidObjectException);
            }
        }
        object = this.getDiPulizeHelpers();
        ((DiPulizeHelpers)object).updateAllRenderer(refObject);
    }

    public static void updateSingleDiAndRenderer(Project project, DiagramElementImpl diagramElementImpl) {
        RefObject refObject = DiAccessory.getElementToDiPulize(diagramElementImpl);
        DiPulizer diPulizer = project.getDiPulizerPool().getDiPulizerFor(refObject);
        diPulizer.updateSingleDiAndRenderer(diagramElementImpl);
    }

    public void updateSingleDiAndRenderer(DiagramElementImpl diagramElementImpl) {
        this.updateSingleDi((GraphElementImpl)diagramElementImpl, true);
        if (RepositoryHelper.isElementStillValid((RefBaseObject)diagramElementImpl)) {
            Project project = this.getProject();
            SceneGraphValidator sceneGraphValidator = project.getSceneGraphValidator();
            sceneGraphValidator.invalidateDiElement(diagramElementImpl, true);
            LayoutValidator layoutValidator = project.getLayoutValidator();
            layoutValidator.setLayoutInvalid(diagramElementImpl);
        }
    }

    protected final DiId getNextDiId() {
        return DiPulizeHelpers.getNextDiId(this.getProject());
    }
}

