/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.jboogie.util.graphicswriter;

import Acme.JPM.Encoders.GifEncoder;
import com.gentleware.jboogie.kernel.FileFormatsResourceBundle;
import com.gentleware.jboogie.util.graphicswriter.C;
import com.gentleware.jboogie.util.graphicswriter.GraphicsWriter;
import com.gentleware.openapi.swingx.ResourceId;
import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.io.IOException;
import java.io.OutputStream;

public class GifWriter
extends GraphicsWriter {
    public static final int TRANSPARENT_BG_COLOR = 0xEFEFEF;

    public void write(OutputStream outputStream, PCanvas pCanvas, Rectangle rectangle) throws GraphicsWriter.WriteException {
        BufferedImage bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        try {
            graphics2D.setClip(0, 0, rectangle.width, rectangle.height);
            graphics2D.setColor(new Color(0xEFEFEF));
            graphics2D.fillRect(0, 0, rectangle.width, rectangle.height);
            graphics2D.translate(-rectangle.x, -rectangle.y);
            PPaintContext pPaintContext = new PPaintContext(graphics2D);
            PCamera pCamera = pCanvas.getCamera();
            pPaintContext.pushCamera(pCamera);
            pCamera.fullPaint(pPaintContext);
            FilteredImageSource filteredImageSource = new FilteredImageSource(bufferedImage.getSource(), new C(0xEFEFEF));
            GifEncoder gifEncoder = new GifEncoder(filteredImageSource, outputStream);
            gifEncoder.encode();
        }
        catch (IOException iOException) {
            throw new GraphicsWriter.WriteException(iOException);
        }
        finally {
            graphics2D.dispose();
        }
    }

    public String getFormatName() {
        return "CompuServe Graphics Interchange";
    }

    public ResourceId getFormatNameResourceId() {
        return FileFormatsResourceBundle.GIF;
    }

    public String getDefaultFileSuffix() {
        return "gif";
    }
}

