/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jmiimpl.omg.uml2.diagraminterchange;

import com.gentleware.jboogie.kernel.ProjectImpl;
import com.gentleware.jboogie.layout.LayoutableConnector;
import com.gentleware.jboogie.layout.LayoutableEdge;
import com.gentleware.jboogie.layout.LayoutableEdges;
import com.gentleware.jboogie.model_management.DiAccessory;
import com.gentleware.jboogie.util.DiMemento;
import com.gentleware.jboogie.util.JBoogieUtils;
import com.gentleware.jboogie.util.SPoint2DDouble;
import com.gentleware.openapi.jboogie.DiId;
import com.gentleware.openapi.jboogie.Project;
import com.gentleware.openapi.util.CollectionFactory;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.jmi.reflect.RefObject;
import org.netbeans.jmiimpl.omg.uml2.diagraminterchange.GraphElementImpl;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.omg.uml2.diagraminterchange.BezierPoint;
import org.omg.uml2.diagraminterchange.DiagramInterchangePackage;
import org.omg.uml2.diagraminterchange.GraphConnector;
import org.omg.uml2.diagraminterchange.GraphEdge;
import org.omg.uml2.diagraminterchange.Point;

public abstract class GraphEdgeImpl
extends GraphElementImpl
implements GraphEdge,
LayoutableEdge {
    protected GraphEdgeImpl(StorableObject storableObject) {
        super(storableObject);
    }

    public int getWaypointCount() {
        return this.getWaypoints().size();
    }

    public double getWaypointX(int n2) {
        int n3 = LayoutableEdges.getPositiveWaypointIndex(this, n2);
        BezierPoint bezierPoint = (BezierPoint)this.getWaypoints().get(n3);
        return bezierPoint.getBase().getX();
    }

    public double getWaypointY(int n2) {
        int n3 = LayoutableEdges.getPositiveWaypointIndex(this, n2);
        BezierPoint bezierPoint = (BezierPoint)this.getWaypoints().get(n3);
        return bezierPoint.getBase().getY();
    }

    public void removeWaypoint(int n2) {
        int n3 = LayoutableEdges.getPositiveWaypointIndex(this, n2);
        List list = this.getWaypoints();
        list.remove(n3);
        LayoutableEdge layoutableEdge = (LayoutableEdge)this.getPiccoloElement();
        if (layoutableEdge != null) {
            layoutableEdge.removeWaypoint(n3);
        }
    }

    public void addWaypoint(int n2, double d2, double d3) {
        int n3 = LayoutableEdges.getPositiveWaypointIndex(this, n2);
        double d4 = GraphEdgeImpl.round(d2);
        double d5 = GraphEdgeImpl.round(d3);
        BezierPoint bezierPoint = this.makeBezierPoint(d4, d5);
        this.getWaypoints().add(n3, bezierPoint);
        LayoutableEdge layoutableEdge = (LayoutableEdge)this.getPiccoloElement();
        if (layoutableEdge != null) {
            layoutableEdge.addWaypoint(n3, d4, d5);
        }
    }

    public void setWaypoint(int n2, double d2, double d3) {
        int n3 = LayoutableEdges.getPositiveWaypointIndex(this, n2);
        double d4 = GraphEdgeImpl.round(d2);
        double d5 = GraphEdgeImpl.round(d3);
        BezierPoint bezierPoint = this.makeBezierPoint(d4, d5);
        this.getWaypoints().set(n3, bezierPoint);
        LayoutableEdge layoutableEdge = (LayoutableEdge)this.getPiccoloElement();
        if (layoutableEdge != null) {
            layoutableEdge.setWaypoint(n3, d4, d5);
        }
    }

    public void setWaypoints(Point2D[] point2DArray) {
        List list = this.getWaypoints();
        list.clear();
        for (int i2 = 0; i2 < point2DArray.length; ++i2) {
            double d2 = GraphEdgeImpl.round(point2DArray[i2].getX());
            double d3 = GraphEdgeImpl.round(point2DArray[i2].getY());
            BezierPoint bezierPoint = this.makeBezierPoint(d2, d3);
            this.getWaypoints().add(bezierPoint);
        }
        LayoutableEdge layoutableEdge = (LayoutableEdge)this.getPiccoloElement();
        if (layoutableEdge != null) {
            layoutableEdge.setWaypoints(point2DArray);
        }
    }

    public LayoutableConnector getSourceConnector() {
        if (this.getAnchor().size() < 1) {
            return null;
        }
        return (LayoutableConnector)this.getAnchor().get(0);
    }

    public LayoutableConnector getTargetConnector() {
        if (this.getAnchor().size() < 2) {
            return null;
        }
        return (LayoutableConnector)this.getAnchor().get(1);
    }

    protected String getParamString() {
        StringBuffer stringBuffer = new StringBuffer(super.getParamString());
        stringBuffer.append(", anchors={");
        List list = this.getAnchor();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            GraphConnector graphConnector = (GraphConnector)list.get(i2);
            if (i2 > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(JBoogieUtils.getShortInstanceId(graphConnector));
        }
        stringBuffer.append("}, waypoints=");
        List list2 = this.getWaypoints();
        for (int i3 = 0; i3 < list2.size(); ++i3) {
            BezierPoint bezierPoint = (BezierPoint)list2.get(i3);
            stringBuffer.append("(");
            stringBuffer.append(bezierPoint.getBase().getX());
            stringBuffer.append(", ");
            stringBuffer.append(bezierPoint.getBase().getY());
            stringBuffer.append(")");
        }
        return new String(stringBuffer);
    }

    public DiMemento getLayoutMemento(Project project) {
        return new FullMemento(project, this);
    }

    public DiMemento getLayoutMemento(Project project, DiId diId, DiId diId2) {
        return new FullMemento(project, this, diId, diId2);
    }

    public List getAnchors() {
        List list = this.getAnchor();
        List list2 = CollectionFactory.createArrayList();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            GraphConnector graphConnector = (GraphConnector)list.get(i2);
            list2.add(graphConnector.getGraphElement());
        }
        return list2;
    }

    public static class FullMemento
    extends GraphElementImpl.FullMemento
    implements Serializable {
        private transient Point2D.Double[] V;
        private transient Point2D.Double[] U;
        private transient Point2D.Double[] S;
        private SPoint2DDouble[] T;
        private SPoint2DDouble[] R;
        private SPoint2DDouble[] W;

        public void serialize() {
            super.serialize();
            this.W = JBoogieUtils.transform(this.V);
            this.R = JBoogieUtils.transform(this.U);
            this.T = JBoogieUtils.transform(this.S);
        }

        public void deserialize(ProjectImpl projectImpl) {
            super.deserialize(projectImpl);
            this.V = JBoogieUtils.transformBack(this.W);
            this.U = JBoogieUtils.transformBack(this.R);
            this.S = JBoogieUtils.transformBack(this.T);
        }

        public FullMemento(Project project, GraphEdgeImpl graphEdgeImpl) {
            super(project, graphEdgeImpl);
            this.A(graphEdgeImpl);
        }

        public FullMemento(Project project, GraphEdgeImpl graphEdgeImpl, DiId diId, DiId diId2) {
            super(project, graphEdgeImpl, diId, diId2);
            this.A(graphEdgeImpl);
        }

        private FullMemento(DiId diId) {
            super(diId);
        }

        protected void cloneProperties(FullMemento fullMemento) {
            super.cloneProperties(fullMemento);
            fullMemento.V = this.V;
            fullMemento.U = this.U;
            fullMemento.S = this.S;
        }

        public DiMemento cloneMemento() {
            FullMemento fullMemento = new FullMemento(this.getDiId());
            this.cloneProperties(fullMemento);
            return fullMemento;
        }

        private void A(GraphEdgeImpl graphEdgeImpl) {
            List list = graphEdgeImpl.getWaypoints();
            this.V = new Point2D.Double[list.size()];
            this.U = new Point2D.Double[list.size()];
            this.S = new Point2D.Double[list.size()];
            for (int i2 = 0; i2 < list.size(); ++i2) {
                BezierPoint bezierPoint = (BezierPoint)list.get(i2);
                Point point = bezierPoint.getBase();
                Point point2 = bezierPoint.getControl1();
                Point point3 = bezierPoint.getControl2();
                this.V[i2] = new Point2D.Double(point.getX(), point.getY());
                this.U[i2] = new Point2D.Double(point2.getX(), point2.getY());
                this.S[i2] = new Point2D.Double(point3.getX(), point3.getY());
            }
        }

        public void cloneDiId(Map map) {
            super.cloneDiId(map);
        }

        protected void restore(RefObject refObject) {
            super.restore(refObject);
            GraphEdgeImpl graphEdgeImpl = (GraphEdgeImpl)refObject;
            DiAccessory diAccessory = this.getProject().getDiAccessory();
            DiagramInterchangePackage diagramInterchangePackage = diAccessory.getDiagramInterchangePackage();
            List list = graphEdgeImpl.getWaypoints();
            list.clear();
            for (int i2 = 0; i2 < this.V.length; ++i2) {
                Point2D.Double double_ = this.V[i2];
                Point2D.Double double_2 = this.U[i2];
                Point2D.Double double_3 = this.S[i2];
                Point point = diagramInterchangePackage.createPoint(double_.getX(), double_.getY());
                Point point2 = diagramInterchangePackage.createPoint(double_2.getX(), double_2.getY());
                Point point3 = diagramInterchangePackage.createPoint(double_3.getX(), double_3.getY());
                list.add(diagramInterchangePackage.createBezierPoint(point, point2, point3));
            }
        }

        protected RefObject createElement(Project project) {
            DiAccessory diAccessory = project.getDiAccessory();
            DiagramInterchangePackage diagramInterchangePackage = diAccessory.getDiagramInterchangePackage();
            GraphEdge graphEdge = diagramInterchangePackage.getGraphEdge().createGraphEdge();
            return graphEdge;
        }
    }
}

