/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.treeview.base;

import com.gentleware.treeview.base.TreePerspective;
import com.gentleware.treeview.base.TreeViewModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public abstract class AbstractTreeModel
implements TreeViewModel {
    private static final Logger A = Logger.getLogger("com.gentleware.poseidon.ui.treeview.AbstractTreeModel");
    protected EventListenerList listeners = new EventListenerList();
    private static Class B;

    public abstract void setPerspective(TreePerspective var1);

    public abstract TreePerspective getPerspective();

    protected AbstractTreeModel() {
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listeners.add(B == null ? (B = AbstractTreeModel.A("javax.swing.event.TreeModelListener")) : B, treeModelListener);
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listeners.remove(B == null ? (B = AbstractTreeModel.A("javax.swing.event.TreeModelListener")) : B, treeModelListener);
    }

    public synchronized void fireNewRoot() {
        Object[] objectArray = this.listeners.getListenerList();
        Object object = this.getRoot();
        if (object == null) {
            return;
        }
        TreePath treePath = new TreePath(object);
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath, null, null);
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != (B == null ? AbstractTreeModel.A("javax.swing.event.TreeModelListener") : B) || objectArray.length <= i2 + 1) continue;
            ((TreeModelListener)objectArray[i2 + 1]).treeStructureChanged(treeModelEvent);
        }
    }

    public synchronized void fireStructureChanged() {
        this.fireTreeStructureChanged(new TreePath(this.getRoot()));
    }

    public synchronized void fireTreeStructureChanged(TreePath treePath) {
        Object[] objectArray = this.listeners.getListenerList();
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath, null, null);
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != (B == null ? AbstractTreeModel.A("javax.swing.event.TreeModelListener") : B) || objectArray.length <= i2 + 1) continue;
            ((TreeModelListener)objectArray[i2 + 1]).treeStructureChanged(treeModelEvent);
        }
    }

    public synchronized void fireChildAdded(TreePath treePath, TreeNode treeNode, int n) {
        this.fireChildrenAdded(treePath, new TreeNode[]{treeNode}, new int[]{n});
    }

    public synchronized void fireChildChanged(TreePath treePath, TreeNode treeNode, int n) {
        this.fireChildrenChanged(treePath, new TreeNode[]{treeNode}, new int[]{n});
    }

    public synchronized void fireChildRemoved(TreePath treePath, TreeNode treeNode, int n) {
        this.fireChildrenRemoved(treePath, new TreeNode[]{treeNode}, new int[]{n});
    }

    public synchronized void fireChildrenAdded(TreePath treePath, TreeNode[] treeNodeArray, int[] nArray) {
        Object[] objectArray = this.listeners.getListenerList();
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath, nArray, (Object[])treeNodeArray);
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != (B == null ? AbstractTreeModel.A("javax.swing.event.TreeModelListener") : B) || objectArray.length <= i2 + 1) continue;
            ((TreeModelListener)objectArray[i2 + 1]).treeNodesInserted(treeModelEvent);
        }
    }

    public synchronized void fireChildrenChanged(TreePath treePath, TreeNode[] treeNodeArray, int[] nArray) {
        Object[] objectArray = this.listeners.getListenerList();
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath, nArray, (Object[])treeNodeArray);
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != (B == null ? AbstractTreeModel.A("javax.swing.event.TreeModelListener") : B) || objectArray.length <= i2 + 1) continue;
            try {
                ((TreeModelListener)objectArray[i2 + 1]).treeNodesChanged(treeModelEvent);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                A.debug("(ArrayIndexOutOfBoundsException in the tree model)");
            }
        }
    }

    public synchronized void fireChildrenRemoved(TreePath treePath, TreeNode[] treeNodeArray, int[] nArray) {
        Object[] objectArray = this.listeners.getListenerList();
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath, nArray, (Object[])treeNodeArray);
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != (B == null ? AbstractTreeModel.A("javax.swing.event.TreeModelListener") : B) || objectArray.length <= i2 + 1) continue;
            try {
                ((TreeModelListener)objectArray[i2 + 1]).treeNodesRemoved(treeModelEvent);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                A.info("HandleRemoveEvent caused an ArrayIndexOutOfBoundsException. This is normal when multiple listeners try to delete.");
            }
        }
    }

    private static Class A(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

