/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.treeview.base;

import com.gentleware.openapi.swingx.ResourceId;
import com.gentleware.openapi.util.CollectionFactory;
import com.gentleware.treeview.base.DefaultTreeViewModel;
import com.gentleware.treeview.base.E;
import com.gentleware.treeview.base.TreeExpandStrategy;
import com.gentleware.treeview.base.TreePerspective;
import com.gentleware.treeview.base.TreeView;
import com.gentleware.treeview.base.TreeViewEditor;
import com.gentleware.treeview.base.TreeViewModel;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class DefaultTreePerspective
extends TreePerspective {
    private static final Logger Q = Logger.getLogger("com.gentleware.poseidon.ui.treeview.DefaultTreePerspective");
    private Map I = CollectionFactory.createHashMap();
    private Map K = CollectionFactory.createHashMap();
    private WeakHashMap G = CollectionFactory.createWeakHashMap();
    private Map N = CollectionFactory.createHashMap();
    private Map L = CollectionFactory.createHashMap();
    private WeakHashMap F = CollectionFactory.createWeakHashMap();
    private TreeCellRenderer O;
    private TreeViewEditor E;
    private String P;
    private ResourceId J;
    private Class H;
    private TreeExpandStrategy M = new E();

    public DefaultTreePerspective(String string, ResourceId resourceId, Class clazz, TreeCellRenderer treeCellRenderer, TreeViewEditor treeViewEditor) {
        this.P = string;
        this.J = resourceId;
        this.H = clazz;
        this.O = treeCellRenderer;
        this.E = treeViewEditor;
    }

    public DefaultTreePerspective(String string, ResourceId resourceId, TreeCellRenderer treeCellRenderer, Class clazz) {
        this(string, resourceId, clazz, treeCellRenderer, null);
    }

    public String getName() {
        return this.P;
    }

    public ResourceId getTreeResourceId() {
        return this.J;
    }

    public Class getRootClass() {
        return this.H;
    }

    public void addFilter(Class clazz, TreePerspective.Filter filter) {
        this.I.put(clazz, filter);
        this.G.clear();
    }

    public void addFilter(String string, TreePerspective.Filter filter) {
        this.K.put(string, filter);
        this.G.clear();
    }

    public void addView(Class clazz, Object object) {
        this.A(object);
        this.N.put(clazz, object);
        this.F.clear();
    }

    public Object getView(Class clazz) {
        return this.N.get(clazz);
    }

    public void addView(String string, Object object) {
        this.A(object);
        this.L.put(string, object);
        this.F.clear();
    }

    private void A(Object object) {
        if (object != null && !(object instanceof TreeView)) {
            throw new IllegalArgumentException("DefaultTreePerspective:addView viewClass must be derived from TreeView");
        }
    }

    public void removeView(Class clazz) {
        this.N.remove(clazz);
        this.F.clear();
    }

    public TreeView createViewFor(Object object, TreeView treeView, TreeViewModel treeViewModel) {
        TreeView treeView2;
        if ((treeView == null || treeView.shouldElementBeViewed(object)) && (treeView2 = this.getViewFor(object)) != null) {
            try {
                TreeView treeView3 = (TreeView)treeView2.clone();
                treeView3.setViewedObject(object);
                treeView3.setParent(treeView);
                treeView3.setTreeModel(treeViewModel);
                return treeView3;
            }
            catch (Exception exception) {
                Q.debug("[DefaultTreePerspective.createViewFor] ", exception);
            }
        }
        return null;
    }

    public TreePath[] getSelectionPathsTo(Object object, TreeModel treeModel) {
        if (object instanceof TreeView) {
            object = ((TreeView)object).getViewedObject();
        }
        TreePath[] treePathArray = null;
        if (treeModel != null && treeModel instanceof DefaultTreeViewModel) {
            TreeView treeView = (TreeView)treeModel.getRoot();
            if (treeView.getViewedObject() == object) {
                treePathArray = new TreePath[]{new TreePath(treeView)};
            } else {
                List list = treeView.getSelectionPathsTo(object, null, CollectionFactory.createArrayList());
                treePathArray = list.toArray(new TreePath[list.size()]);
            }
        }
        if (treePathArray == null) {
            treePathArray = new TreePath[]{};
        }
        Q.debug("[DefaultTreePerspective] getSelectionPathsTo" + Arrays.asList(treePathArray));
        return treePathArray;
    }

    public TreePath[] getSelectionPathsTo(Collection collection, TreeModel treeModel) {
        List list = CollectionFactory.createArrayList();
        TreePath[] treePathArray = collection.iterator();
        while (treePathArray.hasNext()) {
            Object object = treePathArray.next();
            if (object instanceof TreeView) {
                object = ((TreeView)object).getViewedObject();
            }
            List list2 = null;
            if (treeModel != null && treeModel instanceof DefaultTreeViewModel) {
                list2 = ((TreeView)treeModel.getRoot()).getSelectionPathsTo(object, null, CollectionFactory.createArrayList());
            }
            if (list2 == null) continue;
            list.addAll(list2);
        }
        Q.debug("[DefaultTreePerspective] getSelectionPathsTo" + list);
        treePathArray = list.toArray(new TreePath[list.size()]);
        return treePathArray;
    }

    public TreePath getExpandPathForSelection(TreePath[] treePathArray) {
        return this.M.getExpandPathForSelection(treePathArray);
    }

    public void setTreeSelectionExpandStrategy(TreeExpandStrategy treeExpandStrategy) {
        this.M = treeExpandStrategy;
    }

    public TreeCellRenderer getTreeCellRenderer() {
        return this.O;
    }

    public TreeViewEditor getTreeViewEditor() {
        return this.E;
    }

    public TreeViewModel getTreeModel(Object object) {
        DefaultTreeViewModel defaultTreeViewModel = new DefaultTreeViewModel(object, this.getTreeViewEditor());
        defaultTreeViewModel.setPerspective(this);
        return defaultTreeViewModel;
    }

    protected TreeView getViewFor(Object object) {
        TreePerspective.Filter filter;
        TreeView treeView = null;
        if (object == null) {
            return treeView;
        }
        Class<?> clazz = object.getClass();
        if (this.F.containsKey(clazz)) {
            treeView = (TreeView)this.F.get(clazz);
        } else {
            treeView = this.getViewFor(clazz);
            this.F.put(clazz, treeView);
        }
        if (this.G.containsKey(clazz)) {
            filter = (TreePerspective.Filter)this.G.get(clazz);
        } else {
            filter = this.getFilterFor(clazz);
            this.G.put(clazz, filter);
        }
        if (filter != null && !filter.shouldBeViewed(object)) {
            treeView = null;
        }
        return treeView;
    }

    protected TreeView getViewFor(Class clazz) {
        TreeView treeView = null;
        if (this.L.containsKey(clazz.getName())) {
            treeView = (TreeView)this.L.get(clazz.getName());
        } else if (this.N.containsKey(clazz)) {
            treeView = (TreeView)this.N.get(clazz);
        } else {
            Class<?>[] classArray = clazz.getInterfaces();
            for (int i2 = 0; i2 < classArray.length && (treeView = this.getViewFor(classArray[i2])) == null; ++i2) {
            }
            if (treeView == null && clazz.getSuperclass() != null) {
                treeView = this.getViewFor(clazz.getSuperclass());
            }
        }
        return treeView;
    }

    protected TreePerspective.Filter getFilterFor(Class clazz) {
        TreePerspective.Filter filter = null;
        if (this.K.containsKey(clazz.getName())) {
            filter = (TreePerspective.Filter)this.K.get(clazz.getName());
        } else if (this.I.containsKey(clazz)) {
            filter = (TreePerspective.Filter)this.I.get(clazz);
        } else {
            Class<?>[] classArray = clazz.getInterfaces();
            for (int i2 = 0; i2 < classArray.length && (filter = this.getFilterFor(classArray[i2])) == null; ++i2) {
            }
            if (filter == null && clazz.getSuperclass() != null) {
                filter = this.getFilterFor(clazz.getSuperclass());
            }
        }
        return filter;
    }

    public TreeCellRenderer getRenderer() {
        return this.O;
    }
}

