/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.treeview.base;

import com.gentleware.openapi.util.CollectionFactory;
import com.gentleware.treeview.base.TreePerspective;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class TreePerspectiveManager {
    protected Comparator comparator = new Comparator(){

        public int compare(Object object, Object object2) {
            return object.toString().compareTo(object2.toString());
        }

        public boolean equals(Object object) {
            return false;
        }

        public int hashCode() {
            return 0;
        }
    };
    public static final String PERSPECTIVES_PROPERTY = "perspectives";
    protected Map _perspectives = CollectionFactory.createHashMap();
    protected Map _rootClassToPerspectives = CollectionFactory.createHashMap();
    protected Map _rootClassDefaultPerspective = CollectionFactory.createHashMap();
    protected static TreePerspectiveManager _instance = new TreePerspectiveManager();
    protected PropertyChangeSupport _changeSupport = new PropertyChangeSupport(this);

    private TreePerspectiveManager() {
        this.A();
    }

    public static TreePerspectiveManager getInstance() {
        return _instance;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public TreePerspective getPerspective(String string) {
        return (TreePerspective)this._perspectives.get(string);
    }

    public void addPerspective(TreePerspective treePerspective) {
        List list;
        List list2 = this.getPerspectives();
        this._perspectives.put(treePerspective.getName(), treePerspective);
        if (!this._rootClassToPerspectives.containsKey(treePerspective.getRootClass())) {
            list = CollectionFactory.createArrayList();
            this._rootClassToPerspectives.put(treePerspective.getRootClass(), list);
        } else {
            list = (List)this._rootClassToPerspectives.get(treePerspective.getRootClass());
        }
        list.add(treePerspective);
        this._changeSupport.firePropertyChange(PERSPECTIVES_PROPERTY, list2, this.getPerspectives());
    }

    public void removePerspective(TreePerspective treePerspective) {
        List list = this.getPerspectives();
        if (treePerspective == null) {
            return;
        }
        this._perspectives.remove(treePerspective.getName());
        if (this._rootClassToPerspectives.containsKey(treePerspective.getRootClass())) {
            List list2 = (List)this._rootClassToPerspectives.get(treePerspective.getRootClass());
            list2.remove(treePerspective);
        }
        this._changeSupport.firePropertyChange(PERSPECTIVES_PROPERTY, list, this.getPerspectives());
    }

    public void removePerspective(String string) {
        TreePerspective treePerspective = (TreePerspective)this._perspectives.get(string);
        if (treePerspective != null) {
            this.removePerspective(treePerspective);
        }
    }

    public List getPerspectives() {
        List list = CollectionFactory.createArrayList(this._perspectives.values());
        Collections.sort(list, this.comparator);
        return list;
    }

    public List getPerspectivesFor(Class clazz) {
        if (this._rootClassToPerspectives.get(clazz) != null) {
            List list = CollectionFactory.createArrayList((Collection)((List)this._rootClassToPerspectives.get(clazz)));
            Collections.sort(list, this.comparator);
            return list;
        }
        return null;
    }

    public void setDefaultPerspective(TreePerspective treePerspective) {
        this._rootClassDefaultPerspective.put(treePerspective.getRootClass(), treePerspective);
    }

    public TreePerspective getDefaultPerspective(Class clazz) {
        TreePerspective treePerspective = null;
        if (!this._rootClassDefaultPerspective.containsKey(clazz)) {
            List list = this.getPerspectivesFor(clazz);
            if (list != null && !list.isEmpty()) {
                treePerspective = (TreePerspective)list.get(0);
            }
        } else {
            treePerspective = (TreePerspective)this._rootClassDefaultPerspective.get(clazz);
        }
        return treePerspective;
    }

    private void A() {
    }
}

