/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.openapi.swingx;

import com.gentleware.openapi.swingx.Localizer;
import com.gentleware.openapi.swingx.ResourceId;
import com.gentleware.openapi.util.IconLoader;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class ComponentResources {
    private static final Logger H = Logger.getLogger("com.gentleware.openapi.swingx.ComponentResources");
    private static final String I = "_name";
    private static final String L = "_mnemonic";
    private static final String A = "_mnemonic_index";
    private static final String P = "_tooltip";
    private static final String O = "_icon";
    private static final String N = "_accelerator";
    private static final String B = "_accelerator2";
    private static final String S = "_enabled";
    private static final String E = "_toggle";
    private String C;
    private String J;
    private String T;
    private Integer K;
    private Integer M;
    private ImageIcon G;
    private KeyStroke Q;
    private KeyStroke F;
    private boolean R;
    private boolean D;

    public static final String[] getAllSuffixes() {
        String[] stringArray = new String[]{I, L, A, P, O, N, B, S, E};
        return stringArray;
    }

    public ComponentResources(ResourceId resourceId) {
        Localizer localizer = Localizer.getInstance();
        this.C = ComponentResources.E(localizer, resourceId);
        this.J = ComponentResources.G(localizer, resourceId);
        this.K = ComponentResources.C(localizer, resourceId);
        this.M = ComponentResources.A(localizer, resourceId, this.C.length());
        this.T = ComponentResources.I(localizer, resourceId);
        this.G = ComponentResources.B(localizer, resourceId);
        this.Q = ComponentResources.A(localizer, resourceId);
        this.F = ComponentResources.F(localizer, resourceId);
        this.R = ComponentResources.H(localizer, resourceId);
        this.D = ComponentResources.D(localizer, resourceId);
    }

    public ComponentResources(Action action) {
        this.J = (String)action.getValue("Default");
        this.C = (String)action.getValue("Name");
        this.G = (ImageIcon)action.getValue("SmallIcon");
        this.T = (String)action.getValue("ShortDescription");
        this.Q = (KeyStroke)action.getValue("AcceleratorKey");
        this.F = (KeyStroke)action.getValue("AcceleratorKey2");
        Integer n = (Integer)action.getValue("MnemonicKey");
        this.K = n != null ? n : new Integer(0);
        this.M = (Integer)action.getValue("MnemonicIndex");
        this.R = action.isEnabled();
        this.D = Boolean.TRUE == action.getValue("ToggleAction");
    }

    private static boolean D(Localizer localizer, ResourceId resourceId) {
        boolean bl = localizer.getBoolean(resourceId.createSubResourceId(E));
        return bl;
    }

    private static boolean H(Localizer localizer, ResourceId resourceId) {
        boolean bl = localizer.getBoolean(resourceId.createSubResourceId(S), true);
        return bl;
    }

    private static KeyStroke F(Localizer localizer, ResourceId resourceId) {
        KeyStroke keyStroke = null;
        ResourceId resourceId2 = resourceId.createSubResourceId(B);
        if (localizer.containsKey(resourceId2)) {
            keyStroke = localizer.getKeyStroke(resourceId2);
        }
        return keyStroke;
    }

    private static KeyStroke A(Localizer localizer, ResourceId resourceId) {
        KeyStroke keyStroke = null;
        ResourceId resourceId2 = resourceId.createSubResourceId(N);
        if (localizer.containsKey(resourceId2)) {
            keyStroke = localizer.getKeyStroke(resourceId2);
        }
        return keyStroke;
    }

    public static ImageIcon retrieveIcon(ResourceId resourceId) {
        Localizer localizer = Localizer.getInstance();
        ImageIcon imageIcon = ComponentResources.B(localizer, resourceId);
        return imageIcon;
    }

    private static ImageIcon B(Localizer localizer, ResourceId resourceId) {
        ImageIcon imageIcon = null;
        ResourceId resourceId2 = resourceId.createSubResourceId(O);
        if (localizer.containsKey(resourceId2)) {
            String string = localizer.get(resourceId2);
            IconLoader iconLoader = IconLoader.getIconLoader();
            imageIcon = iconLoader.get(string, "");
            if (imageIcon == null) {
                // empty if block
            }
        }
        return imageIcon;
    }

    public static String retrieveTooltip(ResourceId resourceId) {
        Localizer localizer = Localizer.getInstance();
        String string = ComponentResources.I(localizer, resourceId);
        return string;
    }

    private static String I(Localizer localizer, ResourceId resourceId) {
        String string = null;
        ResourceId resourceId2 = resourceId.createSubResourceId(P);
        if (localizer.containsKey(resourceId2)) {
            string = localizer.get(resourceId2);
        }
        return string;
    }

    private static Integer A(Localizer localizer, ResourceId resourceId, int n) {
        String string;
        Integer n2 = null;
        ResourceId resourceId2 = resourceId.createSubResourceId(A);
        if (localizer.containsKey(resourceId2) && (string = localizer.get(resourceId2)) != null && string.length() > 0) {
            try {
                int n3 = Integer.parseInt(string);
                if (n3 < n) {
                    n2 = new Integer(n3);
                } else {
                    H.warn("mnemonic index " + n3 + " too large in " + resourceId2 + ". Value is ignored.");
                }
            }
            catch (NumberFormatException numberFormatException) {
                H.error("[SwingFactory] Cannot parse mnemonic index in bundle " + resourceId2 + string);
            }
        }
        return n2;
    }

    public static Integer retrieveMnemonic(ResourceId resourceId) {
        Localizer localizer = Localizer.getInstance();
        Integer n = ComponentResources.C(localizer, resourceId);
        return n;
    }

    private static Integer C(Localizer localizer, ResourceId resourceId) {
        String string;
        Integer n = null;
        ResourceId resourceId2 = resourceId.createSubResourceId(L);
        if (localizer.containsKey(resourceId2) && (string = localizer.get(resourceId2)).length() > 0) {
            char c;
            char c2 = c = string.charAt(0);
            n = new Integer(c2);
        }
        if (n == null) {
            n = new Integer(0);
        }
        return n;
    }

    public static String retrieveText(ResourceId resourceId) {
        Localizer localizer = Localizer.getInstance();
        String string = ComponentResources.E(localizer, resourceId);
        return string;
    }

    private static String E(Localizer localizer, ResourceId resourceId) {
        String string = localizer.get(resourceId);
        return string;
    }

    public static String retrieveName(ResourceId resourceId) {
        Localizer localizer = Localizer.getInstance();
        return ComponentResources.G(localizer, resourceId);
    }

    private static String G(Localizer localizer, ResourceId resourceId) {
        ResourceId resourceId2 = resourceId.createSubResourceId(I);
        String string = localizer.containsKey(resourceId2) ? localizer.get(resourceId2) : resourceId.getKey();
        return string;
    }

    public void configureAction(Action action) {
        action.putValue("Default", this.J);
        action.putValue("Name", this.C);
        action.putValue("SmallIcon", this.G);
        action.putValue("ShortDescription", this.T);
        action.putValue("AcceleratorKey", this.Q);
        action.putValue("AcceleratorKey2", this.F);
        action.putValue("MnemonicKey", this.K);
        action.putValue("MnemonicIndex", this.M);
        action.putValue("enabled", this.R ? Boolean.TRUE : Boolean.FALSE);
        action.putValue("ToggleAction", this.D ? Boolean.TRUE : Boolean.FALSE);
        action.setEnabled(this.R);
    }

    public String getText() {
        return this.C;
    }

    public void setText(String string) {
        this.C = string;
    }

    public String getName() {
        return this.J;
    }

    public void setName(String string) {
        this.J = string;
    }

    public String getToolTip() {
        return this.T;
    }

    public void setToolTip(String string) {
        this.T = string;
    }

    public Integer getMnemonic() {
        return this.K;
    }

    public void setMnemonic(Integer n) {
        this.K = n;
    }

    public Integer getMnemonicIndex() {
        return this.M;
    }

    public void setMnemonicIndex(Integer n) {
        this.M = n;
    }

    public ImageIcon getIcon() {
        return this.G;
    }

    public void setIcon(ImageIcon imageIcon) {
        this.G = imageIcon;
    }

    public KeyStroke getAccelerator() {
        return this.Q;
    }

    public KeyStroke getAccelerator2() {
        return this.F;
    }

    public void setAccelerator(KeyStroke keyStroke) {
        this.Q = keyStroke;
    }

    public void setAccelerator2(KeyStroke keyStroke) {
        this.F = keyStroke;
    }

    public boolean isEnabled() {
        return this.R;
    }

    public void setEnabled(boolean bl) {
        this.R = bl;
    }

    public boolean isToggleAction() {
        return this.D;
    }

    public void setToggleAction(boolean bl) {
        this.D = bl;
    }
}

