/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.swingx;

import com.gentleware.openapi.configuration.Configuration;
import com.gentleware.openapi.configuration.Services;
import com.gentleware.openapi.swingx.XColorPanel;
import com.gentleware.openapi.swingx.XColorPicker;
import com.gentleware.openapi.swingx.XThinBevelBorder;
import com.gentleware.openapi.util.Utils;
import com.gentleware.swingx.PanelToggleButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public class PopupColorButton
extends JPanel {
    private XColorPicker E;
    private PanelToggleButton B;
    private final ActionListener A = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            PopupColorButton.this.B.popDown();
            PopupColorButton.this.D = PopupColorButton.this.E.getCurrentColor();
            PopupColorButton.this.B.setBackground(PopupColorButton.this.D);
            PopupColorButton.this.B.repaint();
            if (PopupColorButton.this.C != null) {
                PopupColorButton.this.C.actionPerformed(actionEvent);
            }
        }
    };
    private Color D;
    private ActionListener C;

    public PopupColorButton(String string) {
        Configuration configuration = Services.getInstance().getConfiguration();
        this.D = Color.RED;
        this.E = new XColorPicker(this.A, this.D, configuration, string);
        Border border = BorderFactory.createEmptyBorder(4, 4, 4, 4);
        XThinBevelBorder xThinBevelBorder = XThinBevelBorder.getRaisedBorder();
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(xThinBevelBorder, border);
        this.E.setBorder(compoundBorder);
        this.B = new PanelToggleButton(this.E){

            public void paint(Graphics graphics) {
                boolean bl = this.isPopupVisible();
                XThinBevelBorder xThinBevelBorder = bl ? XThinBevelBorder.getLoweredBorder() : XThinBevelBorder.getRaisedBorder();
                int n = this.getWidth();
                int n2 = this.getHeight();
                graphics.setColor(PopupColorButton.this.D);
                graphics.fillRect(0, 0, n, n2);
                this.paintArrowIcon(graphics, !bl, true, n - 8, (n2 - 3) / 2);
                xThinBevelBorder.paintBorder(this, graphics, 0, 0, n, n2);
            }

            protected Object getMouseOverComponent(Component component, Point point) {
                if (component instanceof AbstractButton) {
                    return super.getMouseOverComponent(component, point);
                }
                if (component instanceof XColorPanel) {
                    XColorPanel xColorPanel = (XColorPanel)component;
                    return xColorPanel.getColorAt(point);
                }
                return null;
            }

            protected void click(Object object, Object object2) {
                if (object instanceof AbstractButton) {
                    super.click(object, object2);
                }
                if (object instanceof XColorPanel) {
                    XColorPanel xColorPanel = (XColorPanel)object;
                    xColorPanel.selectColor((Color)object2);
                }
            }

            protected void arm(Object object, Object object2) {
                if (object instanceof AbstractButton) {
                    super.arm(object, object2);
                }
                if (object instanceof XColorPanel) {
                    XColorPanel xColorPanel = (XColorPanel)object;
                    xColorPanel.setArmed((Color)object2);
                }
            }

            protected void unarm(Object object, Object object2) {
                if (object instanceof AbstractButton) {
                    super.unarm(object, object2);
                }
                if (object instanceof XColorPanel) {
                    XColorPanel xColorPanel = (XColorPanel)object;
                    xColorPanel.setUnArmed();
                }
            }
        };
        this.setLayout(new BorderLayout());
        this.add(this.B);
    }

    public Color getColor() {
        return this.D;
    }

    public void setColor(Color color) {
        this.D = color;
        this.E.setCurrentColor(color);
        this.B.setBackground(this.D);
        this.B.repaint();
        Color color2 = this.D != null && Utils.getColorSimilarity((Color)this.D, (Color)Color.DARK_GRAY) < 0.7f ? Color.WHITE : Color.DARK_GRAY;
        this.B.setArrowColor(color2);
    }

    public void setActionListener(ActionListener actionListener) {
        this.C = actionListener;
    }

    public Dimension getPreferredSize() {
        return new Dimension(24, 14);
    }

    public Dimension getMaximumSize() {
        return new Dimension(24, 14);
    }

    public Dimension getMinimumSize() {
        return new Dimension(24, 14);
    }
}

