/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.DocMarks;
import org.netbeans.editor.DocOp;
import org.netbeans.editor.InvalidMarkException;
import org.netbeans.editor.Mark;
import org.netbeans.editor.MarkFactory;

public class Analyzer {
    private static Object platformLS;
    public static final char[] EMPTY_CHAR_ARRAY;
    private static char[] spacesBuffer;
    private static char[] tabsBuffer;
    private static final int MAX_CACHED_SPACES_STRING_LENGTH = 50;
    private static final String[] spacesStrings;

    private Analyzer() {
    }

    public static Object getPlatformLS() {
        if (platformLS == null) {
            platformLS = System.getProperty("line.separator");
        }
        return platformLS;
    }

    public static String testLS(char[] cArray, int n) {
        int n2 = 0;
        while (n2 < n) {
            switch (cArray[n2]) {
                case '\r': {
                    if (n2 + 1 < n && cArray[n2 + 1] == '\n') {
                        return "\r\n";
                    }
                    return "\r";
                }
                case '\n': {
                    return "\n";
                }
            }
            ++n2;
        }
        return null;
    }

    public static int convertLSToLF(char[] cArray, int n) {
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 < n) {
            if (cArray[n6] == '\r') {
                n4 = n6 + 1 < n && cArray[n6 + 1] == '\n' ? 2 : 1;
            }
            if (n4 > 0) {
                n2 = n6 - n5;
                if (n2 > 0) {
                    if (n3 != n5) {
                        System.arraycopy(cArray, n5, cArray, n3, n2);
                    }
                    n3 += n2;
                }
                cArray[n3++] = 10;
                n5 += n2 + n4;
                n6 += n4 - 1;
                n4 = 0;
            }
            ++n6;
        }
        n2 = n - n5;
        if (n2 > 0) {
            if (n3 != n5) {
                System.arraycopy(cArray, n5, cArray, n3, n2);
            }
            n3 += n2;
        }
        return n3;
    }

    public static String convertLSToLF(String string) {
        int n;
        char[] cArray = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = string.length();
        int n6 = 0;
        while (n6 < n5) {
            if (string.charAt(n6) == '\r') {
                n3 = n6 + 1 < n5 && string.charAt(n6 + 1) == '\n' ? 2 : 1;
            }
            if (n3 > 0) {
                if (cArray == null) {
                    cArray = new char[n5];
                    string.getChars(0, n5, cArray, 0);
                }
                if ((n = n6 - n4) > 0) {
                    if (n2 != n4) {
                        string.getChars(n4, n4 + n, cArray, n2);
                    }
                    n2 += n;
                }
                cArray[n2++] = 10;
                n4 += n + n3;
                n6 += n3 - 1;
                n3 = 0;
            }
            ++n6;
        }
        n = n5 - n4;
        if (n > 0) {
            if (n2 != n4) {
                string.getChars(n4, n4 + n, cArray, n2);
            }
            n2 += n;
        }
        return cArray == null ? string : new String(cArray, 0, n2);
    }

    public static boolean isSpace(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            if (string.charAt(n2) != ' ') {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isSpace(char[] cArray, int n, int n2) {
        while (n2 > 0) {
            if (cArray[n++] != ' ') {
                return false;
            }
            --n2;
        }
        return true;
    }

    public static boolean isWhitespace(char[] cArray, int n, int n2) {
        while (n2 > 0) {
            if (!Character.isWhitespace(cArray[n])) {
                return false;
            }
            ++n;
            --n2;
        }
        return true;
    }

    public static int findFirstNonTab(char[] cArray, int n, int n2) {
        while (n2 > 0) {
            if (cArray[n] != '\t') {
                return n;
            }
            ++n;
            --n2;
        }
        return -1;
    }

    public static int findFirstNonSpace(char[] cArray, int n, int n2) {
        while (n2 > 0) {
            if (cArray[n] != ' ') {
                return n;
            }
            ++n;
            --n2;
        }
        return -1;
    }

    public static int findFirstNonWhite(char[] cArray, int n, int n2) {
        while (n2 > 0) {
            if (!Character.isWhitespace(cArray[n])) {
                return n;
            }
            ++n;
            --n2;
        }
        return -1;
    }

    public static int findLastNonWhite(char[] cArray, int n, int n2) {
        int n3 = n + n2 - 1;
        while (n3 >= n) {
            if (!Character.isWhitespace(cArray[n3])) {
                return n3;
            }
            --n3;
        }
        return -1;
    }

    public static int getLFCount(char[] cArray) {
        return Analyzer.getLFCount(cArray, 0, cArray.length);
    }

    public static int getLFCount(char[] cArray, int n, int n2) {
        int n3 = 0;
        while (n2 > 0) {
            if (cArray[n++] == '\n') {
                ++n3;
            }
            --n2;
        }
        return n3;
    }

    public static int getLFCount(String string) {
        int n = 0;
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            if (string.charAt(n3) == '\n') {
                ++n;
            }
            ++n3;
        }
        return n;
    }

    public static int findFirstLFOffset(char[] cArray, int n, int n2) {
        while (n2 > 0) {
            if (cArray[n++] == '\n') {
                return n - 1;
            }
            --n2;
        }
        return -1;
    }

    public static int findFirstLFOffset(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            if (string.charAt(n2) == '\n') {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public static int findFirstTab(char[] cArray, int n, int n2) {
        while (n2 > 0) {
            if (cArray[n++] == '\t') {
                return n - 1;
            }
            --n2;
        }
        return -1;
    }

    public static int findFirstTabOrLF(char[] cArray, int n, int n2) {
        while (n2 > 0) {
            switch (cArray[n++]) {
                case '\t': 
                case '\n': {
                    return n - 1;
                }
            }
            --n2;
        }
        return -1;
    }

    public static void reverse(char[] cArray, int n) {
        int n2 = --n - 1 >> 1;
        while (n2 >= 0) {
            char c = cArray[n2];
            cArray[n2] = cArray[n - n2];
            cArray[n - n2] = c;
            --n2;
        }
    }

    public static boolean equals(String string, char[] cArray) {
        return Analyzer.equals(string, cArray, 0, cArray.length);
    }

    public static boolean equals(String string, char[] cArray, int n, int n2) {
        if (string.length() != n2) {
            return false;
        }
        int n3 = 0;
        while (n3 < n2) {
            if (string.charAt(n3) != cArray[n + n3]) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public static void initialRead(BaseDocument baseDocument, Reader reader, boolean bl) throws IOException {
        if (baseDocument.getLength() > 0) {
            return;
        }
        if (reader != null) {
            int n = (Integer)baseDocument.getProperty("read-buffer-size");
            int n2 = (Integer)baseDocument.getProperty("read-mark-distance");
            char[] cArray = new char[n];
            boolean bl2 = true;
            boolean bl3 = false;
            int n3 = 0;
            boolean bl4 = false;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = n2;
            int n9 = n2;
            int n10 = 0;
            DocOp docOp = baseDocument.op;
            synchronized (docOp) {
                int n11;
                final Mark[][] markArray = new Mark[1][];
                baseDocument.op.renderMarks(new DocMarks.Renderer(){

                    public void render() {
                        markArray[0] = this.copyAllMarks();
                    }
                });
                int n12 = 0;
                while (n12 < markArray[0].length) {
                    block39: {
                        Mark mark = markArray[0][n12];
                        if (!mark.getInsertAfter() && !(mark instanceof MarkFactory.CaretMark)) {
                            try {
                                mark.remove();
                            }
                            catch (InvalidMarkException invalidMarkException) {
                                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block39;
                                invalidMarkException.printStackTrace();
                            }
                        }
                    }
                    ++n12;
                }
                while (true) {
                    int n13;
                    block41: {
                        String string;
                        n3 = 0;
                        while (n3 == 0) {
                            n3 = reader.read(cArray, 0, cArray.length);
                        }
                        n11 = 0;
                        if (bl3 && n3 > 0 && cArray[0] == '\n') {
                            ++n11;
                        }
                        if (n3 == -1) break;
                        if (bl2 && bl && (string = Analyzer.testLS(cArray, n3)) != null) {
                            baseDocument.putProperty("__EndOfLine__", string);
                        }
                        n13 = 0;
                        int n14 = 0;
                        while (n14 < n3) {
                            if (n14 == n8) {
                                block40: {
                                    MarkFactory.SyntaxMark syntaxMark = new MarkFactory.SyntaxMark();
                                    try {
                                        baseDocument.op.insertMark(syntaxMark, n9, n5);
                                    }
                                    catch (BadLocationException badLocationException) {
                                        if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                                            badLocationException.printStackTrace();
                                        }
                                    }
                                    catch (InvalidMarkException invalidMarkException) {
                                        if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block40;
                                        invalidMarkException.printStackTrace();
                                    }
                                }
                                ++n10;
                                n8 += n2;
                                n9 += n2;
                            }
                            switch (cArray[n14]) {
                                case '\n': {
                                    if (bl3) {
                                        if (n11 > 0) {
                                            int n15 = n14 - n11;
                                            if (n15 > 0) {
                                                System.arraycopy(cArray, n11, cArray, n13, n15);
                                                n13 += n15;
                                            }
                                        } else {
                                            n13 = n14;
                                        }
                                        n11 = n14 + 1;
                                        bl3 = false;
                                        ++n7;
                                        ++n8;
                                        break;
                                    }
                                    ++n5;
                                    n6 = Math.max(n6, n14 - n7);
                                    n7 = n14 + 1;
                                    break;
                                }
                                case '\r': {
                                    bl3 = true;
                                    cArray[n14] = 10;
                                    ++n5;
                                    n6 = Math.max(n6, n14 - n7);
                                    n7 = n14 + 1;
                                }
                            }
                            ++n14;
                        }
                        if (n11 > 0) {
                            int n16 = n14 - n11;
                            if (n16 > 0) {
                                System.arraycopy(cArray, n11, cArray, n13, n16);
                                n13 += n16;
                            }
                        } else {
                            n13 = n14;
                        }
                        n8 -= n14;
                        n7 -= n14;
                        try {
                            baseDocument.op.directCacheWrite(n4, cArray, 0, n13);
                        }
                        catch (BadLocationException badLocationException) {
                            if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block41;
                            badLocationException.printStackTrace();
                        }
                    }
                    if (bl2) {
                        baseDocument.op.initCacheContent(cArray, 0, n13);
                    }
                    n4 += n13;
                    bl2 = false;
                }
                n11 = 0;
                while (n11 < markArray[0].length) {
                    block42: {
                        Mark mark = markArray[0][n11];
                        if (!mark.getInsertAfter() && !(mark instanceof MarkFactory.CaretMark)) {
                            try {
                                baseDocument.op.insertMark(markArray[0][n11], n4, n5);
                            }
                            catch (InvalidMarkException invalidMarkException) {
                                if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                                    invalidMarkException.printStackTrace();
                                }
                            }
                            catch (BadLocationException badLocationException) {
                                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block42;
                                badLocationException.printStackTrace();
                            }
                        }
                    }
                    ++n11;
                }
                baseDocument.putProperty("line-limit", new Integer(n6));
                baseDocument.op.initialReadUpdate();
            }
        }
    }

    static void read(BaseDocument baseDocument, Reader reader, int n) throws BadLocationException, IOException {
        int n2 = 0;
        boolean bl = false;
        int n3 = (Integer)baseDocument.getProperty("read-buffer-size");
        char[] cArray = new char[n3 + 1];
        while (true) {
            int n4 = 0;
            while (n4 == 0) {
                n4 = reader.read(cArray, n2, n3);
            }
            int n5 = 0;
            if (n4 == -1) {
                if (n2 == 0) break;
                n4 = 0;
            } else if (cArray[n4 + n2 - 1] == '\r') {
                n5 = 1;
                --n4;
            }
            n4 += n2;
            n4 = Analyzer.convertLSToLF(cArray, n4);
            baseDocument.insertString(n, new String(cArray, 0, n4), null);
            n += n4;
            n2 = n5;
        }
    }

    static void write(BaseDocument baseDocument, Writer writer, int n, int n2) throws BadLocationException, IOException {
        String string = (String)baseDocument.getProperty("write-line-separator");
        if (string == null && (string = (String)baseDocument.getProperty("__EndOfLine__")) == null) {
            string = "\n";
        }
        int n3 = (Integer)baseDocument.getProperty("write-buffer-size");
        char[] cArray = new char[n3];
        char[] cArray2 = new char[2 * n3];
        int n4 = 0;
        while (n2 > 0) {
            n4 = Math.min(n2, n3);
            baseDocument.getChars(n, cArray, 0, n4);
            int n5 = Analyzer.convertLFToLS(cArray, n4, cArray2, string);
            writer.write(cArray2, 0, n5);
            n += n4;
            n2 -= n4;
        }
    }

    public static int getColumn(char[] cArray, int n, int n2, int n3, int n4) {
        int n5 = n4;
        int n6 = n + n2;
        if (n3 <= 0) {
            new Exception("Wrong tab size=" + n3).printStackTrace();
            n3 = 8;
        }
        while (n < n6) {
            switch (cArray[n++]) {
                case '\t': {
                    n5 = (n5 + n3) / n3 * n3;
                    break;
                }
                default: {
                    ++n5;
                }
            }
        }
        return n5;
    }

    public static synchronized char[] getSpacesBuffer(int n) {
        while (n > spacesBuffer.length) {
            char[] cArray = new char[spacesBuffer.length * 2];
            System.arraycopy(spacesBuffer, 0, cArray, 0, spacesBuffer.length);
            System.arraycopy(spacesBuffer, 0, cArray, spacesBuffer.length, spacesBuffer.length);
            spacesBuffer = cArray;
        }
        return spacesBuffer;
    }

    public static synchronized String getSpacesString(int n) {
        if (n <= 50) {
            String string = spacesStrings[n];
            if (string == null) {
                Analyzer.spacesStrings[n] = string = spacesStrings[50].substring(0, n);
            }
            return string;
        }
        return new String(Analyzer.getSpacesBuffer(n), 0, n);
    }

    public static char[] createSpacesBuffer(int n) {
        char[] cArray = new char[n];
        System.arraycopy(Analyzer.getSpacesBuffer(n), 0, cArray, 0, n);
        return cArray;
    }

    public static char[] getTabsBuffer(int n) {
        if (n > tabsBuffer.length) {
            char[] cArray = new char[n * 2];
            int n2 = 0;
            while (n2 < cArray.length) {
                System.arraycopy(tabsBuffer, 0, cArray, n2, Math.min(tabsBuffer.length, cArray.length - n2));
                n2 += tabsBuffer.length;
            }
            tabsBuffer = cArray;
        }
        return tabsBuffer;
    }

    public static String getIndentString(int n, boolean bl, int n2) {
        return Analyzer.getWhitespaceString(0, n, bl, n2);
    }

    public static String getWhitespaceString(int n, int n2, boolean bl, int n3) {
        return bl || n3 <= 0 ? Analyzer.getSpacesString(n2 - n) : new String(Analyzer.createWhiteSpaceFillBuffer(n, n2, n3));
    }

    public static char[] createWhiteSpaceFillBuffer(int n, int n2, int n3) {
        return Analyzer.createWhitespaceFillBuffer(n, n2, n3);
    }

    public static char[] createWhitespaceFillBuffer(int n, int n2, int n3) {
        if (n >= n2) {
            return EMPTY_CHAR_ARRAY;
        }
        if (n3 <= 0) {
            new Exception("Wrong tab size=" + n3).printStackTrace();
            n3 = 8;
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = (n + n3) / n3 * n3;
        if (n6 > n2) {
            n5 += n2 - n;
        } else {
            ++n4;
            int n7 = n2 - n2 / n3 * n3;
            n4 += (n2 - n7 - n6) / n3;
            n5 += n7;
        }
        char[] cArray = new char[n4 + n5];
        if (n4 > 0) {
            System.arraycopy(Analyzer.getTabsBuffer(n4), 0, cArray, 0, n4);
        }
        if (n5 > 0) {
            System.arraycopy(Analyzer.getSpacesBuffer(n5), 0, cArray, n4, n5);
        }
        return cArray;
    }

    public static char[] loadFile(String string) throws IOException {
        File file = new File(string);
        char[] cArray = new char[(int)file.length()];
        FileReader fileReader = new FileReader(file);
        fileReader.read(cArray);
        fileReader.close();
        int n = Analyzer.convertLSToLF(cArray, cArray.length);
        if (n != cArray.length) {
            char[] cArray2 = new char[n];
            System.arraycopy(cArray, 0, cArray2, 0, n);
            cArray = cArray2;
        }
        return cArray;
    }

    public static int convertLFToLS(char[] cArray, int n, char[] cArray2, String string) {
        if (string.equals("\r")) {
            System.arraycopy(cArray, 0, cArray2, 0, n);
            if (string == "\r") {
                char[] cArray3 = cArray2;
                int n2 = 0;
                while (n2 < n) {
                    if (cArray3[n2] == '\n') {
                        cArray3[n2] = 13;
                    }
                    ++n2;
                }
            }
            return n;
        }
        if (string.equals("\r\n")) {
            int n3;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            while (n6 < n) {
                if (cArray[n6] == '\n') {
                    n3 = n6 - n5;
                    if (n3 > 0) {
                        System.arraycopy(cArray, n5, cArray2, n4, n3);
                        n4 += n3;
                    }
                    cArray2[n4++] = 13;
                    cArray2[n4++] = 10;
                    n5 = n6 + 1;
                }
                ++n6;
            }
            n3 = n - n5;
            if (n3 > 0) {
                System.arraycopy(cArray, n5, cArray2, n4, n3);
                n4 += n3;
            }
            return n4;
        }
        System.arraycopy(cArray, 0, cArray2, 0, n);
        return n;
    }

    public static boolean startsWith(char[] cArray, char[] cArray2) {
        if (cArray == null || cArray.length < cArray2.length) {
            return false;
        }
        int n = 0;
        while (n < cArray2.length) {
            if (cArray[n] != cArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static boolean endsWith(char[] cArray, char[] cArray2) {
        if (cArray == null || cArray.length < cArray2.length) {
            return false;
        }
        int n = cArray.length - cArray2.length;
        while (n < cArray.length) {
            if (cArray[n] != cArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static char[] concat(char[] cArray, char[] cArray2) {
        if (cArray == null || cArray.length == 0) {
            return cArray2;
        }
        if (cArray2 == null || cArray2.length == 0) {
            return cArray;
        }
        char[] cArray3 = new char[cArray.length + cArray2.length];
        System.arraycopy(cArray, 0, cArray3, 0, cArray.length);
        System.arraycopy(cArray2, 0, cArray3, cArray.length, cArray2.length);
        return cArray3;
    }

    public static char[] extract(char[] cArray, int n, int n2) {
        char[] cArray2 = new char[n2];
        System.arraycopy(cArray, n, cArray2, 0, n2);
        return cArray2;
    }

    public static boolean blocksHit(int[] nArray, int n, int n2) {
        return Analyzer.blocksIndex(nArray, n, n2) >= 0;
    }

    public static int blocksIndex(int[] nArray, int n, int n2) {
        if (nArray.length > 0) {
            int n3 = -2;
            int n4 = 0;
            int n5 = nArray.length - 2;
            while (n4 <= n5) {
                int n6 = (n4 + n5) / 2 & n3;
                if (nArray[n6 + 1] <= n) {
                    n4 = n6 + 2;
                    continue;
                }
                if (nArray[n6] >= n2) {
                    n5 = n6 - 2;
                    continue;
                }
                return n4;
            }
        }
        return -1;
    }

    public static String removeSpaces(String string) {
        int n = string.indexOf(32);
        if (n >= 0) {
            StringBuffer stringBuffer = new StringBuffer(string.substring(0, n));
            int n2 = string.length();
            int n3 = n + 1;
            while (n3 < n2) {
                char c = string.charAt(n3);
                if (c != ' ') {
                    stringBuffer.append(c);
                }
                ++n3;
            }
            return stringBuffer.toString();
        }
        return string;
    }

    static {
        EMPTY_CHAR_ARRAY = new char[0];
        spacesBuffer = new char[]{' '};
        tabsBuffer = new char[]{'\t'};
        spacesStrings = new String[51];
        Analyzer.spacesStrings[0] = "";
        Analyzer.spacesStrings[50] = new String(Analyzer.getSpacesBuffer(50), 0, 50);
    }
}

