/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TextUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.TextAction;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseDocumentEvent;
import org.netbeans.editor.BaseElement;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.BaseView;
import org.netbeans.editor.DrawGraphics;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.LeafView;
import org.netbeans.editor.Registry;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsDefaults;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.Utilities;

public class BaseTextUI
extends TextUI
implements ViewFactory,
PropertyChangeListener,
DocumentListener {
    private static final int MAX_SPAN = 0x7FFFFDFF;
    private static final int MIN_WIDTH = 300;
    private static final int MIN_HEIGHT = 200;
    private JTextComponent component;
    private EditorUI editorUI;
    int componentID = -1;
    private static final GetFocusedComponentAction gfcAction = new GetFocusedComponentAction();
    private RootView rootView = new RootView();
    static /* synthetic */ Class class$javax$swing$JComponent;
    static /* synthetic */ Class class$javax$swing$SwingUtilities;

    static JTextComponent getFocusedComponent() {
        return gfcAction.getFocusedComponent2();
    }

    protected void modelChanged(BaseDocument baseDocument, BaseDocument baseDocument2) {
        if (baseDocument != null) {
            baseDocument.removeDocumentListener(this);
        }
        if (baseDocument2 != null) {
            baseDocument2.addDocumentListener(this);
            Registry.activate(baseDocument2);
            ViewFactory viewFactory = this.rootView.getViewFactory();
            BaseKit baseKit = (BaseKit)this.getEditorKit(this.component);
            this.component.removeAll();
            Element element = baseDocument2.getDefaultRootElement();
            View view = viewFactory.create(element);
            this.rootView.setView(view);
            this.rootView.updateMainHeight();
            this.component.revalidate();
            Settings.KitAndValue[] kitAndValueArray = Settings.getValueHierarchy(baseKit.getClass(), "doc-install-action-name-list");
            int n = kitAndValueArray.length - 1;
            while (n >= 0) {
                List list = (List)kitAndValueArray[n].value;
                if ((list = baseKit.translateActionNameList(list)) != null) {
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        Action action = (Action)iterator.next();
                        action.actionPerformed(new ActionEvent(this.component, 1001, ""));
                    }
                }
                --n;
            }
        }
    }

    void updateHeight() {
        this.rootView.updateMainHeight();
    }

    public void installUI(JComponent jComponent) {
        if (jComponent instanceof JTextComponent) {
            this.component = (JTextComponent)jComponent;
            this.getEditorUI().installUI(this.component);
            this.component.setOpaque(true);
            this.component.setAutoscrolls(true);
            this.component.addPropertyChangeListener(this);
            BaseKit baseKit = (BaseKit)this.getEditorKit(this.component);
            Caret caret = baseKit.createCaret();
            this.component.setCaretColor(Color.black);
            this.component.setCaret(caret);
            int n = SettingsUtil.getInteger(Utilities.getKitClass(this.component), "caret-blink-rate", (int)SettingsDefaults.defaultCaretBlinkRate);
            caret.setBlinkRate(n);
            BaseDocument baseDocument = Utilities.getDocument(this.component);
            if (baseDocument != null) {
                this.modelChanged(null, baseDocument);
            }
            try {
                Class<?> clazz = Class.forName("javax.swing.InputMap");
                if (clazz != null) {
                    Method method = (class$javax$swing$SwingUtilities == null ? (class$javax$swing$SwingUtilities = BaseTextUI.class$("javax.swing.SwingUtilities")) : class$javax$swing$SwingUtilities).getDeclaredMethod("replaceUIInputMap", class$javax$swing$JComponent == null ? (class$javax$swing$JComponent = BaseTextUI.class$("javax.swing.JComponent")) : class$javax$swing$JComponent, Integer.TYPE, clazz);
                    method.invoke(null, jComponent, new Integer(0), null);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Registry.addComponent(this.component);
            Registry.activate(this.component);
            this.component.setCursor(Cursor.getPredefinedCursor(2));
        }
    }

    public void uninstallUI(JComponent jComponent) {
        this.component.removePropertyChangeListener(this);
        this.component.getDocument().removeDocumentListener(this);
        this.rootView.setView(null);
        this.component.removeAll();
        this.component.setKeymap(null);
        this.component.setCaret(null);
        this.getEditorUI().uninstallUI(this.component);
        Registry.removeComponent(this.component);
        this.editorUI = null;
        this.component = null;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        if (this.rootView.getViewCount() > 0 && this.rootView.getView(0) != null) {
            BaseDocument baseDocument = Utilities.getDocument(this.component);
            if (jComponent == this.component && baseDocument != null) {
                baseDocument.readLock();
                try {
                    this.getEditorUI().paint(graphics);
                    Caret caret = this.component.getCaret();
                    if (caret != null) {
                        caret.paint(graphics);
                    }
                    if (this.getEditorUI().virtualSizeUpdated) {
                        this.preferenceChanged(true, true);
                    }
                    Object var6_5 = null;
                    baseDocument.readUnlock();
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    baseDocument.readUnlock();
                    throw throwable;
                }
            }
        }
    }

    void paintRegion(Graphics graphics) {
        this.rootView.paint(graphics, null);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        BaseDocument baseDocument;
        Insets insets = jComponent.getInsets();
        Insets insets2 = this.getEditorUI().getTextMargin();
        Dimension dimension = jComponent.getSize();
        BaseDocument baseDocument2 = baseDocument = jComponent instanceof JTextComponent ? Utilities.getDocument((JTextComponent)jComponent) : null;
        if (baseDocument != null) {
            baseDocument.readLock();
        }
        try {
            if (dimension.width > insets.left + insets.right && dimension.height > insets.top + insets.bottom) {
                this.rootView.setSize(dimension.width - insets.left - insets.right, dimension.height - insets.top - insets.bottom);
            }
            dimension.width = (int)Math.min(this.rootView.getPreferredSpan(0) + (float)insets.left + (float)insets.right + (float)insets2.left + (float)insets2.right, 2.1474831E9f);
            dimension.height = (int)Math.min(this.rootView.getPreferredSpan(1) + (float)insets.top + (float)insets.bottom + (float)insets2.top + (float)insets2.bottom, 2.1474831E9f);
            Object var7_6 = null;
            if (baseDocument != null) {
                baseDocument.readUnlock();
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (baseDocument != null) {
                baseDocument.readUnlock();
            }
            throw throwable;
        }
        return dimension;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        BaseDocument baseDocument;
        Insets insets = jComponent.getInsets();
        Insets insets2 = this.getEditorUI().getTextMargin();
        Dimension dimension = new Dimension();
        BaseDocument baseDocument2 = baseDocument = jComponent instanceof JTextComponent ? Utilities.getDocument((JTextComponent)jComponent) : null;
        if (baseDocument != null) {
            baseDocument.readLock();
        }
        try {
            dimension.width = (int)this.rootView.getMinimumSpan(0) + insets.left + insets.right + insets2.left + insets2.right;
            dimension.height = (int)this.rootView.getMinimumSpan(1) + insets.top + insets.bottom + insets2.top + insets2.bottom;
            Object var7_6 = null;
            if (baseDocument != null) {
                baseDocument.readUnlock();
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (baseDocument != null) {
                baseDocument.readUnlock();
            }
            throw throwable;
        }
        return dimension;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        BaseDocument baseDocument;
        Insets insets = jComponent.getInsets();
        Insets insets2 = this.getEditorUI().getTextMargin();
        Dimension dimension = new Dimension();
        BaseDocument baseDocument2 = baseDocument = jComponent instanceof JTextComponent ? Utilities.getDocument((JTextComponent)jComponent) : null;
        if (baseDocument != null) {
            baseDocument.readLock();
        }
        try {
            dimension.width = (int)Math.min(this.rootView.getMaximumSpan(0) + (float)insets.left + (float)insets.right + (float)insets2.left + (float)insets2.right, 2.1474831E9f);
            dimension.height = (int)Math.min(this.rootView.getMaximumSpan(1) + (float)insets.top + (float)insets.bottom + (float)insets2.top + (float)insets2.bottom, 2.1474831E9f);
            Object var7_6 = null;
            if (baseDocument != null) {
                baseDocument.readUnlock();
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (baseDocument != null) {
                baseDocument.readUnlock();
            }
            throw throwable;
        }
        return dimension;
    }

    public void invalidateStartY() {
        this.rootView.invalidateStartY();
    }

    public Rectangle modelToView(JTextComponent jTextComponent, int n) throws BadLocationException {
        return (Rectangle)this.rootView.modelToView(n, null, Position.Bias.Forward);
    }

    public Rectangle modelToView(JTextComponent jTextComponent, int n, Position.Bias bias) throws BadLocationException {
        return (Rectangle)this.rootView.modelToView(n, null, bias);
    }

    void modelToViewDG(int n, DrawGraphics drawGraphics) throws BadLocationException {
        this.rootView.modelToViewDG(n, drawGraphics);
    }

    public int getYFromPos(int n) throws BadLocationException {
        return this.rootView.getYFromPos(n);
    }

    public int getPosFromY(int n) throws BadLocationException {
        return this.rootView.getPosFromY(n);
    }

    public int getBaseX(int n) {
        return this.rootView.getBaseX(n);
    }

    public int viewToModel(JTextComponent jTextComponent, Point point) {
        return this.viewToModel(jTextComponent, point.x, point.y);
    }

    public int viewToModel(JTextComponent jTextComponent, int n, int n2) {
        return this.rootView.viewToModel(n, n2, null, null);
    }

    public int viewToModel(JTextComponent jTextComponent, Point point, Position.Bias[] biasArray) {
        return this.rootView.viewToModel(point.x, point.y, null, biasArray);
    }

    public int getNextVisualPositionFrom(JTextComponent jTextComponent, int n, Position.Bias bias, int n2, Position.Bias[] biasArray) throws BadLocationException {
        return this.rootView.getNextVisualPositionFrom(n, bias, null, n2, biasArray);
    }

    public void damageRange(JTextComponent jTextComponent, int n, int n2) {
        this.damageRange(jTextComponent, n, n2, Position.Bias.Forward, Position.Bias.Backward);
    }

    public void damageRange(JTextComponent jTextComponent, int n, int n2, Position.Bias bias, Position.Bias bias2) {
        BaseDocument baseDocument = Utilities.getDocument(this.component);
        if (jTextComponent == this.component && baseDocument != null) {
            baseDocument.readLock();
            try {
                try {
                    Rectangle rectangle = (Rectangle)this.rootView.modelToView(n, bias, n2, bias2, null);
                    this.component.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
                catch (BadLocationException badLocationException) {
                    Object var9_10 = null;
                    baseDocument.readUnlock();
                }
                Object var9_9 = null;
                baseDocument.readUnlock();
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                baseDocument.readUnlock();
                throw throwable;
            }
        }
    }

    public EditorKit getEditorKit(JTextComponent jTextComponent) {
        JEditorPane jEditorPane = (JEditorPane)this.component;
        return jEditorPane.getEditorKit();
    }

    public View getRootView(JTextComponent jTextComponent) {
        return this.rootView;
    }

    public EditorUI getEditorUI() {
        if (this.editorUI == null) {
            BaseKit baseKit = (BaseKit)this.getEditorKit(this.component);
            this.editorUI = baseKit.createEditorUI();
        }
        return this.editorUI;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("document".equals(string)) {
            BaseDocument baseDocument = propertyChangeEvent.getOldValue() instanceof BaseDocument ? (BaseDocument)propertyChangeEvent.getOldValue() : null;
            BaseDocument baseDocument2 = propertyChangeEvent.getNewValue() instanceof BaseDocument ? (BaseDocument)propertyChangeEvent.getNewValue() : null;
            this.modelChanged(baseDocument, baseDocument2);
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.rootView.insertUpdate(documentEvent, null, this.rootView.getViewFactory());
        if (((BaseDocumentEvent)documentEvent).getLFCount() > 0 || documentEvent.getLength() == 0) {
            if (this.getEditorUI().updateVirtualHeight(this.rootView.getHeight())) {
                this.preferenceChanged(true, true);
            }
            this.getEditorUI().checkLineLimit();
            if (documentEvent.getLength() == 0) {
                this.component.repaint(500L);
            }
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.rootView.removeUpdate(documentEvent, null, this.rootView.getViewFactory());
        if (((BaseDocumentEvent)documentEvent).getLFCount() > 0 && this.getEditorUI().updateVirtualHeight(this.rootView.getHeight())) {
            this.preferenceChanged(true, true);
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        if (documentEvent instanceof BaseDocumentEvent) {
            BaseDocumentEvent baseDocumentEvent = (BaseDocumentEvent)documentEvent;
            BaseDocument baseDocument = (BaseDocument)baseDocumentEvent.getDocument();
            String string = baseDocumentEvent.getDrawLayerName();
            if (string != null) {
                this.getEditorUI().addLayer(baseDocument.findLayer(string), baseDocumentEvent.getDrawLayerVisibility());
            } else {
                this.rootView.changedUpdate(documentEvent, null, this.rootView.getViewFactory());
            }
        }
    }

    public View create(Element element) {
        LeafView leafView = null;
        if (element instanceof BaseElement) {
            leafView = new LeafView(element);
        }
        return leafView;
    }

    public View create(Element element, int n, int n2) {
        return new LeafView(element);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BaseTextUI();
    }

    public void preferenceChanged(boolean bl, boolean bl2) {
        this.getEditorUI().virtualSizeUpdated = false;
        this.component.revalidate();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class GetFocusedComponentAction
    extends TextAction {
        private GetFocusedComponentAction() {
            super("get-focused-component");
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }

        JTextComponent getFocusedComponent2() {
            return super.getFocusedComponent();
        }
    }

    class RootView
    extends BaseView {
        BaseView view;

        RootView() {
            super(null);
        }

        void setView(View view) {
            if (view instanceof BaseView) {
                if (this.view != null) {
                    this.view.setParent(null);
                }
                this.view = (BaseView)view;
                if (this.view != null) {
                    this.view.setParent(this);
                }
            }
        }

        public AttributeSet getAttributes() {
            return null;
        }

        public float getPreferredSpan(int n) {
            EditorUI editorUI = BaseTextUI.this.getEditorUI();
            switch (n) {
                case 0: {
                    return Math.max(BaseTextUI.this.getEditorUI().virtualSize.width, 300);
                }
                case 1: {
                    return Math.max(BaseTextUI.this.getEditorUI().virtualSize.height, 200);
                }
            }
            return 0.0f;
        }

        public float getMinimumSpan(int n) {
            return this.getPreferredSpan(n);
        }

        public float getMaximumSpan(int n) {
            return 2.1474836E9f;
        }

        public void preferenceChanged(View view, boolean bl, boolean bl2) {
            BaseTextUI.this.preferenceChanged(bl, bl2);
        }

        public float getAlignment(int n) {
            if (this.view != null) {
                return this.view.getAlignment(n);
            }
            return 0.0f;
        }

        public void paint(Graphics graphics, Shape shape) {
            if (this.view != null) {
                this.view.paint(graphics, shape);
            }
        }

        public void setParent(View view) {
        }

        public int getViewCount() {
            return 1;
        }

        public View getView(int n) {
            return this.view;
        }

        public Shape getChildAllocation(int n, Shape shape) {
            return shape;
        }

        public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
            if (this.view != null) {
                return this.view.modelToView(n, shape, bias);
            }
            return null;
        }

        public Shape modelToView(int n, Position.Bias bias, int n2, Position.Bias bias2, Shape shape) throws BadLocationException {
            if (this.view != null) {
                return this.view.modelToView(n, bias, n2, bias2, shape);
            }
            return null;
        }

        public void modelToViewDG(int n, DrawGraphics drawGraphics) throws BadLocationException {
            if (this.view != null) {
                this.view.modelToViewDG(n, drawGraphics);
            }
        }

        public int getNextVisualPositionFrom(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
            if (this.view != null) {
                int n3 = this.view.getNextVisualPositionFrom(n, bias, shape, n2, biasArray);
                if (n3 != -1) {
                    n = n3;
                } else if (biasArray != null) {
                    biasArray[0] = bias;
                }
            }
            return n;
        }

        public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
            if (this.view != null) {
                return this.view.viewToModel(f, f2, shape, biasArray);
            }
            return -1;
        }

        protected int getYFromPos(int n) throws BadLocationException {
            if (this.view != null) {
                return this.view.getYFromPos(n);
            }
            return 0;
        }

        protected int getPosFromY(int n) {
            if (this.view != null) {
                return this.view.getPosFromY(n);
            }
            return -1;
        }

        protected int getBaseX(int n) {
            if (this.view != null) {
                return this.view.getBaseX(n);
            }
            return 0;
        }

        public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            if (this.view != null) {
                this.view.insertUpdate(documentEvent, shape, viewFactory);
            }
        }

        public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            if (this.view != null) {
                this.view.removeUpdate(documentEvent, shape, viewFactory);
            }
        }

        public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            if (this.view != null) {
                this.view.changedUpdate(documentEvent, shape, viewFactory);
            }
        }

        public Document getDocument() {
            return BaseTextUI.this.component.getDocument();
        }

        public int getStartOffset() {
            if (this.view != null) {
                return this.view.getStartOffset();
            }
            return this.getElement().getStartOffset();
        }

        public int getEndOffset() {
            if (this.view != null) {
                return this.view.getEndOffset();
            }
            return this.getElement().getEndOffset();
        }

        public Element getElement() {
            if (this.view != null) {
                return this.view.getElement();
            }
            return BaseTextUI.this.component.getDocument().getDefaultRootElement();
        }

        public View breakView(int n, float f, Shape shape) {
            return null;
        }

        public int getResizeWeight(int n) {
            if (this.view != null) {
                return this.view.getResizeWeight(n);
            }
            return 0;
        }

        public void setSize(float f, float f2) {
            if (this.view != null) {
                this.view.setSize(f, f2);
            }
        }

        public Container getContainer() {
            return BaseTextUI.this.component;
        }

        public ViewFactory getViewFactory() {
            EditorKit editorKit = BaseTextUI.this.getEditorKit(BaseTextUI.this.component);
            ViewFactory viewFactory = editorKit.getViewFactory();
            if (viewFactory != null) {
                return viewFactory;
            }
            return BaseTextUI.this;
        }

        protected int getStartY() {
            return BaseTextUI.this.getEditorUI().textMargin.top;
        }

        protected int getPaintAreas(Graphics graphics, int n, int n2) {
            return 0;
        }

        protected void paintAreas(Graphics graphics, int n, int n2, int n3) {
        }

        protected int getViewStartY(BaseView baseView, int n) {
            return this.getStartY();
        }

        protected void invalidateStartY() {
            if (this.view != null) {
                this.view.invalidateStartY();
            }
        }

        public int getHeight() {
            if (this.view != null) {
                return this.view.getHeight();
            }
            return 0;
        }

        public void updateMainHeight() {
            if (this.view != null) {
                this.view.updateMainHeight();
                EditorUI editorUI = BaseTextUI.this.getEditorUI();
                if (editorUI.updateVirtualHeight(this.getHeight())) {
                    BaseTextUI.this.preferenceChanged(true, true);
                }
            }
        }
    }
}

