/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.DrawGraphics;
import org.netbeans.editor.EditorUI;

public abstract class BaseView
extends View {
    protected static final int INSETS_TOP = 1;
    protected static final int MAIN_AREA = 2;
    protected static final int INSETS_BOTTOM = 4;
    protected boolean packed;
    protected int helperInd;
    private JTextComponent component;
    protected Insets insets;
    private int startY = -1;

    public BaseView(Element element) {
        super(element);
    }

    public boolean isPacked() {
        return this.packed;
    }

    public void setPacked(boolean bl) {
        this.packed = bl;
    }

    public float getAlignment(int n) {
        return 0.0f;
    }

    public abstract void modelToViewDG(int var1, DrawGraphics var2) throws BadLocationException;

    protected abstract int getYFromPos(int var1) throws BadLocationException;

    protected abstract int getPosFromY(int var1);

    protected abstract int getBaseX(int var1);

    protected abstract int getPaintAreas(Graphics var1, int var2, int var3);

    protected abstract void paintAreas(Graphics var1, int var2, int var3, int var4);

    public void paint(Graphics graphics, Shape shape) {
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle.height < 0 || rectangle.width < 0) {
            return;
        }
        int n = this.getPaintAreas(graphics, rectangle.y, rectangle.height);
        if (n != 0) {
            this.paintAreas(graphics, rectangle.y, rectangle.height, n);
        }
    }

    public JTextComponent getComponent() {
        if (this.component == null) {
            this.component = (JTextComponent)this.getContainer();
        }
        return this.component;
    }

    public Insets getInsets() {
        return this.insets;
    }

    protected void setHelperInd(int n) {
        this.helperInd = n;
    }

    protected abstract int getViewStartY(BaseView var1, int var2);

    protected void invalidateStartY() {
        this.startY = -1;
    }

    protected int getStartY() {
        BaseView baseView;
        if (this.startY == -1 && (baseView = (BaseView)this.getParent()) != null) {
            this.startY = baseView.getViewStartY(this, this.helperInd);
        }
        return this.startY;
    }

    public abstract int getHeight();

    public abstract void updateMainHeight();

    public float getPreferredSpan(int n) {
        switch (n) {
            case 1: {
                return this.getHeight();
            }
        }
        return 0.0f;
    }

    protected EditorUI getEditorUI() {
        return ((BaseTextUI)this.getComponent().getUI()).getEditorUI();
    }

    public void displayHierarchy() {
        BaseView baseView = this;
        while (baseView.getParent() != null) {
            baseView = (BaseView)baseView.getParent();
        }
        baseView.displayHierarchyHelper(this, 0, 0);
    }

    private void displayHierarchyHelper(View view, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this == view ? "*" : " ");
        int n3 = 0;
        while (n3 < n) {
            stringBuffer.append(' ');
            ++n3;
        }
        stringBuffer.append('[');
        stringBuffer.append(Integer.toString(n2));
        stringBuffer.append("] ");
        stringBuffer.append(this.toString());
        System.out.println(stringBuffer);
        int n4 = this.getViewCount();
        if (n4 > 0) {
            int n5 = 0;
            while (n5 < n4) {
                ((BaseView)this.getView(n5)).displayHierarchyHelper(view, n + 1, n5);
                ++n5;
            }
        }
    }

    public String toString() {
        return "BaseView=" + System.identityHashCode(this) + ", elem=" + this.getElement() + ", parent=" + System.identityHashCode(this.getParent());
    }
}

