/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import org.netbeans.editor.DrawContext;
import org.netbeans.editor.MarkFactory;

public interface DrawLayer {
    public String getName();

    public boolean extendsEOL();

    public boolean extendsEmptyLine();

    public int getNextActivityChangeOffset(DrawContext var1);

    public void init(DrawContext var1);

    public boolean isActive(DrawContext var1, MarkFactory.DrawMark var2);

    public void updateContext(DrawContext var1);

    public int updateLineNumberContext(int var1, DrawContext var2);

    public static abstract class AbstractLayer
    implements DrawLayer {
        private String name;
        int nextActivityChangeOffset = Integer.MAX_VALUE;

        public AbstractLayer(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public boolean extendsEOL() {
            return false;
        }

        public boolean extendsEmptyLine() {
            return false;
        }

        public int getNextActivityChangeOffset(DrawContext drawContext) {
            return this.nextActivityChangeOffset;
        }

        public void setNextActivityChangeOffset(int n) {
            this.nextActivityChangeOffset = n;
        }

        public void init(DrawContext drawContext) {
        }

        public int updateLineNumberContext(int n, DrawContext drawContext) {
            return n;
        }

        public String toString() {
            return "Layer " + this.getClass() + ", name='" + this.name;
        }

        public abstract void updateContext(DrawContext var1);

        public abstract boolean isActive(DrawContext var1, MarkFactory.DrawMark var2);
    }
}

