/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import org.netbeans.editor.Analyzer;
import org.netbeans.editor.DocCacheSupport;

class MemCacheSupport
extends DocCacheSupport {
    private static final int CACHE_INCREMENT = 2048;
    char[] buffer = Analyzer.EMPTY_CHAR_ARRAY;

    public MemCacheSupport() {
    }

    public MemCacheSupport(int n) {
        this.buffer = new char[n];
    }

    private void checkSpace(int n) {
        if (this.buffer.length < n) {
            char[] cArray = new char[n + 2048 + n / 8];
            System.arraycopy(this.buffer, 0, cArray, 0, this.getDocLength());
            this.buffer = cArray;
        }
    }

    public void ensureCapacity(int n) {
        this.checkSpace(n);
    }

    public void read(int n, char[] cArray, int n2, int n3) {
        if (n3 == 0) {
            return;
        }
        System.arraycopy(this.buffer, n, cArray, n2, n3);
    }

    public void write(int n, char[] cArray, int n2, int n3) {
        if (n3 == 0) {
            return;
        }
        this.checkSpace(n + n3);
        System.arraycopy(cArray, n2, this.buffer, n, n3);
        this.docLen = Math.max(this.docLen, n + n3);
    }

    public void insert(int n, char[] cArray, int n2, int n3) {
        if (n3 == 0) {
            return;
        }
        this.checkSpace(this.getDocLength() + n3);
        System.arraycopy(this.buffer, n, this.buffer, n + n3, this.getDocLength() - n);
        System.arraycopy(cArray, n2, this.buffer, n, n3);
        this.docLen += n3;
    }

    public void insertString(int n, String string, int n2, int n3) {
        if (n3 == 0) {
            return;
        }
        this.checkSpace(this.getDocLength() + n3);
        System.arraycopy(this.buffer, n, this.buffer, n + n3, this.getDocLength() - n);
        string.getChars(n2, n2 + n3, this.buffer, n);
        this.docLen += n3;
    }

    public void remove(int n, int n2) {
        if (n2 == 0) {
            return;
        }
        System.arraycopy(this.buffer, n + n2, this.buffer, n, this.getDocLength() - (n + n2));
        this.docLen -= n2;
    }

    public boolean supportsDirectMode() {
        return true;
    }

    public char[] getDirectModeBuffer() {
        return this.buffer;
    }
}

