/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.editor.EditorDebug;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.WeakEventListenerList;

public class Settings {
    public static final int CORE_LEVEL = 0;
    public static final int SYSTEM_LEVEL = 1;
    public static final int EXTENSION_LEVEL = 2;
    public static final int OPTION_LEVEL = 3;
    public static final int USER_LEVEL = 4;
    private static final ArrayList initializerLists = new ArrayList();
    private static InitializerSorter currentInitializerSorter;
    private static final ArrayList filterList;
    private static final Map kit2Maps;
    private static final WeakEventListenerList listenerList;
    private static final Map NULL_MAP;
    private static boolean firingEnabled;
    private static HashMap emptyMap;
    static /* synthetic */ Class class$org$netbeans$editor$SettingsChangeListener;
    static /* synthetic */ Class class$org$netbeans$editor$Settings;

    private Settings() {
    }

    public static synchronized void addInitializer(Initializer initializer) {
        Settings.addInitializer(initializer, 1);
        Settings.reset();
    }

    public static synchronized void addInitializer(Initializer initializer, int n) {
        int n2;
        int n3 = n2 = initializerLists.size();
        while (n3 <= n) {
            initializerLists.add(new ArrayList());
            ++n3;
        }
        ((List)initializerLists.get(n)).add(initializer);
        if (currentInitializerSorter != null) {
            currentInitializerSorter.sort(initializerLists);
        }
    }

    public static synchronized void removeInitializer(String string) {
        Iterator iterator = ((AbstractList)initializerLists).iterator();
        while (iterator.hasNext()) {
            Iterator iterator2 = ((List)iterator.next()).iterator();
            while (iterator2.hasNext()) {
                if (!string.equals(((Initializer)iterator2.next()).getName())) continue;
                iterator2.remove();
            }
        }
        if (currentInitializerSorter != null) {
            currentInitializerSorter.sort(initializerLists);
        }
    }

    public static synchronized InitializerSorter getInitializerSorter() {
        return currentInitializerSorter;
    }

    public static synchronized void setInitializerSorter(InitializerSorter initializerSorter) {
        currentInitializerSorter = initializerSorter;
    }

    public static synchronized void addFilter(Filter filter) {
        filterList.add(filter);
    }

    public static synchronized void removeFilter(Filter filter) {
        Iterator iterator = ((AbstractList)filterList).iterator();
        while (iterator.hasNext()) {
            if (iterator.next() != filter) continue;
            iterator.remove();
        }
    }

    public static Object getValue(Class clazz, String string) {
        return Settings.getValue(clazz, string, true);
    }

    public static synchronized Object getValue(Class clazz, String string, boolean bl) {
        Object object = null;
        Class clazz2 = clazz;
        while (true) {
            Map map;
            if ((map = Settings.getKitMap(clazz2, false)) != null) {
                object = map.get(string);
                if (bl && object instanceof Evaluator) {
                    object = ((Evaluator)object).getValue(clazz, string);
                }
                if (object != null) break;
            }
            if (clazz2 == null) break;
            clazz2 = clazz2.getSuperclass();
        }
        int n = filterList.size();
        int n2 = 0;
        while (n2 < n) {
            object = ((Filter)filterList.get(n2)).filterValue(clazz, string, object);
            ++n2;
        }
        return object;
    }

    public static KitAndValue[] getValueHierarchy(Class clazz, String string) {
        return Settings.getValueHierarchy(clazz, string, true);
    }

    public static synchronized KitAndValue[] getValueHierarchy(Class clazz, String string, boolean bl) {
        KitAndValue[] kitAndValueArray;
        ArrayList<KitAndValue> arrayList = new ArrayList<KitAndValue>();
        Class clazz2 = clazz;
        while (true) {
            if ((kitAndValueArray = Settings.getKitMap(clazz2, false)) != null) {
                Object object = kitAndValueArray.get(string);
                if (bl && object instanceof Evaluator) {
                    object = ((Evaluator)object).getValue(clazz, string);
                }
                if (object != null) {
                    arrayList.add(new KitAndValue(clazz2, object));
                }
            }
            if (clazz2 == null) break;
            clazz2 = clazz2.getSuperclass();
        }
        kitAndValueArray = arrayList.toArray(new KitAndValue[arrayList.size()]);
        int n = filterList.size();
        int n2 = 0;
        while (n2 < n) {
            kitAndValueArray = ((Filter)filterList.get(n2)).filterValueHierarchy(clazz, string, kitAndValueArray);
            ++n2;
        }
        return kitAndValueArray;
    }

    public static synchronized void setValue(Class clazz, String string, Object object) {
        Map map = Settings.getKitMap(clazz, true);
        Object v = map.get(string);
        if (v == null && object == null || v != null && v.equals(object)) {
            return;
        }
        if (object != null) {
            map.put(string, object);
        } else {
            map.remove(string);
        }
        Settings.fireSettingsChange(clazz, string, v, object);
    }

    public static synchronized void touchValue(Class clazz, String string) {
        Settings.fireSettingsChange(clazz, string, null, null);
    }

    public static synchronized void propagateValue(Class clazz, String string, Object object) {
        Map map = Settings.getKitMap(clazz, true);
        if (object != null) {
            map.put(string, object);
        } else {
            map.remove(string);
        }
        Iterator iterator = kit2Maps.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Class clazz2 = (Class)entry.getKey();
            if (clazz == clazz2 || clazz != null && !clazz.isAssignableFrom(clazz2)) continue;
            ((Map)entry.getValue()).remove(string);
        }
        Settings.fireSettingsChange(null, string, null, null);
    }

    public static synchronized void update(Runnable runnable) {
        block3: {
            boolean bl = firingEnabled;
            firingEnabled = false;
            try {
                runnable.run();
                Object var3_2 = null;
                if (!bl) break block3;
                firingEnabled = true;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (bl) {
                    firingEnabled = true;
                    Settings.fireSettingsChange(null, null, null, null);
                }
                throw throwable;
            }
            Settings.fireSettingsChange(null, null, null, null);
            {
            }
        }
    }

    public static synchronized void reset() {
        kit2Maps.clear();
        Settings.fireSettingsChange(null, null, null, null);
    }

    public static synchronized String initializersToString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < initializerLists.size()) {
            switch (n) {
                case 0: {
                    stringBuffer.append("CORE_LEVEL");
                    break;
                }
                case 1: {
                    stringBuffer.append("SYSTEM_LEVEL");
                    break;
                }
                case 2: {
                    stringBuffer.append("EXTENSION_LEVEL");
                    break;
                }
                case 3: {
                    stringBuffer.append("OPTION_LEVEL");
                    break;
                }
                case 4: {
                    stringBuffer.append("USER_LEVEL");
                    break;
                }
                default: {
                    stringBuffer.append("level " + n);
                }
            }
            stringBuffer.append(":\n");
            stringBuffer.append(EditorDebug.debugList((List)initializerLists.get(n)));
            stringBuffer.append('\n');
            ++n;
        }
        return stringBuffer.toString();
    }

    public static void addSettingsChangeListener(SettingsChangeListener settingsChangeListener) {
        listenerList.add(class$org$netbeans$editor$SettingsChangeListener == null ? (class$org$netbeans$editor$SettingsChangeListener = Settings.class$("org.netbeans.editor.SettingsChangeListener")) : class$org$netbeans$editor$SettingsChangeListener, settingsChangeListener);
    }

    public static void removeSettingsChangeListener(SettingsChangeListener settingsChangeListener) {
        listenerList.remove(class$org$netbeans$editor$SettingsChangeListener == null ? (class$org$netbeans$editor$SettingsChangeListener = Settings.class$("org.netbeans.editor.SettingsChangeListener")) : class$org$netbeans$editor$SettingsChangeListener, settingsChangeListener);
    }

    private static void fireSettingsChange(Class clazz, String string, Object object, Object object2) {
        if (firingEnabled) {
            SettingsChangeListener[] settingsChangeListenerArray = (SettingsChangeListener[])listenerList.getListeners(class$org$netbeans$editor$SettingsChangeListener == null ? (class$org$netbeans$editor$SettingsChangeListener = Settings.class$("org.netbeans.editor.SettingsChangeListener")) : class$org$netbeans$editor$SettingsChangeListener);
            SettingsChangeEvent settingsChangeEvent = new SettingsChangeEvent(class$org$netbeans$editor$Settings == null ? (class$org$netbeans$editor$Settings = Settings.class$("org.netbeans.editor.Settings")) : class$org$netbeans$editor$Settings, clazz, string, object, object2);
            int n = 0;
            while (n < settingsChangeListenerArray.length) {
                settingsChangeListenerArray[n].settingsChange(settingsChangeEvent);
                ++n;
            }
        }
    }

    private static Map getKitMap(Class clazz, boolean bl) {
        Map map = (HashMap)kit2Maps.get(clazz);
        if (map == null) {
            if (emptyMap == null) {
                emptyMap = new HashMap();
            }
            Iterator iterator = ((AbstractList)initializerLists).iterator();
            while (iterator.hasNext()) {
                Iterator iterator2 = ((List)iterator.next()).iterator();
                while (iterator2.hasNext()) {
                    Initializer initializer = (Initializer)iterator2.next();
                    try {
                        initializer.updateSettingsMap(clazz, emptyMap);
                    }
                    catch (Throwable throwable) {
                        if (System.getProperty("netbeans.debug.exceptions") == null) continue;
                        throwable.printStackTrace();
                    }
                }
            }
            if (emptyMap.size() > 0) {
                map = emptyMap;
                emptyMap = null;
            }
            if (map == null) {
                map = NULL_MAP;
            }
            kit2Maps.put(clazz, map);
        }
        if (map == NULL_MAP) {
            if (!bl) {
                return null;
            }
            map = new HashMap();
            kit2Maps.put(clazz, map);
        }
        return map;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        filterList = new ArrayList();
        kit2Maps = new HashMap();
        listenerList = new WeakEventListenerList();
        NULL_MAP = new HashMap(1);
        firingEnabled = true;
        emptyMap = null;
    }

    public static interface Filter {
        public Object filterValue(Class var1, String var2, Object var3);

        public KitAndValue[] filterValueHierarchy(Class var1, String var2, KitAndValue[] var3);
    }

    public static interface Evaluator {
        public Object getValue(Class var1, String var2);
    }

    public static abstract class FilterInitializerSorter {
        private InitializerSorter delegate;

        public FilterInitializerSorter(InitializerSorter initializerSorter) {
            this.delegate = initializerSorter;
        }

        public void sort(List list) {
            if (this.delegate != null) {
                this.delegate.sort(list);
            }
        }
    }

    public static interface InitializerSorter {
        public void sort(List var1);
    }

    public static abstract class AbstractInitializer
    implements Initializer {
        private String name;

        public AbstractInitializer(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.getName();
        }

        public abstract void updateSettingsMap(Class var1, Map var2);
    }

    public static interface Initializer {
        public String getName();

        public void updateSettingsMap(Class var1, Map var2);
    }

    public static class KitAndValue {
        public Class kitClass;
        public Object value;

        public KitAndValue(Class clazz, Object object) {
            this.kitClass = clazz;
            this.value = object;
        }
    }
}

