/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.editor.EditorState;
import org.netbeans.editor.LocaleSupport;

public class GotoDialogPanel
extends JPanel {
    static final long serialVersionUID = -8686958102543713464L;
    private static final String HISTORY_KEY = "GotoDialogPanel.history-goto-line";
    private static final int MAX_ITEMS = 20;
    private boolean dontFire = false;
    protected JLabel gotoLabel;
    protected JComboBox gotoCombo;

    public GotoDialogPanel() {
        this.initComponents();
        this.getAccessibleContext().setAccessibleName(LocaleSupport.getString("goto-title"));
        this.getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_goto"));
        this.gotoCombo.getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_goto-line"));
        ArrayList arrayList = (ArrayList)EditorState.get(HISTORY_KEY);
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        this.updateCombo(arrayList);
    }

    protected void updateCombo(List list) {
        this.dontFire = true;
        this.gotoCombo.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
        this.dontFire = false;
    }

    private void initComponents() {
        this.gotoLabel = new JLabel();
        this.gotoCombo = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.gotoLabel.setText(LocaleSupport.getString("goto-line"));
        this.gotoLabel.setLabelFor(this.gotoCombo);
        this.gotoLabel.setDisplayedMnemonic(LocaleSupport.getChar("goto-line-mnemonic", 'l'));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.gotoLabel, gridBagConstraints);
        this.gotoCombo.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 0, 0, 10);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.gotoCombo, gridBagConstraints);
    }

    public String getValue() {
        return (String)this.gotoCombo.getEditor().getItem();
    }

    public void updateHistory() {
        String string;
        List<String> list = (ArrayList<String>)EditorState.get(HISTORY_KEY);
        if (list == null) {
            list = new ArrayList<String>();
        }
        if (list.contains(string = this.getValue())) {
            list.remove(string);
            list.add(0, string);
        } else {
            if (list.size() >= 20) {
                list = list.subList(0, 19);
            }
            list.add(0, this.getValue());
        }
        EditorState.put(HISTORY_KEY, list);
        this.updateCombo(list);
    }

    public void popupNotify() {
        this.gotoCombo.getEditor().selectAll();
        this.gotoCombo.getEditor().getEditorComponent().requestFocus();
    }

    public JComboBox getGotoCombo() {
        return this.gotoCombo;
    }
}

