/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.WeakTimerListener;
import org.netbeans.editor.ext.ExtEditorUI;

public class ToolTipSupport
extends MouseAdapter
implements MouseMotionListener,
ActionListener,
PropertyChangeListener,
SettingsChangeListener,
FocusListener {
    public static final String PROP_TOOL_TIP = "toolTip";
    public static final String PROP_TOOL_TIP_TEXT = "toolTipText";
    public static final String PROP_STATUS = "status";
    public static final String PROP_ENABLED = "enabled";
    public static final String PROP_INITIAL_DELAY = "initialDelay";
    public static final String PROP_DISMISS_DELAY = "dismissDelay";
    private static final String UI_PREFIX = "ToolTip";
    public static final int INITIAL_DELAY = 1000;
    public static final int DISMISS_DELAY = 60000;
    public static final int STATUS_HIDDEN = 0;
    public static final int STATUS_VISIBILITY_ENABLED = 1;
    public static final int STATUS_TEXT_VISIBLE = 2;
    public static final int STATUS_COMPONENT_VISIBLE = 3;
    private ExtEditorUI extEditorUI;
    private JComponent toolTip;
    private String toolTipText;
    private Timer enterTimer;
    private Timer exitTimer;
    private boolean enabled;
    private int status;
    private MouseEvent lastMouseEvent;
    private ComponentAdapter componentL;
    private PropertyChangeSupport pcs;
    static /* synthetic */ Class class$java$lang$String;

    public ToolTipSupport(ExtEditorUI extEditorUI) {
        this.extEditorUI = extEditorUI;
        this.componentL = new ComponentAdapter(){

            public void componentHidden(ComponentEvent componentEvent) {
                ToolTipSupport.this.checkRemoveFromPane((JComponent)componentEvent.getSource());
            }
        };
        this.enterTimer = new Timer(1000, new WeakTimerListener(this));
        this.enterTimer.setRepeats(false);
        this.exitTimer = new Timer(60000, new WeakTimerListener(this));
        this.exitTimer.setRepeats(false);
        Settings.addSettingsChangeListener(this);
        extEditorUI.addPropertyChangeListener(this);
        this.setEnabled(true);
    }

    public final JComponent getToolTip() {
        if (this.toolTip == null) {
            this.setToolTip(this.createDefaultToolTip());
        }
        return this.toolTip;
    }

    public void setToolTip(JComponent jComponent) {
        if (this.toolTip != jComponent) {
            JComponent jComponent2 = this.toolTip;
            this.checkRemoveFromPane(this.extEditorUI.getComponent());
            this.toolTip = jComponent;
            this.checkAddToPane();
            if (this.status >= 1) {
                this.ensureVisibility();
            }
            this.firePropertyChange(PROP_TOOL_TIP, jComponent2, this.toolTip);
        }
    }

    protected JComponent createDefaultToolTip() {
        JLabel jLabel = new JLabel();
        Font font = UIManager.getFont("ToolTip.font");
        Color color = UIManager.getColor("ToolTip.background");
        Color color2 = UIManager.getColor("ToolTip.foreground");
        if (font != null) {
            jLabel.setFont(font);
        }
        if (color2 != null) {
            jLabel.setForeground(color2);
        }
        if (color != null) {
            jLabel.setBackground(color);
        }
        jLabel.setOpaque(true);
        jLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(jLabel.getForeground()), BorderFactory.createEmptyBorder(0, 3, 0, 3)));
        return jLabel;
    }

    public void settingsChange(SettingsChangeEvent settingsChangeEvent) {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        JComponent jComponent;
        String string = propertyChangeEvent.getPropertyName();
        if ("component".equals(string)) {
            jComponent = (JTextComponent)propertyChangeEvent.getNewValue();
            if (jComponent != null) {
                jComponent.addPropertyChangeListener(this);
                jComponent.addComponentListener(this.componentL);
                this.checkAddToPane();
                this.disableSwingToolTip(jComponent);
                jComponent.addFocusListener(this);
                if (jComponent.hasFocus()) {
                    this.focusGained(new FocusEvent(jComponent, 1004));
                }
            } else {
                jComponent = (JTextComponent)propertyChangeEvent.getOldValue();
                jComponent.removeFocusListener(this);
                jComponent.removePropertyChangeListener(this);
                jComponent.removeComponentListener(this.componentL);
                this.checkRemoveFromPane(jComponent);
            }
        }
        if ("ToolTipText".equals(string)) {
            jComponent = (JComponent)propertyChangeEvent.getSource();
            this.disableSwingToolTip(jComponent);
            this.componentToolTipTextChanged(propertyChangeEvent);
        }
    }

    private void disableSwingToolTip(final JComponent jComponent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ToolTipManager.sharedInstance().unregisterComponent(jComponent);
            }
        });
    }

    private void checkRemoveFromPane(JComponent jComponent) {
        JRootPane jRootPane;
        if (this.toolTip != null && (jRootPane = jComponent.getRootPane()) != null) {
            jRootPane.remove(this.toolTip);
        }
    }

    private void checkAddToPane() {
        JTextComponent jTextComponent;
        if (this.toolTip != null && (jTextComponent = this.extEditorUI.getComponent()) != null) {
            JRootPane jRootPane = jTextComponent.getRootPane();
            JRootPane jRootPane2 = this.toolTip.getRootPane();
            if (jRootPane2 != jRootPane) {
                if (jRootPane2 != null) {
                    jRootPane2.getLayeredPane().remove(this.toolTip);
                }
                jRootPane.getLayeredPane().add(this.toolTip, JLayeredPane.POPUP_LAYER, 0);
            }
        }
    }

    protected void updateToolTip() {
        Action action;
        ExtEditorUI extEditorUI = this.extEditorUI;
        if (extEditorUI == null) {
            return;
        }
        JTextComponent jTextComponent = extEditorUI.getComponent();
        if (jTextComponent == null) {
            return;
        }
        BaseKit baseKit = Utilities.getKit(jTextComponent);
        if (baseKit != null && (action = baseKit.getActionByName("build-tool-tip")) != null) {
            action.actionPerformed(new ActionEvent(jTextComponent, 0, ""));
        }
    }

    protected void updateToolTipBounds() {
        Dimension dimension = this.toolTip.getPreferredSize();
        Rectangle rectangle = this.extEditorUI.getExtentBounds();
        int n = Math.min(this.lastMouseEvent.getX() - dimension.width / 2, rectangle.x + rectangle.width - dimension.width);
        n = Math.max(n, rectangle.x);
        int n2 = this.extEditorUI.getLineHeight();
        int n3 = this.lastMouseEvent.getY() - 2 * n2;
        if (n3 - rectangle.y < n2) {
            n3 = this.lastMouseEvent.getY() + n2;
        }
        this.toolTip.setBounds(n - rectangle.x, n3 - rectangle.y, dimension.width, dimension.height);
    }

    protected void setToolTipVisible(boolean bl) {
        if (!bl) {
            this.enterTimer.stop();
            this.exitTimer.stop();
        }
        if (bl && this.status < 1 || !bl && this.status >= 1) {
            if (bl) {
                if (this.enabled) {
                    this.setStatus(1);
                    this.updateToolTip();
                }
            } else {
                if (this.toolTip != null) {
                    this.toolTip.setVisible(false);
                }
                this.setStatus(0);
            }
        }
    }

    public boolean isToolTipVisible() {
        return this.status > 1;
    }

    public final int getStatus() {
        return this.status;
    }

    private void setStatus(int n) {
        if (this.status != n) {
            int n2 = this.status;
            this.status = n;
            this.firePropertyChange(PROP_STATUS, new Integer(n2), new Integer(this.status));
        }
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public void setToolTipText(String string) {
        String string2 = this.toolTipText;
        this.toolTipText = string;
        this.firePropertyChange(PROP_TOOL_TIP_TEXT, string2, this.toolTipText);
        this.applyToolTipText();
        if (this.toolTipText != null) {
            if (this.status >= 1) {
                this.ensureVisibility();
            }
        } else if (this.status == 2) {
            this.setToolTipVisible(false);
        }
    }

    private void applyToolTipText() {
        JComponent jComponent = this.getToolTip();
        if (jComponent != null) {
            if (jComponent instanceof JLabel) {
                ((JLabel)jComponent).setText(this.toolTipText);
            } else if (jComponent instanceof JTextComponent) {
                ((JTextComponent)jComponent).setText(this.toolTipText);
            } else if (jComponent instanceof JToolTip) {
                ((JToolTip)jComponent).setTipText(this.toolTipText);
            } else {
                try {
                    Method method = jComponent.getClass().getMethod("setText", class$java$lang$String == null ? (class$java$lang$String = ToolTipSupport.class$("java.lang.String")) : class$java$lang$String);
                    if (method != null) {
                        method.invoke((Object)this.toolTip, this.toolTipText);
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
        }
    }

    private void ensureVisibility() {
        this.updateToolTipBounds();
        this.toolTip.setVisible(true);
        this.exitTimer.restart();
    }

    public String getIdentifierUnderCursor() {
        String string = null;
        try {
            JTextComponent jTextComponent = this.extEditorUI.getComponent();
            BaseTextUI baseTextUI = (BaseTextUI)jTextComponent.getUI();
            int n = baseTextUI.viewToModel(jTextComponent, this.lastMouseEvent.getPoint());
            if (n >= 0) {
                BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                int n2 = Utilities.getRowEnd(baseDocument, n);
                Rectangle rectangle = baseTextUI.modelToView(jTextComponent, n2);
                int n3 = this.extEditorUI.getLineHeight();
                if (this.lastMouseEvent.getX() <= rectangle.x && this.lastMouseEvent.getY() <= rectangle.y + n3) {
                    string = Utilities.getIdentifier(baseDocument, n);
                }
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return string;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        if (bl != this.enabled) {
            this.enabled = bl;
            this.firePropertyChange(PROP_ENABLED, bl ? Boolean.FALSE : Boolean.TRUE, bl ? Boolean.TRUE : Boolean.FALSE);
            if (!bl) {
                this.setToolTipVisible(false);
            }
        }
    }

    public int getInitialDelay() {
        return this.enterTimer.getDelay();
    }

    public void setInitialDelay(int n) {
        if (this.enterTimer.getDelay() != n) {
            int n2 = this.enterTimer.getDelay();
            this.enterTimer.setDelay(n);
            this.firePropertyChange(PROP_INITIAL_DELAY, new Integer(n2), new Integer(this.enterTimer.getDelay()));
        }
    }

    public int getDismissDelay() {
        return this.exitTimer.getDelay();
    }

    public void setDismissDelay(int n) {
        if (this.exitTimer.getDelay() != n) {
            int n2 = this.exitTimer.getDelay();
            this.exitTimer.setDelay(n);
            this.firePropertyChange(PROP_DISMISS_DELAY, new Integer(n2), new Integer(this.exitTimer.getDelay()));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.enterTimer) {
            this.setToolTipVisible(true);
        } else if (actionEvent.getSource() == this.exitTimer) {
            this.setToolTipVisible(false);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.lastMouseEvent = mouseEvent;
        this.setToolTipVisible(false);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.lastMouseEvent = mouseEvent;
        this.setToolTipVisible(false);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.lastMouseEvent = mouseEvent;
        this.setToolTipVisible(false);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.lastMouseEvent = mouseEvent;
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.lastMouseEvent = mouseEvent;
        this.setToolTipVisible(false);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.lastMouseEvent = mouseEvent;
        this.setToolTipVisible(false);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.setToolTipVisible(false);
        if (this.enabled) {
            this.enterTimer.restart();
        }
        this.lastMouseEvent = mouseEvent;
    }

    public final MouseEvent getLastMouseEvent() {
        return this.lastMouseEvent;
    }

    protected void componentToolTipTextChanged(PropertyChangeEvent propertyChangeEvent) {
        JComponent jComponent = (JComponent)propertyChangeEvent.getSource();
        this.setToolTipText(jComponent.getToolTipText());
    }

    private PropertyChangeSupport getPCS() {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        return this.pcs;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getPCS().addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getPCS().removePropertyChangeListener(propertyChangeListener);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        this.getPCS().firePropertyChange(string, object, object2);
    }

    public void focusGained(FocusEvent focusEvent) {
        JComponent jComponent = (JComponent)focusEvent.getSource();
        jComponent.addMouseListener(this);
        jComponent.addMouseMotionListener(this);
    }

    public void focusLost(FocusEvent focusEvent) {
        JComponent jComponent = (JComponent)focusEvent.getSource();
        jComponent.removeMouseListener(this);
        jComponent.removeMouseMotionListener(this);
        this.setToolTipVisible(false);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

