/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.java;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.netbeans.editor.ext.Completion;
import org.netbeans.editor.ext.CompletionQuery;
import org.netbeans.editor.ext.CompletionView;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.editor.ext.ListCompletionView;
import org.netbeans.editor.ext.java.JCCellRenderer;
import org.netbeans.editor.ext.java.JCClass;
import org.netbeans.editor.ext.java.JCClassProvider;
import org.netbeans.editor.ext.java.JCConstructor;
import org.netbeans.editor.ext.java.JCField;
import org.netbeans.editor.ext.java.JCFinder;
import org.netbeans.editor.ext.java.JCMethod;
import org.netbeans.editor.ext.java.JCPackage;
import org.netbeans.editor.ext.java.JCParameter;
import org.netbeans.editor.ext.java.JCType;
import org.netbeans.editor.ext.java.JavaCompletionQuery;
import org.netbeans.editor.ext.java.JavaTokenContext;

public class JavaCompletion
extends Completion {
    public static final int PUBLIC_LEVEL = 3;
    public static final int PROTECTED_LEVEL = 2;
    public static final int PACKAGE_LEVEL = 1;
    public static final int PRIVATE_LEVEL = 0;
    public static final SimpleClass BOOLEAN_CLASS = new SimpleClass("boolean", "");
    public static final SimpleClass BYTE_CLASS = new SimpleClass("byte", "");
    public static final SimpleClass CHAR_CLASS = new SimpleClass("char", "");
    public static final SimpleClass DOUBLE_CLASS = new SimpleClass("double", "");
    public static final SimpleClass FLOAT_CLASS = new SimpleClass("float", "");
    public static final SimpleClass INT_CLASS = new SimpleClass("int", "");
    public static final SimpleClass LONG_CLASS = new SimpleClass("long", "");
    public static final SimpleClass SHORT_CLASS = new SimpleClass("short", "");
    public static final SimpleClass VOID_CLASS = new SimpleClass("void", "");
    public static final BaseType BOOLEAN_TYPE = new BaseType(BOOLEAN_CLASS, 0);
    public static final BaseType BYTE_TYPE = new BaseType(BYTE_CLASS, 0);
    public static final BaseType CHAR_TYPE = new BaseType(CHAR_CLASS, 0);
    public static final BaseType DOUBLE_TYPE = new BaseType(DOUBLE_CLASS, 0);
    public static final BaseType FLOAT_TYPE = new BaseType(FLOAT_CLASS, 0);
    public static final BaseType INT_TYPE = new BaseType(INT_CLASS, 0);
    public static final BaseType LONG_TYPE = new BaseType(LONG_CLASS, 0);
    public static final BaseType SHORT_TYPE = new BaseType(SHORT_CLASS, 0);
    public static final BaseType VOID_TYPE = new BaseType(VOID_CLASS, 0);
    public static final SimpleClass INVALID_CLASS = new SimpleClass("", "");
    public static final BaseType INVALID_TYPE = new BaseType(INVALID_CLASS, 0);
    public static final SimpleClass NULL_CLASS = new SimpleClass("null", "");
    public static final BaseType NULL_TYPE = new BaseType(NULL_CLASS, 0);
    public static final SimpleClass OBJECT_CLASS_ARRAY = new SimpleClass("java.lang.Object[]", "java.lang".length(), true);
    public static final BaseType OBJECT_TYPE_ARRAY = new BaseType(OBJECT_CLASS_ARRAY, 0);
    public static final SimpleClass OBJECT_CLASS = new SimpleClass("java.lang.Object", "java.lang".length(), true);
    public static final BaseType OBJECT_TYPE = new BaseType(OBJECT_CLASS, 0);
    public static final SimpleClass CLASS_CLASS = new SimpleClass("java.lang.Class", "java.lang".length(), true);
    public static final BaseType CLASS_TYPE = new BaseType(CLASS_CLASS, 0);
    public static final SimpleClass STRING_CLASS = new SimpleClass("java.lang.String", "java.lang".length(), true);
    public static final BaseType STRING_TYPE = new BaseType(STRING_CLASS, 0);
    static final int INTERFACE_BIT = 0x40000000;
    static final int INTERFACE_BIT_FILTER = -1073741825;
    private static final HashMap str2PrimitiveClass = new HashMap();
    private static final HashMap str2PrimitiveType = new HashMap();
    public static final JCParameter[] EMPTY_PARAMETERS;
    public static final JCClass[] EMPTY_CLASSES;
    public static final JCPackage[] EMPTY_PACKAGES;
    public static final JCField[] EMPTY_FIELDS;
    public static final JCConstructor[] EMPTY_CONSTRUCTORS;
    public static final JCMethod[] EMPTY_METHODS;
    private static JCFinder finder;
    private static int debugMode;
    private static HashMap classCache;
    private static HashMap typeCache;
    public static final int DEBUG_EXP = 1;
    public static final int DEBUG_FIND = 2;
    private static JCFinderInitializer initializer;

    public static synchronized JCFinder getFinder() {
        if (finder == null) {
            if (initializer == null) {
                throw new IllegalStateException("Editor: Java completion can't be initialized.");
            }
            initializer.initJCFinder();
        }
        return finder;
    }

    public static synchronized void setFinder(JCFinder jCFinder) {
        finder = jCFinder;
    }

    public static void setFinderInitializer(JCFinderInitializer jCFinderInitializer) {
        initializer = jCFinderInitializer;
    }

    public JavaCompletion(ExtEditorUI extEditorUI) {
        super(extEditorUI);
    }

    protected CompletionView createView() {
        return new ListCompletionView(new JCCellRenderer());
    }

    protected CompletionQuery createQuery() {
        return new JavaCompletionQuery();
    }

    public static int getLevel(int n) {
        if ((n & 1) != 0) {
            return 3;
        }
        if ((n & 4) != 0) {
            return 2;
        }
        if ((n & 2) == 0) {
            return 1;
        }
        return 0;
    }

    public static boolean isPrimitiveClassName(String string) {
        return JavaTokenContext.isTypeOrVoid(string);
    }

    public static boolean isPrimitiveClass(JCClass jCClass) {
        return jCClass.getPackageName().length() == 0 && JavaCompletion.isPrimitiveClassName(jCClass.getName());
    }

    public static JCClass getPrimitiveClass(String string) {
        return (JCClass)str2PrimitiveClass.get(string);
    }

    public static JCType getPrimitiveType(String string) {
        return (JCType)str2PrimitiveType.get(string);
    }

    public static Iterator getPrimitiveClassIterator() {
        return str2PrimitiveClass.values().iterator();
    }

    public static JCClass getSimpleClass(String string, int n) {
        JCClass jCClass = (JCClass)classCache.get(string);
        if (jCClass == null || n != jCClass.getPackageName().length()) {
            jCClass = new SimpleClass(string, n, true);
            classCache.put(string, jCClass);
        }
        return jCClass;
    }

    public static JCClass getSimpleClass(JCClass jCClass) {
        return JavaCompletion.getSimpleClass(jCClass.getFullName(), jCClass.getPackageName().length());
    }

    public static JCClass createSimpleClass(String string) {
        int n = string.lastIndexOf(46) + 1;
        return JavaCompletion.createSimpleClass(string.substring(n), n > 0 ? string.substring(0, n - 1) : "");
    }

    public static JCClass createSimpleClass(String string, String string2) {
        return new SimpleClass(string, string2);
    }

    public static JCType createType(JCClass jCClass, int n) {
        return new BaseType(jCClass, n);
    }

    public static JCType getType(JCClass jCClass, int n) {
        if (jCClass == null) {
            return null;
        }
        JCType[] jCTypeArray = (JCType[])typeCache.get(jCClass);
        if (jCTypeArray != null) {
            if (n < jCTypeArray.length) {
                if (jCTypeArray[n] == null) {
                    jCTypeArray[n] = new BaseType(jCTypeArray[0].getClazz(), n);
                }
            } else {
                jCClass = jCTypeArray[0].getClazz();
                JCType[] jCTypeArray2 = new JCType[n + 1];
                System.arraycopy(jCTypeArray, 0, jCTypeArray2, 0, jCTypeArray.length);
                jCTypeArray = jCTypeArray2;
                jCTypeArray[n] = new BaseType(jCClass, n);
                typeCache.put(jCClass, jCTypeArray);
            }
        } else {
            jCClass = JavaCompletion.getSimpleClass(jCClass.getFullName(), jCClass.getPackageName().length());
            if (n > 0) {
                jCTypeArray = new JCType[n + 1];
                jCTypeArray[n] = new BaseType(jCClass, n);
            } else {
                jCTypeArray = new JCType[2];
            }
            jCTypeArray[0] = new BaseType(jCClass, 0);
            typeCache.put(jCClass, jCTypeArray);
        }
        return jCTypeArray[n];
    }

    public static int getDebugMode() {
        return debugMode;
    }

    public static void setDebugMode(int n) {
        debugMode = n;
    }

    static {
        BaseType[] baseTypeArray = new BaseType[]{BOOLEAN_TYPE, BYTE_TYPE, CHAR_TYPE, DOUBLE_TYPE, FLOAT_TYPE, INT_TYPE, LONG_TYPE, SHORT_TYPE, VOID_TYPE};
        int n = baseTypeArray.length - 1;
        while (n >= 0) {
            String string = baseTypeArray[n].getClazz().getName();
            str2PrimitiveClass.put(string, baseTypeArray[n].getClazz());
            str2PrimitiveType.put(string, baseTypeArray[n]);
            --n;
        }
        EMPTY_PARAMETERS = new JCParameter[0];
        EMPTY_CLASSES = new JCClass[0];
        EMPTY_PACKAGES = new JCPackage[0];
        EMPTY_FIELDS = new JCField[0];
        EMPTY_CONSTRUCTORS = new JCConstructor[0];
        EMPTY_METHODS = new JCMethod[0];
        classCache = new HashMap(5003);
        typeCache = new HashMap(5003);
    }

    public static interface JCFinderInitializer {
        public void initJCFinder();
    }

    public static class SingleProvider
    extends AbstractProvider
    implements Iterator {
        JCClass c;
        boolean next = true;

        public SingleProvider(JCClass jCClass) {
            this.c = jCClass;
        }

        public Iterator getClasses() {
            if (this.next) {
                return this;
            }
            throw new IllegalStateException();
        }

        public boolean hasNext() {
            return this.next;
        }

        public Object next() {
            this.next = false;
            return this.c;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class ListProvider
    extends AbstractProvider {
        private List classList;

        public ListProvider() {
            this.classList = new ArrayList();
        }

        public ListProvider(List list) {
            this.classList = list;
        }

        protected boolean appendClass(JCClass jCClass) {
            this.classList.add(jCClass);
            return true;
        }

        public Iterator getClasses() {
            return this.classList.iterator();
        }

        public int getClassCount() {
            return this.classList.size();
        }
    }

    public static abstract class AbstractProvider
    implements JCClassProvider {
        public abstract Iterator getClasses();

        public boolean append(JCClassProvider jCClassProvider) {
            Iterator iterator = jCClassProvider.getClasses();
            while (iterator.hasNext()) {
                JCClass jCClass = (JCClass)iterator.next();
                if (!jCClassProvider.notifyAppend(jCClass, false)) {
                    return false;
                }
                if (!this.appendClass(jCClass)) {
                    return false;
                }
                if (jCClassProvider.notifyAppend(jCClass, true)) continue;
                return false;
            }
            return true;
        }

        protected boolean appendClass(JCClass jCClass) {
            return true;
        }

        public void reset() {
        }

        public boolean notifyAppend(JCClass jCClass, boolean bl) {
            return true;
        }
    }

    public static class BaseMethod
    extends BaseConstructor
    implements JCMethod {
        protected String name;
        protected JCType returnType;

        public BaseMethod(JCClass jCClass, String string, int n, JCType jCType, JCParameter[] jCParameterArray, JCClass[] jCClassArray) {
            super(jCClass, n, jCParameterArray, jCClassArray);
            this.name = string;
            this.returnType = jCType;
        }

        BaseMethod() {
        }

        public String getName() {
            return this.name;
        }

        public JCType getReturnType() {
            return this.returnType;
        }

        public int compareTo(Object object) {
            if (this == object) {
                return 0;
            }
            JCMethod jCMethod = (JCMethod)object;
            int n = this.name.compareTo(jCMethod.getName());
            if (n == 0) {
                n = super.compareTo(object);
            }
            return n;
        }

        public int hashCode() {
            return this.name.hashCode() ^ super.hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof JCMethod) {
                return this.compareTo(object) == 0;
            }
            return false;
        }

        public String toString() {
            String string = this.getReturnType().toString();
            return this.toString(string.length() > 0 ? string + ' ' : "", this.name);
        }
    }

    public static class BaseConstructor
    implements JCConstructor {
        protected JCClass clazz;
        protected int tagOffset;
        protected int modifiers;
        protected JCParameter[] parameters;
        protected JCClass[] exceptions;

        public BaseConstructor(JCClass jCClass, int n, JCParameter[] jCParameterArray, JCClass[] jCClassArray) {
            this.clazz = jCClass;
            this.modifiers = n;
            this.parameters = jCParameterArray;
            this.exceptions = jCClassArray;
        }

        BaseConstructor() {
        }

        public JCClass getClazz() {
            return this.clazz;
        }

        public int getTagOffset() {
            return this.tagOffset;
        }

        public int getModifiers() {
            return this.modifiers;
        }

        public JCParameter[] getParameters() {
            return this.parameters;
        }

        public JCClass[] getExceptions() {
            return this.exceptions;
        }

        public int compareTo(Object object) {
            if (this == object) {
                return 0;
            }
            JCConstructor jCConstructor = (JCConstructor)object;
            int n = 0;
            JCParameter[] jCParameterArray = jCConstructor.getParameters();
            int n2 = Math.min(this.parameters.length, jCParameterArray.length);
            int n3 = 0;
            while (n3 < n2) {
                n = this.parameters[n3].compareTo(jCParameterArray[n3]);
                if (n != 0) {
                    return n;
                }
                ++n3;
            }
            n = this.parameters.length - jCParameterArray.length;
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof JCConstructor) {
                return this.compareTo(object) == 0;
            }
            return false;
        }

        public int hashCode() {
            int n = 0;
            int n2 = 0;
            while (n2 < this.parameters.length) {
                n ^= this.parameters[n2].hashCode();
                ++n2;
            }
            return n;
        }

        String toString(String string, String string2) {
            StringBuffer stringBuffer = new StringBuffer(Modifier.toString(this.modifiers));
            stringBuffer.append(' ');
            stringBuffer.append(string);
            stringBuffer.append(string2);
            stringBuffer.append('(');
            int n = this.parameters.length - 1;
            int n2 = 0;
            while (n2 <= n) {
                stringBuffer.append(this.parameters[n2].toString());
                if (n2 < n) {
                    stringBuffer.append(", ");
                }
                ++n2;
            }
            stringBuffer.append(')');
            n = this.exceptions.length - 1;
            if (n >= 0) {
                stringBuffer.append(" throws ");
                int n3 = 0;
                while (n3 <= n) {
                    stringBuffer.append(this.exceptions[n3].toString());
                    if (n3 < n) {
                        stringBuffer.append(", ");
                    }
                    ++n3;
                }
            }
            return stringBuffer.toString();
        }

        public String toString() {
            return this.toString("", this.getClazz().getName());
        }
    }

    public static class BaseField
    extends BaseParameter
    implements JCField {
        protected JCClass clazz;
        protected int modifiers;
        protected int tagOffset;

        public BaseField(JCClass jCClass, String string, JCType jCType, int n) {
            super(string, jCType);
            this.clazz = jCClass;
            this.modifiers = n;
        }

        BaseField() {
        }

        public int getModifiers() {
            return this.modifiers;
        }

        public JCClass getClazz() {
            return this.clazz;
        }

        public int getTagOffset() {
            return this.tagOffset;
        }

        public int compareTo(Object object) {
            if (this == object) {
                return 0;
            }
            JCField jCField = (JCField)object;
            int n = super.compareTo(object);
            if (n == 0) {
                n = this.name.compareTo(jCField.getName());
            }
            return n;
        }

        public int hashCode() {
            return this.type.hashCode() ^ this.name.hashCode() ^ this.modifiers;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof JCField) {
                JCField jCField = (JCField)object;
                return this.name.equals(jCField.getName()) && this.type.equals(jCField.getType());
            }
            return false;
        }

        public String toString() {
            return Modifier.toString(this.modifiers) + ' ' + super.toString();
        }
    }

    public static class BaseParameter
    implements JCParameter {
        protected String name;
        protected JCType type;

        public BaseParameter(String string, JCType jCType) {
            this.name = string;
            this.type = jCType;
        }

        BaseParameter() {
        }

        public String getName() {
            return this.name;
        }

        public JCType getType() {
            return this.type;
        }

        public int compareTo(Object object) {
            if (this == object) {
                return 0;
            }
            JCParameter jCParameter = (JCParameter)object;
            return this.type.compareTo(jCParameter.getType());
        }

        public int hashCode() {
            return this.type.hashCode() ^ this.name.hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof JCParameter) {
                JCParameter jCParameter = (JCParameter)object;
                return this.type.equals(jCParameter.getType());
            }
            return false;
        }

        public String toString() {
            return this.type.toString() + ' ' + this.name;
        }
    }

    public static class BaseType
    implements JCType {
        protected JCClass clazz;
        protected int arrayDepth;

        public BaseType(JCClass jCClass, int n) {
            this.clazz = jCClass;
            this.arrayDepth = n;
            if (n < 0) {
                throw new IllegalArgumentException("Array depth " + n + " < 0.");
            }
        }

        BaseType() {
        }

        public JCClass getClazz() {
            return this.clazz;
        }

        public int getArrayDepth() {
            return this.arrayDepth;
        }

        public String format(boolean bl) {
            StringBuffer stringBuffer = new StringBuffer(bl ? this.getClazz().getFullName() : this.getClazz().getName());
            int n = this.arrayDepth;
            while (n > 0) {
                stringBuffer.append("[]");
                --n;
            }
            return stringBuffer.toString();
        }

        public int compareTo(Object object) {
            if (this == object) {
                return 0;
            }
            JCType jCType = (JCType)object;
            int n = this.clazz.compareTo(jCType.getClazz());
            if (n == 0) {
                n = this.arrayDepth - jCType.getArrayDepth();
            }
            return n;
        }

        public int hashCode() {
            return this.clazz.hashCode() + this.arrayDepth;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof JCType) {
                JCType jCType = (JCType)object;
                return this.clazz.equals(jCType.getClazz()) && this.arrayDepth == jCType.getArrayDepth();
            }
            return false;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.clazz.toString());
            int n = this.arrayDepth;
            while (n > 0) {
                stringBuffer.append("[]");
                --n;
            }
            return stringBuffer.toString();
        }
    }

    public static abstract class AbstractClass
    extends SimpleClass {
        protected int modifiers;
        protected Body body;

        public AbstractClass(String string, String string2, boolean bl, int n) {
            super(string, string2);
            this.modifiers = n;
            if (bl) {
                this.modifiers |= 0x40000000;
            }
        }

        AbstractClass() {
        }

        protected abstract void init();

        public boolean isInterface() {
            return (this.modifiers & 0x40000000) != 0;
        }

        public int getModifiers() {
            return this.modifiers & 0xBFFFFFFF;
        }

        public int getTagOffset() {
            if (this.body == null) {
                this.init();
            }
            return this.body.tagOffset;
        }

        public JCClass getSuperclass() {
            if (this.body == null) {
                this.init();
            }
            return this.body.superClass;
        }

        public JCClass[] getInterfaces() {
            if (this.body == null) {
                this.init();
            }
            return this.body.interfaces;
        }

        public JCField[] getFields() {
            if (this.body == null) {
                this.init();
            }
            return this.body.fields;
        }

        public JCConstructor[] getConstructors() {
            if (this.body == null) {
                this.init();
            }
            return this.body.constructors;
        }

        public JCMethod[] getMethods() {
            if (this.body == null) {
                this.init();
            }
            return this.body.methods;
        }

        public static class Body {
            public int tagOffset;
            public JCClass superClass;
            public JCClass[] interfaces;
            public JCField[] fields;
            public JCConstructor[] constructors;
            public JCMethod[] methods;
        }
    }

    public static class SimpleClass
    implements JCClass {
        protected String name;
        protected String packageName;
        protected String fullName;

        public SimpleClass(String string, String string2) {
            this.name = string;
            this.packageName = string2;
            if (string == null || string2 == null) {
                throw new NullPointerException("className=" + string + ", packageName=" + string2);
            }
        }

        public SimpleClass(String string, int n, boolean bl) {
            this.fullName = string;
            if (n <= 0) {
                this.name = string;
                this.packageName = "";
            } else {
                this.name = string.substring(n + 1);
                this.packageName = string.substring(0, n);
                if (bl) {
                    this.name = this.name.intern();
                    this.packageName = this.packageName.intern();
                }
            }
        }

        SimpleClass() {
        }

        public final String getName() {
            return this.name;
        }

        public final String getPackageName() {
            return this.packageName;
        }

        public String getFullName() {
            if (this.fullName == null) {
                this.fullName = this.packageName.length() > 0 ? this.packageName + "." + this.name : this.name;
            }
            return this.fullName;
        }

        public int getTagOffset() {
            return -1;
        }

        public boolean isInterface() {
            return false;
        }

        public int getModifiers() {
            return 0;
        }

        public JCClass getSuperclass() {
            return null;
        }

        public JCClass[] getInterfaces() {
            return EMPTY_CLASSES;
        }

        public JCField[] getFields() {
            return EMPTY_FIELDS;
        }

        public JCConstructor[] getConstructors() {
            return EMPTY_CONSTRUCTORS;
        }

        public JCMethod[] getMethods() {
            return EMPTY_METHODS;
        }

        public int compareTo(Object object) {
            if (this == object) {
                return 0;
            }
            JCClass jCClass = (JCClass)object;
            int n = this.packageName.compareTo(jCClass.getPackageName());
            if (n == 0) {
                n = this.name.compareTo(jCClass.getName());
            }
            return n;
        }

        public int hashCode() {
            return this.name.hashCode() ^ this.packageName.hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof JCClass) {
                JCClass jCClass = (JCClass)object;
                return this.name.equals(jCClass.getName()) && this.packageName.equals(jCClass.getPackageName());
            }
            return false;
        }

        public String toString() {
            return this.getPackageName().length() > 0 ? this.getPackageName() + '.' + this.getName().replace('.', '$') : this.getName().replace('.', '$');
        }
    }

    public static class BasePackage
    implements JCPackage {
        private String name;
        private JCClass[] classes;
        private int dotCnt = -1;
        private String lastName;

        public BasePackage(String string) {
            this(string, EMPTY_CLASSES);
        }

        public BasePackage(String string, JCClass[] jCClassArray) {
            this.name = string;
            this.classes = jCClassArray;
        }

        public final String getName() {
            return this.name;
        }

        public String getLastName() {
            if (this.lastName == null) {
                this.lastName = this.name.substring(this.name.lastIndexOf(46) + 1);
            }
            return this.lastName;
        }

        public JCClass[] getClasses() {
            return this.classes;
        }

        public void setClasses(JCClass[] jCClassArray) {
            this.classes = jCClassArray;
        }

        public int getDotCount() {
            if (this.dotCnt < 0) {
                int n = 0;
                do {
                    ++this.dotCnt;
                } while ((n = this.name.indexOf(46, n) + 1) > 0);
            }
            return this.dotCnt;
        }

        public int compareTo(Object object) {
            if (this == object) {
                return 0;
            }
            JCPackage jCPackage = (JCPackage)object;
            return this.name.compareTo(jCPackage.getName());
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof JCPackage) {
                return this.name.equals(((JCPackage)object).getName());
            }
            if (object instanceof String) {
                return this.name.equals((String)object);
            }
            return false;
        }

        public String toString() {
            return this.name;
        }
    }
}

