/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.java;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.netbeans.editor.LocaleSupport;
import org.netbeans.editor.ext.java.JavaFastOpen;

class JavaFastOpenPanel
extends JPanel {
    private JavaFastOpen jfo;
    private JPanel listPanel;
    private JLabel expLabel;
    private JLabel foundLabel;
    private JTextField expField;
    private JScrollPane listScrollPane;
    private JPanel queryPanel;

    public JavaFastOpenPanel(JavaFastOpen javaFastOpen) {
        this.jfo = javaFastOpen;
        this.initComponents();
        this.getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_JFO"));
        this.expField.getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_JFOP_expLabel"));
        JList jList = javaFastOpen.getResultList();
        this.listScrollPane.setViewportView(jList);
        this.foundLabel.setLabelFor(jList);
        jList.getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_JFOP_foundLabel"));
        this.setPreferredSize(new Dimension(340, 178));
        this.setMaximumSize(new Dimension(400, 200));
        this.expLabel.setDisplayedMnemonic(LocaleSupport.getString("JFOP_expLabelMnemonic", "C").charAt(0));
        this.expLabel.setLabelFor(this.expField);
        this.expField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                if (!this.checkArrows(keyEvent)) {
                    this.change();
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
                if (!this.isArrows(keyEvent)) {
                    this.change();
                }
            }

            public void keyTyped(KeyEvent keyEvent) {
                if (!this.isArrows(keyEvent)) {
                    this.change();
                }
            }

            private boolean isArrows(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                return n == 40 || n == 38;
            }

            private boolean checkArrows(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                switch (n) {
                    case 40: {
                        JavaFastOpenPanel.this.jfo.scrollDown();
                        return true;
                    }
                    case 38: {
                        JavaFastOpenPanel.this.jfo.scrollUp();
                        return true;
                    }
                }
                return false;
            }

            private void change() {
                JavaFastOpenPanel.this.jfo.postUpdate();
            }
        });
        this.foundLabel.setDisplayedMnemonic(LocaleSupport.getString("JFOP_foundLabelMnemonic", "F").charAt(0));
        this.foundLabel.setLabelFor(javaFastOpen.getResultList());
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        Dimension dimension2 = this.getMaximumSize();
        if (dimension.width > dimension2.width) {
            dimension.width = dimension2.width;
        }
        if (dimension.height > dimension2.height) {
            dimension.height = dimension2.height;
        }
        return dimension;
    }

    void popupNotify() {
        this.expField.requestFocus();
    }

    String getSearchText() {
        return this.expField.getText();
    }

    void setSearchText(String string) {
        this.expField.setText(string);
        this.expField.setCaretPosition(this.expField.getText().length());
    }

    private void initComponents() {
        this.queryPanel = new JPanel();
        this.expLabel = new JLabel();
        this.expField = new JTextField();
        this.listPanel = new JPanel();
        this.foundLabel = new JLabel();
        this.listScrollPane = new JScrollPane();
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(new Insets(12, 12, 0, 11)));
        this.queryPanel.setLayout(new GridBagLayout());
        this.expLabel.setText(LocaleSupport.getString("JFOP_expLabel", "Class Name:"));
        this.expLabel.setLabelFor(this.expField);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.queryPanel.add((Component)this.expLabel, gridBagConstraints);
        this.expField.setPreferredSize(new Dimension(100, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.queryPanel.add((Component)this.expField, gridBagConstraints);
        this.add((Component)this.queryPanel, "North");
        this.listPanel.setLayout(new GridBagLayout());
        this.listPanel.setBorder(new EmptyBorder(new Insets(12, 0, 0, 0)));
        this.foundLabel.setText(LocaleSupport.getString("JFOP_foundLabel", "Matching Classes:"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.listPanel.add((Component)this.foundLabel, gridBagConstraints);
        this.listScrollPane.setPreferredSize(new Dimension(200, 100));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.listPanel.add((Component)this.listScrollPane, gridBagConstraints);
        this.add((Component)this.listPanel, "Center");
    }
}

