/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.IOException;
import java.util.Enumeration;
import org.openide.filesystems.FileSystem;
import org.openide.util.enum.QueueEnumeration;

class EventControl {
    private int requests;
    private int priorityRequests;
    private AtomicActionLink currentAtomAction;
    private QueueEnumeration requestsQueue;

    EventControl() {
    }

    void dispatchEvent(FileSystem.EventDispatcher dispatcher) {
        if (this.postponeFiring(dispatcher)) {
            return;
        }
        dispatcher.run();
    }

    void beginAtomicAction(FileSystem.AtomicAction run) {
        this.enterAtomicAction(run, true);
    }

    void finishAtomicAction() {
        this.exitAtomicAction(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runAtomicAction(FileSystem.AtomicAction run) throws IOException {
        try {
            this.enterAtomicAction(run, false);
            run.run();
        }
        finally {
            this.exitAtomicAction(false);
        }
    }

    private synchronized void enterAtomicAction(Object propID, boolean priority) {
        AtomicActionLink nextPropID = new AtomicActionLink(propID);
        nextPropID.setPreviousLink(this.currentAtomAction);
        this.currentAtomAction = nextPropID;
        if (priority) {
            ++this.priorityRequests;
        }
        if (this.requests++ == 0) {
            this.requestsQueue = new QueueEnumeration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exitAtomicAction(boolean priority) {
        QueueEnumeration reqQueueCopy;
        boolean fireAll = false;
        boolean firePriority = false;
        EventControl eventControl = this;
        synchronized (eventControl) {
            this.currentAtomAction = this.currentAtomAction.getPreviousLink();
            --this.requests;
            if (priority) {
                --this.priorityRequests;
            }
            if (this.requests == 0) {
                fireAll = true;
            }
            if (!fireAll && priority && this.priorityRequests == 0) {
                firePriority = true;
            }
            if (!fireAll && !firePriority) {
                return;
            }
            reqQueueCopy = this.requestsQueue;
            this.requestsQueue = null;
            this.priorityRequests = 0;
        }
        if (fireAll) {
            this.invokeDispatchers(false, (Enumeration)reqQueueCopy);
            return;
        }
        if (firePriority) {
            this.requestsQueue = new QueueEnumeration();
            QueueEnumeration newReqQueue = this.invokeDispatchers(true, (Enumeration)reqQueueCopy);
            EventControl eventControl2 = this;
            synchronized (eventControl2) {
                while (this.requestsQueue != null && this.requestsQueue.hasMoreElements()) {
                    FileSystem.EventDispatcher r = (FileSystem.EventDispatcher)this.requestsQueue.nextElement();
                    newReqQueue.put((Object)r);
                }
                this.requestsQueue = newReqQueue;
            }
        }
    }

    private QueueEnumeration invokeDispatchers(boolean priority, Enumeration reqQueueCopy) {
        QueueEnumeration newEnum = new QueueEnumeration();
        while (reqQueueCopy != null && reqQueueCopy.hasMoreElements()) {
            FileSystem.EventDispatcher r = (FileSystem.EventDispatcher)reqQueueCopy.nextElement();
            r.dispatch(priority);
            if (!priority) continue;
            newEnum.put((Object)r);
        }
        return newEnum;
    }

    private synchronized boolean postponeFiring(FileSystem.EventDispatcher disp) {
        if (this.priorityRequests == 0) {
            disp.setAtomicActionLink(this.currentAtomAction);
            disp.dispatch(true);
        }
        if (this.requestsQueue != null) {
            disp.setAtomicActionLink(this.currentAtomAction);
            this.requestsQueue.put((Object)disp);
            return true;
        }
        return false;
    }

    static final class AtomicActionLink {
        private AtomicActionLink upper;
        private Object propagationID;

        AtomicActionLink(Object propagationID) {
            this.propagationID = propagationID;
        }

        Object getAtomicAction() {
            return this.propagationID;
        }

        void setPreviousLink(AtomicActionLink upper) {
            this.upper = upper;
        }

        AtomicActionLink getPreviousLink() {
            return this.upper;
        }
    }
}

