/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.util.EventObject;
import org.openide.filesystems.EventControl;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;

public class FileEvent
extends EventObject {
    private static final long serialVersionUID = 1028087432345400108L;
    private FileObject file;
    private long time;
    private boolean expected;
    private EventControl.AtomicActionLink atomActionID;

    public FileEvent(FileObject src) {
        this(src, src);
    }

    public FileEvent(FileObject src, FileObject file) {
        super(src);
        this.file = file;
        this.time = System.currentTimeMillis();
    }

    FileEvent(FileObject src, FileObject file, long time) {
        this(src, file);
        this.time = time;
    }

    public FileEvent(FileObject src, FileObject file, boolean expected) {
        this(src, file);
        this.expected = expected;
    }

    public final FileObject getFile() {
        return this.file;
    }

    public final long getTime() {
        return this.time;
    }

    public final boolean isExpected() {
        return this.expected;
    }

    public String toString() {
        FileSystem fs;
        try {
            fs = this.file.getFileSystem();
        }
        catch (FileStateInvalidException fsie) {
            fs = null;
        }
        return super.toString() + "[file=" + this.file + ",time=" + this.time + ",expected=" + this.expected + ",fs=" + fs + "]";
    }

    void setAtomicActionLink(EventControl.AtomicActionLink atomActionID) {
        this.atomActionID = atomActionID;
    }

    public boolean firedFrom(FileSystem.AtomicAction run) {
        if (run == null) {
            return false;
        }
        for (EventControl.AtomicActionLink currentPropID = this.atomActionID; currentPropID != null; currentPropID = currentPropID.getPreviousLink()) {
            if (!run.equals(currentPropID.getAtomicAction())) continue;
            return true;
        }
        return false;
    }
}

