/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

final class PathElements {
    private static final String DELIMITER = "/";
    private String name;
    private StringTokenizer tokenizer;
    private List tokens;

    public PathElements(String name) {
        this.name = name;
        this.tokenizer = new StringTokenizer(name, DELIMITER);
        this.tokens = new ArrayList(10);
    }

    public String getOriginalName() {
        return this.name;
    }

    public Enumeration getEnumeration() {
        return new EnumerationImpl(this);
    }

    boolean contains(int i) {
        if (this.tokens.size() <= i) {
            this.scanUpTo(i);
        }
        return this.tokens.size() > i;
    }

    String get(int i) throws NoSuchElementException {
        if (this.tokens.size() <= i) {
            this.scanUpTo(i);
        }
        if (this.tokens.size() <= i) {
            throw new NoSuchElementException();
        }
        return (String)this.tokens.get(i);
    }

    private synchronized void scanUpTo(int i) {
        if (this.tokenizer == null) {
            return;
        }
        if (this.tokens.size() > i) {
            return;
        }
        for (int k = this.tokens.size() - 1; k < i && this.tokenizer.hasMoreTokens(); ++k) {
            this.tokens.add(this.tokenizer.nextToken());
        }
        if (!this.tokenizer.hasMoreTokens()) {
            this.tokenizer = null;
        }
    }

    static final class EnumerationImpl
    implements Enumeration {
        private PathElements elements;
        private int pos;

        EnumerationImpl(PathElements elements) {
            this.elements = elements;
            this.pos = 0;
        }

        public boolean hasMoreElements() {
            return this.elements.contains(this.pos);
        }

        public Object nextElement() throws NoSuchElementException {
            return this.elements.get(this.pos++);
        }
    }
}

