/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.openide.filesystems.AbstractFolder;
import org.openide.filesystems.ExternalUtil;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.WeakSet;

final class StreamPool {
    private static final boolean ANNOTATE_UNCLOSED_STREAMS = Boolean.getBoolean("org.openide.filesystems.annotateUnclosedStreams");
    private static Map fo2StreamPool = new WeakHashMap();
    private static Map fs2StreamPool = new WeakHashMap();
    private Set iStreams;
    private Set oStreams;

    private StreamPool() {
    }

    public static synchronized InputStream createInputStream(AbstractFolder fo, InputStream is) {
        NotifyInputStream retVal = new NotifyInputStream(fo, is);
        StreamPool.get(fo).iStream().add(retVal);
        StreamPool.get(fo.getFileSystem()).iStream().add(retVal);
        return retVal;
    }

    public static synchronized OutputStream createOutputStream(AbstractFolder fo, OutputStream os, boolean fireFileChanged) {
        NotifyOutputStream retVal = new NotifyOutputStream(fo, os, fireFileChanged);
        StreamPool.get(fo).oStream().add(retVal);
        StreamPool.get(fo.getFileSystem()).oStream().add(retVal);
        return retVal;
    }

    public static synchronized StreamPool find(FileObject fo) {
        return (StreamPool)fo2StreamPool.get(fo);
    }

    public static synchronized StreamPool find(FileSystem fs) {
        return (StreamPool)fs2StreamPool.get(fs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void annotate(Exception ex) {
        if (!ANNOTATE_UNCLOSED_STREAMS) {
            return;
        }
        Class clazz = StreamPool.class;
        synchronized (clazz) {
            Exception annotation;
            if (this.iStreams != null) {
                Iterator itIs = this.iStreams.iterator();
                while (itIs.hasNext()) {
                    NotifyInputStream nis = (NotifyInputStream)itIs.next();
                    annotation = nis.getException();
                    if (annotation == null) continue;
                    ExternalUtil.annotate((Throwable)ex, annotation);
                }
            }
            if (this.oStreams != null) {
                Iterator itOs = this.oStreams.iterator();
                while (itOs.hasNext()) {
                    NotifyOutputStream nos = (NotifyOutputStream)itOs.next();
                    annotation = nos.getException();
                    if (annotation == null) continue;
                    ExternalUtil.annotate((Throwable)ex, annotation);
                }
            }
        }
    }

    public boolean isInputStreamOpen() {
        return this.iStreams != null && !this.iStreams.isEmpty();
    }

    public boolean isOutputStreamOpen() {
        return this.oStreams != null && !this.oStreams.isEmpty();
    }

    private static StreamPool get(FileObject fo) {
        StreamPool strPool = (StreamPool)fo2StreamPool.get(fo);
        if (strPool == null) {
            strPool = new StreamPool();
            fo2StreamPool.put(fo, strPool);
        }
        return strPool;
    }

    private static StreamPool get(FileSystem fs) {
        StreamPool strPool = (StreamPool)fs2StreamPool.get(fs);
        if (strPool == null) {
            strPool = new StreamPool();
            fs2StreamPool.put(fs, strPool);
        }
        return strPool;
    }

    private Set iStream() {
        if (this.iStreams == null) {
            this.iStreams = new WeakSet();
        }
        return this.iStreams;
    }

    private Set oStream() {
        if (this.oStreams == null) {
            this.oStreams = new WeakSet();
        }
        return this.oStreams;
    }

    private static void closeOutputStream(AbstractFolder fo, OutputStream os, boolean fireFileChanged) {
        StreamPool foPool = StreamPool.find(fo);
        StreamPool fsPool = StreamPool.find(fo.getFileSystem());
        Set foSet = foPool != null ? foPool.oStreams : null;
        Set fsSet = fsPool != null ? fsPool.oStreams : null;
        StreamPool.removeStreams(fsSet, foSet, os);
        StreamPool.removeStreamPools(fsPool, foPool, fo);
        fo.outputStreamClosed(fireFileChanged);
    }

    private static void closeInputStream(AbstractFolder fo, InputStream is) {
        StreamPool foPool = StreamPool.find(fo);
        StreamPool fsPool = StreamPool.find(fo.getFileSystem());
        Set foSet = foPool != null ? foPool.iStreams : null;
        Set fsSet = fsPool != null ? fsPool.iStreams : null;
        StreamPool.removeStreams(fsSet, foSet, is);
        StreamPool.removeStreamPools(fsPool, foPool, fo);
    }

    private static synchronized void removeStreams(Set fsSet, Set foSet, Object stream) {
        if (foSet != null) {
            foSet.remove(stream);
        }
        if (fsSet != null) {
            fsSet.remove(stream);
        }
    }

    private static synchronized void removeStreamPools(StreamPool fsPool, StreamPool foPool, AbstractFolder fo) {
        boolean isOStreamEmpty;
        boolean isIStreamEmpty = foPool == null || foPool.iStreams == null || foPool.iStreams.isEmpty();
        boolean bl = isOStreamEmpty = foPool == null || foPool.oStreams == null || foPool.oStreams.isEmpty();
        if (isIStreamEmpty && isOStreamEmpty) {
            fo2StreamPool.remove(fo);
        }
        isIStreamEmpty = fsPool == null || fsPool.iStreams == null || fsPool.iStreams.isEmpty();
        boolean bl2 = isOStreamEmpty = fsPool == null || fsPool.oStreams == null || fsPool.oStreams.isEmpty();
        if (isIStreamEmpty && isOStreamEmpty) {
            fs2StreamPool.remove(fo.getFileSystem());
        }
    }

    static final class NotifyInputStream
    extends FilterInputStream {
        private Exception ex;
        AbstractFolder fo;
        private boolean closed = false;

        public NotifyInputStream(AbstractFolder fo, InputStream is) {
            super(is);
            this.fo = fo;
            if (ANNOTATE_UNCLOSED_STREAMS) {
                this.ex = new Exception();
            }
        }

        public void close() throws IOException {
            if (!this.closed) {
                this.closed = true;
                this.ex = null;
                super.close();
                StreamPool.closeInputStream(this.fo, this);
            }
        }

        public Exception getException() {
            return this.ex;
        }
    }

    static final class NotifyOutputStream
    extends FilterOutputStream {
        private Exception ex;
        private boolean closed = false;
        AbstractFolder fo;
        private boolean fireFileChanged;

        public NotifyOutputStream(AbstractFolder fo, OutputStream os, boolean fireFileChanged) {
            super(os);
            this.fo = fo;
            if (ANNOTATE_UNCLOSED_STREAMS) {
                this.ex = new Exception();
            }
            this.fireFileChanged = fireFileChanged;
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }

        public void close() throws IOException {
            if (!this.closed) {
                this.closed = true;
                this.ex = null;
                this.out.flush();
                super.close();
                StreamPool.closeOutputStream(this.fo, this, this.fireFileChanged);
            }
        }

        public Exception getException() {
            return this.ex;
        }
    }
}

