/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo;

import edu.umd.cs.piccolo.PComponent;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.PRoot;
import edu.umd.cs.piccolo.activities.PTransformActivity;
import edu.umd.cs.piccolo.util.PAffineTransform;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PDebug;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolo.util.PObjectOutputStream;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolo.util.PPickPath;
import edu.umd.cs.piccolo.util.PUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PCamera
extends PNode {
    public static final String PROPERTY_LAYERS = "layers";
    public static final String PROPERTY_VIEW_TRANSFORM = "viewTransform";
    public static final int VIEW_CONSTRAINT_NONE = 0;
    public static final int VIEW_CONSTRAINT_ALL = 1;
    public static final int VIEW_CONSTRAINT_CENTER = 2;
    private transient PComponent component;
    private transient List layers;
    private PAffineTransform viewTransform = new PAffineTransform();
    private int viewConstraint = 0;
    private static PBounds TEMP_REPAINT_RECT = new PBounds();

    public PCamera() {
        this.layers = new ArrayList();
    }

    public PComponent getComponent() {
        return this.component;
    }

    public void setComponent(PComponent aComponent) {
        this.component = aComponent;
        this.invalidatePaint();
    }

    public void repaintFrom(PBounds localBounds, PNode descendentOrThis) {
        if (this.getParent() != null) {
            if (descendentOrThis != this) {
                this.localToParent(localBounds);
            }
            if (this.component != null) {
                this.component.repaint(localBounds);
            }
            this.getParent().repaintFrom(localBounds, this);
        }
    }

    public void repaintFromLayer(PBounds viewBounds, PNode repaintedLayer) {
        TEMP_REPAINT_RECT.setRect(viewBounds);
        this.viewToLocal(TEMP_REPAINT_RECT);
        if (this.getBoundsReference().intersects(TEMP_REPAINT_RECT)) {
            PBounds.intersect(TEMP_REPAINT_RECT, this.getBoundsReference(), TEMP_REPAINT_RECT);
            this.repaintFrom(TEMP_REPAINT_RECT, repaintedLayer);
        }
    }

    public List getLayersReference() {
        return this.layers;
    }

    public int getLayerCount() {
        return this.layers.size();
    }

    public PLayer getLayer(int index) {
        return (PLayer)this.layers.get(index);
    }

    public int indexOfLayer(PLayer layer) {
        return this.layers.indexOf(layer);
    }

    public void addLayer(PLayer layer) {
        this.addLayer(this.layers.size(), layer);
    }

    public void addLayer(int index, PLayer layer) {
        this.layers.add(index, layer);
        layer.addCamera(this);
        this.invalidatePaint();
        this.firePropertyChange(PROPERTY_LAYERS, null, this.layers);
    }

    public PLayer removeLayer(PLayer layer) {
        return this.removeLayer(this.layers.indexOf(layer));
    }

    public PLayer removeLayer(int index) {
        PLayer layer = (PLayer)this.layers.remove(index);
        layer.removeCamera(this);
        this.invalidatePaint();
        this.firePropertyChange(PROPERTY_LAYERS, null, this.layers);
        return layer;
    }

    public PBounds getUnionOfLayerFullBounds() {
        PBounds result = new PBounds();
        int count = this.getLayerCount();
        for (int i = 0; i < count; ++i) {
            PLayer each = (PLayer)this.layers.get(i);
            result.add(each.getFullBoundsReference());
        }
        return result;
    }

    protected void paint(PPaintContext paintContext) {
        super.paint(paintContext);
        paintContext.pushClip(this.getBoundsReference());
        paintContext.pushTransform(this.viewTransform);
        this.paintCameraView(paintContext);
        this.paintDebugInfo(paintContext);
        paintContext.popTransform(this.viewTransform);
        paintContext.popClip(this.getBoundsReference());
    }

    protected void paintCameraView(PPaintContext paintContext) {
        int count = this.getLayerCount();
        for (int i = 0; i < count; ++i) {
            PLayer each = (PLayer)this.layers.get(i);
            each.fullPaint(paintContext);
        }
    }

    protected void paintDebugInfo(PPaintContext paintContext) {
        if (PDebug.debugBounds || PDebug.debugFullBounds) {
            Graphics2D g2 = paintContext.getGraphics();
            paintContext.setRenderQuality(0);
            g2.setStroke(new BasicStroke(0.0f));
            ArrayList nodes = new ArrayList();
            PBounds nodeBounds = new PBounds();
            Color boundsColor = Color.red;
            Color fullBoundsColor = new Color(1.0f, 0.0f, 0.0f, 0.2f);
            for (int i = 0; i < this.getLayerCount(); ++i) {
                this.getLayer(i).getAllNodes(null, nodes);
            }
            Iterator i = this.getAllNodes(null, nodes).iterator();
            while (i.hasNext()) {
                PNode each = (PNode)i.next();
                if (PDebug.debugBounds) {
                    g2.setPaint(boundsColor);
                    nodeBounds.setRect(each.getBoundsReference());
                    if (!nodeBounds.isEmpty()) {
                        each.localToGlobal(nodeBounds);
                        this.globalToLocal(nodeBounds);
                        if (each == this || each.isDescendentOf(this)) {
                            this.localToView(nodeBounds);
                        }
                        g2.draw(nodeBounds);
                    }
                }
                if (!PDebug.debugFullBounds) continue;
                g2.setPaint(fullBoundsColor);
                nodeBounds.setRect(each.getFullBoundsReference());
                if (nodeBounds.isEmpty()) continue;
                if (each.getParent() != null) {
                    each.getParent().localToGlobal(nodeBounds);
                }
                this.globalToLocal(nodeBounds);
                if (each == this || each.isDescendentOf(this)) {
                    this.localToView(nodeBounds);
                }
                g2.fill(nodeBounds);
            }
        }
    }

    public void fullPaint(PPaintContext paintContext) {
        paintContext.pushCamera(this);
        super.fullPaint(paintContext);
        paintContext.popCamera(this);
    }

    public PPickPath pick(double x, double y, double halo) {
        PBounds b = new PBounds(new Point2D.Double(x, y), -halo, -halo);
        PPickPath result = new PPickPath(this, b);
        this.fullPick(result);
        if (result.getNodeStackReference().size() == 0) {
            result.pushNode(this);
            result.pushTransform(this.getTransformReference(false));
        }
        return result;
    }

    protected boolean pickAfterChildren(PPickPath pickPath) {
        if (this.intersects(pickPath.getPickBounds())) {
            pickPath.pushTransform(this.viewTransform);
            if (this.pickCameraView(pickPath)) {
                return true;
            }
            pickPath.popTransform(this.viewTransform);
            return true;
        }
        return false;
    }

    protected boolean pickCameraView(PPickPath pickPath) {
        int count = this.getLayerCount();
        for (int i = count - 1; i >= 0; --i) {
            PLayer each = (PLayer)this.layers.get(i);
            if (!each.fullPick(pickPath)) continue;
            return true;
        }
        return false;
    }

    public PBounds getViewBounds() {
        return (PBounds)this.localToView(this.getBounds());
    }

    public double getViewScale() {
        return this.viewTransform.getScale();
    }

    public void scaleView(double scale) {
        this.scaleViewAboutPoint(scale, 0.0, 0.0);
    }

    public void scaleViewAboutPoint(double scale, double x, double y) {
        this.viewTransform.scaleAboutPoint(scale, x, y);
        this.applyViewConstraints();
        this.invalidatePaint();
        this.firePropertyChange(PROPERTY_VIEW_TRANSFORM, null, this.viewTransform);
    }

    public void setViewScale(double scale) {
        this.scaleView(scale / this.getViewScale());
    }

    public void translateView(double dx, double dy) {
        this.viewTransform.translate(dx, dy);
        this.applyViewConstraints();
        this.invalidatePaint();
        this.firePropertyChange(PROPERTY_VIEW_TRANSFORM, null, this.viewTransform);
    }

    public void setViewOffset(double x, double y) {
        this.viewTransform.setOffset(x, y);
        this.applyViewConstraints();
        this.invalidatePaint();
        this.firePropertyChange(PROPERTY_VIEW_TRANSFORM, null, this.viewTransform);
    }

    public PAffineTransform getViewTransform() {
        return (PAffineTransform)this.viewTransform.clone();
    }

    public PAffineTransform getViewTransformReference() {
        return this.viewTransform;
    }

    public void setViewTransform(AffineTransform aTransform) {
        this.viewTransform.setTransform(aTransform);
        this.applyViewConstraints();
        this.invalidatePaint();
        this.firePropertyChange(PROPERTY_VIEW_TRANSFORM, null, this.viewTransform);
    }

    public PTransformActivity animateViewToCenterBounds(Rectangle2D centerBounds, boolean shouldScaleToFit, long duration) {
        PBounds viewBounds = this.getViewBounds();
        PDimension delta = viewBounds.deltaRequiredToCenter(centerBounds);
        PAffineTransform newTransform = this.getViewTransform();
        newTransform.translate(delta.width, delta.height);
        if (shouldScaleToFit) {
            double s = Math.min(viewBounds.getWidth() / centerBounds.getWidth(), viewBounds.getHeight() / centerBounds.getHeight());
            newTransform.scaleAboutPoint(s, centerBounds.getCenterX(), centerBounds.getCenterY());
        }
        return this.animateViewToTransform(newTransform, duration);
    }

    public PTransformActivity animateViewToPanToBounds(Rectangle2D panToBounds, long duration) {
        PBounds viewBounds = this.getViewBounds();
        PDimension delta = viewBounds.deltaRequiredToContain(panToBounds);
        if (delta.width != 0.0 || delta.height != 0.0) {
            if (duration == 0L) {
                this.translateView(-delta.width, -delta.height);
            } else {
                PAffineTransform at = this.getViewTransform();
                at.translate(-delta.width, -delta.height);
                return this.animateViewToTransform(at, duration);
            }
        }
        return null;
    }

    public PTransformActivity animateViewToIncludeBounds(Rectangle2D includeBounds, long duration) {
        return this.animateViewToPanToBounds(includeBounds, duration);
    }

    public PTransformActivity animateViewToTransform(AffineTransform destination, long duration) {
        if (duration == 0L) {
            this.setViewTransform(destination);
            return null;
        }
        PTransformActivity.Target t = new PTransformActivity.Target(){

            public void setTransform(AffineTransform aTransform) {
                PCamera.this.setViewTransform(aTransform);
            }

            public void getSourceMatrix(double[] aSource) {
                PCamera.this.viewTransform.getMatrix(aSource);
            }
        };
        PTransformActivity ta = new PTransformActivity(duration, PUtil.DEFAULT_ACTIVITY_STEP_RATE, t, destination);
        PRoot r = this.getRoot();
        if (r != null) {
            r.getActivityScheduler().addActivity(ta);
        }
        return ta;
    }

    public void setViewConstraint(int constraint) {
        this.viewConstraint = constraint;
        this.applyViewConstraints();
    }

    protected void applyViewConstraints() {
        if (this.viewConstraint == 0) {
            return;
        }
        PBounds viewBounds = this.getViewBounds();
        PBounds layerBounds = (PBounds)this.globalToLocal(this.getUnionOfLayerFullBounds());
        PDimension constraintDelta = null;
        switch (this.viewConstraint) {
            case 1: {
                constraintDelta = viewBounds.deltaRequiredToContain(layerBounds);
                break;
            }
            case 2: {
                layerBounds.setRect(layerBounds.getCenterX(), layerBounds.getCenterY(), 0.0, 0.0);
                constraintDelta = viewBounds.deltaRequiredToContain(layerBounds);
            }
        }
        this.viewTransform.translate(-constraintDelta.width, -constraintDelta.height);
    }

    public Point2D viewToLocal(Point2D viewPoint) {
        return this.viewTransform.transform(viewPoint, viewPoint);
    }

    public Dimension2D viewToLocal(Dimension2D viewDimension) {
        return this.viewTransform.transform(viewDimension, viewDimension);
    }

    public Rectangle2D viewToLocal(Rectangle2D viewRectangle) {
        return this.viewTransform.transform(viewRectangle, viewRectangle);
    }

    public Point2D localToView(Point2D localPoint) {
        try {
            return this.viewTransform.inverseTransform(localPoint, localPoint);
        }
        catch (NoninvertibleTransformException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Dimension2D localToView(Dimension2D localDimension) {
        return this.viewTransform.inverseTransform(localDimension, localDimension);
    }

    public Rectangle2D localToView(Rectangle2D localRectangle) {
        return this.viewTransform.inverseTransform(localRectangle, localRectangle);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        int count = this.getLayerCount();
        for (int i = 0; i < count; ++i) {
            ((PObjectOutputStream)out).writeConditionalObject(this.layers.get(i));
        }
        out.writeObject(Boolean.FALSE);
        ((PObjectOutputStream)out).writeConditionalObject(this.component);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.layers = new ArrayList();
        while (true) {
            Object each;
            if ((each = in.readObject()) == null) {
                continue;
            }
            if (each.equals(Boolean.FALSE)) break;
            this.layers.add(each);
        }
        this.component = (PComponent)in.readObject();
    }
}

