/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.datatype;

import java.util.Hashtable;
import java.util.Locale;
import org.apache.xerces.utils.XMLCharacterProperties;
import org.apache.xerces.validators.datatype.AbstractDatatypeValidator;
import org.apache.xerces.validators.datatype.DatatypeMessageProvider;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeFacetException;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;
import org.apache.xerces.validators.datatype.StateMessageDatatype;

public class IDDatatypeValidator
extends AbstractDatatypeValidator {
    private DatatypeValidator fBaseValidator = null;
    private Object fNullValue = null;
    private DatatypeMessageProvider fMessageProvider = new DatatypeMessageProvider();
    private Hashtable fTableOfId;
    private Locale fLocale = null;
    public static final int IDREF_STORE = 0;
    public static final int ID_CLEAR = 1;

    public IDDatatypeValidator() throws InvalidDatatypeFacetException {
        this(null, null, false);
    }

    public IDDatatypeValidator(DatatypeValidator datatypeValidator, Hashtable hashtable, boolean bl) throws InvalidDatatypeFacetException {
    }

    public Object validate(String string, Object object) throws InvalidDatatypeValueException {
        StateMessageDatatype stateMessageDatatype;
        if (object != null && (stateMessageDatatype = (StateMessageDatatype)object).getDatatypeState() == 1) {
            if (this.fTableOfId != null) {
                this.fTableOfId.clear();
                this.fTableOfId = null;
            }
            return null;
        }
        if (!XMLCharacterProperties.validName(string)) {
            InvalidDatatypeValueException invalidDatatypeValueException = new InvalidDatatypeValueException("ID is not valid: " + string);
            invalidDatatypeValueException.setMinorCode(75);
            invalidDatatypeValueException.setMajorCode(76);
            throw invalidDatatypeValueException;
        }
        if (!this.addId(string, object)) {
            InvalidDatatypeValueException invalidDatatypeValueException = new InvalidDatatypeValueException("ID '" + string + "'  has to be unique");
            invalidDatatypeValueException.setMinorCode(76);
            invalidDatatypeValueException.setMajorCode(76);
            throw invalidDatatypeValueException;
        }
        return this.fTableOfId;
    }

    public int compare(String string, String string2) {
        return -1;
    }

    public Hashtable getFacets() {
        return null;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("clone() is not supported in " + this.getClass().getName());
    }

    private void setBasetype(DatatypeValidator datatypeValidator) {
        this.fBaseValidator = datatypeValidator;
    }

    private boolean addId(String string, Object object) {
        if (this.fTableOfId == null) {
            this.fTableOfId = new Hashtable();
        } else if (this.fTableOfId.containsKey(string)) {
            return false;
        }
        if (this.fNullValue == null) {
            this.fNullValue = new Object();
        }
        try {
            this.fTableOfId.put(string, this.fNullValue);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return true;
    }

    public void setLocale(Locale locale) {
        this.fLocale = locale;
    }

    private String getErrorString(int n, int n2, Object[] objectArray) {
        try {
            return this.fMessageProvider.createMessage(this.fLocale, n, n2, objectArray);
        }
        catch (Exception exception) {
            return "Illegal Errorcode " + n2;
        }
    }
}

