/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.mdr;

import com.gentleware.A.B.D;
import com.gentleware.mdr.F;
import com.gentleware.mdr.MdrFacade;
import com.gentleware.openapi.util.CollectionFactory;
import com.gentleware.openapi.util.Strings;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.jmi.model.Association;
import javax.jmi.model.ModelElement;
import javax.jmi.model.ModelPackage;
import javax.jmi.model.MofClass;
import javax.jmi.model.MofPackage;
import javax.jmi.model.MofPackageClass;
import javax.jmi.model.Namespace;
import javax.jmi.model.PrimitiveType;
import javax.jmi.reflect.RefBaseObject;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefPackage;
import javax.jmi.xmi.MalformedXMIException;
import org.apache.log4j.Logger;
import org.netbeans.api.mdr.DTDProducer;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.api.xmi.XMIOutputConfig;
import org.netbeans.api.xmi.XMIReader;
import org.netbeans.api.xmi.XMIReaderFactory;
import org.netbeans.api.xmi.XMIReferenceProvider;
import org.netbeans.api.xmi.XMIWriter;
import org.netbeans.api.xmi.XMIWriterFactory;
import org.netbeans.lib.jmi.xmi.OutputConfig;
import org.netbeans.lib.jmi.xmi.SchemaProducer;
import org.netbeans.lib.jmi.xmi.XMIHeaderProvider;

public final class RepositoryHelper {
    public static final String META_MODEL_VERSION = "1.4.3";
    private static final Logger B = Logger.getLogger((String)"com.gentleware.mdr.RepositoryHelper");
    private static RepositoryHelper D;
    static final Map _packageNameMap;
    private static final String C = "Package$Impl";
    private static final String E = "Class$Impl";
    public static final String VALUE_SPECIFICATION = "ValueSpecification";
    public static final String NAMED_ELEMENT = "NamedElement";
    public static final String PARAMETER = "Parameter";
    public static final String MODEL_ELEMENT = "ModelElement";
    public static final String CLASSIFIER = "Classifier";
    public static final String BEHAVIOR = "Behavior";
    public static final String OPERATION = "Operation";
    public static final String TRIGGER = "Trigger";
    public static final String MULTIPLICITY_ELEMENT = "MultiplicityElement";
    private static Class A;

    public static String formatMetaclassName(String string) {
        int n2 = string.lastIndexOf(".");
        if (n2 > -1) {
            string = string.substring(n2 + 1);
        }
        if (string.endsWith(C)) {
            string = string.substring(0, string.length() - C.length());
        } else if (string.endsWith(E)) {
            string = string.substring(0, string.length() - E.length());
        }
        if (string.startsWith("Uml")) {
            string = string.substring(3);
        }
        return string;
    }

    public static String translateMetaPackageName(String string) {
        return (String)_packageNameMap.get(string);
    }

    public static RepositoryHelper getInstance() {
        if (D == null) {
            D = new RepositoryHelper();
        }
        return D;
    }

    private RepositoryHelper() {
    }

    public static void writeXmi(String string, RefPackage refPackage) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            RepositoryHelper.writeXmi((OutputStream)fileOutputStream, refPackage, null);
        }
        catch (Exception exception) {
            throw new RuntimeException("Error while writing file '" + string + '\'', exception);
        }
    }

    public static void writeXmi(OutputStream outputStream, RefPackage refPackage, XMIReferenceProvider xMIReferenceProvider) {
        try {
            XMIWriter xMIWriter = XMIWriterFactory.getDefault().createXMIWriter();
            OutputConfig outputConfig = (OutputConfig)xMIWriter.getConfiguration();
            outputConfig.setEncoding("UTF-8");
            if (xMIReferenceProvider != null) {
                outputConfig.setReferenceProvider(xMIReferenceProvider);
            }
            outputConfig.setHeaderProvider((XMIHeaderProvider)new F(META_MODEL_VERSION));
            xMIWriter.write(outputStream, refPackage, "1.2");
        }
        catch (Exception exception) {
            throw new RuntimeException("Error while writing XMI file", exception);
        }
    }

    public static void writeXmi(OutputStream outputStream, Collection collection, XMIReferenceProvider xMIReferenceProvider) {
        try {
            XMIWriter xMIWriter = XMIWriterFactory.getDefault().createXMIWriter();
            XMIOutputConfig xMIOutputConfig = xMIWriter.getConfiguration();
            xMIOutputConfig.setEncoding("UTF-8");
            if (xMIReferenceProvider != null) {
                xMIOutputConfig.setReferenceProvider(xMIReferenceProvider);
            }
            xMIWriter.write(outputStream, collection, "1.2");
        }
        catch (Exception exception) {
            throw new RuntimeException("Error while writing XMI file", exception);
        }
    }

    public static void readXmi(URL uRL, RefPackage refPackage) throws IOException, MalformedXMIException {
        XMIReaderFactory xMIReaderFactory = XMIReaderFactory.getDefault();
        XMIReader xMIReader = xMIReaderFactory.createXMIReader();
        xMIReader.read(uRL.toString(), refPackage);
    }

    public static MofPackage findMofPackage(ModelPackage modelPackage, String string) {
        MofPackageClass mofPackageClass = modelPackage.getMofPackage();
        Collection collection = mofPackageClass.refAllOfClass();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ModelElement modelElement = (ModelElement)iterator.next();
            String string2 = modelElement.getName();
            if (Strings.isEmpty((String)string2) || !string2.equals(string)) continue;
            return (MofPackage)modelElement;
        }
        return null;
    }

    public static ModelElement findModelElement(ModelPackage modelPackage, String string, Class clazz) {
        return RepositoryHelper.findModelElement(modelPackage, string, clazz, null);
    }

    public static ModelElement findModelElement(ModelPackage modelPackage, String string, Class clazz, Namespace namespace) {
        Iterator iterator = modelPackage.getModelElement().refAllOfType().iterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                boolean bl;
                ModelElement modelElement = (ModelElement)iterator.next();
                if (modelElement == null) continue;
                boolean bl2 = clazz.isInstance(modelElement);
                String string2 = modelElement.getName();
                boolean bl3 = bl = !Strings.isEmpty((String)string2) && string.equals(string2);
                if (!bl2 || !bl || namespace != null && namespace != modelElement.getContainer()) continue;
                return modelElement;
            }
        }
        return null;
    }

    public static Collection findModelElements(ModelPackage modelPackage, String string, Class clazz) {
        List list = CollectionFactory.createArrayList();
        Iterator iterator = modelPackage.getModelElement().refAllOfType().iterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                ModelElement modelElement = (ModelElement)iterator.next();
                if (modelElement == null) continue;
                boolean bl = clazz.isInstance(modelElement);
                boolean bl2 = string.equals(modelElement.getName());
                if (!bl || !bl2) continue;
                list.add(modelElement);
            }
        }
        return list;
    }

    public static Association findAssociation(ModelPackage modelPackage, String string) {
        return RepositoryHelper.findAssociation(modelPackage, string, null);
    }

    public static Association findAssociation(ModelPackage modelPackage, String string, Namespace namespace) {
        Iterator iterator = modelPackage.getAssociation().refAllOfType().iterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                String string2;
                boolean bl;
                Association association = (Association)iterator.next();
                if (association == null || !(bl = !Strings.isEmpty((String)(string2 = association.getName())) && string.equals(string2)) || namespace != null && namespace != association.getContainer()) continue;
                return association;
            }
        }
        throw new IllegalStateException("Association " + string + " not found");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeModelAsDTD(RefPackage refPackage, String string) {
        File file = new File(string);
        FilterOutputStream filterOutputStream = null;
        try {
            filterOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            DTDProducer.getDefault().generate((OutputStream)filterOutputStream, refPackage);
        }
        catch (FileNotFoundException fileNotFoundException) {
            B.error((Object)fileNotFoundException);
        }
        finally {
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (IOException iOException) {
                    B.error((Object)iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeModelAsSchema(RefPackage refPackage, String string) {
        B.info((Object)("Writing schema to " + string));
        File file = new File(string);
        FilterOutputStream filterOutputStream = null;
        try {
            filterOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            SchemaProducer schemaProducer = new SchemaProducer();
            schemaProducer.generate((OutputStream)filterOutputStream, refPackage);
        }
        catch (FileNotFoundException fileNotFoundException) {
            B.error((Object)fileNotFoundException);
        }
        catch (IOException iOException) {
            B.error((Object)"IOException was thrown!", (Throwable)iOException);
        }
        finally {
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (IOException iOException) {
                    B.error((Object)iOException);
                }
            }
        }
    }

    public static void addNsUriToAllPackages(RefPackage refPackage) {
        String string = "org.omg.xmi.nsURI";
        String string2 = "http://www.omg.org/XMI";
        ModelElement modelElement = (ModelElement)refPackage.refMetaObject();
        ModelPackage modelPackage = (ModelPackage)modelElement.refImmediatePackage();
        com.gentleware.A.B.D.A(modelPackage, (Namespace)modelElement, modelElement, "org.omg.xmi.nsURI", "http://www.omg.org/XMI");
        Collection collection = refPackage.refAllPackages();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            RefPackage refPackage2 = (RefPackage)iterator.next();
            RepositoryHelper.addNsUriToAllPackages(refPackage2);
        }
    }

    public static RefPackage findOrCreateRefPackageExtent(MDRepository mDRepository, String string) {
        return RepositoryHelper.findOrCreateRefPackageExtent(mDRepository, string, null, null);
    }

    public static RefPackage findOrCreateRefPackageExtent(MDRepository mDRepository, String string, URL uRL) {
        return RepositoryHelper.findOrCreateRefPackageExtent(mDRepository, string, uRL, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RefPackage findOrCreateRefPackageExtent(MDRepository mDRepository, String string, URL uRL, RefObject refObject) {
        if (uRL == null) {
            throw new IllegalArgumentException("No valid path to metamodel description given");
        }
        MdrFacade.getInstance().beginWriteTransaction();
        boolean bl = true;
        RefPackage refPackage = null;
        try {
            refPackage = mDRepository.getExtent(string);
            if (refPackage == null) {
                refPackage = mDRepository.createExtent(string, refObject);
                RepositoryHelper.readXmi(uRL, refPackage);
            }
            bl = false;
        }
        catch (Exception exception) {
            B.info((Object)exception);
        }
        finally {
            MdrFacade.getInstance().endTransaction(bl);
        }
        return refPackage;
    }

    public static boolean isElementStillValid(RefBaseObject refBaseObject) {
        if (refBaseObject == null) {
            return false;
        }
        try {
            refBaseObject.refMetaObject();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static RefPackage getNestedPackage(String string, RefPackage refPackage) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            refPackage = refPackage.refPackage(string2);
        }
        return refPackage;
    }

    public static void deleteAssociationAndReferences(ModelPackage modelPackage, MofClass mofClass, String string, MofClass mofClass2, String string2, String string3) {
        RepositoryHelper.deleteAssociationAndReferences(modelPackage, mofClass, string, mofClass2, string2, string3, null);
    }

    public static void deleteAssociationAndReferences(ModelPackage modelPackage, MofClass mofClass, String string, MofClass mofClass2, String string2, String string3, Namespace namespace) {
        RepositoryHelper.deleteReference(mofClass, string);
        RepositoryHelper.deleteReference(mofClass2, string2);
        Association association = RepositoryHelper.findAssociation(modelPackage, string3, namespace);
        association.refDelete();
    }

    public static void deleteReference(MofClass mofClass, String string) {
        if (mofClass == null || string == null) {
            return;
        }
        List list = CollectionFactory.createArrayList((Collection)mofClass.getContents());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            RefObject refObject = (RefObject)iterator.next();
            String string2 = (String)refObject.refGetValue("name");
            if (!Strings.equals((String)string, (String)string2)) continue;
            refObject.refDelete();
        }
    }

    public static PrimitiveType getBoolean(ModelPackage modelPackage) {
        return RepositoryHelper.getPrimitiveType(modelPackage, "Boolean");
    }

    public static PrimitiveType getPrimitiveType(ModelPackage modelPackage, String string) {
        return (PrimitiveType)RepositoryHelper.findModelElement(modelPackage, string, A == null ? (A = RepositoryHelper.A("javax.jmi.model.PrimitiveType")) : A);
    }

    public static PrimitiveType getInteger(ModelPackage modelPackage) {
        return RepositoryHelper.getPrimitiveType(modelPackage, "Integer");
    }

    public static PrimitiveType getString(ModelPackage modelPackage) {
        return RepositoryHelper.getPrimitiveType(modelPackage, "String");
    }

    public static Collection filterCollectionByClass(Collection collection, Class clazz) {
        List list = CollectionFactory.createArrayList();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (!clazz.isInstance(e2)) continue;
            list.add(e2);
        }
        return list;
    }

    public static Object getFirstCollectionElementOfClass(Collection collection, Class clazz) {
        Object var2_2 = null;
        if (!collection.isEmpty()) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                if (!clazz.isInstance(e2)) continue;
                var2_2 = e2;
                break;
            }
        }
        return var2_2;
    }

    static {
        _packageNameMap = CollectionFactory.createHashMap();
        _packageNameMap.put("Core", "Core");
        _packageNameMap.put("ModelManagement", "Model_Management");
        _packageNameMap.put("CommonBehavior", "Common_Behavior");
        _packageNameMap.put("DataTypes", "Data_Types");
        _packageNameMap.put("DiagramInterchange", "Diagram_Interchange");
        _packageNameMap.put("Collaborations", "Collaborations");
        _packageNameMap.put("ActivityGraphs", "Activity_Graphs");
        _packageNameMap.put("UseCases", "Use_Cases");
        _packageNameMap.put("StateMachines", "State_Machines");
        _packageNameMap.put("Core2", "Core2");
        _packageNameMap.put("CompositeStructures2", "CompositeStructures2");
        _packageNameMap.put("CommonBehaviors2", "CommonBehaviors2");
        _packageNameMap.put("Actions2", "Actions2");
        _packageNameMap.put("Activities2", "Activities2");
        _packageNameMap.put("AuxiliaryConstructs2", "AuxiliaryConstructs2");
        _packageNameMap.put("Components2", "Components2");
        _packageNameMap.put("Deployment2", "Deployment2");
        _packageNameMap.put("Interactions2", "Interactions2");
        _packageNameMap.put("Profiles2", "Profiles2");
        _packageNameMap.put("StateMachines2", "StateMachines2");
        _packageNameMap.put("UseCases2", "UseCases2");
    }

    private static Class A(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

