/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.anvil.kernel;

import com.gentleware.openapi.util.Files;
import com.gentleware.openapi.util.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import org.apache.log4j.Logger;

public abstract class H {
    private static final Logger A = Logger.getLogger((String)"com.gentleware.anvil.kernel.PropertyLoader");
    protected Properties _properties;
    protected String _propertiesLocation;

    protected void load(String string) throws IOException, NullPointerException {
        this._propertiesLocation = System.getProperty(string);
        if (this._propertiesLocation == null) {
            throw new NullPointerException("System property " + string + " is not set!");
        }
        try {
            this.A(this._propertiesLocation);
        }
        catch (IOException iOException) {
            A.error((Object)("Error while loading properties from file set in property " + string + "."), (Throwable)iOException);
            throw iOException;
        }
    }

    private void A(String string) throws IOException {
        if (string.startsWith("http:") || string.startsWith("ftp:")) {
            URL uRL = new URL(string);
            this.A(uRL);
        } else {
            String string2 = Utils.resolveUserHomePath((String)string);
            File file = new File(string2);
            if (!file.exists()) {
                throw new IOException("File \"" + string2 + "\" does not exist.");
            }
            this.loadPropertyFile(file);
        }
    }

    private void A(URL uRL) throws IOException {
        A.info((Object)("Loading properties from URL \"" + uRL + "\"."));
        this._properties = Files.readPropertiesFromUrl((URL)uRL);
    }

    protected void loadPropertyFile(File file) throws IOException {
        A.info((Object)("Loading properties from file \"" + file.getAbsolutePath() + "\"."));
        Properties properties = new Properties();
        FileInputStream fileInputStream = new FileInputStream(file);
        properties.load(fileInputStream);
        fileInputStream.close();
        this._properties = properties;
    }

    protected String getCheckedString(String string) throws IllegalArgumentException {
        String string2 = this.get(string);
        if (string2 == null) {
            throw new IllegalArgumentException("Property " + string + " is not set in properties file " + this._propertiesLocation + "! Aborting.");
        }
        return string2;
    }

    public String getPropertiesLocation() {
        return this._propertiesLocation;
    }

    protected boolean getCheckedBoolean(String string, Boolean bl) throws IllegalArgumentException {
        boolean bl2;
        String string2 = this.get(string);
        if (string2 == null && bl == null) {
            throw new IllegalArgumentException("Property " + string + " is not set in properties file " + this._propertiesLocation + "! Aborting.");
        }
        if (string2 == null) {
            bl2 = bl;
        } else if ("true".equals(string2)) {
            bl2 = true;
        } else if ("false".equals(string2)) {
            bl2 = false;
        } else {
            throw new IllegalArgumentException("Value for property " + string + " must be either true or false, but was " + string2);
        }
        return bl2;
    }

    protected int getCheckedInt(String string) throws IllegalArgumentException {
        String string2 = this.getCheckedString(string);
        int n = this.A(string2, string);
        return n;
    }

    private int A(String string, String string2) throws IllegalArgumentException {
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Cannot parse integer value for property " + string2 + ": " + string);
        }
        return n;
    }

    protected int getCheckedInt(String string, int n) throws IllegalArgumentException {
        String string2 = this.get(string);
        if (string2 == null) {
            return n;
        }
        int n2 = this.A(string2, string);
        return n2;
    }

    public String get(String string) throws IllegalStateException {
        if (this._properties == null) {
            throw new IllegalStateException("Call load() first!");
        }
        String string2 = this._properties.getProperty(string);
        return string2;
    }
}

