/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.anvil.kernel;

import com.gentleware.anvil.kernel.J;
import com.gentleware.anvil.kernel.KeyManager;
import com.gentleware.anvil.kernel.LicenseData;
import com.gentleware.anvil.kernel.LicenseResourceBundle;
import com.gentleware.anvil.kernel.ProductEditionImpl;
import com.gentleware.anvil.kernel.ProductImpl;
import com.gentleware.anvil.kernel.RegistrationDialog;
import com.gentleware.anvil.kernel.RegistrationResourceBundle;
import com.gentleware.anvil.kernel.keymodel.KeyType;
import com.gentleware.anvil.kernel.keymodel.LicenseKey;
import com.gentleware.anvil.kernel.utils.LicenseCipherClient;
import com.gentleware.anvil.kernel.utils.LicenseException;
import com.gentleware.anvil.kernel.utils.LicenseUtils;
import com.gentleware.locksmith.client.LicenseKeys;
import com.gentleware.openapi.configuration.Services;
import com.gentleware.openapi.swingx.Localizer;
import com.gentleware.openapi.swingx.ResourceId;
import com.gentleware.openapi.swingx.SwingFactory;
import com.gentleware.openapi.swingx.SwingUtil;
import com.gentleware.openapi.swingx.XAbstractAction;
import com.gentleware.openapi.swingx.XTab;
import com.gentleware.openapi.swingx.XTableLayout;
import com.gentleware.openapi.util.BuildPropertiesBasic;
import com.gentleware.openapi.util.CollectionFactory;
import com.gentleware.openapi.util.IconLoader;
import com.gentleware.openapi.util.ProductEdition;
import com.gentleware.openapi.util.ProductVersion;
import com.gentleware.swingx.BrowserLauncher;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.apache.log4j.Logger;

public class KeyManagerTab
extends XTab {
    private static final Logger N = Logger.getLogger((String)"com.gentleware.anvil.kernel.KeyManagerTab");
    private JDialog k;
    private final JTextArea _ = new JTextArea(3, 75);
    private Action T = new XAbstractAction(RegistrationResourceBundle.ButtonEvaluate){

        public void actionPerformed(ActionEvent actionEvent) {
            String string = Services.getInstance().getConfiguration().getString("services/browser");
            BrowserLauncher.showURL((String)"http://www.gentleware.com?redirect=evaluate", (String)string);
        }
    };
    private Action b = new XAbstractAction(RegistrationResourceBundle.ButtonBuy){

        public void actionPerformed(ActionEvent actionEvent) {
            String string = Services.getInstance().getConfiguration().getString("services/browser");
            BrowserLauncher.showURL((String)"http://www.gentleware.com?redirect=order", (String)string);
        }
    };
    private final String L = Localizer.localize((ResourceId)RegistrationResourceBundle.validText);
    private final String i = Localizer.localize((ResourceId)RegistrationResourceBundle.expiredText);
    private final String j = Localizer.localize((ResourceId)RegistrationResourceBundle.validRegisterText);
    private final String X = Localizer.localize((ResourceId)RegistrationResourceBundle.expiredInterimText);
    private final String g = Localizer.localize((ResourceId)RegistrationResourceBundle.invalidUserText);
    private final String U = Localizer.localize((ResourceId)RegistrationResourceBundle.invalidMachineText);
    private final String K = Localizer.localize((ResourceId)RegistrationResourceBundle.invalidEditionText);
    private final String a = Localizer.localize((ResourceId)RegistrationResourceBundle.invalidVersionText);
    private final String d = Localizer.localize((ResourceId)RegistrationResourceBundle.invalidConcurrentSerial);
    private final String S = Localizer.localize((ResourceId)RegistrationResourceBundle.invalidSerial);
    final JLabel _introductionLabel;
    private J I;
    private JTable Z;
    private JLabel e = SwingFactory.makeLabel((ResourceId)RegistrationResourceBundle.LicenseTableLabel, (JComponent)this.Z);
    private AbstractButton O = SwingFactory.makeButton((ResourceId)RegistrationResourceBundle.AddLicenseKey);
    private AbstractButton W = SwingFactory.makeButton((ResourceId)RegistrationResourceBundle.RemoveLicenseKey);
    private AbstractButton G = SwingFactory.makeButton((ResourceId)RegistrationResourceBundle.Register);
    private AbstractButton l = SwingFactory.makeButton((Action)this.T);
    private AbstractButton m = SwingFactory.makeButton((Action)this.b);
    private final AbstractButton Y = SwingFactory.makeButton((ResourceId)new ResourceId("Registration", "PasteFromClipboard"));
    private ImageIcon o = IconLoader.getIconLoader().get("Check16", ((Object)((Object)this)).getClass().getClassLoader());
    private ImageIcon u = IconLoader.getIconLoader().get("Error16", ((Object)((Object)this)).getClass().getClassLoader());
    private static final String s = Localizer.localize((ResourceId)LicenseResourceBundle.KeyManagerAddInvalidKey);
    private static final String P = Localizer.localize((ResourceId)LicenseResourceBundle.KeyManagerAddInvalidEdition);
    private final String h = Localizer.localize((ResourceId)LicenseResourceBundle.KeyManagerAddNoKey);
    public static final String WRONG_KEY_TYPE = Localizer.localize((ResourceId)LicenseResourceBundle.KeyManagerWrongKeyType);
    public static final ResourceId INVALID_KEY_TITLE_RESOURCE_ID = LicenseResourceBundle.KeyManagerAddInvalidKeyTitle;
    public static final String INVALID_KEY_TITLE = Localizer.localize((ResourceId)INVALID_KEY_TITLE_RESOURCE_ID);
    private static final String q = Localizer.localize((ResourceId)LicenseResourceBundle.KeyVersionTooLow);
    private static final String V = Localizer.localize((ResourceId)LicenseResourceBundle.KeyVersionTooHigh);
    private KeyManager M;
    private boolean Q;
    private ProductImpl p;
    private TableModelListener n = new TableModelListener(){

        public void tableChanged(TableModelEvent tableModelEvent) {
            KeyManagerTab.this.notifyChangeListeners();
            int n = KeyManagerTab.this.I.getRowCount();
            final int n2 = Math.min(tableModelEvent.getFirstRow(), n - 1);
            if (n2 >= 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        int n = Math.min(KeyManagerTab.this.Z.getRowCount() - 1, n2);
                        if (n > 0) {
                            KeyManagerTab.this.Z.setRowSelectionInterval(n, n);
                        }
                    }
                });
            }
        }
    };
    private ActionListener R = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            KeyManagerTab.this.D();
        }
    };
    private ActionListener t = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            KeyManagerTab.this.E();
        }
    };
    private ActionListener c = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            KeyManagerTab.this.B();
        }
    };
    private ListSelectionListener f = new ListSelectionListener(){

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            KeyManagerTab.this.handleTableSelectionChanged();
        }
    };
    private TableCellRenderer H = new _A();
    private KeyType[] r;
    private final int v;
    public final ResourceId _tabLabel;
    public boolean _containsConcurrentKeys;
    private List J = CollectionFactory.createArrayList();

    public KeyManagerTab(JDialog jDialog, KeyManager keyManager, boolean bl, ProductImpl productImpl, boolean bl2, ResourceId resourceId, ResourceId resourceId2) {
        super(resourceId2);
        this._tabLabel = resourceId2;
        this._containsConcurrentKeys = bl2;
        this.k = jDialog;
        this.M = keyManager;
        this.Q = bl;
        this.p = productImpl;
        this.I = new J(this.M, bl2);
        this.Z = new JTable(this.I);
        this._.setFont(new Font("Courier New", 0, 12));
        this._introductionLabel = SwingFactory.makeLabel((ResourceId)resourceId, (JComponent)this.Z);
        this.C();
        this.G();
        this.v = this._containsConcurrentKeys ? 6 : 5;
        TableColumn tableColumn = this.Z.getColumnModel().getColumn(this.v);
        tableColumn.setCellRenderer(this.H);
        TableColumn tableColumn2 = this.Z.getColumnModel().getColumn(4);
        tableColumn2.setCellRenderer(new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                J j = (J)jTable.getModel();
                LicenseKey licenseKey = j.A(n);
                if (KeyType.LICENSE_KEY_CONTAINER.equals(licenseKey.getType())) {
                    int n3 = LicenseUtils.getAvailableLeaseLicenseCountFromContainer(licenseKey);
                    if (n3 != -1) {
                        String string = Localizer.localize((ResourceId)RegistrationResourceBundle.AvailableLicense);
                        this.setToolTipText(string + n3);
                    } else {
                        this.setToolTipText(null);
                    }
                }
                return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            }
        });
        this.Z.setAutoResizeMode(3);
        this.G.addActionListener(this.R);
        this.W.addActionListener(this.t);
        this.Y.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                try {
                    Transferable transferable = clipboard.getContents(null);
                    String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                    KeyManagerTab.this._.setText(string);
                }
                catch (Exception exception) {
                    N.error((Object)exception);
                }
            }
        });
        this.O.addActionListener(this.c);
        this.Z.getSelectionModel().addListSelectionListener(this.f);
        this.I.addTableModelListener(this.n);
        this.O.setMnemonic(Localizer.localize((ResourceId)RegistrationResourceBundle.addKeyButtonText_mnemonic).charAt(0));
        this.W.setMnemonic(Localizer.localize((ResourceId)RegistrationResourceBundle.removeKeyButtonText_mnemonic).charAt(0));
        this.G.setMnemonic(Localizer.localize((ResourceId)RegistrationResourceBundle.registerKeyButtonText_mnemonic).charAt(0));
        this.e.setLabelFor(this.Z);
        this.e.setDisplayedMnemonic(Localizer.localize((ResourceId)RegistrationResourceBundle.LicenseTableLabel_mnemonic).charAt(0));
        this.notifyChangeListeners();
        this.handleTableSelectionChanged();
        this.r = bl2 ? new KeyType[]{KeyType.EVALUATION, KeyType.LICENSE_KEY_CONTAINER, KeyType.SERIAL_NUMBER, KeyType.SERVER_CONCURRENT} : new KeyType[]{KeyType.EVALUATION, KeyType.FINAL, KeyType.SERIAL_NUMBER};
        Arrays.sort(this.r);
    }

    private void B() {
        KeyManagerTab keyManagerTab;
        String string = this._.getText();
        boolean bl = KeyManagerTab.B(string, keyManagerTab = this, this.h);
        if (!bl) {
            return;
        }
        try {
            LicenseKey licenseKey = KeyManagerTab.decryptLicenseKeyAndShowMessageOnError((Component)((Object)keyManagerTab), string, this.Q);
            boolean bl2 = this.verifyKeyValidityAndShowMessageOnError(licenseKey);
            if (!bl2) {
                return;
            }
            try {
                this.B(licenseKey);
                this.M.addKey(licenseKey);
                this._.setText("");
            }
            catch (IOException iOException) {
                KeyManagerTab.B((Component)((Object)keyManagerTab), iOException, this.Q);
            }
        }
        catch (LicenseException licenseException) {
            KeyManagerTab.B((Component)((Object)keyManagerTab), s, licenseException, this.Q);
            this._.setText("");
        }
    }

    boolean verifyKeyValidityAndShowMessageOnError(LicenseKey licenseKey) {
        boolean bl;
        boolean bl2 = true;
        boolean bl3 = this.proveLicenseKey(licenseKey);
        if (!bl3) {
            bl2 = false;
        } else if (KeyType.SERIAL_NUMBER.equals(licenseKey.getType()) && !(bl = this.verifySerialValidityAndShowMessageOnError(licenseKey))) {
            bl2 = false;
        }
        return bl2;
    }

    protected boolean proveLicenseKey(LicenseKey licenseKey) {
        ProductEdition productEdition = this.p.getEdition();
        ProductVersion productVersion = this.p.getVersion();
        boolean bl = KeyManagerTab.proveLicenseKey((Component)((Object)this), licenseKey, this.r, productEdition, productVersion, this.Q);
        return bl;
    }

    protected boolean verifySerialValidityAndShowMessageOnError(LicenseKey licenseKey) {
        boolean bl = true;
        boolean bl2 = LicenseUtils.isConcurrentLicense(licenseKey);
        if (bl2 && !this._containsConcurrentKeys) {
            String string = this.S;
            KeyManagerTab.B((Component)((Object)this), string, null, this.Q);
            bl = false;
        } else if (!bl2 && this._containsConcurrentKeys) {
            String string = this.d;
            KeyManagerTab.B((Component)((Object)this), string, null, this.Q);
            bl = false;
        }
        return bl;
    }

    private static boolean B(String string, KeyManagerTab keyManagerTab, String string2) {
        boolean bl;
        if (string.length() == 0) {
            KeyManagerTab.B((Component)((Object)keyManagerTab), string2, null, keyManagerTab.Q);
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    public static LicenseKey decryptLicenseKeyAndShowMessageOnError(Component component, String string, boolean bl) {
        LicenseKey licenseKey = null;
        try {
            licenseKey = LicenseCipherClient.getInstance().decryptKeyFromServer(string);
        }
        catch (LicenseException licenseException) {
            KeyManagerTab.B(component, s, licenseException, bl);
        }
        return licenseKey;
    }

    public static boolean proveLicenseKey(Component component, LicenseKey licenseKey, KeyType[] keyTypeArray, ProductEdition productEdition, ProductVersion productVersion, boolean bl) {
        boolean bl2;
        if (licenseKey == null) {
            return false;
        }
        if (!KeyManagerTab.keyValidForApplication(component, licenseKey, bl, productEdition)) {
            return false;
        }
        if (!KeyManagerTab.B(component, licenseKey, productVersion, bl)) {
            return false;
        }
        int n = Arrays.binarySearch(keyTypeArray, licenseKey.getType());
        boolean bl3 = bl2 = n < 0;
        if (bl2) {
            String string = WRONG_KEY_TYPE;
            KeyManagerTab.B(component, string, null, bl);
            return false;
        }
        return true;
    }

    private static boolean B(Component component, LicenseKey licenseKey, ProductVersion productVersion, boolean bl) {
        boolean bl2;
        if (LicenseUtils.isModule(licenseKey)) {
            bl2 = true;
        } else {
            ProductVersion productVersion2 = LicenseUtils.getProductVersion(licenseKey);
            int n = productVersion2.compareTo(productVersion, true);
            if (n != 0) {
                String string = productVersion2.toString();
                String string2 = productVersion.toString();
                String string3 = n < 0 ? q : V;
                String string4 = MessageFormat.format(string3, string, string2);
                KeyManagerTab.B(component, string4, null, bl);
                bl2 = false;
            } else {
                bl2 = true;
            }
        }
        return bl2;
    }

    private static void B(Component component, String string, Throwable throwable, boolean bl) {
        if (bl) {
            JOptionPane.showMessageDialog(component, string, INVALID_KEY_TITLE, 0);
        } else {
            N.error((Object)string, throwable);
        }
    }

    private static void B(Component component, Throwable throwable, boolean bl) {
        String string = Localizer.localize((ResourceId)LicenseResourceBundle.ErrorDialogTitle);
        String string2 = Localizer.localize((ResourceId)LicenseResourceBundle.ErrorDialogMessage);
        N.error((Object)string2, throwable);
        if (bl) {
            JOptionPane.showMessageDialog(component, string2, string, 0);
        }
    }

    private void B(LicenseKey licenseKey) throws IOException {
        if (licenseKey.getType() == KeyType.FINAL) {
            long l = licenseKey.getSerialNoDbId();
            int n = this.M.size();
            for (int i = 0; i < n; ++i) {
                LicenseKey licenseKey2 = this.M.getKey(i);
                if (licenseKey2.getType() != KeyType.SERIAL_NUMBER || licenseKey2.getDbId() != l) continue;
                this.M.removeKey(licenseKey2);
                break;
            }
        }
    }

    protected static boolean keyValidForApplication(Component component, LicenseKey licenseKey, boolean bl, ProductEdition productEdition) {
        ProductEditionImpl[] productEditionImplArray = LicenseUtils.getApplicationEditions(licenseKey);
        List<ProductEditionImpl> list = Arrays.asList(productEditionImplArray);
        boolean bl2 = list.contains(productEdition);
        if (!bl2) {
            Object[] objectArray;
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            ProductEdition productEdition2 = list.get(0);
            String string = productEdition2.getLongName();
            stringBuffer.append(string);
            for (n = 1; n < list.size() - 1; ++n) {
                productEdition2 = list.get(n);
                stringBuffer.append(", ");
                string = productEdition2.getLongName();
                stringBuffer.append(string);
            }
            if (n < list.size()) {
                productEdition2 = list.get(n);
                objectArray = Localizer.localize((ResourceId)LicenseResourceBundle.KeyManagerAddInvalidKeyAnd);
                string = productEdition2.getLongName();
                stringBuffer.append(" " + (String)objectArray + " " + string);
            }
            objectArray = new Object[]{productEdition.getLongName(), stringBuffer.toString()};
            String string2 = MessageFormat.format(P, objectArray);
            KeyManagerTab.B(component, string2, null, bl);
        }
        return bl2;
    }

    public JTable getLicenseKeyTable() {
        return this.Z;
    }

    public KeyManager getKeyManager() {
        return this.M;
    }

    private void D() {
        LicenseKey licenseKey = this.H();
        this.C(licenseKey);
    }

    private void C(LicenseKey licenseKey) {
        if (licenseKey.getType() == KeyType.SERIAL_NUMBER) {
            RegistrationDialog registrationDialog = new RegistrationDialog(this.k, licenseKey, this.p);
            registrationDialog.show();
            if (registrationDialog.hasFinalKey()) {
                LicenseKey licenseKey2 = registrationDialog.getFinalKey();
                this.B(licenseKey, licenseKey2);
            }
            this.notifyChangeListeners();
            this.Z.repaint();
        }
    }

    private void B(LicenseKey licenseKey, LicenseKey licenseKey2) {
        try {
            this.M.addKey(licenseKey2);
            this.M.removeKey(licenseKey);
        }
        catch (LicenseException licenseException) {
            N.error((Object)"Error while registering key at key-manager.", (Throwable)licenseException);
        }
        catch (IOException iOException) {
            N.error((Object)"Error while registering key at key-manager.", (Throwable)iOException);
        }
    }

    public void registerKeyAtKeyManager_TEST_ONLY(LicenseKey licenseKey, LicenseKey licenseKey2) {
        this.B(licenseKey, licenseKey2);
    }

    private void E() {
        LicenseKey[] licenseKeyArray = this.F();
        try {
            this.M.removeKeys(licenseKeyArray);
        }
        catch (IOException iOException) {
            KeyManagerTab.B((Component)((Object)this), iOException, this.Q);
        }
    }

    public boolean isWithGui() {
        return this.Q;
    }

    public void setWithGui_TEST_ONLY(boolean bl) {
        this.Q = bl;
    }

    private LicenseKey H() {
        LicenseKey licenseKey = null;
        int n = this.Z.getSelectedRow();
        if (n >= 0) {
            licenseKey = this.I.A(n);
        }
        if (licenseKey != null && licenseKey.getType().equals(KeyType.LICENSE_KEY_CONTAINER)) {
            LicenseKey licenseKey2 = LicenseUtils.getConcurrentKey(licenseKey);
            licenseKey = licenseKey2 != null ? licenseKey2 : licenseKey;
        }
        return licenseKey;
    }

    private LicenseKey[] F() {
        List list = CollectionFactory.createArrayList();
        int[] nArray = this.Z.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            LicenseKey licenseKey = this.I.A(n);
            list.add(licenseKey);
        }
        return list.toArray(new LicenseKey[list.size()]);
    }

    public void handleTableSelectionChanged() {
        ProductEditionImpl[] productEditionImplArray;
        LicenseKey licenseKey = this.H();
        boolean bl = false;
        if (licenseKey != null && licenseKey.isRegisterable() && Arrays.asList(productEditionImplArray = LicenseUtils.getApplicationEditions(licenseKey)).contains(this.getPoseidonEdition())) {
            bl = true;
        }
        this.G.setEnabled(bl);
        this.W.setEnabled(licenseKey != null);
    }

    private void G() {
        String string = Localizer.localize((ResourceId)this._tabLabel);
        this.setName(string);
        this.e.setName("tableLabel");
        this.O.setName("addKeyButton");
        this.W.setName("removeKeyButton");
        this.G.setName("registerKeyButton");
        this.Z.setName("licenseKeyTable");
    }

    private void C() {
        Font font = this.e.getFont();
        Font font2 = new Font(font.getName(), 1, font.getSize() + 1);
        this.e.setFont(font2);
        JPanel jPanel = new JPanel((LayoutManager)new XTableLayout(0, 4));
        jPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        String string = "+ . 1 1 fill center";
        String string2 = ". + 1 1 fill center 1 0";
        SwingUtil.makePreferSameSize((JComponent[])new JComponent[]{this.O, this.W, this.G, this.l, this.m});
        JPanel jPanel2 = new JPanel((LayoutManager)new XTableLayout(3, 0));
        jPanel2.add((Component)this.W, "+ . 1 1 fill center");
        jPanel2.add((Component)this.G, "+ . 1 1 fill center");
        jPanel2.add(Box.createHorizontalStrut(6), "+ . 1 1 fill center");
        jPanel2.add((Component)this.l, "+ . 1 1 fill center");
        jPanel2.add((Component)this.m, "+ . 1 1 fill center");
        jPanel2.add(Box.createHorizontalGlue(), "+ . 1 1 fill center 1 0");
        jPanel2.setBorder(BorderFactory.createEmptyBorder(6, 0, 0, 0));
        TableColumnModel tableColumnModel = this.Z.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(70);
        tableColumnModel.getColumn(1).setPreferredWidth(140);
        tableColumnModel.getColumn(2).setPreferredWidth(75);
        tableColumnModel.getColumn(3).setPreferredWidth(60);
        if (this._containsConcurrentKeys) {
            tableColumnModel.getColumn(4).setPreferredWidth(60);
            tableColumnModel.getColumn(5).setPreferredWidth(100);
            tableColumnModel.getColumn(6).setPreferredWidth(230);
        } else {
            tableColumnModel.getColumn(4).setPreferredWidth(100);
            tableColumnModel.getColumn(5).setPreferredWidth(230);
        }
        JScrollPane jScrollPane = new JScrollPane(this.Z);
        jScrollPane.setPreferredSize(new Dimension(680, 150));
        jPanel.add((Component)this._introductionLabel, ". + 1 1 fill center 1 0");
        jPanel.add((Component)this.e, ". + 1 1 fill center 1 0");
        jPanel.add((Component)jScrollPane, ". + 1 1 fill fill 1 1");
        jPanel.add((Component)jPanel2, ". + 1 1 fill center 1 0");
        JLabel jLabel = SwingFactory.makeLabel((ResourceId)RegistrationResourceBundle.NewKeySerial, null);
        jLabel.setFont(font2);
        JLabel jLabel2 = SwingFactory.makeLabel((ResourceId)RegistrationResourceBundle.AddNewKey, null);
        jPanel.add(Box.createVerticalStrut(15), ". + 1 1 fill center 1 0");
        jPanel.add((Component)jLabel, ". + 1 1 fill center 1 0");
        jPanel.add((Component)jLabel2, ". + 1 1 fill center 1 0");
        jPanel.add((Component)new JScrollPane(this._), ". + 1 1 fill center 1 0");
        JPanel jPanel3 = new JPanel((LayoutManager)new XTableLayout(3, 0));
        SwingUtil.makePreferSameSize((JComponent[])new JComponent[]{this.Y, this.O});
        jPanel3.add((Component)this.Y, "+ .");
        jPanel3.add((Component)this.O, "+ .");
        jPanel.add((Component)jPanel3, ". + 1 1 fill center 1 0");
        this.add(jPanel);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.J.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.J.remove(changeListener);
    }

    protected void notifyChangeListeners() {
        ChangeEvent changeEvent = new ChangeEvent((Object)this);
        for (int i = 0; i < this.J.size(); ++i) {
            ChangeListener changeListener = (ChangeListener)this.J.get(i);
            changeListener.stateChanged(changeEvent);
        }
    }

    public ProductEdition getPoseidonEdition() {
        String string = BuildPropertiesBasic.getEditionShort();
        ProductEditionImpl productEditionImpl = ProductEditionImpl.get(string);
        return productEditionImpl;
    }

    public JTextArea getAddKeyField() {
        return this._;
    }

    public String getValidText() {
        return this.L;
    }

    public String getInvalidVersionText() {
        return this.a;
    }

    public String getValidRegisterText() {
        return this.j;
    }

    public String getInvalidUserText() {
        return this.g;
    }

    public AbstractButton getAddKeyButton() {
        return this.O;
    }

    public int getColumnForkeyValidRenderer() {
        return this.v;
    }

    class _A
    extends DefaultTableCellRenderer {
        private final String A;
        private final ProductEditionImpl B;

        _A() {
            this.A = BuildPropertiesBasic.getEditionShort();
            this.B = ProductEditionImpl.get(this.A);
        }

        _A(String string) {
            this.A = string;
            this.B = ProductEditionImpl.get(this.A);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            String string;
            boolean bl3;
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            LicenseKey licenseKey = (LicenseKey)jTable.getValueAt(n, n2);
            LicenseData licenseData = LicenseKeys.getInstance().getPoseidonLicenseData(KeyManagerTab.this.p);
            ProductImpl productImpl = licenseData.getApplication();
            boolean bl4 = licenseKey.isValidForDate(licenseData.getDate());
            boolean bl5 = licenseKey.isValidForCustomer(licenseData.getCustomer());
            boolean bl6 = licenseKey.isValidForMachine(licenseData.getMachine());
            boolean bl7 = licenseKey.isValidForVersion(productImpl);
            boolean bl8 = licenseKey.isValidForApplication(productImpl);
            KeyType keyType = licenseKey.getType();
            if (KeyType.EVALUATION.equals(keyType)) {
                bl3 = LicenseUtils.checkForConcurrentEvaluationLicense(licenseKey);
                bl8 = this.B.isTeamAware() ? bl3 : !bl3;
            }
            bl3 = KeyType.SERIAL_NUMBER.equals(keyType);
            boolean bl9 = LicenseUtils.isConcurrentLicense(licenseKey);
            if (KeyType.SERVER_CONCURRENT.equals(keyType)) {
                bl8 = true;
            } else if (bl3 && bl9) {
                LicenseKey licenseKey2 = LicenseUtils.getConcurrentKey(licenseKey);
                string = LicenseUtils.getApplicationName(licenseKey2);
                boolean bl10 = "EnterpriseEditionServer".equalsIgnoreCase(string);
                bl8 = bl10 ? true : licenseKey2.isValidForApplication(productImpl);
            }
            boolean bl11 = bl4 && bl5 && bl6 && bl8 && bl7;
            this.setIcon(bl11 ? KeyManagerTab.this.o : KeyManagerTab.this.u);
            string = KeyManagerTab.this.L;
            if (!bl4 && bl3) {
                string = KeyManagerTab.this.X;
            } else if (!bl7) {
                string = KeyManagerTab.this.a;
            } else if (!bl8) {
                string = KeyManagerTab.this.K;
            } else if (!bl4 && !bl3) {
                string = KeyManagerTab.this.i;
            } else if (!bl5) {
                string = KeyManagerTab.this.g;
            } else if (!bl6) {
                string = KeyManagerTab.this.U;
            } else if (bl3) {
                string = KeyManagerTab.this.j;
            }
            this.setText(string);
            return this;
        }
    }
}

