/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.anvil.kernel;

import com.gentleware.anvil.kernel.G;
import com.gentleware.anvil.kernel.LicenseKeyResponse;
import com.gentleware.anvil.kernel.keymodel.LicenseKey;
import com.gentleware.anvil.kernel.utils.LicenseCipherClient;
import com.gentleware.anvil.kernel.utils.LicenseException;
import com.gentleware.openapi.configuration.Configuration;
import com.gentleware.openapi.configuration.Services;
import com.gentleware.openapi.util.Files;
import com.gentleware.openapi.util.Strings;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.log4j.Logger;

public class RegistrationTask
extends Thread {
    private static final Logger E = Logger.getLogger((String)"com.gentleware.anvil.kernel.RegistrationTask");
    public static final int MAX_CANCEL_DELAY = 6000;
    public static final int EVT_CONTACT_GW_SERVER = 1;
    public static final int EVT_CONTACT_REG_SERVER = 2;
    public static final int EVT_DISABLED = 4;
    public static final int EVT_SUCCESS = 5;
    public static final int EVT_FAILED = 6;
    public static final int EVT_CANCELED = 7;
    public static final String SOAP_CONFIGURATION_URL = G.B();
    public static final String DISABLED_MESSAGE_BASE_URL = G.D();
    private static String A = G.G();
    private final Object B = new Object(){

        public String toString() {
            return "SoapConfigurationLock";
        }
    };
    protected int _currentState;
    protected String _registrationDataText;
    protected LicenseKey _finalKey;
    protected String _finalKeyAsString;
    protected boolean _keepRunning = true;
    private Listener C;
    protected String _disabledMessage;
    protected String _resultMessage;
    protected final _A _doTell = new _A();
    private String F;
    private String D;
    private static Class class$com$gentleware$anvil$kernel$RegistrationTask;

    public String toString() {
        return super.toString() + "{\n\tSOAP_CONFIGURATION_URL='" + SOAP_CONFIGURATION_URL + "',\n\tDISABLED_MESSAGE_BASE_URL='" + DISABLED_MESSAGE_BASE_URL + "',\n\t_currentState=" + this._currentState + "\n}";
    }

    public RegistrationTask(String string, Listener listener, String string2) {
        this(string, listener, string2, true);
    }

    public RegistrationTask(String string, Listener listener, String string2, boolean bl) {
        super((class$com$gentleware$anvil$kernel$RegistrationTask == null ? (class$com$gentleware$anvil$kernel$RegistrationTask = RegistrationTask.A("com.gentleware.anvil.kernel.RegistrationTask")) : class$com$gentleware$anvil$kernel$RegistrationTask).getName());
        this._registrationDataText = string;
        this.C = listener;
        A = string2;
        if (bl) {
            this.start();
        }
    }

    public String getDisabledMessage() {
        return this._disabledMessage;
    }

    public String getResultMessage() {
        return this._resultMessage;
    }

    public LicenseKey getFinalKey() {
        return this._finalKey;
    }

    public String getFinalKeyAsString() {
        return this._finalKeyAsString;
    }

    public void run() {
        Locale locale = Locale.getDefault();
        this.run(locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String C() {
        Object object = this.B;
        synchronized (object) {
            return this.F;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSoapEndpoint(String string) {
        Object object = this.B;
        synchronized (object) {
            this.F = string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String B() {
        Object object = this.B;
        synchronized (object) {
            return this.D;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSoapMethodName(String string) {
        Object object = this.B;
        synchronized (object) {
            this.D = string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void E() {
        Object object = this.B;
        synchronized (object) {
            this.setSoapEndpoint(null);
            this.setSoapMethodName(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Locale locale) {
        block8: {
            try {
                String string;
                String string2;
                boolean bl = this.B(locale);
                if (!bl) break block8;
                Object object = this.B;
                synchronized (object) {
                    string2 = this.C();
                    string = this.B();
                }
                this.tell(2);
                E.info((Object)("Sending registration-data to " + string2));
                object = RegistrationTask.getFinalKey(string2, string, this._registrationDataText, locale);
                String string3 = ((LicenseKeyResponse)object).getKey();
                this._resultMessage = ((LicenseKeyResponse)object).getMessage();
                if (Strings.isEmpty((String)string3)) {
                    this.E();
                    this.tell(6);
                } else {
                    this._finalKeyAsString = string3;
                    this._finalKey = LicenseCipherClient.getInstance().decryptKeyFromServer(string3);
                    this.tell(5);
                }
            }
            catch (IOException iOException) {
                E.error((Object)iOException);
                this._resultMessage = RegistrationTask.C(A);
                this.tell(6);
            }
            catch (LicenseException licenseException) {
                E.error((Object)licenseException);
                this._resultMessage = RegistrationTask.C(A);
                this.tell(6);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean B(Locale locale) throws IOException {
        boolean bl;
        boolean bl2;
        String string;
        String string2;
        Object object = this.B;
        synchronized (object) {
            string2 = this.C();
            string = this.B();
        }
        boolean bl3 = bl2 = string2 != null && string != null;
        if (bl2) {
            return true;
        }
        this.tell(1);
        if (this.D()) {
            bl = false;
        } else {
            String string3 = RegistrationTask.A();
            if (this.D()) {
                bl = false;
            } else if (string3 == null || string3.length() == 0) {
                this.A(locale);
                bl = false;
            } else {
                bl = this.D() ? false : this.D(string3);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean D(String string) {
        boolean bl;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        if (stringTokenizer.countTokens() != 2) {
            this._resultMessage = this.B(A);
            this.tell(6);
            bl = false;
        } else {
            String string2 = stringTokenizer.nextToken().trim();
            String string3 = stringTokenizer.nextToken().trim();
            Object object = this.B;
            synchronized (object) {
                this.setSoapEndpoint(string2);
                this.setSoapMethodName(string3);
            }
            bl = true;
        }
        return bl;
    }

    private void A(Locale locale) throws IOException {
        Services services = Services.getInstance();
        Configuration configuration = services.getConfiguration();
        String string = configuration.getString(locale.getLanguage(), System.getProperty("user.language", "en"));
        String string2 = DISABLED_MESSAGE_BASE_URL + "_" + string + ".txt";
        this._disabledMessage = RegistrationTask.readUrl(string2, 4096);
        if (this._disabledMessage == null) {
            String string3 = DISABLED_MESSAGE_BASE_URL + ".txt";
            this._disabledMessage = RegistrationTask.readUrl(string3, 4096);
        }
        if (this._disabledMessage == null) {
            this._disabledMessage = this.B(A);
        }
        E.debug((Object)("[PoseidonRegistrationTask] disabledMessage: " + this._disabledMessage));
        this.tell(4);
    }

    private static String A() throws IOException {
        String string;
        E.info((Object)("Reading registration-configuration from " + SOAP_CONFIGURATION_URL));
        try {
            string = RegistrationTask.readUrl(SOAP_CONFIGURATION_URL, 1024);
        }
        catch (MalformedURLException malformedURLException) {
            E.error((Object)("Reading of SOAP-configuration-URL failed! - Please check web-server (tomcat). " + malformedURLException));
            throw malformedURLException;
        }
        E.info((Object)("[PoseidonRegistrationTask] soap configuration text: " + string));
        return string;
    }

    private String B(String string) {
        return "A server configuration error occured. Please try again later.\nIf the problem persists please contact Gentleware's support via http: " + string + "'.";
    }

    protected void tell(int n) {
        this._currentState = n;
        try {
            SwingUtilities.invokeAndWait(this._doTell);
        }
        catch (InterruptedException interruptedException) {
            E.debug((Object)interruptedException);
        }
        catch (InvocationTargetException invocationTargetException) {
            E.debug((Object)invocationTargetException);
        }
    }

    public static String readUrl(String string, int n) throws IOException, MalformedURLException {
        URL uRL = new URL(string);
        return Files.readStringFromUrl((URL)uRL, (int)n);
    }

    private boolean D() {
        if (!this._keepRunning) {
            this.tell(7);
            return true;
        }
        return false;
    }

    public static LicenseKeyResponse getFinalKey(String string, String string2, String string3, Locale locale) {
        try {
            String string4 = locale.toString();
            Service service = new Service();
            Call call = (Call)service.createCall();
            call.setTargetEndpointAddress(new URL(string));
            call.setOperationName(new QName(string2));
            String string5 = (String)call.invoke(new Object[]{string3, string4});
            String string6 = "#$#";
            int n = string5.indexOf("#$#");
            String string7 = Strings.left((String)string5, (int)n);
            String string8 = string5.substring(n + "#$#".length());
            LicenseKeyResponse licenseKeyResponse = new LicenseKeyResponse(string7, string8);
            return licenseKeyResponse;
        }
        catch (ServiceException serviceException) {
            E.error((Object)("Caught exception while trying SOAP registration at " + string + "," + string2), (Throwable)serviceException);
            LicenseKeyResponse licenseKeyResponse = new LicenseKeyResponse(null, RegistrationTask.C(A));
            return licenseKeyResponse;
        }
        catch (MalformedURLException malformedURLException) {
            E.error((Object)("Caught exception while trying SOAP registration at " + string + "," + string2), (Throwable)malformedURLException);
            LicenseKeyResponse licenseKeyResponse = new LicenseKeyResponse(null, RegistrationTask.C(A));
            return licenseKeyResponse;
        }
        catch (RemoteException remoteException) {
            E.error((Object)("Caught exception while trying SOAP registration at " + string + "," + string2), (Throwable)remoteException);
            LicenseKeyResponse licenseKeyResponse = new LicenseKeyResponse(null, RegistrationTask.C(A));
            return licenseKeyResponse;
        }
    }

    private static String C(String string) {
        return "A server side error occured. Please try again later.\nIf the problem persists please contact \nGentleware's support through http: '" + string + "'.";
    }

    private static Class A(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private class _A
    implements Runnable {
        private _A() {
        }

        public void run() {
            RegistrationTask.this.C.handleRegisterEvent(RegistrationTask.this, RegistrationTask.this._currentState);
        }
    }

    public static interface Listener {
        public void handleRegisterEvent(RegistrationTask var1, int var2);
    }
}

