/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.locksmith.client;

import com.gentleware.anvil.kernel.Customer;
import com.gentleware.locksmith.client.B;
import com.gentleware.locksmith.client.C;
import com.gentleware.locksmith.client.D;
import com.gentleware.locksmith.client.E;
import com.gentleware.locksmith.client.F;
import com.gentleware.locksmith.client.LicenseKeys;
import com.gentleware.openapi.util.BuildPropertiesBasic;
import com.gentleware.openapi.util.CollectionFactory;
import com.gentleware.openapi.util.Utils;
import com.gentleware.util.crypt.Crypter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public abstract class LicenseCode {
    private static final Logger D = Logger.getLogger((String)"com.gentleware.locksmith.client.LicenseCode");
    private static Class A;
    private static Map B;
    private String C;
    private String E;
    private String F;
    protected static final String KEY_TYPE_REGISTRATION = "PlatformInfo";
    protected static final String KEY_TYPE_EVALUATION = "EnablingKey";
    protected static final String KEY_TYPE_INTERIM = "InterimKey";
    protected static final String KEY_TYPE_UPGRADE = "UpgradeKey";
    protected static final String KEY_TYPE_FINAL = "FinalKey";
    protected static final String LICENSE_TYPE_EVALUATION = "Evaluation";
    protected static final String LICENSE_TYPE_INTERIM = "Interim";
    protected static final String LICENSE_TYPE_UPGRADE = "Upgrade";
    protected static final String LICENSE_TYPE_REGISTRATION = "Registration";
    protected static final String LICENSE_TYPE_MAJOR_RELEASE = "MajorRelease";

    public abstract String getName();

    protected abstract String getTokenString();

    protected abstract void setTokenString(StringTokenizer var1);

    public abstract String getDefaultFileName();

    public static Class getLicenseKeyClass() {
        if (A == null) {
            LicenseCode licenseCode = new LicenseCode(){

                public String getName() {
                    return null;
                }

                protected String getTokenString() {
                    return null;
                }

                protected void setTokenString(StringTokenizer stringTokenizer) {
                }

                public String getDefaultFileName() {
                    return null;
                }
            };
            A = licenseCode.getClass().getSuperclass();
        }
        return A;
    }

    public static LicenseCode[] newLicenseKeys(File file) {
        List list = CollectionFactory.createArrayList();
        try {
            int n = 81920;
            String string = LicenseCode.A(file, 81920);
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    LicenseCode licenseCode = LicenseCode.newLicenseKey(string2);
                    list.add(licenseCode);
                }
            }
        }
        catch (Exception exception) {
            D.warn((Object)"[LicenseCode] ", (Throwable)exception);
        }
        return list.toArray(new LicenseCode[list.size()]);
    }

    public static LicenseCode newLicenseKey(File file) {
        try {
            int n = 10240;
            String string = LicenseCode.A(file, 10240);
            LicenseCode licenseCode = null;
            if (string != null) {
                licenseCode = LicenseCode.newLicenseKey(string);
            }
            return licenseCode;
        }
        catch (RuntimeException runtimeException) {
            D.warn((Object)"[LicenseCode] ", (Throwable)runtimeException);
            return null;
        }
    }

    public static LicenseCode newLicenseKey(InputStream inputStream) {
        try {
            int n = 10240;
            String string = LicenseCode.A(inputStream, 10240);
            LicenseCode licenseCode = null;
            if (string != null) {
                licenseCode = LicenseCode.newLicenseKey(string);
            }
            return licenseCode;
        }
        catch (RuntimeException runtimeException) {
            D.warn((Object)"[LicenseCode] ", (Throwable)runtimeException);
            return null;
        }
    }

    public static LicenseCode newLicenseKey(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "#");
            LicenseCode licenseCode = LicenseCode.newLicenseKey(stringTokenizer);
            if (stringTokenizer.hasMoreTokens()) {
                D.warn((Object)"[LicenseCode] Found additional tokens. Key is invalid.");
                return null;
            }
            return licenseCode;
        }
        catch (Exception exception) {
            D.warn((Object)"[LicenseCode] ", (Throwable)exception);
            return null;
        }
    }

    public static LicenseCode newLicenseKey(StringTokenizer stringTokenizer) {
        try {
            String string = stringTokenizer.nextToken();
            if (KEY_TYPE_EVALUATION.equals(string)) {
                return new E(stringTokenizer);
            }
            if (KEY_TYPE_INTERIM.equals(string)) {
                return new F(stringTokenizer);
            }
            if (KEY_TYPE_FINAL.equals(string)) {
                return new C(stringTokenizer);
            }
            if (KEY_TYPE_REGISTRATION.equals(string)) {
                return new D(stringTokenizer);
            }
            if (KEY_TYPE_UPGRADE.equals(string)) {
                return new B(stringTokenizer);
            }
            D.debug((Object)("[LicenseCode] Unknown key type: " + string));
            return null;
        }
        catch (Exception exception) {
            D.debug((Object)"[LicenseCode] ", (Throwable)exception);
            return null;
        }
    }

    public static void saveLicenseKeys(File file, LicenseCode[] licenseCodeArray) throws IOException {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < licenseCodeArray.length; ++i) {
            object = licenseCodeArray[i];
            if (i > 0) {
                stringBuffer.append("|");
            }
            stringBuffer.append(((LicenseCode)object).getKeyValue());
        }
        byte[] byArray = Crypter.get().encrypt(new String(stringBuffer));
        object = new FileOutputStream(file);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream((OutputStream)object);
        bufferedOutputStream.write(byArray);
        bufferedOutputStream.close();
        ((FileOutputStream)object).close();
    }

    public void save(File file) throws IOException {
        String string = this.getKeyValue();
        byte[] byArray = Crypter.get().encrypt(string);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        bufferedOutputStream.write(byArray);
        bufferedOutputStream.close();
        fileOutputStream.close();
    }

    public boolean equals(Object object) {
        if (!(object instanceof LicenseCode)) {
            return false;
        }
        LicenseCode licenseCode = (LicenseCode)object;
        return this.getKeyValue().equals(licenseCode.getKeyValue());
    }

    public int hashCode() {
        return this.getKeyValue().hashCode();
    }

    public boolean supercedes(LicenseCode licenseCode) {
        if (!this.F.equals(licenseCode.getProductName()) || this instanceof D) {
            return false;
        }
        if (!this.isValid() && licenseCode.isValid()) {
            return false;
        }
        if (this.isValid() && !licenseCode.isValid()) {
            return true;
        }
        return (!(licenseCode instanceof C) || this instanceof C) && (!(licenseCode instanceof F) || !(this instanceof E));
    }

    protected LicenseCode() {
    }

    protected LicenseCode(String string, String string2, String string3) {
        this.C = string;
        this.E = string2;
        this.F = string3;
    }

    protected LicenseCode(String string, StringTokenizer stringTokenizer) {
        this.C = string;
        this.E = stringTokenizer.nextToken();
        this.F = stringTokenizer.nextToken();
        this.setTokenString(stringTokenizer);
    }

    public String getProductRelease() {
        return "";
    }

    public String getProductLine() {
        return "";
    }

    public Date getExpirationDate() {
        return null;
    }

    public F getInterimKey() {
        return null;
    }

    public boolean isValidForDate(Date date) {
        return true;
    }

    public boolean isValidForUser(String string, String string2) {
        return true;
    }

    public boolean isValidForMachine(String string, String string2, String string3, String string4) {
        return true;
    }

    public boolean isValidForProduct(String string, String string2, String string3) {
        return !(!this.getProductName().equals(string) || string2 != null && !this.getProductLine().equals(string2) || string3 != null && !this.sameMajorRelease(string3));
    }

    public boolean isValidForApplication(String string, String string2, String string3) {
        if (this.getProductName().startsWith("Poseidon")) {
            return this.getProductLine().equals(string2);
        }
        return LicenseCode.isCompatibleProductLine(string2, this.getProductLine());
    }

    public boolean isVerified() {
        return true;
    }

    public boolean isValid() {
        return this.isValidForCurrentDate() && this.isValidForCurrentMachine() && this.isValidForCurrentUser() && this.isValidForCurrentApplication();
    }

    public boolean isValidForCurrentDate() {
        Date date = new Date();
        return this.isValidForDate(date);
    }

    public boolean isValidForCurrentUser() {
        Customer customer = LicenseKeys.getPoseidonUser();
        String string = customer.getFullName();
        String string2 = customer.getEmail();
        return this.isValidForUser(string, string2);
    }

    public boolean isValidForCurrentMachine() {
        String string = "";
        String string2 = "";
        String string3 = System.getProperty("os.name").toUpperCase();
        String string4 = System.getProperty("os.version");
        try {
            string = Utils.removeDots((String)InetAddress.getLocalHost().getHostName());
            string2 = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            D.error((Object)"[LicenseCode] Cannot resolve local hostname.", (Throwable)unknownHostException);
        }
        return this.isValidForMachine(string, string2, string3, string4);
    }

    public boolean isValidForCurrentProduct() {
        String string = BuildPropertiesBasic.getEditionShort();
        String string2 = Integer.toString(BuildPropertiesBasic.getMajorVersionNumber());
        String string3 = "Poseidon" + string;
        return this.isValidForProduct(string3, string, string2);
    }

    public boolean isValidForCurrentApplication() {
        String string = BuildPropertiesBasic.getEditionShort();
        String string2 = Integer.toString(BuildPropertiesBasic.getMajorVersionNumber());
        String string3 = "Poseidon" + string;
        return this.isValidForApplication(string3, string, string2);
    }

    public static boolean isCompatibleProductLine(String string, String string2) {
        Integer n = (Integer)B.get(string);
        Integer n2 = (Integer)B.get(string2);
        return n != null && n2 != null && n >= n2;
    }

    public boolean sameMajorRelease(String string) {
        return this.getMajorRelease(this.getProductRelease()) == this.getMajorRelease(string);
    }

    public int getMajorRelease(String string) {
        int n = string.indexOf(46);
        String string2 = n >= 0 ? string.substring(0, n) : string;
        int n2 = Integer.parseInt(string2);
        return n2;
    }

    public String getKeyValue() {
        return this.C + "##" + this.E + "##" + this.F + "##" + this.getTokenString();
    }

    public String getKeyType() {
        return this.C;
    }

    public String getLicenseType() {
        return this.E;
    }

    public String getProductName() {
        return this.F;
    }

    public static long getDaysFromDate(Date date) {
        long l = date == null ? 0L : date.getTime() / 86400000L;
        return l;
    }

    public static Date getDateFromDays(long l) {
        long l2 = l * 86400000L;
        Date date = new Date(l2);
        return date;
    }

    private static String A(File file, int n) {
        String string = null;
        try {
            if (!file.exists() || !file.isFile()) {
                return null;
            }
            if (file.length() > (long)n) {
                return null;
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            string = LicenseCode.A(fileInputStream, n);
            fileInputStream.close();
        }
        catch (Exception exception) {
            D.warn((Object)"[LicenseCode] ", (Throwable)exception);
        }
        return string;
    }

    private static String A(InputStream inputStream, int n) {
        String string = null;
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            byte[] byArray = new byte[n];
            int n2 = bufferedInputStream.read(byArray);
            bufferedInputStream.close();
            if (n2 > 0) {
                byte[] byArray2 = new byte[n2];
                System.arraycopy(byArray, 0, byArray2, 0, n2);
                string = Crypter.get().decrypt(byArray2);
            }
        }
        catch (Exception exception) {
            D.warn((Object)"[LicenseCode] ", (Throwable)exception);
        }
        return string;
    }

    static {
        B = CollectionFactory.createHashMap();
        B.put("CE", new Integer(0));
        B.put("SE", new Integer(1));
        B.put("DE", new Integer(2));
        B.put("PE", new Integer(3));
        B.put("EE", new Integer(4));
    }
}

