/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.poseidon.reveng;

import com.gentleware.jboogie.command_framework.MacroCommandImpl;
import com.gentleware.jboogie.kernel.ProjectImpl;
import com.gentleware.jboogie.util.JBoogieUtils;
import com.gentleware.openapi.jboogie.Command;
import com.gentleware.openapi.jboogie.MacroCommand;
import com.gentleware.openapi.jboogie.ProgressDisplayStrategy;
import com.gentleware.openapi.jboogie.SmId;
import com.gentleware.openapi.swingx.Localizer;
import com.gentleware.openapi.swingx.ResourceId;
import com.gentleware.openapi.util.CollectionFactory;
import com.gentleware.openapi.util.Utils;
import com.gentleware.poseidon.jboogie.PoseidonApplicationState;
import com.gentleware.poseidon.kernel.PoseidonProject;
import com.gentleware.poseidon.kernel.settings.CustomConfigurationSettings;
import com.gentleware.poseidon.openapi.PoseidonUIConnector;
import com.gentleware.poseidon.openapi.ProgressDialogStrategy;
import com.gentleware.poseidon.reveng.C;
import com.gentleware.poseidon.reveng.ImportImpl;
import com.gentleware.poseidon.reveng.ImportModeller;
import com.gentleware.poseidon.reveng.ImportStrategy;
import com.gentleware.poseidon.reveng.InterruptedUmlImportException;
import com.gentleware.poseidon.reveng.LanguageImportStrategy;
import com.gentleware.poseidon.reveng.RevengResourceBundle;
import com.gentleware.poseidon.reveng.java.util.ImportedPackage;
import com.gentleware.poseidon.reveng.ui.A;
import com.gentleware.poseidon.reveng.ui.ImportErrorDialog;
import com.gentleware.poseidon.reveng.ui.ImportErrorDialogResourceBundle;
import com.gentleware.poseidon.ui.ProcessImportSettings;
import com.gentleware.poseidon.ui.SettingsDialog;
import com.gentleware.poseidon.ui.SettingsResourceBundle;
import com.gentleware.poseidon.uml.CommandDescriptionsUmlResourceBundle;
import com.gentleware.poseidon.uml.UmlProject;
import com.gentleware.poseidon.uml.ui.DiagramFacade;
import com.gentleware.poseidon.uml.util.ClassifierHistory;
import com.gentleware.swingx.InputBlocker;
import com.gentleware.swingx.ProgressDialog;
import com.gentleware.swingx.SuffixFileFilter;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import org.omg.uml.modelmanagement.Model;

public abstract class LanguageImport
implements ActionListener,
WindowListener,
ProcessImportSettings {
    private static final Logger O = Logger.getLogger("com.gentleware.poseidon.reveng.LanguageImport");
    private ProgressDialog V;
    private List X;
    private MacroCommand W;
    private UmlProject S;
    private Model T;
    private Set M;
    private boolean R = true;
    private boolean C = true;
    private boolean P;
    private boolean E;
    protected ImportModeller _modeller;
    protected ImportStrategy _importStrategy;
    private final C J;
    private static Vector D;
    private Map N = CollectionFactory.createHashMap();
    private Map F = CollectionFactory.createHashMap();
    private Map G = CollectionFactory.createHashMap();
    private List K;
    private Set L = CollectionFactory.createHashSet();
    private Map B = CollectionFactory.createHashMap();
    private Map I = CollectionFactory.createHashMap();
    private Map A = CollectionFactory.createHashMap();
    private File H;
    private String U;
    private StringBuffer Q = new StringBuffer();
    protected final List diagramInterfaces = CollectionFactory.createArrayList();

    public abstract ResourceId getTitleResourceId();

    public abstract ResourceId getTabTitleResourceId();

    public abstract SuffixFileFilter getFileFilter();

    public abstract JComponent getConfigPanel();

    public abstract String getConfigHeader();

    public abstract void processConfigPanel();

    public abstract ImportedPackage getImportedTree();

    public abstract void parseFile(File var1) throws InterruptedUmlImportException;

    public abstract LanguageImportStrategy getNewLanguageImportStrategy();

    protected abstract CustomConfigurationSettings getCustomSettings();

    protected abstract void updateSettingsFromConfiguration();

    protected abstract void updateConfigPanelUI();

    public LanguageImport() {
        this.J = new C(this);
        this.setSimpleImportStrategy();
        this.resetFailedImports();
    }

    public void setSimpleImportStrategy() {
        this.setImportStrategy(this.J);
    }

    public void addFailedImport(String string) {
        this.M.add(string);
    }

    public Set getFailedImports() {
        return this.M;
    }

    public int handleFailedImports() {
        Set set = this.getFailedImports();
        int n = 1;
        if (set != null && !set.isEmpty()) {
            if (ProjectImpl.isGuiMode()) {
                this.hideParseProgressDialog();
                Frame frame = PoseidonUIConnector.getApplicationWindow();
                boolean bl = InputBlocker.isBlocking();
                InputBlocker.blockEvents((boolean)false);
                ImportErrorDialog importErrorDialog = new ImportErrorDialog(frame, set);
                importErrorDialog.show();
                n = importErrorDialog.getResult();
                if (n == 0) {
                    String string = Localizer.localize((ResourceId)ImportErrorDialogResourceBundle.invalidClasspath);
                    SettingsDialog.display((ResourceId)SettingsDialog.PROJECT_SETTINGS_RESOURCE_ID, (ResourceId)SettingsResourceBundle.tab_import, (ResourceId)RevengResourceBundle.JavaJarImport, (Dialog)((Object)importErrorDialog), (String)string, (boolean)true);
                }
                InputBlocker.blockEvents((boolean)bl);
            } else {
                this.A(set);
            }
        }
        return n;
    }

    private void A(Set set) {
        if (set != null && !set.isEmpty()) {
            O.info("Import errors:");
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                O.info(" - " + string);
            }
        }
    }

    public void resetFailedImports() {
        if (this.M == null) {
            this.initFailedImports();
        } else {
            this.M.clear();
        }
    }

    public void initFailedImports() {
        this.M = CollectionFactory.createHashSet();
    }

    public ProgressDialog getParseProgressDialog() {
        return this.V;
    }

    public void setParseProgressDialog(ProgressDialog progressDialog) {
        this.V = progressDialog;
        if (this.V != null) {
            this.V.setTitle(this.getTitle());
            this.V.addActionListener((ActionListener)this);
            this.V.addWindowListener((WindowListener)this);
        }
    }

    protected String getTitle() {
        return Localizer.localize((ResourceId)this.getTitleResourceId());
    }

    public void clearCommand() {
        this.W = null;
    }

    public void hideParseProgressDialog() {
        if (this.V != null) {
            this.V.hideProgressDialog();
        }
    }

    public void showParseProgressDialog(String string, File[] fileArray) {
        if (this.V != null) {
            this.V.showProgressDialog("Parsing " + string, (Component)PoseidonUIConnector.getApplicationWindow(), this.getFileCount(fileArray));
        }
    }

    public void showParseProgressDialog(String string, int n) {
        if (this.V != null) {
            this.V.showProgressDialog("Parsing " + string, (Component)PoseidonUIConnector.getApplicationWindow(), n);
        }
    }

    public void updateParseProgressDialog() {
        try {
            JBoogieUtils.updateProgressDialog((ProgressDialog)this.V);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addImportCommand(Command command) {
        this.getImportCommand().addCommand(command);
    }

    public MacroCommand getImportCommand() {
        if (this.W == null) {
            this.W = this.S.getDiCommandFactory().makeMacroCommand(CommandDescriptionsUmlResourceBundle.ImportJavaFiles);
        }
        return this.W;
    }

    public void executeCommand() {
        this.getProject().getConflictChecker().deactivate();
        MacroCommand macroCommand = this.getImportCommand();
        int n = ((MacroCommandImpl)macroCommand).getCommands().size();
        O.info("Number commands: " + n);
        Frame frame = PoseidonUIConnector.getApplicationWindow();
        boolean bl = Boolean.getBoolean("java.awt.headless") || frame == null;
        ProgressDialog progressDialog = null;
        if (!bl) {
            progressDialog = new ProgressDialog(frame, RevengResourceBundle.NoText, false);
            progressDialog.setTitle(this.getTitle());
            progressDialog.initDialog(RevengResourceBundle.CreateUmlModel, 0);
            this.W.setProgressDisplayStrategy((ProgressDisplayStrategy)new ProgressDialogStrategy(progressDialog));
        }
        macroCommand.execute();
        if (!this.S.getUndoManager().hasExcecutedLastCommandWithoutProblems() && !bl) {
            progressDialog.hideProgressDialog();
        }
        this.getProject().getConflictChecker().activate();
    }

    public boolean parseImportFiles(String string, File[] fileArray) throws InterruptedUmlImportException {
        this.resetErrorMessages();
        boolean bl = false;
        try {
            this.startParsing(string, fileArray);
            this.doTheImport(fileArray);
            bl = true;
            this.endParsing();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.reset();
            this.endParsing();
            Runtime.getRuntime().gc();
            O.error("<html>The system ran out of memory while parsing the import files!<BR> Please save your project immediately and restart Poseidon after you have increased the memory available to Poseidon (see the FAQ).</html>");
            Frame frame = PoseidonUIConnector.getApplicationWindow();
            boolean bl2 = InputBlocker.isBlocking();
            InputBlocker.blockEvents((boolean)false);
            JBoogieUtils.showMessageDialog((Component)frame, (Object)Localizer.localize((ResourceId)CommandDescriptionsUmlResourceBundle.ImportOutOfMemory));
            InputBlocker.blockEvents((boolean)bl2);
        }
        this.handleParserErrors();
        return bl;
    }

    public void handleParserErrors() throws InterruptedUmlImportException {
        boolean bl;
        String string = this.getErrorMessages();
        boolean bl2 = bl = ProjectImpl.isGuiMode() && !"".equals(string);
        if (bl) {
            this.hideParseProgressDialog();
            Frame frame = PoseidonUIConnector.getApplicationWindow();
            A a = new A(frame, string);
            boolean bl3 = InputBlocker.isBlocking();
            InputBlocker.blockEvents((boolean)false);
            a.show();
            int n = a.D();
            InputBlocker.blockEvents((boolean)bl3);
            if (n == 0) {
                throw new InterruptedUmlImportException("Parse errors - Cancel Import!");
            }
        } else {
            O.info(string);
        }
    }

    public void startParsing(String string, File[] fileArray) {
        this.showParseProgressDialog(string, fileArray);
    }

    public void startParsing(String string, int n) {
        this.showParseProgressDialog(string, n);
    }

    public void endParsing() {
        this.hideParseProgressDialog();
    }

    public void setExcludedDirectoryNames(List list) {
        this.X = list;
    }

    public List getExcludedDirectoryNames() {
        return this.X;
    }

    public void setProject(UmlProject umlProject) {
        this.S = umlProject;
    }

    public void updateProject(PoseidonProject poseidonProject) {
        this.S = (UmlProject)poseidonProject;
        this.T = (Model)this.S.getFirstModel();
    }

    public void setModel(Model model) {
        this.T = model;
    }

    public void addDiagramInterface(DiagramFacade diagramFacade) {
        this.diagramInterfaces.add(diagramFacade);
    }

    public void clearDiagramInterfaces() {
        this.diagramInterfaces.clear();
    }

    public List getDiagramInterfaces() {
        return this.diagramInterfaces;
    }

    public boolean needsSave() {
        for (int i = 0; i < this.diagramInterfaces.size(); ++i) {
            DiagramFacade diagramFacade = (DiagramFacade)this.diagramInterfaces.get(i);
            if (diagramFacade.getModifiedDiagrams().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public void cleanup() {
        for (int i = 0; i < this.diagramInterfaces.size(); ++i) {
            DiagramFacade diagramFacade = (DiagramFacade)this.diagramInterfaces.get(i);
            diagramFacade.cleanup();
        }
    }

    public int getFileCount(File[] fileArray) {
        int n = 0;
        for (int i = 0; i < fileArray.length; ++i) {
            n += Utils.getFileCount((File)fileArray[i]);
        }
        O.info("Number Files: " + n);
        return n;
    }

    public void doTheImport(File[] fileArray) throws InterruptedUmlImportException {
    }

    public void doTheImport(List list, List list2, List list3) throws InterruptedUmlImportException {
    }

    public UmlProject getProject() {
        if (this.S == null) {
            PoseidonApplicationState poseidonApplicationState = PoseidonApplicationState.getInstance();
            PoseidonProject poseidonProject = poseidonApplicationState.getCurrentProject();
            this.S = (UmlProject)poseidonProject;
        }
        return this.S;
    }

    public Model getModel() {
        return this.T;
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void setInterrupted(boolean bl) {
        this.P = bl;
    }

    public boolean isInterrupted() {
        return this.P;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.P = true;
        PoseidonUIConnector.showStatus((String)Localizer.localize((ResourceId)RevengResourceBundle.StoppingImport));
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.P = true;
        PoseidonUIConnector.showStatus((String)Localizer.localize((ResourceId)RevengResourceBundle.StoppingImport));
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void setDescendRecursively(boolean bl) {
        this.E = bl;
    }

    public boolean isDescendRecursively() {
        return this.E;
    }

    public void doFile(File[] fileArray, boolean bl) throws InterruptedUmlImportException {
        if (fileArray == null) {
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            if (this.isInterrupted()) {
                return;
            }
            File file = fileArray[i];
            if (file.isDirectory()) {
                if (ImportImpl.isExcludedDir(file.getName().toUpperCase())) continue;
                this.doDirectory(file, bl);
                continue;
            }
            if (!this.getFileFilter().accept(file)) continue;
            if (bl) {
                this.setCurrentlyImportedFile(file);
            }
            this.parseFile(file);
        }
    }

    public void doDirectory(File file, boolean bl) throws InterruptedUmlImportException {
        if (ImportImpl.isExcludedDir(file.getName())) {
            return;
        }
        String[] stringArray = file.list();
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(file, stringArray[i]);
            if (file2.isDirectory() && this.isDescendRecursively()) {
                this.doDirectory(file2, bl);
                continue;
            }
            if (!this.getFileFilter().accept(file2)) continue;
            if (bl) {
                this.setCurrentlyImportedFile(file2);
            }
            this.parseFile(file2);
        }
    }

    public void resetModeller() {
        if (this._modeller != null) {
            this._modeller.resetImportedTree();
        }
    }

    public void reset() {
        this.resetModeller();
        this.clearCommand();
        this.resetFailedImports();
        this.setInterrupted(false);
        this.N.clear();
        this.F.clear();
        this.K = null;
        this.G.clear();
        this.resetDeletedClassiferSet();
    }

    public void resetDeletedClassiferSet() {
        this.L.clear();
    }

    public void setAltClassLoader() {
    }

    public ImportModeller getModeller() {
        return this._modeller;
    }

    public void setModeller(ImportModeller importModeller) {
        this._modeller = importModeller;
    }

    public boolean isModelAsAttributeSelected() {
        return false;
    }

    public boolean isDatatypeSelected() {
        return true;
    }

    public ImportStrategy getImportStrategy() {
        return this._importStrategy;
    }

    public void setImportStrategy(ImportStrategy importStrategy) {
        this._importStrategy = importStrategy;
    }

    public boolean isInRoundtrip() {
        return !(this._importStrategy instanceof C);
    }

    protected static void fireImportEnd(List list) {
        if (D == null || D.size() == 0) {
            return;
        }
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(list, "Imported", null, null);
        Iterator iterator = D.iterator();
        while (iterator.hasNext()) {
            try {
                ((VetoableChangeListener)iterator.next()).vetoableChange(propertyChangeEvent);
            }
            catch (PropertyVetoException propertyVetoException) {
                propertyVetoException.printStackTrace();
            }
        }
    }

    public static void addImportEndListener(VetoableChangeListener vetoableChangeListener) {
        if (D == null) {
            D = new Vector();
        }
        D.add(vetoableChangeListener);
    }

    public static void removeImportEndListener(VetoableChangeListener vetoableChangeListener) {
        if (D != null) {
            D.remove(vetoableChangeListener);
        }
    }

    public static void clearImportEndListeners() {
        D.removeAllElements();
        D = null;
    }

    public void turnOnRoundtripQuestion() {
    }

    public void updateClassifierHistory(PoseidonProject poseidonProject) {
        List list = CollectionFactory.createArrayList((Collection)this.getImportedClassifierSmIds());
        ClassifierHistory classifierHistory = ((UmlProject)poseidonProject).getClassifierHistory();
        classifierHistory.postImport(list, CollectionFactory.createArrayList((Collection)this.getDeletedClassifierSmIds()));
    }

    public void addImportedClassifierSmId(SmId smId, String string) {
        File file = this.getCurrentlyImportedFile();
        if (file != null) {
            String string2 = file.getAbsolutePath();
            this.N.put(smId, string2);
            this.K.add(smId);
        }
        if (string != null) {
            this.F.put(smId, string);
        }
    }

    public void addDeletedClassifierSmId(SmId smId) {
        this.L.add(smId);
    }

    public Set getDeletedClassifierSmIds() {
        return this.L;
    }

    public void addDeletedClassifierSmIds(Collection collection) {
        this.L.addAll(collection);
    }

    public Map getDeletedInModelChangedInSourcecodeConflict() {
        return this.B;
    }

    public void setDeletedInModelChangedInSourcecodeConflict(Map map) {
        this.B = map;
    }

    public Map getChangedInModelChangedInSourcecodeConflict() {
        return this.I;
    }

    public void setChangedInModelChangedInSourcecodeConflict(Map map) {
        this.I = map;
    }

    public Map getChangedInModelDeletedInSourcecodeConflict() {
        return this.A;
    }

    public void setChangedInModelDeletedInSourcecodeConflict(Map map) {
        this.A = map;
    }

    public Set getImportedClassifierSmIds() {
        return this.N.keySet();
    }

    public Map getFileToClassifierSmIdsMap() {
        return this.G;
    }

    public Map getImportedClassifierSmIdsMap() {
        return this.N;
    }

    public Map getImportedClassifierSmIdXmiIdMap() {
        return this.F;
    }

    public File getCurrentlyImportedFile() {
        return this.H;
    }

    public void setCurrentlyImportedFile(File file) {
        this.H = file;
        this.K = CollectionFactory.createArrayList();
        this.G.put(file, this.K);
    }

    public String getCurrentlyImportedFileName() {
        return this.U;
    }

    public void setCurrentlyImportedFileName(String string) {
        this.U = string;
    }

    public boolean isAskWetherDeleteClassifier() {
        return this.R;
    }

    public void setAskWetherDeleteClassifier(boolean bl) {
        this.R = bl;
    }

    public boolean isExecuteCommandAndResetSettings() {
        return this.C;
    }

    public void setExecuteCommandAndResetSettings(boolean bl) {
        this.C = bl;
    }

    public void appendErrorMessage(String string) {
        boolean bl;
        if ("".equals(string)) {
            return;
        }
        boolean bl2 = bl = this.getImportStrategy().getPass() == 0;
        if (bl) {
            this.Q.append("Parse errors in file:");
            File file = this.getCurrentlyImportedFile();
            if (file != null) {
                this.Q.append(file.getAbsolutePath());
            } else {
                this.Q.append(this.getCurrentlyImportedFileName());
            }
            this.Q.append("\n");
            this.Q.append(string);
            this.Q.append("\n");
        }
    }

    public String getErrorMessages() {
        return this.Q.toString();
    }

    public void resetErrorMessages() {
        this.Q = new StringBuffer();
    }

    public void saveSettingsAsDefault() {
        this.processConfigPanel();
        this.getCustomSettings().saveAsDefault();
    }

    public void resetSettingsToDefaults() {
        this.getCustomSettings().resetToDefaults();
        this.updateSettingsFromConfiguration();
        this.updateConfigPanelUI();
    }

    public JPanel getSourcesListPanel(JFileChooser jFileChooser) {
        return null;
    }

    public Enumeration getSourceFileNames() {
        return null;
    }

    public int getNumberSourceFiles() {
        return 0;
    }

    public void clearSourceFileList() {
    }
}

