/*
 * Decompiled with CFR 0.152.
 */
package foxtrot;

import foxtrot.Job;
import foxtrot.Task;
import foxtrot.Worker;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.swing.SwingUtilities;

public class Worker {
    private static Link m_current;
    private static Thread m_thread;
    private static Object m_lock;
    private static EventQueue m_queue;
    private static final boolean m_debug = false;

    private Worker() {
    }

    public static Object post(Task task) throws Exception {
        boolean isEventThread = SwingUtilities.isEventDispatchThread();
        if (!isEventThread && !Worker.isWorkerThread()) {
            throw new IllegalStateException("This method can be called only from the AWT Event Dispatch Thread or from the another Task");
        }
        if (isEventThread) {
            if (!m_thread.isAlive()) {
                Worker.start();
            }
            Worker.addTask(task);
            EventPump pump = new EventPump(task);
            pump.pumpEvents();
        } else {
            Worker.runTask(task);
        }
        return task.getResultOrThrow();
    }

    public static Object post(Job job) {
        try {
            return Worker.post((Task)job);
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw new UndeclaredThrowableException(x);
        }
        catch (Error x) {
            throw x;
        }
    }

    private static void addTask(Task t) {
        Object object = m_lock;
        synchronized (object) {
            if (Worker.hasTasks()) {
                Link item = m_current;
                while (item.m_next != null) {
                    item = item.m_next;
                }
                item.m_next = new Link(t);
            } else {
                m_current = new Link(t);
                m_lock.notifyAll();
            }
        }
    }

    private static Task getTask() throws InterruptedException {
        Object object = m_lock;
        synchronized (object) {
            Task t;
            while (!Worker.hasTasks()) {
                m_lock.wait();
            }
            Task task = t = m_current.m_task;
            return task;
        }
    }

    private static void removeTask() {
        Object object = m_lock;
        synchronized (object) {
            m_current = m_current.m_next;
        }
    }

    private static boolean hasTasks() {
        Object object = m_lock;
        synchronized (object) {
            boolean bl = m_current != null;
            return bl;
        }
    }

    private static void start() {
        m_thread = new Thread((Runnable)new Runner(), "Foxtrot Worker Thread");
        m_thread.setDaemon(true);
        m_thread.start();
    }

    private static void stop() {
        m_thread.interrupt();
    }

    private static boolean isWorkerThread() {
        return Thread.currentThread() == m_thread;
    }

    private static void runTask(final Task task) {
        block5: {
            try {
                try {
                    Object obj = AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            return task.run();
                        }
                    }, task.getSecurityContext());
                    task.setResult(obj);
                }
                catch (PrivilegedActionException x) {
                    task.setThrowable(x.getException());
                    Object var4_4 = null;
                    task.completed();
                    break block5;
                }
                catch (Throwable x) {
                    task.setThrowable(x);
                    Object var4_5 = null;
                    task.completed();
                }
                Object var4_3 = null;
                task.completed();
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                task.completed();
                throw throwable;
            }
        }
    }

    static {
        m_lock = new Object();
        m_queue = (EventQueue)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Toolkit.getDefaultToolkit().getSystemEventQueue();
            }
        });
        new EventPump(null).pumpEvents();
        Worker.start();
    }

    private static class Link {
        private Link m_next;
        private Task m_task;

        private Link(Task t) {
            this.m_task = t;
        }
    }

    private static class Runner
    implements Runnable {
        private static Runnable EMPTY_EVENT = new Runnable(){

            public final void run() {
            }
        };

        private Runner() {
        }

        public void run() {
            while (!m_thread.isInterrupted()) {
                try {
                    Task t = Worker.getTask();
                    Worker.runTask(t);
                    Worker.removeTask();
                    SwingUtilities.invokeLater(EMPTY_EVENT);
                }
                catch (InterruptedException x) {
                    break;
                }
            }
        }
    }

    public static class AWTThrowableHandler {
        public void handle(Throwable t) {
            System.err.println("Foxtrot - Exception occurred during event dispatching:");
            t.printStackTrace();
        }
    }

    private static class FoxtrotConditional
    implements InvocationHandler {
        private Task m_task;

        private FoxtrotConditional(Task task) {
            this.m_task = task;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String name = method.getName();
            if ("evaluate".equals(name)) {
                return this.m_task.isCompleted() ? Boolean.FALSE : Boolean.TRUE;
            }
            throw new Error("Unknown java.awt.Conditional method: " + name);
        }
    }

    private static class EventPump {
        private static Method m_pumpMethod;
        private static Class m_conditionalClass;
        private Task m_task;

        private EventPump(Task t) {
            this.m_task = t;
        }

        private void pumpEvents() {
            if (this.m_task == null) {
                return;
            }
            try {
                try {
                    Object conditional = Proxy.newProxyInstance(m_conditionalClass.getClassLoader(), new Class[]{m_conditionalClass}, (InvocationHandler)new FoxtrotConditional(this.m_task));
                    m_pumpMethod.invoke((Object)Thread.currentThread(), conditional);
                }
                catch (InvocationTargetException x) {
                    Throwable t = x.getTargetException();
                    System.err.println("Foxtrot - Exception occurred during event dispatching:");
                    t.printStackTrace();
                    System.err.println("Foxtrot - WARNING: uncaught exception during event dispatching, Task is still running !");
                    if (t instanceof RuntimeException) {
                        throw (RuntimeException)t;
                    }
                    throw (Error)t;
                }
                catch (Throwable x) {
                    x.printStackTrace();
                    System.err.println("Foxtrot - WARNING: uncaught exception in Foxtrot code, Task is still running !");
                    Object var4_4 = null;
                }
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                throw throwable;
            }
        }

        static /* synthetic */ Class access$602(Class x0) {
            m_conditionalClass = x0;
            return m_conditionalClass;
        }

        static /* synthetic */ Method access$702(Method x0) {
            m_pumpMethod = x0;
            return m_pumpMethod;
        }

        static /* synthetic */ Class access$600() {
            return m_conditionalClass;
        }

        static /* synthetic */ Method access$700() {
            return m_pumpMethod;
        }

        static {
            try {
                String property = "sun.awt.exception.handler";
                AccessController.doPrivileged(new PrivilegedExceptionAction(){
                    static /* synthetic */ Class class$foxtrot$Worker$AWTThrowableHandler;

                    public Object run() throws ClassNotFoundException, NoSuchMethodException {
                        ClassLoader classloader = ClassLoader.getSystemClassLoader();
                        Class<?> dispatchThreadClass = classloader.loadClass("java.awt.EventDispatchThread");
                        EventPump.access$602(classloader.loadClass("java.awt.Conditional"));
                        EventPump.access$702(dispatchThreadClass.getDeclaredMethod("pumpEvents", EventPump.access$600()));
                        ((AccessibleObject)EventPump.access$700()).setAccessible(true);
                        String handler = System.getProperty("sun.awt.exception.handler");
                        if (handler == null) {
                            System.setProperty("sun.awt.exception.handler", (class$foxtrot$Worker$AWTThrowableHandler == null ? (class$foxtrot$Worker$AWTThrowableHandler = 3.class$("foxtrot.Worker$AWTThrowableHandler")) : class$foxtrot$Worker$AWTThrowableHandler).getName());
                        }
                        return null;
                    }

                    static /* synthetic */ Class class$(String x0) {
                        try {
                            return Class.forName(x0);
                        }
                        catch (ClassNotFoundException x1) {
                            throw new NoClassDefFoundError(x1.getMessage());
                        }
                    }
                });
            }
            catch (PrivilegedActionException x) {
                x.getException().printStackTrace();
            }
            catch (RuntimeException x) {
                throw x;
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }
}

