/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.mdr.trovememoryimpl;

import com.gentleware.mdr.trovememoryimpl.Utils;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.decorator.TIntHashSetDecorator;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.netbeans.mdr.persistence.Index;
import org.netbeans.mdr.persistence.MultivaluedIndex;
import org.netbeans.mdr.persistence.SinglevaluedIndex;
import org.netbeans.mdr.persistence.Storage;
import org.netbeans.mdr.persistence.StorageBadRequestException;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.memoryimpl.MIWrapper;
import org.netbeans.mdr.persistence.memoryimpl.MOWrapper;
import org.netbeans.mdr.persistence.memoryimpl.MultivalueLog;
import org.netbeans.mdr.persistence.memoryimpl.MultivaluedIndexImpl;
import org.netbeans.mdr.persistence.memoryimpl.Transactionable;
import org.netbeans.mdr.util.AbstractCollectionFactory;

public class IntegerMultivaluedIndexImpl
implements MultivaluedIndex,
Transactionable {
    private TIntObjectHashMap _entries;
    protected boolean _unique;
    private String _name;
    private Storage.EntryType _valueType;
    protected MultivalueLog transLog = new MultivalueLog();

    public IntegerMultivaluedIndexImpl(String name, Storage.EntryType valueType, boolean unique) {
        this._entries = new TIntObjectHashMap();
        this._unique = unique;
        this._name = name;
        this._valueType = valueType;
    }

    public Collection getItems(Object key) throws StorageException {
        Collection items = this.getItemsInternal(key);
        return new MIWrapper((MultivaluedIndex)this, (List)items, key, this.transLog);
    }

    protected Collection getItemsInternal(Object key) {
        Collection items;
        int keyAsInt = Utils.getKeyAsInt(key);
        if (this._entries.containsKey(keyAsInt)) {
            items = (Collection)this._entries.get(keyAsInt);
        } else {
            items = AbstractCollectionFactory.getCollectionFactory().createArrayList();
            this._entries.put(keyAsInt, (Object)items);
        }
        return items;
    }

    public Collection getObjects(Object key, SinglevaluedIndex singlevaluedIndex) throws StorageException {
        return new MOWrapper((MultivaluedIndex)this, (List)this.getItems(key), singlevaluedIndex, key);
    }

    public boolean isUnique() throws StorageException {
        return this._unique;
    }

    public boolean remove(Object key, Object value) throws StorageException {
        Collection items = this.getItemsInternal(key);
        boolean removed = items.remove(value);
        if (removed) {
            this.transLog.logRemove(key, value);
        }
        return removed;
    }

    public Collection queryByKeyPrefix(Object o, SinglevaluedIndex singlevaluedIndex) throws StorageException {
        return null;
    }

    public String getName() throws StorageException {
        return this._name;
    }

    public Storage.EntryType getValueType() throws StorageException {
        return this._valueType;
    }

    public Storage.EntryType getKeyType() throws StorageException {
        return Storage.EntryType.MOFID;
    }

    public Set keySet() throws StorageException {
        TIntHashSet keySet = new TIntHashSet(this._entries.keys());
        return new TIntHashSetDecorator(keySet);
    }

    public void add(Object key, Object value) throws StorageException {
        Collection items = this.getItemsInternal(key);
        if (this._unique && items.contains(value)) {
            throw MultivaluedIndexImpl.createValueAlreadyContainedExc((Object)key, (Object)value);
        }
        items.add(value);
        this.transLog.logAdd(key, value);
    }

    public boolean remove(Object key) throws StorageException {
        boolean removed;
        int keyAsInt = Utils.getKeyAsInt(key);
        Object oldValue = this._entries.remove(keyAsInt);
        boolean bl = removed = oldValue != null;
        if (removed) {
            this.transLog.logRemoveKey(key, oldValue);
        }
        return removed;
    }

    public void dispose() {
    }

    protected StorageBadRequestException createValueAlreadyContainedExc(Object key, Object value) {
        return new StorageBadRequestException("Unique index already contains value " + value + " for key " + key);
    }

    public void setKey(Object key, Object vals) {
        int keyAsInt = Utils.getKeyAsInt(key);
        this._entries.put(keyAsInt, vals);
    }

    public Collection addNewRecord(Object key) {
        return null;
    }

    public final synchronized void rollBackChanges() throws StorageException {
        this.transLog.rollBack((Index)this);
        this.transLog.clear();
    }

    public final synchronized void commitChanges() throws StorageException {
        this.transLog.clear();
    }
}

