/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.mdr.trovememoryimpl;

import com.gentleware.mdr.trovememoryimpl.Utils;
import gnu.trove.TIntObjectHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.netbeans.mdr.persistence.Index;
import org.netbeans.mdr.persistence.SinglevaluedIndex;
import org.netbeans.mdr.persistence.Storage;
import org.netbeans.mdr.persistence.StorageBadRequestException;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.memoryimpl.TransactionSingleValueLog;
import org.netbeans.mdr.persistence.memoryimpl.Transactionable;

public class IntegerSinglevaluedIndexImpl
implements SinglevaluedIndex,
Transactionable {
    private TIntObjectHashMap _entries;
    private String _name;
    private Storage.EntryType _valueType;
    protected TransactionSingleValueLog _transSingleValueLog = new TransactionSingleValueLog();

    public IntegerSinglevaluedIndexImpl(String name, Storage.EntryType valueType) {
        this._entries = new TIntObjectHashMap();
        this._name = name;
        this._valueType = valueType;
    }

    public boolean put(Object key, Object value) throws StorageException {
        if (key instanceof Integer) {
            int keyAsInt = Utils.getKeyAsInt(key);
            Object old = this._entries.put(keyAsInt, value);
            if (old == null) {
                this._transSingleValueLog.logAdd(key);
                return false;
            }
            this._transSingleValueLog.logReplace(key, old);
            return true;
        }
        return false;
    }

    public void replace(Object key, Object value) throws StorageException, StorageBadRequestException {
        int keyAsInt = Utils.getKeyAsInt(key);
        Object oldValue = this._entries.put(keyAsInt, value);
        this._transSingleValueLog.logReplace(key, oldValue);
    }

    public Object get(Object key) throws StorageException, StorageBadRequestException {
        int keyAsInt = Utils.getKeyAsInt(key);
        Object value = this._entries.get(keyAsInt);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(Object key, SinglevaluedIndex repos) throws StorageException {
        SinglevaluedIndex singlevaluedIndex = repos;
        synchronized (singlevaluedIndex) {
            return repos.get(this.get(key));
        }
    }

    public Object getIfExists(Object key) throws StorageException {
        int keyAsInt = Utils.getKeyAsInt(key);
        Object value = this._entries.get(keyAsInt);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObjectIfExists(Object key, SinglevaluedIndex repos) throws StorageException {
        SinglevaluedIndex singlevaluedIndex = repos;
        synchronized (singlevaluedIndex) {
            return repos.get(this.getIfExists(key));
        }
    }

    public Collection values() throws StorageException {
        List<Object> values = Arrays.asList(this._entries.getValues());
        return values;
    }

    public Collection queryByKeyPrefix(Object o, SinglevaluedIndex singlevaluedIndex) throws StorageException {
        return null;
    }

    public String getName() throws StorageException {
        return this._name;
    }

    public Storage.EntryType getValueType() throws StorageException {
        return this._valueType;
    }

    public Storage.EntryType getKeyType() throws StorageException {
        return Storage.EntryType.INT;
    }

    public Set keySet() throws StorageException {
        return null;
    }

    public void add(Object key, Object value) throws StorageException {
        int keyAsInt = Utils.getKeyAsInt(key);
        Object oldValue = this._entries.put(keyAsInt, value);
        this._transSingleValueLog.logAdd(key);
    }

    public boolean remove(Object key) throws StorageException {
        boolean removedValue;
        int keyAsInt = Utils.getKeyAsInt(key);
        Object oldValue = this._entries.remove(keyAsInt);
        boolean bl = removedValue = oldValue != null;
        if (removedValue) {
            this._transSingleValueLog.logRemove(key, oldValue);
        }
        return removedValue;
    }

    public void dispose() {
    }

    public final synchronized void rollBackChanges() throws StorageException {
        this._transSingleValueLog.rollBack((Index)this);
        this._transSingleValueLog.clear();
    }

    public final synchronized void commitChanges() throws StorageException {
        this._transSingleValueLog.clear();
    }
}

