/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.mdr.trovememoryimpl;

import com.gentleware.mdr.storagemodel.TransactionLogSwitcher;
import com.gentleware.mdr.trovememoryimpl.MOFIDSinglevaluedIndexImpl;
import com.gentleware.mdr.trovememoryimpl.NullPrimaryIndexLogStrategyImpl;
import com.gentleware.mdr.trovememoryimpl.PrimaryIndexLogStrategy;
import com.gentleware.mdr.trovememoryimpl.PrimaryIndexLogStrategyImpl;
import com.gentleware.mdr.trovememoryimpl.Utils;
import gnu.trove.TLongObjectHashMap;
import gnu.trove.TLongObjectIterator;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.persistence.Storage;
import org.netbeans.mdr.persistence.StorageBadRequestException;
import org.netbeans.mdr.persistence.StorageClient;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.StorageIOException;
import org.netbeans.mdr.persistence.StoragePersistentDataException;
import org.netbeans.mdr.persistence.Streamable;
import org.netbeans.mdr.persistence.memoryimpl.IndexStorageCreator;
import org.netbeans.mdr.persistence.memoryimpl.PrimaryIndex;
import org.netbeans.mdr.storagemodel.StorableBaseObject;
import org.netbeans.mdr.util.IOUtils;
import org.netbeans.mdr.util.Logger;

public class MOFIDPrimaryIndexImpl
extends MOFIDSinglevaluedIndexImpl
implements PrimaryIndex {
    private Storage _storage;
    private PropertyChangeListener _strategyLogChangerListener;

    public MOFIDPrimaryIndexImpl(IndexStorageCreator indexStorageCreator, Storage storage) {
        super(indexStorageCreator.getStorageName(), Storage.EntryType.STREAMABLE);
        this._storage = storage;
        this._strategyLogChangerListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                MOFIDPrimaryIndexImpl.this.assignIndexLogStrategy(Boolean.TRUE.equals(evt.getNewValue()));
            }
        };
        TransactionLogSwitcher.addPropertyChangeListener(this._strategyLogChangerListener);
        this.assignIndexLogStrategy(TransactionLogSwitcher.isNullStrategy());
    }

    protected void assignIndexLogStrategy(boolean transactionLogStrategyIsNull) {
        this._indexLogStrategy = transactionLogStrategyIsNull ? new NullPrimaryIndexLogStrategyImpl(this) : new PrimaryIndexLogStrategyImpl(this, this._storage);
    }

    public synchronized boolean put(Object key, Object value) throws StorageException {
        if (key instanceof MOFID) {
            long serialNumber = Utils.getSerialNumber(key);
            Object old = this._entries.put(serialNumber, value);
            this._mofIds.put(serialNumber, key);
            this._indexLogStrategy.putLog(old, key);
            return old != null;
        }
        return false;
    }

    public synchronized void replace(Object key, Object value) throws StorageException, StorageBadRequestException {
        long serialNumber = Utils.getSerialNumber(key);
        Object oldValue = this._entries.put(serialNumber, value);
        if (oldValue == null) {
            this._entries.remove(serialNumber);
            this._mofIds.remove(serialNumber);
            throw new StorageBadRequestException("Cannot replace item that does not exist in the index.");
        }
        ((PrimaryIndexLogStrategy)this._indexLogStrategy).replaceLog(oldValue, serialNumber, key);
    }

    public synchronized void willChange(Object key) throws StorageException {
        long serialNumber = Utils.getSerialNumber(key);
        ((PrimaryIndexLogStrategy)this._indexLogStrategy).willChange(key, this._entries, serialNumber);
    }

    public void changed(Object key) {
    }

    public void write(OutputStream out) throws StorageException {
        try {
            IOUtils.writeInt((OutputStream)out, (int)this._entries.size());
            TLongObjectIterator it = this._entries.iterator();
            while (it.hasNext()) {
                it.advance();
                this._storage.writeMOFID(out, (MOFID)this._mofIds.get(it.key()));
                Streamable value = (Streamable)it.value();
                IOUtils.writeString((OutputStream)out, (String)value.getClass().getName());
                value.write(out);
            }
        }
        catch (IOException e) {
            throw new StorageIOException(e);
        }
    }

    public void read(InputStream is) throws StorageException {
        try {
            int size = IOUtils.readInt((InputStream)is);
            this._entries = new TLongObjectHashMap(size * 4 / 3);
            this._mofIds = new TLongObjectHashMap(size * 4 / 3);
            for (int i = 0; i < size; ++i) {
                MOFID key = this._storage.readMOFID(is);
                Streamable value = (Streamable)Class.forName(IOUtils.readString((InputStream)is)).newInstance();
                if (value instanceof StorageClient) {
                    ((StorageClient)value).setStorage(this._storage);
                }
                value.read(is);
                long serialNumber = Utils.getSerialNumber(key);
                this._entries.put(serialNumber, (Object)value);
                key.setObject((StorableBaseObject)value);
                this._mofIds.put(serialNumber, (Object)key);
            }
        }
        catch (IOException e) {
            throw new StorageIOException(e);
        }
        catch (Exception e) {
            throw (StorageException)Logger.getDefault().annotate((Throwable)new StoragePersistentDataException(), (Throwable)e);
        }
    }

    public void dispose() {
        TransactionLogSwitcher.removePropertyChangeListener(this._strategyLogChangerListener);
    }
}

