/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.locksmith.kernel;

import com.gentleware.anvil.kernel.KeyManagerImpl;
import com.gentleware.anvil.kernel.ProductEditionImpl;
import com.gentleware.anvil.kernel.ProductImpl;
import com.gentleware.anvil.kernel.keymodel.KeyType;
import com.gentleware.anvil.kernel.keymodel.LicenseKey;
import com.gentleware.anvil.kernel.utils.LicenseCipher;
import com.gentleware.anvil.kernel.utils.LicenseCipherClient;
import com.gentleware.anvil.kernel.utils.LicenseException;
import com.gentleware.locksmith.client.LicenseKeys;
import com.gentleware.openapi.util.Files;
import com.gentleware.openapi.util.Strings;
import com.gentleware.openapi.util.Utils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public final class PoseidonKeyManager
extends KeyManagerImpl {
    private static final Logger D = Logger.getLogger((String)"com.gentleware.locksmith.kernel.PoseidonKeyManager");
    private static PoseidonKeyManager C;
    public ProductImpl _poseidonProduct;
    public boolean _ceProduct;

    public PoseidonKeyManager(String string, String string2, ProductImpl productImpl) throws LicenseException {
        super(string, (LicenseCipher)LicenseCipherClient.getInstance());
        this._poseidonProduct = productImpl;
        this._ceProduct = ProductEditionImpl.CE.equals((Object)this._poseidonProduct.getEdition());
        File file = new File(string, this.getLicenseKeyRingFileName());
        this.B(file, true);
        File file2 = new File(string2, this.getLicenseKeyRingFileName());
        this.B(file2, false);
        try {
            this.B();
        }
        catch (LicenseException licenseException) {
            D.error((Object)licenseException);
        }
    }

    private void B(File file, boolean bl) {
        try {
            LicenseKey[] licenseKeyArray = PoseidonKeyManager.readKeyRing((LicenseCipher)this._licenseCipher, (File)file);
            D.info((Object)("Read license-keys from: " + file.getAbsolutePath()));
            this.B(licenseKeyArray, false, false, bl);
        }
        catch (Exception exception) {
            D.error((Object)("Unable to add keys contained in: " + file.getAbsolutePath()), (Throwable)exception);
        }
    }

    public static synchronized PoseidonKeyManager get(String string, ProductImpl productImpl) throws LicenseException {
        if (C == null) {
            C = new PoseidonKeyManager(string, string, productImpl);
        }
        return C;
    }

    public static PoseidonKeyManager get(String string, String string2, ProductImpl productImpl) throws LicenseException {
        if (C == null) {
            C = new PoseidonKeyManager(string, string2, productImpl);
        }
        return C;
    }

    public static void setInstance_TEST_ONLY(PoseidonKeyManager poseidonKeyManager) {
        C = poseidonKeyManager;
    }

    private void B() throws LicenseException {
        if (this._ceProduct) {
            try {
                this.restoreCeKey();
            }
            catch (IOException iOException) {
                D.error((Object)iOException);
            }
        }
    }

    public void restoreCeKey() throws IOException, LicenseException {
        URL uRL = ((Object)((Object)this)).getClass().getResource("/license-keys.txt");
        if (uRL != null) {
            if (this.hasExpiredFinalKey()) {
                return;
            }
            D.info((Object)("key file is " + uRL + "."));
            String string = Files.readStringFromUrl((URL)uRL, (int)32000);
            List list = PoseidonKeyManager.tokenizeKeyStringToKeys((LicenseCipher)this._licenseCipher, (String)string);
            LicenseKey[] licenseKeyArray = list.toArray(new LicenseKey[list.size()]);
            this.B(licenseKeyArray, false, false);
        }
    }

    public boolean addKeyImpl_TEST_ONLY(LicenseKey licenseKey, boolean bl, boolean bl2) {
        return this.addKeyImpl(licenseKey, bl, bl2, false);
    }

    boolean addKeyImpl(LicenseKey licenseKey, boolean bl, boolean bl2, boolean bl3) {
        KeyType keyType;
        LicenseKey licenseKey2;
        if (Strings.isEmpty((String)licenseKey.getRsaAscii())) {
            return false;
        }
        if (!bl2 && (licenseKey2 = this.D(this._keys, licenseKey, bl3)) != null) {
            return false;
        }
        if (bl && (licenseKey2 = this.B(this._keys, licenseKey, bl3)) != null) {
            this.removeKeyImpl(licenseKey2);
        }
        if ((licenseKey2 = this.C(this._keys, licenseKey, bl3)) != null && !(keyType = licenseKey2.getType()).equals((Object)KeyType.FINAL)) {
            this.removeKeyImpl(licenseKey2);
        }
        boolean bl4 = this.addKeyImpl(licenseKey);
        return bl4;
    }

    public boolean addKey(LicenseKey licenseKey) throws IOException {
        boolean bl = this.B(licenseKey, false, true);
        return bl;
    }

    public void addKeys(LicenseKey[] licenseKeyArray) throws IOException {
        this.B(licenseKeyArray, false, true);
    }

    private boolean B(LicenseKey licenseKey, boolean bl, boolean bl2) throws IOException {
        boolean bl3 = this.addKeyImpl(licenseKey, bl, bl2, false);
        this.saveKeys();
        return bl3;
    }

    private void B(LicenseKey[] licenseKeyArray, boolean bl, boolean bl2) throws IOException {
        this.B(licenseKeyArray, bl, bl2, false);
    }

    private void B(LicenseKey[] licenseKeyArray, boolean bl, boolean bl2, boolean bl3) throws IOException {
        for (int i2 = 0; i2 < licenseKeyArray.length; ++i2) {
            this.addKeyImpl(licenseKeyArray[i2], bl, bl2, bl3);
        }
        this.saveKeys();
    }

    private LicenseKey C(Collection collection, LicenseKey licenseKey, boolean bl) {
        return this.B(collection, licenseKey, 0, bl);
    }

    private LicenseKey D(Collection collection, LicenseKey licenseKey, boolean bl) {
        return this.B(collection, licenseKey, 1, bl);
    }

    private LicenseKey B(Collection collection, LicenseKey licenseKey, boolean bl) {
        return this.B(collection, licenseKey, -1, bl);
    }

    private LicenseKey B(Collection collection, LicenseKey licenseKey, int n2, boolean bl) {
        LicenseKeys licenseKeys = LicenseKeys.getInstance();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            int n3;
            LicenseKey licenseKey2 = (LicenseKey)iterator.next();
            if (!licenseKeys.comparable(licenseKey, licenseKey2) || Utils.getSign((double)(n3 = licenseKeys.compare(licenseKey2, licenseKey, this._poseidonProduct, bl))) != n2) continue;
            return licenseKey2;
        }
        return null;
    }

    public String getLicenseKeyRingFileName() {
        return "license-keys.txt";
    }

    public static String getLicenseRingFileName() {
        return "license-keys.txt";
    }

    public String getLogPrefix() {
        return "[PoseidonKeyManager] ";
    }
}

