/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.poseidon;

import com.gentleware.anvil.kernel.LicenseData;
import com.gentleware.anvil.kernel.ProductEditionImpl;
import com.gentleware.anvil.kernel.RegistrationResourceBundle;
import com.gentleware.anvil.kernel.utils.LicenseException;
import com.gentleware.jboogie.kernel.JBoogie;
import com.gentleware.jboogie.kernel.ProjectImpl;
import com.gentleware.jboogie.util.JBoogieUtils;
import com.gentleware.locksmith.client.LicenseChecker;
import com.gentleware.locksmith.client.LicenseKeys;
import com.gentleware.mdr.MdrFacade;
import com.gentleware.mdr.ModelListener;
import com.gentleware.mdr.storagemodel.TransactionLogSwitcher;
import com.gentleware.openapi.configuration.Services;
import com.gentleware.openapi.jboogie.Project;
import com.gentleware.openapi.swingx.Localizer;
import com.gentleware.openapi.swingx.ResourceId;
import com.gentleware.openapi.swingx.SwingUtil;
import com.gentleware.openapi.util.Files;
import com.gentleware.openapi.util.Utils;
import com.gentleware.poseidon.B;
import com.gentleware.poseidon.BuildProperties;
import com.gentleware.poseidon.PoseidonCoreStarter;
import com.gentleware.poseidon.PoseidonServices;
import com.gentleware.poseidon.ProjectConverter;
import com.gentleware.poseidon.jboogie.PoseidonApplicationState;
import com.gentleware.poseidon.kernel.PoseidonProject;
import com.gentleware.poseidon.kernel.PoseidonProjectMemberManager;
import com.gentleware.poseidon.license.C;
import com.gentleware.poseidon.openapi.PoseidonUIConnector;
import com.gentleware.poseidon.ui.CoreResourceBundle;
import com.gentleware.poseidon.ui.LafManager;
import com.gentleware.poseidon.ui.PoseidonFrame;
import com.gentleware.poseidon.ui.ProjectPanel;
import com.gentleware.poseidon.ui.ProjectPanelManager;
import com.gentleware.poseidon.ui.R;
import com.gentleware.poseidon.ui.SplashScreen;
import com.gentleware.poseidon.ui.f;
import com.gentleware.poseidon.util.E;
import com.gentleware.poseidon.util.PoseidonUtils;
import com.gentleware.poseidon.util.UmlFunctions;
import com.gentleware.poseidon.util.plugin.A;
import com.gentleware.poseidon.util.plugin.PoseidonModuleInstaller;
import com.gentleware.swingx.InputBlocker;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.text.MessageFormat;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.WriterAppender;
import org.netbeans.api.mdr.events.MDRChangeListener;

public class Poseidon {
    private static final Logger E = Logger.getLogger((String)"com.gentleware.poseidon.Poseidon");
    public static final int DEFAULT_WIDTH = 1024;
    public static final int DEFAULT_HEIGHT = 768;
    public static final String PROPERTY_NOSPLASH = "poseidon.nosplash";
    private static final String C = "convertOldProjects";
    private static Services F;
    public static final String INITIAL_PROJECT_TYPE = "Uml1";
    private static final String D = "MDRStorageProperty.mutexClass";
    private static final String B = "MDRStorageProperty.storage";
    private static final String A = "collection.factoryclass.name";
    private static String[] G;

    public static void main(final String[] stringArray) {
        ThreadGroup threadGroup = new ThreadGroup("Poseidon"){

            public void uncaughtException(Thread thread, Throwable throwable) {
                if (!(throwable instanceof ThreadDeath)) {
                    E.error((Object)"Uncaught exception", throwable);
                }
            }
        };
        Thread thread = new Thread(threadGroup, "startup"){

            public void run() {
                try {
                    Poseidon.A(stringArray);
                }
                catch (IOException iOException) {
                    E.error((Object)"", (Throwable)iOException);
                }
            }
        };
        thread.start();
    }

    private static void A(String[] stringArray) throws IOException {
        boolean bl = false;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = stringArray[i2];
            if (!"-convert".equals(string)) continue;
            bl = true;
            System.setProperty(C, "true");
            System.setProperty("java.awt.headless", "true");
            if (i2 != stringArray.length - 1) continue;
            E.error((Object)"Expected list of project files to convert");
            return;
        }
        Utils.initializeLogging();
        G = stringArray;
        try {
            Poseidon.initStandalone(stringArray, !bl, !bl);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    private static void A() {
        String string = System.getProperty(D);
        String string2 = System.getProperty(B);
        String string3 = System.getProperty(A);
        if (string == null || "".equalsIgnoreCase(string)) {
            System.setProperty(D, "com.gentleware.mdr.MutableTransactionMutex");
        }
        if (string2 == null || "".equalsIgnoreCase(string2)) {
            System.setProperty(B, "com.gentleware.mdr.trovememoryimpl.StorageFactoryImpl");
        }
        if (string3 == null || "".equalsIgnoreCase(string3)) {
            System.setProperty(A, "com.gentleware.mdr.util.CollectionFactoryTrove");
        }
    }

    public static String[] getCommandLineArguments() {
        return G;
    }

    public static void init() {
        try {
            Poseidon.initStandalone(new String[0], false, true);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public static void init(String string) {
        String[] stringArray = new String[]{string};
        try {
            Poseidon.initStandalone(stringArray, false, true);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initStandalone(String[] stringArray, boolean bl, boolean bl2) throws Exception {
        boolean bl3;
        Object object;
        int n2;
        int n3;
        Serializable serializable;
        Object object2;
        Object object3;
        Object object4;
        boolean bl4;
        Poseidon.A();
        System.setProperty("java.util.prefs.syncInterval", "2000000");
        System.setProperty("entityExpansionLimit", Integer.toString(Integer.MAX_VALUE));
        try {
            F = Services.getInstance();
        }
        catch (IllegalStateException illegalStateException) {
            F = new PoseidonServices();
        }
        Poseidon.A(bl2);
        new JBoogie(F);
        if (!PoseidonCoreStarter.checkJavaVersion()) {
            System.exit(0);
        }
        PoseidonApplicationState.getInstance();
        PoseidonApplicationState.setHasOwnFrame(bl);
        PoseidonCoreStarter.initServices();
        com.gentleware.poseidon.util.E.C();
        System.setSecurityManager(new B());
        PoseidonCoreStarter.printStartLog(stringArray);
        PoseidonCoreStarter.setPoseidonLibProperty();
        PoseidonUtils.setOsSpecifics();
        if (!PoseidonCoreStarter.ensureConfigDirectoriesAndModulesFile()) {
            System.exit(0);
        }
        if (!Poseidon.isConvertingOldProjectFiles() && !PoseidonCoreStarter.checkLicenseAccepted()) {
            System.exit(0);
        }
        E.info((Object)"Init resources and file filters");
        PoseidonCoreStarter.initResourcesAndFileFilters();
        ProductEditionImpl productEditionImpl = BuildProperties.getPoseidonEdition();
        LicenseChecker licenseChecker = Poseidon.A(bl2, productEditionImpl);
        if (!Poseidon.isConvertingOldProjectFiles()) {
            licenseChecker.checkLicenseKeys();
        }
        boolean bl5 = bl4 = bl2 && productEditionImpl.isTeamAware();
        if (bl4 && ((com.gentleware.poseidon.license.E)licenseChecker).B()) {
            object4 = Localizer.localize((ResourceId)RegistrationResourceBundle.FL_EvaluationPeriodNote);
            JBoogieUtils.showMessageDialog(null, (Object)object4);
        }
        PoseidonCoreStarter.parseCommandLineArgs(stringArray);
        if (bl2) {
            try {
                object4 = Toolkit.getDefaultToolkit();
                ((Toolkit)object4).getSystemEventQueue().push(f.B());
                ((Toolkit)object4).setDynamicLayout(true);
            }
            catch (HeadlessException headlessException) {
                E.debug((Object)"Poseidon is apparently running headless.");
            }
            if (System.getProperty(PROPERTY_NOSPLASH) == null) {
                SplashScreen.show();
                SplashScreen.showStatus("Booting ...");
                SplashScreen.showProgress(5);
            }
            ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
            ToolTipManager.sharedInstance().setInitialDelay(800);
            InputBlocker.add();
        }
        SplashScreen.showStatus("Booting MDR and MOF");
        PoseidonCoreStarter.initDefaultRegistration();
        TransactionLogSwitcher.setNullStrategy((boolean)true);
        JBoogie.getInstance().setProjectMemberManager(PoseidonProjectMemberManager.getInstance());
        ProjectPanelManager.initMenus();
        try {
            object4 = PoseidonApplicationState.getInstance().getProjectOfType("Default");
            SplashScreen.showStatus("General setup");
            SplashScreen.showProgress(10);
            object4.initEmptyProject();
            object3 = PoseidonApplicationState.getInstance().getCurrentProject().createTransferable(null);
            if (bl2) {
                try {
                    object2 = Toolkit.getDefaultToolkit();
                    ((Toolkit)object2).getSystemClipboard().setContents((Transferable)object3, (ClipboardOwner)object3);
                }
                catch (IllegalStateException illegalStateException) {
                    E.error((Object)"Cannot get System clipboard!", (Throwable)illegalStateException);
                }
            }
            com.gentleware.poseidon.util.plugin.A.J();
            object2 = PoseidonUtils.getUserModuleFolder();
            serializable = new File(PoseidonUtils.getInstallationDirectory() + File.separator + "lib" + File.separator + "ext");
            PoseidonModuleInstaller.initialize(serializable, (File)object2, 50, 20);
            SplashScreen.showProgress(70);
            PoseidonModuleInstaller.autoLoadModules();
            URL uRL = PoseidonCoreStarter.getProjectUrlToOpen();
            if (uRL != null && !Poseidon.isConvertingOldProjectFiles()) {
                object4 = PoseidonApplicationState.getInstance().getProjectOfType(INITIAL_PROJECT_TYPE);
                if (object4 == null) {
                    E.error((Object)"Could not init project - not registered?");
                    System.exit(1);
                }
                object4.initEmptyProject();
                object4 = UmlFunctions.openProjectFile(uRL);
                SplashScreen.showProgress(75);
            } else {
                object4 = PoseidonApplicationState.getInstance().getProjectOfType(INITIAL_PROJECT_TYPE);
                if (object4 == null) {
                    E.error((Object)"Could not init project - not registered?");
                    System.exit(1);
                }
                SplashScreen.showProgress(75);
                object4.initEmptyProject();
            }
        }
        finally {
            TransactionLogSwitcher.setNullStrategy((boolean)false);
        }
        SplashScreen.showProgress(80);
        object3 = null;
        if (bl2) {
            object3 = PoseidonApplicationState.getInstance().createProjectPanel();
            if (object3 == null) {
                E.error((Object)"Could not init panel - not registered?");
                System.exit(1);
            }
            SplashScreen.showProgress(90);
            object4.getTargetManager().setBulkUpdate(true);
            ((ProjectPanel)object3).setProject((Project)object4);
            object4.getTargetManager().setBulkUpdate(false);
            SplashScreen.showProgress(100);
            ((ProjectPanel)object3).loadRecentFileList();
            SplashScreen.showStatus("Opening Main Window");
        } else {
            ProjectImpl.setNonGuiMode();
        }
        if (bl2) {
            ((ProjectPanel)object3).selectInitialTarget();
        }
        if (bl) {
            object2 = new PoseidonFrame((ProjectPanel)object3);
            serializable = SwingUtil.getPrimaryScreenSize();
            int n4 = Math.min(Services.getInstance().getConfiguration().getInteger("poseidon/screen/width", 1024), ((Dimension)serializable).width);
            n3 = Math.min(Services.getInstance().getConfiguration().getInteger("poseidon/screen/height", 768), ((Dimension)serializable).height);
            n2 = Services.getInstance().getConfiguration().getInteger("poseidon/screen/left", ((Dimension)serializable).width / 2 - n4 / 2);
            int n5 = Services.getInstance().getConfiguration().getInteger("poseidon/screen/top", ((Dimension)serializable).height / 2 - n3 / 2);
            ((Window)object2).setLocation(n2, n5);
            ((Window)object2).setSize(n4, n3);
            ((PoseidonFrame)object2).updateTitle();
            ((Component)object3).setSize(n4 - 100, n3 - 100);
            try {
                object = new Runnable((PoseidonFrame)object2){
                    final /* synthetic */ PoseidonFrame val$appFrame;
                    {
                        this.val$appFrame = poseidonFrame;
                    }

                    public void run() {
                        this.val$appFrame.setVisible(true);
                    }
                };
                SwingUtilities.invokeLater((Runnable)object);
            }
            catch (Exception exception) {
                E.error((Object)"Got Exception while displaying PoseidonPanel", (Throwable)exception);
                System.exit(0);
            }
        }
        SplashScreen.showProgress(100);
        if (bl2) {
            try {
                object2 = new Runnable(){

                    public void run() {
                        SplashScreen.hide();
                    }
                };
                SwingUtilities.invokeLater((Runnable)object2);
            }
            catch (Exception exception) {
                E.error((Object)"Got Exception while finishing start", (Throwable)exception);
                System.exit(0);
            }
        }
        if ((bl3 = Services.getInstance().getConfiguration().getBoolean("poseidon/didyouknow23/enabled", true)) && bl2) {
            try {
                R.H();
            }
            catch (HeadlessException headlessException) {
                E.info((Object)"[Poseidon]: No Tip of the Day in Headless Mode!");
            }
        }
        if (PoseidonCoreStarter.viewmdr) {
            MdrFacade.getInstance().addRepositoryListener((MDRChangeListener)new ModelListener());
        }
        if (bl2) {
            serializable = LicenseKeys.getInstance().getPoseidonLicenseData(BuildProperties.getPoseidonProduct());
            boolean bl6 = LicenseChecker.getInstance().runsAsEvaluation((LicenseData)serializable);
            n3 = serializable.getApplication().getEdition() != ProductEditionImpl.CE ? 1 : 0;
            n2 = Boolean.getBoolean("poseidon-ide-integration");
            if (bl6 && n3 != 0 && n2 == 0) {
                String string = Localizer.localize((ResourceId)CoreResourceBundle.evaluationLimit);
                object = new Object[]{BuildProperties.getPoseidonNameShort(), BuildProperties.getEvalLimit()};
                String string2 = MessageFormat.format(string, object);
                JBoogieUtils.showConfirmDialog((Component)PoseidonUIConnector.getApplicationWindow(), (Object)string2, (String)Localizer.localize((ResourceId)CoreResourceBundle.evalLimitTitle), (int)-1, (int)1);
            }
        }
        if (bl2) {
            ProjectPanel.firePoseidonStartCompleted();
        }
        if (Poseidon.isConvertingOldProjectFiles()) {
            Poseidon.A(PoseidonCoreStarter.getProjectUrlsToOpen());
        }
    }

    private static void A(URL[] uRLArray) {
        WriterAppender writerAppender = new WriterAppender((Layout)new PatternLayout("%d{ISO8601} %-5p [%-18t]: %m%n"), (OutputStream)Utils.getStandardOut());
        Logger logger = Logger.getLogger((String)"project-conversion");
        logger.addAppender((Appender)writerAppender);
        logger.info((Object)"Converting Project Files from Previous Versions");
        ProjectConverter projectConverter = ProjectConverter.get();
        for (int i2 = 0; i2 < uRLArray.length; ++i2) {
            URL uRL = uRLArray[i2];
            File file = Utils.urlToFile((URL)uRL);
            if (file == null) {
                logger.error((Object)("Cannot convert " + uRL + ". No file url"));
                continue;
            }
            if (!file.exists()) {
                logger.error((Object)("Cannot convert " + uRL + ". No such file."));
                continue;
            }
            File[] fileArray = file.isDirectory() ? file.listFiles(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return string.endsWith(".zuml");
                }
            }) : new File[]{file};
            for (int i3 = 0; i3 < fileArray.length; ++i3) {
                File file2 = fileArray[i3];
                URL uRL2 = Files.toUrl((File)file2);
                try {
                    boolean bl;
                    boolean bl2 = projectConverter.isConversionNecessary(uRL2);
                    if (!bl2) {
                        logger.info((Object)("No need to convert " + file2));
                        continue;
                    }
                    logger.info((Object)("Converting " + file2));
                    PoseidonProject poseidonProject = UmlFunctions.openProjectFile(uRL2);
                    String string = poseidonProject.getLastModified();
                    logger.info((Object)("Converted from version " + string));
                    String string2 = file2.getPath();
                    File file3 = new File(string2 + "." + string);
                    if (file3.exists()) {
                        file3 = File.createTempFile(file2.getName(), "." + string, file2.getParentFile());
                        file3.delete();
                    }
                    if (!(bl = file2.renameTo(file3))) {
                        logger.error((Object)("Project file " + file2.getPath() + " not converted. Cannot rename to backup file " + file3));
                        continue;
                    }
                    try {
                        logger.info((Object)("Saving " + poseidonProject.getName()));
                        UmlFunctions.saveProject(poseidonProject, file2, poseidonProject.getName(), null);
                        continue;
                    }
                    catch (Exception exception) {
                        file2.delete();
                        file3.renameTo(file2);
                        throw exception;
                    }
                }
                catch (Exception exception) {
                    logger.error((Object)("Cannot convert " + file2), (Throwable)exception);
                }
            }
        }
    }

    public static boolean isConvertingOldProjectFiles() {
        String string = System.getProperty(C);
        boolean bl = Boolean.valueOf(string);
        return bl;
    }

    private static void A(boolean bl) {
        if (bl) {
            LafManager.init();
        } else {
            if (Utils.isMacOs()) {
                try {
                    UIManager.setLookAndFeel("com.incors.plaf.alloy.AlloyLookAndFeel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    E.error((Object)"Caught exception setting l&f for headless mode on mac os", (Throwable)classNotFoundException);
                }
                catch (InstantiationException instantiationException) {
                    E.error((Object)"Caught exception setting l&f for headless mode on mac os", (Throwable)instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    E.error((Object)"Caught exception setting l&f for headless mode on mac os", (Throwable)illegalAccessException);
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    E.error((Object)"Caught exception setting l&f for headless mode on mac os", (Throwable)unsupportedLookAndFeelException);
                }
            }
            System.setProperty("java.awt.headless", "true");
            ProjectImpl.setNonGuiMode();
        }
    }

    private static LicenseChecker A(boolean bl, ProductEditionImpl productEditionImpl) throws LicenseException {
        boolean bl2;
        boolean bl3 = bl && productEditionImpl.isConcurrentLicenseEnabled();
        boolean bl4 = bl2 = bl && productEditionImpl.isTeamAware();
        LicenseChecker licenseChecker = bl2 ? new com.gentleware.poseidon.license.E() : (bl3 ? new C() : new com.gentleware.poseidon.license.A());
        return licenseChecker;
    }

    public static Services getServices() {
        return F;
    }
}

