/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.poseidon;

import com.gentleware.anvil.kernel.LicenseResourceBundle;
import com.gentleware.anvil.kernel.Machine;
import com.gentleware.anvil.kernel.RegistrationResourceBundle;
import com.gentleware.jboogie.util.JBoogieUtils;
import com.gentleware.openapi.configuration.Configuration;
import com.gentleware.openapi.configuration.Services;
import com.gentleware.openapi.jboogie.ProjectType;
import com.gentleware.openapi.swingx.Localizer;
import com.gentleware.openapi.swingx.ResourceId;
import com.gentleware.openapi.util.CollectionFactory;
import com.gentleware.openapi.util.Files;
import com.gentleware.openapi.util.Strings;
import com.gentleware.openapi.util.Utils;
import com.gentleware.poseidon.BuildProperties;
import com.gentleware.poseidon.Poseidon;
import com.gentleware.poseidon.generator.ui.GenerationResourceBundle;
import com.gentleware.poseidon.generator.ui.JDirectoryDialogResourceBundle;
import com.gentleware.poseidon.jboogie.PoseidonApplicationState;
import com.gentleware.poseidon.kernel.A;
import com.gentleware.poseidon.openapi.PoseidonResourceConnector;
import com.gentleware.poseidon.ui.CoreResourceBundle;
import com.gentleware.poseidon.ui.MenuResourceBundle;
import com.gentleware.poseidon.ui.SettingsResourceBundle;
import com.gentleware.poseidon.ui.TipResourceBundle;
import com.gentleware.poseidon.ui.V;
import com.gentleware.poseidon.ui.o;
import com.gentleware.poseidon.uml.UmlMenuResourceBundle;
import com.gentleware.poseidon.util.FileFilters;
import com.gentleware.poseidon.util.PoseidonUtils;
import java.awt.Component;
import java.awt.HeadlessException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.JFrame;
import org.apache.log4j.Logger;

public class PoseidonCoreStarter {
    private static final Logger B = Logger.getLogger((String)"com.gentleware.poseidon.PoseidonCoreStarter");
    private static List D = new ArrayList();
    private static boolean C;
    public static boolean viewmdr;
    private static Class class$com$gentleware$poseidon$PoseidonCoreStarter;
    private static Class class$com$gentleware$poseidon$Poseidon;

    private PoseidonCoreStarter() {
    }

    public static URL getProjectUrlToOpen() {
        return D.size() > 0 ? (URL)D.get(0) : null;
    }

    public static URL[] getProjectUrlsToOpen() {
        return D.toArray(new URL[D.size()]);
    }

    public static void parseCommandLineArgs(String[] stringArray) {
        String string;
        File file;
        Object object;
        Object object2;
        String string2 = Localizer.localize((ResourceId)CoreResourceBundle.StartProduct);
        String string3 = MessageFormat.format(string2, BuildProperties.getPoseidonNameLong());
        B.info((Object)string3);
        PoseidonUtils.logVersionInfo();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            object2 = stringArray[i2];
            if (!Strings.isEmpty((String)object2) && ((String)object2).charAt(0) == '-') {
                if ("-nosplash".equalsIgnoreCase((String)object2)) {
                    System.setProperty("poseidon.nosplash", "true");
                    continue;
                }
                if ("-viewmdr".equalsIgnoreCase((String)object2)) {
                    viewmdr = true;
                    continue;
                }
                if ("-convert".equalsIgnoreCase((String)object2)) continue;
                B.error((Object)("Ignoring unknown option '" + (String)object2 + "'"));
                continue;
            }
            object = object2;
            if (Strings.isEmpty((String)object)) continue;
            if (!(new File((String)object).exists() || ((String)object).endsWith(".zuml") || ((String)object).endsWith(".xmi"))) {
                object = (String)object + ".zuml";
            }
            if (!(file = new File((String)object)).exists()) {
                B.error((Object)("Project file '" + file.getAbsolutePath() + "' does not exist."));
                continue;
            }
            URL uRL = Files.toUrl((File)file);
            D.add(uRL);
        }
        if (D.size() == 0 && PoseidonCoreStarter.A() && !Poseidon.isConvertingOldProjectFiles() && (string = Services.getInstance().getConfiguration().getString("poseidon/opened/project")) != null && string.length() > 0) {
            try {
                object2 = new URL(string);
                object = ((URL)object2).getProtocol();
                if ("file".equals(object) && !(file = Utils.urlToFile((URL)object2)).exists()) {
                    return;
                }
                D.add(object2);
            }
            catch (MalformedURLException malformedURLException) {
                B.error((Object)"", (Throwable)malformedURLException);
            }
        }
    }

    private static boolean A() {
        boolean bl = Boolean.getBoolean("java.awt.headless");
        if (BuildProperties.getPoseidonEdition().isTeamAware() && bl) {
            B.info((Object)"No opening of last project for server");
            return false;
        }
        boolean bl2 = Services.getInstance().getConfiguration().getBoolean("poseidon/init/openlast", false);
        return bl2;
    }

    public static void printStartLog(String[] stringArray) {
        Object object;
        Object object2;
        B.info((Object)("Starting " + BuildProperties.getPoseidonNameLong() + " " + BuildProperties.getEditionLong() + " " + BuildProperties.getPoseidonVersion() + " on " + Calendar.getInstance().getTime()));
        B.info((Object)("installation directory:            '" + PoseidonUtils.getInstallationDirectory() + "'"));
        B.info((Object)("config directory:                  '" + PoseidonUtils.getConfigDir() + "'"));
        B.info((Object)("user.home:                         '" + System.getProperty("user.home") + "'"));
        B.info((Object)("java.version:                      '" + System.getProperty("java.version") + "'"));
        try {
            object2 = new Machine();
            B.info((Object)("ip:                                '" + object2.getIp() + "'"));
            B.info((Object)("host name:                         '" + object2.getHostName() + "'"));
            B.info((Object)("domain:                            '" + object2.getDomain() + "'"));
            B.info((Object)("os name:                           '" + object2.getOsName() + "'"));
            B.info((Object)("os version:                        '" + object2.getOsVersion() + "'"));
        }
        catch (Throwable throwable) {
            B.error((Object)"");
            B.error((Object)"Error while determining machine-information. Maybe your network has unconventional");
            B.error((Object)"DHCP-settings (perhaps with generated hostnames)? It might be necessary to override");
            B.error((Object)"some network-settings by adding values to your /etc/hosts file.");
            B.error((Object)"See http://forum.gentleware.com/thread.jspa?forumID=6&threadID=1361&tstart=0");
            B.error((Object)"for some more information on DHCP-issues");
            B.error((Object)"");
        }
        object2 = Services.getInstance().getConfiguration().getString("poseidon/user/lang", System.getProperty("user.language", "en"));
        String string = Services.getInstance().getConfiguration().getString("poseidon/user/region", System.getProperty("user.region", "US"));
        B.info((Object)("language:                          '" + (String)object2 + "'"));
        B.info((Object)("region:                            '" + string + "'"));
        B.info((Object)"");
        if (stringArray != null) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                object = stringArray[i2];
                B.info((Object)("command line parameters: arg[" + i2 + "]=" + (String)object));
            }
        }
        Properties properties = System.getProperties();
        object = properties.keySet();
        List list = CollectionFactory.createArrayList(object);
        Collections.sort(list);
        B.debug((Object)"");
        B.debug((Object)"System Properties");
        B.debug((Object)"=================\n");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = properties.getProperty(string2);
            B.debug((Object)(Strings.rightPad((String)(string2 + ":"), (int)35) + "'" + string3 + "'"));
        }
    }

    public static boolean checkJavaVersion() {
        String string = System.getProperty("java.specification.version");
        String string2 = System.getProperty("java.vm.version");
        boolean bl = true;
        if ("1.4.1-beta-b14".equals(string2)) {
            String string3 = "You are running Poseidon with a beta of JRE 1.4.1 that is known to be unstable.\nIf you continue it is likely that you will encounter problems or crashes.\nRecommended JRE version for this release of Poseidon is 1.4.1 or higher.\n";
            System.out.println("You are running Poseidon with a beta of JRE 1.4.1 that is known to be unstable.\nIf you continue it is likely that you will encounter problems or crashes.\nRecommended JRE version for this release of Poseidon is 1.4.1 or higher.\n");
            int n2 = JBoogieUtils.showConfirmDialog(null, (Object)"You are running Poseidon with a beta of JRE 1.4.1 that is known to be unstable.\nIf you continue it is likely that you will encounter problems or crashes.\nRecommended JRE version for this release of Poseidon is 1.4.1 or higher.\n", (String)"Wrong Java Version", (int)2, (int)0);
            bl = n2 == 0;
        } else if ("1.0".equals(string) || "1.1".equals(string) || "1.2".equals(string) || "1.3".equals(string)) {
            String string4 = "Poseidon needs a Java Runtime Environment compatible to Java specification version 1.4.\nYou are running " + string + ". Poseidon will exit. Please get a suitable JRE (e.g. from http://java.sun.com).";
            System.out.println(string4);
            JBoogieUtils.showMessageDialog(null, (Object)string4, (String)"Wrong Java Version version ", (int)0);
            bl = false;
        }
        return bl;
    }

    public static boolean ensureConfigDirectoriesAndModulesFile() {
        String string = System.getProperty("user.home");
        File file = new File(string);
        Object[] objectArray = new String[]{string};
        if (!file.exists()) {
            System.err.println("No User home directory defined. Program stopped!");
            JBoogieUtils.showMessageDialog((Component)new JFrame(), (Object)Localizer.localize((ResourceId)CoreResourceBundle.NoUserHomeDirectory));
            return false;
        }
        File file2 = new File(PoseidonUtils.getVersionSpecificConfigDir());
        if (!file2.exists() && !file2.mkdirs()) {
            System.err.println("Could not create user directory in " + string + ". Please check file permissions.");
            JBoogieUtils.showMessageDialog((Component)new JFrame(), (Object)MessageFormat.format(Localizer.localize((ResourceId)CoreResourceBundle.checkFilePermissions), objectArray));
            return false;
        }
        File file3 = PoseidonUtils.getInstalledModuleFile();
        if (!file3.exists()) {
            try {
                String string2 = "<?xml version='1.0'?>\n<modules>\n</modules>\n";
                FileWriter fileWriter = new FileWriter(file3);
                fileWriter.write("<?xml version='1.0'?>\n<modules>\n</modules>\n");
                fileWriter.close();
            }
            catch (IOException iOException) {
                Object[] objectArray2 = new String[]{file3.getPath()};
                B.error((Object)iOException);
                B.error((Object)"Could not create installedModules.xml file. Check permissions for directory poseidon.");
                JBoogieUtils.showMessageDialog((Component)new JFrame(), (Object)MessageFormat.format(Localizer.localize((ResourceId)CoreResourceBundle.checkPermissions), objectArray2));
                System.exit(0);
            }
        }
        return true;
    }

    public static synchronized void initResourcesAndFileFilters() {
        if (C) {
            return;
        }
        C = true;
        PoseidonResourceConnector.addResourceLocationFirst("com/gentleware/poseidon/images", (class$com$gentleware$poseidon$PoseidonCoreStarter == null ? (class$com$gentleware$poseidon$PoseidonCoreStarter = PoseidonCoreStarter.A("com.gentleware.poseidon.PoseidonCoreStarter")) : class$com$gentleware$poseidon$PoseidonCoreStarter).getClassLoader());
        CoreResourceBundle.add();
        MenuResourceBundle.add();
        UmlMenuResourceBundle.add();
        SettingsResourceBundle.add();
        RegistrationResourceBundle.add();
        LicenseResourceBundle.add();
        TipResourceBundle.add();
        GenerationResourceBundle.add();
        JDirectoryDialogResourceBundle.add();
        FileFilters.initFilters();
    }

    public static synchronized void initDefaultRegistration() {
        PoseidonApplicationState poseidonApplicationState = PoseidonApplicationState.getInstance();
        ProjectType projectType = A.getInstance();
        poseidonApplicationState.registerProjectType(projectType);
        new o();
    }

    public static boolean checkLicenseAccepted() {
        boolean bl = Boolean.getBoolean("poseidon-ide-integration");
        if (bl) {
            return true;
        }
        B.debug((Object)"Show license text...");
        Services services = Services.getInstance();
        Configuration configuration = services.getConfiguration();
        boolean bl2 = configuration.getBoolean("poseidon/gui/dialog/max/forms", false);
        if (bl2) {
            return true;
        }
        try {
            Utils.setupWebstartDesktopIntegrationFix();
            V v = new V();
            v.show();
            Utils.shutdownWebstartDesktopIntegrationFix();
            v.dispose();
            bl2 = v.B();
        }
        catch (HeadlessException headlessException) {
            B.info((Object)"[PoseidonCoreStarter]: No accept licence check in Headless Mode!");
            bl2 = true;
        }
        configuration.putBoolean("poseidon/gui/dialog/max/forms", bl2);
        if (bl2) {
            boolean bl3 = configuration.flush();
            if (!bl3) {
                B.error((Object)"Could not create preferences file. Check permissions for directory poseidon2.");
                String string = Localizer.localize((ResourceId)CoreResourceBundle.preferencesFile);
                File file = new File(PoseidonUtils.getConfigDir(), "Poseidon.properties");
                Object[] objectArray = new String[]{file.getPath()};
                JBoogieUtils.showMessageDialog((Component)new JFrame(), (Object)MessageFormat.format(string, objectArray));
            }
            return bl3;
        }
        return false;
    }

    public static void setPoseidonLibProperty() {
        String string;
        String string2;
        if (System.getProperty("poseidon.lib") != null) {
            return;
        }
        ClassLoader classLoader = (class$com$gentleware$poseidon$Poseidon == null ? (class$com$gentleware$poseidon$Poseidon = PoseidonCoreStarter.A("com.gentleware.poseidon.Poseidon")) : class$com$gentleware$poseidon$Poseidon).getClassLoader();
        URL uRL = classLoader.getResource(string2 = Strings.replaceAll((String)(string = (class$com$gentleware$poseidon$Poseidon == null ? (class$com$gentleware$poseidon$Poseidon = PoseidonCoreStarter.A("com.gentleware.poseidon.Poseidon")) : class$com$gentleware$poseidon$Poseidon).getName()), (char)'.', (char)'/') + ".class");
        String string3 = uRL.getFile();
        if (string3.startsWith("file:")) {
            String string4 = string3.substring(string3.indexOf(":") + 1, string3.indexOf("poseidon2.jar"));
            System.setProperty("poseidon.lib", string4);
        }
    }

    public static void initServices() {
        Services.getInstance().getConfiguration().setKeyPrefix(BuildProperties.PRODUCT_SMALL);
    }

    private static Class A(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

