/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.poseidon.generator;

import com.gentleware.openapi.swingx.Localizer;
import com.gentleware.openapi.swingx.ResourceId;
import com.gentleware.openapi.util.CollectionFactory;
import com.gentleware.poseidon.generator.CompilationStrategy;
import com.gentleware.poseidon.generator.Generator;
import com.gentleware.poseidon.generator.GeneratorController;
import com.gentleware.poseidon.generator.GeneratorFactory;
import com.gentleware.poseidon.generator.ui.DialogController;
import com.gentleware.poseidon.generator.ui.GenerationResourceBundle;
import com.gentleware.poseidon.generator.ui.TreeRenderingStrategy;
import com.gentleware.poseidon.util.PoseidonUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.velocity.app.VelocityEngine;

public abstract class CoreGeneratorController
implements GeneratorController {
    private static final Logger N = Logger.getLogger((String)"com.gentleware.poseidon.generator.CoreGeneratorController");
    public static final int RETURN_NO_PROBLEMS = 0;
    public static final int RETURN_UNSPECIFIED_PROBLEM = 1;
    public static final int RETURN_GENERATION_CANCELLED = 2;
    public static final int RETURN_IGNORED_ONE_ERROR = 3;
    public static final int RETURN_IGNORE_ALL_ERRORS = 4;
    protected static final String PROPERTY_POSEIDON_CODEGEN_COMPILE = "poseidon/codeGen/compile";
    private static final String G = "directive.foreach.counter.initial.value";
    private static final String T = "resource.manager.logwhenfound";
    protected static final String PROPERTY_TRUE_VALUE = "true";
    protected static final String PROPERTY_RESOURCE_LOADER = "resource.loader";
    private static final String L = "class.resource.loader.description";
    protected static final String PROPERTY_CLASS_RESOURCE_LOADER_CLASS = "class.resource.loader.class";
    private static final String F = "file.resource.loader.description";
    private static final String K = "file.resource.loader.class";
    private static final String O = "file.resource.loader.path";
    private static final String M = "file.resource.loader.cache";
    protected static final String PROPERTY_FALSE_VALUE = "false";
    private static final String H = "velocimacro.library";
    private static final String Q = "velocimacro.permissions.allow.inline";
    private static final String B = "velocimacro.permissions.allow.inline.to.replace.global";
    private static final String D = "runtime.log";
    protected static final String GENERATION_PROBLEM_WARNING_PREFIX = "WARNING";
    protected static final String GENERATION_PROBLEM_ERROR_PREFIX = "ERROR";
    private Generator J = null;
    private List E = CollectionFactory.createArrayList();
    private TreeRenderingStrategy I = null;
    private CompilationStrategy P;
    private boolean A = true;
    private List S = CollectionFactory.createArrayList();
    private boolean C = false;
    protected String _languageForGeneratorController = "";
    private static Class class$com$gentleware$poseidon$generator$ClasspathEncryptedResourceLoader;

    public void initGenerator() {
        Generator generator = this.getGenerator();
        generator.initInternal();
    }

    protected void initVelocityRuntime() {
        try {
            Properties properties = this.createVelocityPropeties();
            GeneratorFactory generatorFactory = GeneratorFactory.getInstance();
            VelocityEngine velocityEngine = generatorFactory.getVelocityEngine();
            velocityEngine.init(properties);
        }
        catch (Exception exception) {
            N.error((Object)"Caught exception while initializing velocity runtime environment!", (Throwable)exception);
        }
    }

    protected Properties createVelocityPropeties() {
        Properties properties = new Properties();
        properties.setProperty(G, "0");
        if (N.isDebugEnabled()) {
            properties.setProperty(T, PROPERTY_TRUE_VALUE);
        }
        properties.setProperty(PROPERTY_RESOURCE_LOADER, "file, class");
        properties.setProperty(L, "Poseidon Class Resource Loader");
        properties.setProperty(PROPERTY_CLASS_RESOURCE_LOADER_CLASS, (class$com$gentleware$poseidon$generator$ClasspathEncryptedResourceLoader == null ? (class$com$gentleware$poseidon$generator$ClasspathEncryptedResourceLoader = CoreGeneratorController.A("com.gentleware.poseidon.generator.ClasspathEncryptedResourceLoader")) : class$com$gentleware$poseidon$generator$ClasspathEncryptedResourceLoader).getName());
        properties.setProperty(F, "Velocity File Resource Loader");
        properties.setProperty(K, "org.apache.velocity.runtime.resource.loader.FileResourceLoader");
        String string = DialogController.getTemplateDir();
        N.info((Object)("Velocity Resource-Loader-Path set to \"" + string + "\""));
        properties.setProperty(O, string);
        properties.setProperty(M, PROPERTY_FALSE_VALUE);
        properties.setProperty(H, "templates/LIB_StaticStructure.vm");
        properties.setProperty(Q, PROPERTY_TRUE_VALUE);
        properties.setProperty(B, PROPERTY_TRUE_VALUE);
        String string2 = PoseidonUtils.getConfigDir();
        properties.setProperty(D, string2 + "/velocity.log");
        return properties;
    }

    public Generator getGenerator() {
        if (!this.J.isInitialized()) {
            this.J.initInternal();
        }
        return this.J;
    }

    public void reloadMacros() {
        this.initVelocityRuntime();
        Generator generator = this.getGenerator();
        if (generator.isInitialized()) {
            List list = generator.getMacroLibraries();
            Iterator iterator = list.iterator();
            GeneratorFactory generatorFactory = GeneratorFactory.getInstance();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                generatorFactory.addMacroLibrary(string);
            }
            this.C = true;
        }
    }

    public void setLanguage(String string) {
        this._languageForGeneratorController = string;
    }

    public Collection getGeneratedFiles() {
        return this.S;
    }

    protected void addGeneratedFile(String string) {
        this.S.add(string);
    }

    protected void addGeneratedFiles(List list) {
        this.S.addAll(list);
    }

    protected void resetGeneratedFiles() {
        this.S = CollectionFactory.createArrayList();
    }

    public void setGenerator(Generator generator) {
        this.J = generator;
    }

    public boolean isValidElementClass(Object object) {
        Iterator iterator = this.E.iterator();
        while (iterator.hasNext()) {
            if (!((Class)iterator.next()).isInstance(object)) continue;
            return true;
        }
        return false;
    }

    public void addValidElementClass(Class clazz) {
        this.E.add(clazz);
    }

    public void removeValidElementClass(Class clazz) {
        this.E.remove(clazz);
    }

    public TreeRenderingStrategy getTreeRenderingStrategy() {
        return this.I;
    }

    public void setTreeRenderingStrategy(TreeRenderingStrategy treeRenderingStrategy) {
        this.I = treeRenderingStrategy;
    }

    public void setUsesEncrypted(boolean bl) {
        this.A = bl;
    }

    public boolean usesEncryptedTemplates() {
        return this.A;
    }

    public boolean hasMacrosPreloaded() {
        return this.C;
    }

    public void resetMacrosPreloaded() {
        this.C = false;
    }

    public CompilationStrategy getCompilationStrategy() {
        return this.P;
    }

    public void setCompilationStrategy(CompilationStrategy compilationStrategy) {
        this.P = compilationStrategy;
    }

    protected String compile(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        Runtime runtime = Runtime.getRuntime();
        int n2 = -1;
        try {
            Process process = runtime.exec(stringArray);
            n2 = CoreGeneratorController.A(process, stringBuffer);
        }
        catch (IOException iOException) {
            N.error((Object)"I/O-Error while executing compiler-process.", (Throwable)iOException);
        }
        String string = null;
        if (n2 != 0) {
            string = stringBuffer.toString();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int A(Process process, StringBuffer stringBuffer) {
        int n2 = -1;
        BufferedReader bufferedReader = null;
        BufferedReader bufferedReader2 = null;
        try {
            InputStream inputStream = process.getInputStream();
            InputStream inputStream2 = process.getErrorStream();
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            bufferedReader2 = new BufferedReader(new InputStreamReader(inputStream2));
            boolean bl = true;
            while (true) {
                int n3;
                int n4;
                if ((n4 = bufferedReader2.read()) != -1) {
                    stringBuffer.append((char)n4);
                    continue;
                }
                while ((n3 = bufferedReader.read()) != -1) {
                    stringBuffer.append((char)n3);
                }
                if (n3 == -1 && n4 == -1) {
                    try {
                        n2 = process.exitValue();
                        bl = false;
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        try {
                            Thread.yield();
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                } else {
                    N.debug((Object)("characterFromOutput==" + n3 + "; characterFromError==" + n4));
                }
                if (!bl) break;
            }
        }
        catch (IOException iOException) {
            N.error((Object)"Exception while reading compiler output!", (Throwable)iOException);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (bufferedReader2 != null) {
                    bufferedReader2.close();
                }
            }
            catch (IOException iOException) {
                N.error((Object)iOException);
            }
        }
        return n2;
    }

    protected String compileGeneratedCode(Collection collection) {
        String[] stringArray;
        StringBuffer stringBuffer = new StringBuffer();
        CompilationStrategy compilationStrategy = this.getCompilationStrategy();
        if (compilationStrategy != null) {
            stringArray = compilationStrategy.createCompilationCommand(collection);
        } else {
            stringArray = null;
            stringBuffer.append(Localizer.localize((ResourceId)GenerationResourceBundle.NoCompilationStrategy) + "\n");
        }
        if (stringArray != null && stringArray.length > 0) {
            String string = this.compile(stringArray);
            if (string == null) {
                stringBuffer.append(Localizer.localize((ResourceId)GenerationResourceBundle.GenerationCompilationDone) + "\n");
            } else {
                stringBuffer.append(Localizer.localize((ResourceId)GenerationResourceBundle.CompilationErrors) + "\n");
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    protected String extractGenerationProblems(Collection collection) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!string.startsWith(GENERATION_PROBLEM_WARNING_PREFIX) && !string.startsWith(GENERATION_PROBLEM_ERROR_PREFIX)) continue;
            stringBuffer.append(string);
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private static Class A(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

