/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.poseidon.generator;

import com.gentleware.openapi.configuration.Services;
import com.gentleware.openapi.util.CollectionFactory;
import com.gentleware.poseidon.generator.CoreGeneratorController;
import com.gentleware.poseidon.generator.Generator;
import com.gentleware.poseidon.generator.GeneratorController;
import com.gentleware.poseidon.kernel.PoseidonProject;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.apache.velocity.app.VelocityEngine;

public class GeneratorFactory {
    private static final Logger H = Logger.getLogger((String)"com.gentleware.poseidon.generator.GeneratorFactory");
    private Map D = CollectionFactory.createHashMap();
    private Map G = CollectionFactory.createHashMap();
    private List F = CollectionFactory.createArrayList();
    private List B = CollectionFactory.createArrayList();
    private static GeneratorFactory E;
    public static final String CONFIGURATION_PREFIX = "poseidon/codeGen/";
    private VelocityEngine A = new VelocityEngine();
    private List C = CollectionFactory.createArrayList();
    public static final String COMPILE_FILE_SUFFIX_KEY = "compileFileSuffix";
    public static final String SOURCE_FILE_SUFFIX_KEY = "sourceFileSuffix";

    public boolean addGeneratorController(String string, GeneratorController generatorController) {
        if (this.D.containsKey(string)) {
            this.D.remove(string);
        }
        this.D.put(string, generatorController);
        return this.D.containsKey(string);
    }

    public boolean addGeneratorControllerWithHiddenLanguage(String string, GeneratorController generatorController) {
        this.C.add(string);
        return this.addGeneratorController(string, generatorController);
    }

    public void addActionListener(ActionListener actionListener) {
        if (!this.F.contains(actionListener)) {
            this.F.add(actionListener);
        }
    }

    public void removeActionListener(ActionListener actionListener) {
        this.F.remove(actionListener);
    }

    public void removeAllListeners() {
        this.F.clear();
    }

    public boolean treatAsUnencrypted(String string) {
        return this.B.contains(string);
    }

    public void addUnencryptedTemplateOrLibrary(String string) {
        this.B.remove(string);
        this.B.add(string);
    }

    public void removeUnencryptedTemplateOrLibrary(String string) {
        this.B.remove(string);
    }

    public boolean removeGeneratorController(String string) {
        this.D.remove(string);
        String string2 = this.getConfigurationEntry(CONFIGURATION_PREFIX + string + "/generate");
        H.debug((Object)("[" + this.getClass().getName() + "] generate entry = " + string2));
        if ("true".equals(string2)) {
            this.setConfigurationEntry("poseidon/codeGen." + string + "/generate", "false");
            this.setConfigurationEntry("poseidon/codeGen/java/generate", "true");
        }
        return !this.D.containsKey(string);
    }

    public void addMacroLibrary(String string) {
        this.addMacroLibrary(string, false);
    }

    public void addMacroLibrary(String string, boolean bl) {
        if (bl) {
            this.B.remove(string);
            this.B.add(string);
        }
        try {
            this.A.getTemplate(string);
        }
        catch (Exception exception) {
            H.error((Object)("[" + this.getClass() + "] exception caught while adding macro library!"), (Throwable)exception);
        }
    }

    public void removeMacroLibrary(String string) {
        this.B.remove(string);
    }

    public List getMacroLibraries() {
        return null;
    }

    public VelocityEngine getVelocityEngine() {
        return this.A;
    }

    public void reloadMacros() {
        this.A = new VelocityEngine();
        GeneratorController generatorController = this.getGeneratorController();
        if (generatorController == null) {
            return;
        }
        if (generatorController instanceof CoreGeneratorController) {
            generatorController.reloadMacros();
        }
    }

    public String getLanguage() {
        return this.getConfigurationEntry("poseidon/codeGen/language");
    }

    public void setLanguage(String string) {
        this.setConfigurationEntry("poseidon/codeGen/language", string);
    }

    public GeneratorController getGeneratorController() {
        Map map = Services.getInstance().getConfiguration().getAllEntriesMatching(CONFIGURATION_PREFIX + this.getLanguage());
        List list = CollectionFactory.createArrayList();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string;
            String string2 = (String)iterator.next();
            if (string2.indexOf("generate") <= -1 || !"true".equals(map.get(string2))) continue;
            StringBuffer stringBuffer = new StringBuffer();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "/");
            stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
                if (!stringTokenizer.hasMoreTokens()) continue;
                stringBuffer.append(string);
                stringBuffer.append("/");
            }
            string = stringBuffer.toString();
            GeneratorController generatorController = this.getGeneratorController(string = string.substring(0, string.length() - 1));
            if (generatorController == null) continue;
            list.add(generatorController);
        }
        if (list.size() > 1) {
            H.error((Object)"too many selected generation attributes, no GeneratorController will be used!");
            return null;
        }
        if (list.size() == 0) {
            return null;
        }
        return (GeneratorController)list.get(0);
    }

    public void fireGenerationDone() {
        if (this.F == null || this.F.size() == 0) {
            return;
        }
        ActionEvent actionEvent = new ActionEvent(this, 999, "GenerationDone");
        Iterator iterator = this.F.iterator();
        while (iterator.hasNext()) {
            ((ActionListener)iterator.next()).actionPerformed(actionEvent);
        }
    }

    public Map getConfiguration() {
        return this.G;
    }

    public void updateConfiguration() {
        this.G = Services.getInstance().getConfiguration().getAllEntriesMatching(CONFIGURATION_PREFIX);
    }

    private GeneratorFactory() {
        VetoableChangeListener vetoableChangeListener = new VetoableChangeListener(){

            public void vetoableChange(PropertyChangeEvent propertyChangeEvent) {
                GeneratorController generatorController;
                String string = propertyChangeEvent.getPropertyName();
                if (("Loaded".equals(string) || "Created".equals(string)) && (generatorController = GeneratorFactory.this.getGeneratorController()) != null) {
                    Generator generator = generatorController.getGenerator();
                    generator.initInternal();
                }
            }
        };
        PoseidonProject.addProjectListener(vetoableChangeListener);
    }

    public static GeneratorFactory getInstance() {
        if (E == null) {
            E = new GeneratorFactory();
            E.updateConfiguration();
            E.reloadMacros();
        }
        return E;
    }

    public String getConfigurationEntry(String string) {
        if (Services.getInstance().getConfiguration().containsKey(string)) {
            return Services.getInstance().getConfiguration().get(string);
        }
        return "";
    }

    public GeneratorController getGeneratorController(String string) {
        return (GeneratorController)this.D.get(string);
    }

    public Set getRegisteredLanguages() {
        Set set = CollectionFactory.createHashSet(this.D.keySet());
        set.removeAll(this.C);
        return set;
    }

    public String getSourceExtension() {
        return this.getConfigurationEntry(CONFIGURATION_PREFIX + this.getLanguage() + "/" + SOURCE_FILE_SUFFIX_KEY);
    }

    public List getSourceExtensionList() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.getSourceExtension(), " ,;:");
        List list = CollectionFactory.createArrayList();
        while (stringTokenizer.hasMoreTokens()) {
            list.add(stringTokenizer.nextToken());
        }
        return list;
    }

    public String getCompiledExtension() {
        return this.getConfigurationEntry(CONFIGURATION_PREFIX + this.getLanguage() + "/" + COMPILE_FILE_SUFFIX_KEY);
    }

    public void setConfigurationEntry(String string, String string2) {
        Services.getInstance().getConfiguration().put(string, string2);
    }
}

