/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.poseidon.generator.ui;

import com.gentleware.anvil.kernel.ProductEditionImpl;
import com.gentleware.openapi.configuration.Configuration;
import com.gentleware.openapi.configuration.Services;
import com.gentleware.openapi.jboogie.Project;
import com.gentleware.openapi.swingx.Localizer;
import com.gentleware.openapi.swingx.ResourceId;
import com.gentleware.openapi.swingx.SwingUtil;
import com.gentleware.openapi.util.CollectionFactory;
import com.gentleware.openapi.util.Files;
import com.gentleware.openapi.util.Utils;
import com.gentleware.poseidon.BuildProperties;
import com.gentleware.poseidon.generator.GeneratorController;
import com.gentleware.poseidon.generator.GeneratorFactory;
import com.gentleware.poseidon.generator.ui.B;
import com.gentleware.poseidon.generator.ui.F;
import com.gentleware.poseidon.generator.ui.GenerationResourceBundle;
import com.gentleware.poseidon.generator.ui.I;
import com.gentleware.poseidon.generator.ui.TemplateTester;
import com.gentleware.poseidon.generator.ui.TreeRenderingStrategy;
import com.gentleware.poseidon.jboogie.PoseidonApplicationState;
import com.gentleware.poseidon.kernel.PoseidonProject;
import com.gentleware.poseidon.openapi.PoseidonUIConnector;
import com.gentleware.poseidon.ui.CheckNode;
import com.gentleware.poseidon.util.PoseidonUtils;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class DialogController {
    private static final Logger D = Logger.getLogger((String)"com.gentleware.poseidon.generator.ui.DialogController");
    public static final String CODE_GEN_KEY = "codeGen";
    public static final String DOCUMENT_AUTHORS_KEY = "documentAuthors";
    public static final String EXTERNAL_LINK_BASE_KEY = "externalLinkBase";
    public static final String EXTERNAL_LINK_BASE_DEFAULT_VALUE = "http://java.sun.com/j2se/1.4.2/docs/api";
    public static final String GENERATE_EXTERNAL_LINKS_KEY = "showExternalLinks";
    private static final String E = "umldoc";
    public static final String CLEAR_DESTINATION_FOLDER_KEY = "clearDestinationFolder";
    public static final String COPYRIGHT_UMLDOC_KEY = "copyright";
    public static final String REPAINT_ALL_DIAGRAMS_KEY = "repaintAllDiagrams";
    public static final String COPYRIGHT_UMLDOC_DEFAULT_VALUE = "<div style=\"font-size:0.8em;\">\nGenerated with Poseidon for UML<sup><font size='small'>TM</font></sup>.<br/>\nPoseidon is a registered trademark of <a href=\"http://www.gentleware.com\" target=\"nw\">Gentleware AG</a> in the USA and other countries.\nCopyright 2003-2006 Gentleware AG, Ludwigstr. 12, 20357 Hamburg, Germany. All Rights Reserved.\n</div>";
    protected static final String codeGenerationStr = Localizer.localize((ResourceId)GenerationResourceBundle.CodeGeneration);
    protected static final String KEY_CLEAR_OUTPUTDIR;
    protected static final String KEY_SHOW_PROGRESSBAR;
    protected static final String KEY_COMPILE;
    public static final String KEY_TEMPLATE_DIR;
    public static final String DOCUMENT_AUTHORS;
    public static final String EXTERNAL_LINK_BASE;
    public static final String GENERATE_EXTERNAL_LINKS;
    public static final String CLEAR_DESTINATION_FOLDER;
    public static final String COPYRIGHT_UMLDOC;
    public static final String REPAINT_ALL_DIAGRAMS;
    private static DialogController B;
    private Map G = CollectionFactory.createHashMap();
    private Map A = CollectionFactory.createHashMap();
    private Map C = CollectionFactory.createHashMap();
    private Map F = CollectionFactory.createHashMap();
    private Map J = CollectionFactory.createHashMap();
    private I I = new I();
    private static final int H = 1024;

    public void addLanguage(String string) {
        if (this.G.get(string) == null) {
            String string2 = this.getLanguageKey(string);
            if (string2 == null) {
                string2 = this.getConfigurationCompatibleString(string);
                this.A.put(string, string2);
            }
            this.F.put(string2, string);
            this.G.put(string, CollectionFactory.createArrayList());
            this.I.A(string);
            PoseidonProject poseidonProject = PoseidonApplicationState.getInstance().getCurrentProject();
            if (poseidonProject != null) {
                poseidonProject.setSourcepath(PoseidonApplicationState.getInstance().getCurrentProject().getSourcepath(), string2);
            } else {
                D.warn((Object)"Current project is null. Not setting source path.", (Throwable)new Exception());
            }
            D.debug((Object)("languageName " + string + " installed, shortname " + string2));
        } else {
            D.info((Object)("The languageName " + string + " is already installed."));
        }
    }

    public void addLanguage(String string, ResourceId resourceId) {
        if (this.G.get(string) == null) {
            ResourceId resourceId2;
            String string2 = this.getLanguageKey(string);
            if (string2 == null) {
                string2 = this.getConfigurationCompatibleString(string);
                this.A.put(string, string2);
            }
            if ((resourceId2 = this.getLanguageResourceId(string)) == null) {
                this.C.put(string, resourceId);
            }
            this.F.put(string2, string);
            this.G.put(string, CollectionFactory.createArrayList());
            this.I.A(string);
            PoseidonProject poseidonProject = PoseidonApplicationState.getInstance().getCurrentProject();
            if (poseidonProject != null) {
                poseidonProject.setSourcepath(PoseidonApplicationState.getInstance().getCurrentProject().getSourcepath(), string2);
            } else {
                D.warn((Object)"Current project is null. Not setting source path.", (Throwable)new Exception());
            }
            D.debug((Object)("languageName " + string + " installed, shortname " + string2));
        } else {
            D.info((Object)("The languageName " + string + " is already installed."));
        }
    }

    public void removeLanguage(String string) {
        List list = (List)this.G.get(string);
        if (list == null) {
            return;
        }
        if (list.size() > 0) {
            D.info((Object)("The language " + string + " still has subsettings and therefore is not removed."));
            return;
        }
        this.G.remove(string);
        this.I.G(string);
    }

    public void removeLanguageEntries(String string) {
        String string2 = (String)this.F.get(string);
        this.F.remove(string);
        this.A.remove(string2);
        this.C.remove(string2);
    }

    public void addSettingsPanel(String string, JPanel jPanel, String string2, ResourceId resourceId) {
        if (jPanel != null) {
            this.I.A(string, jPanel, string2);
        }
    }

    public boolean hasPanel(String string) {
        return this.I.C(string);
    }

    public void removeSettingsPanel(String string, String string2) {
        this.I.A(string, string2);
    }

    public void removeSettingsPanels(String string) {
        this.I.D(string);
    }

    public Map getLanguagePanels(String string) {
        return this.I.F(string);
    }

    public Map getRelevantGeneralPanels(Set set) {
        Map map = CollectionFactory.createHashMap((int)set.size());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object v = this.J.get(string);
            if (v == null) {
                D.error((Object)("Code gen. settings panels: non-existent panel requested for " + string), (Throwable)new Exception());
                continue;
            }
            map.put(string, v);
        }
        return map;
    }

    public List getAllLanguages() {
        return this.I.A();
    }

    protected int getLanguageCount() {
        return this.I.B();
    }

    protected void setSelectedState(JToggleButton jToggleButton, String string) {
        String string2 = Services.getInstance().getConfiguration().makeKey(CODE_GEN_KEY, string, jToggleButton.getName());
        jToggleButton.setSelected(Services.getInstance().getConfiguration().getBoolean(string2));
    }

    public List getSubBoxes(String string) {
        return (List)this.G.get(string);
    }

    public static boolean getCleanDirectory() {
        return Services.getInstance().getConfiguration().getBoolean(KEY_CLEAR_OUTPUTDIR, false);
    }

    public static boolean getRepaintAllDiagrams() {
        return Services.getInstance().getConfiguration().getBoolean(REPAINT_ALL_DIAGRAMS, false);
    }

    public static void setCleanDirectory(boolean bl) {
        Services.getInstance().getConfiguration().putBoolean(KEY_CLEAR_OUTPUTDIR, bl);
    }

    public static String getOutputDir() {
        String string = PoseidonApplicationState.getInstance().getCurrentProject().getSourcepath();
        if ("".equals(string)) {
            string = System.getProperty("user.home") + File.separator + "temp";
            D.warn((Object)("Given output-path is empty. Using default-path: \"" + string + "\"."));
        }
        String string2 = Files.getCanonicalPath((String)string);
        return string2;
    }

    public static String getOutputDir(String string) {
        String string2 = PoseidonApplicationState.getInstance().getCurrentProject().getSourcepath(string);
        if ("".equals(string2)) {
            string2 = System.getProperty("user.home") + File.separator + "temp";
            D.warn((Object)("Given output-path is empty. Using default-path: \"" + string2 + "\"."));
        }
        String string3 = Files.getCanonicalPath((String)string2);
        return string3;
    }

    public static void setOutputDir(String string) {
        PoseidonApplicationState.getInstance().getCurrentProject().setSourcepath(string);
    }

    public static void setOutputDir(String string, String string2) {
        PoseidonApplicationState.getInstance().getCurrentProject().setSourcepath(string, string2);
    }

    public static void setDeselectedNodes(CheckNode checkNode) {
        Set set = CollectionFactory.createHashSet((int)1024);
    }

    public static String getTemplateDir() {
        String string;
        if (PoseidonUtils.isWebStart()) {
            string = PoseidonUtils.getInstallationDirectory().getAbsolutePath();
            D.info((Object)("WebStart installation path:" + string));
        } else {
            string = PoseidonUtils.getInstallationDirectory().getAbsolutePath() + File.separator + "lib";
        }
        String string2 = Services.getInstance().getConfiguration().getString(KEY_TEMPLATE_DIR);
        File file = new File(string2);
        if (!file.exists()) {
            return Files.getCanonicalPath((String)string);
        }
        return Files.getCanonicalPath((String)string2);
    }

    public static void setTemplateDir(String string) {
        if ((string = DialogController.B(string)) == null) {
            string = PoseidonUtils.isWebStart() ? PoseidonUtils.getInstallationDirectory().getAbsolutePath() : PoseidonUtils.getInstallationDirectory().getAbsolutePath() + File.separator + "lib";
        }
        Services.getInstance().getConfiguration().put(KEY_TEMPLATE_DIR, Files.getCanonicalPath((String)string));
    }

    private boolean A(String string) {
        boolean bl = DialogController.B(string) != null;
        return bl;
    }

    private static String B(String string) {
        TemplateTester templateTester = BuildProperties.isTemplateUnencrypted() ? new B() : new F();
        string = templateTester.validate(string);
        return string;
    }

    public static void resetTemplateDir() {
        String string = PoseidonUtils.getInstallationDirectory().getAbsolutePath() + File.separator + "lib";
        Services.getInstance().getConfiguration().put(KEY_TEMPLATE_DIR, Files.getCanonicalPath((String)string));
    }

    public static boolean getShowProgressBar() {
        return Services.getInstance().getConfiguration().getBoolean(KEY_SHOW_PROGRESSBAR, false);
    }

    public static void setShowProgessBar(boolean bl) {
        Services.getInstance().getConfiguration().putBoolean(KEY_SHOW_PROGRESSBAR, bl);
    }

    public static boolean getDoCompilation() {
        return Services.getInstance().getConfiguration().getBoolean(KEY_COMPILE, false);
    }

    public static void setDoCompilation(boolean bl) {
        Services.getInstance().getConfiguration().putBoolean(KEY_COMPILE, bl);
    }

    public static CheckNode getTreeRoot() {
        return DialogController.createTree();
    }

    public static CheckNode getTreeRoot(String string) {
        return DialogController.createTree(string);
    }

    public void transferSettings(String string) {
        this.transferLanguage(string);
        Iterator iterator = this.G.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = this.getLanguageKey(string2);
            if (string3 == null) {
                string3 = string2;
            }
            Iterator iterator2 = ((List)this.G.get(string2)).iterator();
            while (iterator2.hasNext()) {
                JToggleButton jToggleButton = (JToggleButton)iterator2.next();
                if ("".equals(jToggleButton.getName()) || (string2 + ".basic").equalsIgnoreCase(jToggleButton.getName())) continue;
                String string4 = Services.getInstance().getConfiguration().makeKey(CODE_GEN_KEY, string3, jToggleButton.getName());
                Services.getInstance().getConfiguration().putBoolean(string4, jToggleButton.isSelected());
            }
        }
        GeneratorFactory.getInstance().updateConfiguration();
    }

    public void transferLanguage(String string) {
        Services services = Services.getInstance();
        Configuration configuration = services.getConfiguration();
        String string2 = configuration.makeKey(CODE_GEN_KEY, "language");
        String string3 = configuration.getString(string2);
        configuration.put(string2, string);
        String string4 = configuration.makeKey(CODE_GEN_KEY, string3, "generate");
        configuration.putBoolean(string4, false);
        this.resetSubSettings(string);
        String string5 = configuration.makeKey(CODE_GEN_KEY, string, "generate");
        configuration.putBoolean(string5, true);
        this.transferSubSettings(string);
    }

    protected void transferSubSettings(String string) {
        List list = this.getSubBoxes(string);
        if (list == null) {
            return;
        }
        Iterator iterator = list.iterator();
        Services services = Services.getInstance();
        Configuration configuration = services.getConfiguration();
        while (iterator.hasNext()) {
            JToggleButton jToggleButton = (JToggleButton)iterator.next();
            if (!(jToggleButton instanceof JRadioButton)) continue;
            String string2 = this.getLanguageKey(string);
            if (!jToggleButton.isSelected() || jToggleButton.getName().equals(string2 + ".basic")) continue;
            String string3 = configuration.makeKey(CODE_GEN_KEY, string2, "generate");
            configuration.putBoolean(string3, false);
            String string4 = configuration.makeKey(CODE_GEN_KEY, string2, jToggleButton.getName(), "generate");
            configuration.putBoolean(string4, true);
        }
    }

    protected void resetSubSettings(String string) {
        List list = this.getSubBoxes(string);
        if (list == null) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            JToggleButton jToggleButton = (JToggleButton)iterator.next();
            if (!(jToggleButton instanceof JRadioButton) || jToggleButton.getName().equals(string + ".basic")) continue;
            String string2 = Services.getInstance().getConfiguration().makeKey(CODE_GEN_KEY, this.getLanguageKey(string), jToggleButton.getName(), "generate");
            Services.getInstance().getConfiguration().putBoolean(string2, false);
        }
    }

    public void generateCode(String string, CheckNode checkNode, final JTextArea jTextArea) {
        _A _A2 = jTextArea != null ? new _A(){

            public void A(String string) {
                jTextArea.append(string);
            }
        } : new _A(){

            public void A(String string) {
                System.out.println(string);
            }
        };
        String string2 = DialogController.getTemplateDir();
        if (checkNode == null) {
            return;
        }
        boolean bl = BuildProperties.getPoseidonEdition().compareTo(ProductEditionImpl.SE) == 1;
        _A2.A("TemplatePath: " + string2);
        if (bl && !this.A(string2)) {
            _A2.A("Template path is not valid!");
            return;
        }
        Enumeration<TreeNode> enumeration = checkNode.preorderEnumeration();
        List list = CollectionFactory.createArrayList();
        List list2 = CollectionFactory.createArrayList();
        while (enumeration.hasMoreElements()) {
            CheckNode checkNode2 = (CheckNode)enumeration.nextElement();
            if (checkNode2.getUserObject() instanceof Project) continue;
            if (checkNode2.isSelected()) {
                list.add(checkNode2.getUserObject());
                continue;
            }
            list2.add(checkNode2.getUserObject());
        }
        if (list.size() == 0) {
            _A2.A(Localizer.localize((ResourceId)GenerationResourceBundle.nothingToDo));
        } else {
            if (jTextArea != null) {
                jTextArea.setText("");
            }
            boolean bl2 = true;
            if (DialogController.getCleanDirectory()) {
                bl2 = this.A(string, list, list2, _A2);
            }
            if (!bl2) {
                _A2.A(Localizer.localize((ResourceId)GenerationResourceBundle.NothingGenerated));
                return;
            }
            GeneratorController generatorController = GeneratorFactory.getInstance().getGeneratorController();
            GeneratorFactory.getInstance().reloadMacros();
            if (generatorController == null) {
                _A2.A(Localizer.localize((ResourceId)GenerationResourceBundle.GeneratorNotAvailable));
            } else {
                generatorController.generateCode(list, checkNode, jTextArea);
            }
        }
    }

    private boolean A(String string, List list, List list2, _A _A2) {
        Object object;
        int n2;
        List list3;
        Object object2;
        boolean bl = false;
        String string2 = DialogController.getOutputDir(string);
        List list4 = GeneratorFactory.getInstance().getSourceExtensionList();
        String string3 = GeneratorFactory.getInstance().getCompiledExtension();
        list4.add(string3);
        List list5 = CollectionFactory.createArrayList();
        Iterator iterator = list4.iterator();
        while (iterator.hasNext()) {
            object2 = (String)iterator.next();
            list3 = Utils.getAllFilenames((File)new File(string2), (String)object2);
            list5.addAll(list3);
        }
        object2 = GeneratorFactory.getInstance().getGeneratorController().getGenerator();
        object2.initInternal();
        list3 = CollectionFactory.createArrayList();
        list3.addAll(list);
        list3.addAll(list2);
        for (n2 = 0; n2 < list3.size(); ++n2) {
            object = list3.get(n2);
            iterator = list4.iterator();
            while (iterator.hasNext()) {
                String string4 = object2.getPlainFilenameForElement(object, string2) + "." + iterator.next();
                list5.remove(string4);
            }
        }
        if (list5.size() == 0) {
            bl = true;
        } else {
            _A2.A(Localizer.localize((ResourceId)GenerationResourceBundle.FoundExistingFiles));
            for (n2 = 0; n2 < list5.size(); ++n2) {
                object = (String)list5.get(n2);
                _A2.A("  '" + object + "'\n");
            }
            Frame frame = PoseidonUIConnector.getApplicationWindow();
            boolean bl2 = Services.getInstance().getConfiguration().getBoolean(CLEAR_DESTINATION_FOLDER);
            int n3 = -1;
            if (!bl2) {
                n3 = SwingUtil.showConfirmDialog((Component)frame, (Object)Localizer.localize((ResourceId)GenerationResourceBundle.OtherFilesFound), (String)codeGenerationStr, (int)1, (int)2, (boolean)false, (String)CLEAR_DESTINATION_FOLDER, (String)Localizer.localize((ResourceId)GenerationResourceBundle.DoNotAskThisQuestionInFuture));
                boolean bl3 = bl2 = 0 == n3;
            }
            if (bl2) {
                _A2.A(Localizer.localize((ResourceId)GenerationResourceBundle.Deleting));
                for (int i2 = 0; i2 < list5.size(); ++i2) {
                    String string5 = (String)list5.get(i2);
                    _A2.A("  " + string5 + " ... ");
                    File file = new File(string5);
                    if (file.isFile()) {
                        if (file.delete()) {
                            _A2.A(Localizer.localize((ResourceId)GenerationResourceBundle.done));
                            continue;
                        }
                        _A2.A(Localizer.localize((ResourceId)GenerationResourceBundle.ErrorLeavingItThere));
                        continue;
                    }
                    Utils.deleteDir((File)file);
                }
                bl = true;
            } else if (n3 == 1) {
                bl = true;
            }
        }
        return bl;
    }

    private DialogController() {
        this.A.put("Java", "java");
        this.A.put("C++", "cpp");
        this.A.put("C#", "csharp");
    }

    public Set getLanguageNamesSet() {
        return this.F.keySet();
    }

    public String getLanguageKey(String string) {
        return (String)this.A.get(string);
    }

    public String getLanguageName(String string) {
        return (String)this.F.get(string);
    }

    public ResourceId getLanguageResourceId(String string) {
        return (ResourceId)this.C.get(string);
    }

    public String getConfigurationCompatibleString(String string) {
        string.replace('.', '_');
        string.replace('=', '_');
        return string.toLowerCase();
    }

    public static DialogController getInstance() {
        if (B == null) {
            B = new DialogController();
        }
        return B;
    }

    public static CheckNode createTree() {
        PoseidonApplicationState poseidonApplicationState = PoseidonApplicationState.getInstance();
        PoseidonProject poseidonProject = poseidonApplicationState.getCurrentProject();
        GeneratorFactory generatorFactory = GeneratorFactory.getInstance();
        GeneratorController generatorController = generatorFactory.getGeneratorController();
        if (generatorController == null) {
            D.error((Object)"internal confusion: no GeneratorController set", (Throwable)new Exception());
            return null;
        }
        TreeRenderingStrategy treeRenderingStrategy = generatorController.getTreeRenderingStrategy();
        if (!treeRenderingStrategy.isTreeElement(poseidonProject)) {
            D.debug((Object)"[DialogController] project not wanted");
            return null;
        }
        CheckNode checkNode = DialogController.A(poseidonProject, treeRenderingStrategy);
        return checkNode;
    }

    public static CheckNode createTree(String string) {
        PoseidonApplicationState poseidonApplicationState = PoseidonApplicationState.getInstance();
        PoseidonProject poseidonProject = poseidonApplicationState.getCurrentProject();
        GeneratorFactory generatorFactory = GeneratorFactory.getInstance();
        GeneratorController generatorController = generatorFactory.getGeneratorController(string);
        if (generatorController == null) {
            D.error((Object)"internal confusion: no GeneratorController set", (Throwable)new Exception());
            return null;
        }
        TreeRenderingStrategy treeRenderingStrategy = generatorController.getTreeRenderingStrategy();
        if (!treeRenderingStrategy.isTreeElement(poseidonProject)) {
            D.debug((Object)"[DialogController] project not wanted");
            return null;
        }
        CheckNode checkNode = DialogController.A(poseidonProject, treeRenderingStrategy);
        return checkNode;
    }

    private static CheckNode A(Object object, TreeRenderingStrategy treeRenderingStrategy) {
        CheckNode checkNode = new CheckNode(object);
        Collection collection = treeRenderingStrategy.getChildren(object);
        if (collection != null && collection.size() > 0) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                boolean bl = treeRenderingStrategy.isTreeElement(e2);
                if (!bl) continue;
                CheckNode checkNode2 = DialogController.A(e2, treeRenderingStrategy);
                checkNode.add(checkNode2);
            }
        }
        return checkNode;
    }

    static {
        Services services = Services.getInstance();
        Configuration configuration = services.getConfiguration();
        KEY_CLEAR_OUTPUTDIR = configuration.makeKey(CODE_GEN_KEY, "cleanDirectory");
        KEY_SHOW_PROGRESSBAR = configuration.makeKey(CODE_GEN_KEY, "showProgressBar");
        KEY_COMPILE = configuration.makeKey(CODE_GEN_KEY, "compile");
        String string = BuildProperties.getVersionString();
        KEY_TEMPLATE_DIR = configuration.makeKey(CODE_GEN_KEY, "templateFolder_" + string);
        DOCUMENT_AUTHORS = configuration.makeKey(CODE_GEN_KEY, E, DOCUMENT_AUTHORS_KEY);
        EXTERNAL_LINK_BASE = configuration.makeKey(CODE_GEN_KEY, E, EXTERNAL_LINK_BASE_KEY);
        GENERATE_EXTERNAL_LINKS = configuration.makeKey(CODE_GEN_KEY, E, GENERATE_EXTERNAL_LINKS_KEY);
        CLEAR_DESTINATION_FOLDER = configuration.makeKey(CODE_GEN_KEY, E, CLEAR_DESTINATION_FOLDER_KEY);
        COPYRIGHT_UMLDOC = configuration.makeKey(CODE_GEN_KEY, E, COPYRIGHT_UMLDOC_KEY);
        REPAINT_ALL_DIAGRAMS = configuration.makeKey(CODE_GEN_KEY, E, REPAINT_ALL_DIAGRAMS_KEY);
    }

    static interface _A {
        public void A(String var1);
    }
}

