/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.poseidon.kernel;

import com.gentleware.jboogie.kernel.JBoogie;
import com.gentleware.jboogie.kernel.ProjectMember;
import com.gentleware.jboogie.kernel.ProjectMemberDefault;
import com.gentleware.jboogie.kernel.ProjectMemberManager;
import com.gentleware.jboogie.kernel.ProjectMemberReaderWriter;
import com.gentleware.openapi.jboogie.Project;
import com.gentleware.openapi.util.CollectionFactory;
import com.gentleware.openapi.util.Strings;
import com.gentleware.openapi.util.Utils;
import com.gentleware.poseidon.kernel.ProjectMemberReaderWriterDefault;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.log4j.Logger;

public class PoseidonProjectMemberManager
implements ProjectMemberManager {
    private static ProjectMemberManager A;
    private static final Logger B;
    private Map C = CollectionFactory.createHashMap();

    public static synchronized ProjectMemberManager getInstance() {
        if (A == null) {
            A = new PoseidonProjectMemberManager();
        }
        return A;
    }

    private PoseidonProjectMemberManager() {
        B.info((Object)"Poseidon Project Member Manager created");
    }

    public void addMemberReaderWriter(String string, ProjectMemberReaderWriter projectMemberReaderWriter) {
        this.C.put(string, projectMemberReaderWriter);
    }

    public void removeMemberReaderWriter(String string) {
        this.C.remove(string);
    }

    public Map getProjectMemberReaderWriters() {
        return this.C;
    }

    public Project getProject() {
        return JBoogie.getInstance().getCurrentProject();
    }

    public boolean addMember(ProjectMember projectMember) {
        boolean bl = false;
        if (null == projectMember || null == projectMember.getName() || null == projectMember.getNameWithExtension()) {
            return false;
        }
        ProjectMember projectMember2 = this.C(projectMember.getNameWithExtension());
        Project project = this.getProject();
        List list = project.getMembers();
        if (projectMember2 == null) {
            list.add(projectMember);
            bl = true;
        } else if (projectMember2.isDeleted()) {
            list.remove(projectMember2);
            list.add(projectMember);
            bl = true;
        }
        return bl;
    }

    public boolean removeMember(String string) {
        List list = this.getProject().getMembers();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ProjectMember projectMember = (ProjectMember)iterator.next();
            String string2 = projectMember.getNameWithExtension();
            if (!string2.equals(string)) continue;
            projectMember.setDeleted(true);
            return true;
        }
        return false;
    }

    public List getMembersNamesByType(String string, boolean bl) {
        List list = CollectionFactory.createArrayList();
        List list2 = this.getAllMembersNames();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = string2.substring(string2.lastIndexOf(".") + 1);
            if (!string3.equals(string)) continue;
            if (bl) {
                list.add(string2);
                continue;
            }
            list.add(string2.substring(0, string2.lastIndexOf(".")));
        }
        return list;
    }

    public List getAllMembersNames() {
        String string;
        Object object;
        Set set = CollectionFactory.createHashSet();
        Set set2 = CollectionFactory.createHashSet();
        List list = this.A();
        List list2 = this.getProject().getMembers();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            object = (ProjectMember)iterator.next();
            string = object.getNameWithExtension();
            set2.add(object.getType());
            if (object.isDeleted()) continue;
            set.add(string);
        }
        iterator = list.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            string = ((String)object).substring(((String)object).lastIndexOf(".") + 1);
            if (!set2.contains(string)) continue;
            iterator.remove();
        }
        set.addAll(list);
        return CollectionFactory.createArrayList((Collection)set);
    }

    public ProjectMember getMember(String string, String string2) {
        ProjectMember projectMember = this.A(string, string2);
        boolean bl = this.D(string2);
        if (null == projectMember) {
            if (bl) {
                return null;
            }
            List list = this.getMembersNamesByType(string2, false);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                this.B(string3, string2);
            }
            projectMember = this.A(string, string2);
        } else {
            if (projectMember.isDeleted()) {
                return null;
            }
            ProjectMemberReaderWriter projectMemberReaderWriter = (ProjectMemberReaderWriter)this.getProjectMemberReaderWriters().get(string2);
            if (projectMember instanceof ProjectMemberDefault && projectMemberReaderWriter != null) {
                Object object;
                Object object2 = this.getProject().getMembers().iterator();
                while (object2.hasNext()) {
                    object = (ProjectMember)object2.next();
                    if (!object.getType().equals(string2)) continue;
                    object2.remove();
                }
                object2 = this.getMembersNamesByType(string2, false);
                object = object2.iterator();
                while (object.hasNext()) {
                    String string4 = (String)object.next();
                    try {
                        ProjectMember projectMember2 = projectMemberReaderWriter.loadMember(string4, null, this.getProject());
                        if (!projectMember2.getName().equals(string)) continue;
                        projectMember = projectMember2;
                    }
                    catch (Exception exception) {
                        B.error((Object)("Cannot load member " + string + "." + string2 + " to project"));
                    }
                }
            }
        }
        return projectMember;
    }

    public boolean changeMemberName(ProjectMember projectMember, String string) {
        ProjectMember projectMember2 = this.A(string, projectMember.getType());
        if (projectMember2 != null) {
            if (projectMember2.isDeleted()) {
                this.getProject().getMembers().remove(projectMember2);
            } else {
                return false;
            }
        }
        projectMember.setName(string);
        return true;
    }

    private boolean D(String string) {
        List list = this.getProject().getMembers();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ProjectMember projectMember = (ProjectMember)iterator.next();
            String string2 = projectMember.getType();
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private ProjectMember B(String string, String string2) {
        ProjectMember projectMember = null;
        String string3 = string + '.' + string2;
        if (!this.B(string3)) {
            return null;
        }
        ProjectMemberReaderWriter projectMemberReaderWriter = (ProjectMemberReaderWriter)this.getProjectMemberReaderWriters().get(string2);
        if (projectMemberReaderWriter == null) {
            projectMemberReaderWriter = new ProjectMemberReaderWriterDefault();
            string = string3;
        }
        BufferedInputStream bufferedInputStream = this.A(string3);
        try {
            projectMember = projectMemberReaderWriter.loadMember(string, (InputStream)bufferedInputStream, this.getProject());
        }
        catch (Exception exception) {
            B.error((Object)("Project member not found " + string3), (Throwable)exception);
        }
        return projectMember;
    }

    private ProjectMember A(String string, String string2) {
        List list = this.getProject().getMembers();
        ProjectMember projectMember = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ProjectMember projectMember2 = (ProjectMember)iterator.next();
            if (!projectMember2.getName().equals(string) || !projectMember2.getType().equalsIgnoreCase(string2)) continue;
            projectMember = projectMember2;
            break;
        }
        return projectMember;
    }

    public BufferedInputStream getMemberContentFromProjectFile(String string, String string2) {
        ProjectMember projectMember = this.A(string, string2);
        if (projectMember != null && projectMember.isDeleted()) {
            B.warn((Object)"You are trying to get the member content for the member which is marked as deleted. This action is forbidden!");
            return null;
        }
        return this.A(string + '.' + string2);
    }

    private ProjectMember C(String string) {
        List list = this.getProject().getMembers();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ProjectMember projectMember = (ProjectMember)iterator.next();
            if (!projectMember.getNameWithExtension().equals(string)) continue;
            return projectMember;
        }
        return null;
    }

    private List A() {
        String string;
        BufferedInputStream bufferedInputStream;
        List list = CollectionFactory.createArrayList();
        if (this.getProject().getUrl() != null && (bufferedInputStream = this.E(string = this.B())) != null) {
            ZipInputStream zipInputStream = null;
            try {
                zipInputStream = new ZipInputStream(bufferedInputStream);
            }
            catch (Exception exception) {
                B.error((Object)("Some errors occured while reading zip file: " + string), (Throwable)exception);
            }
            if (zipInputStream != null) {
                try {
                    ZipEntry zipEntry = zipInputStream.getNextEntry();
                    while (zipEntry != null) {
                        String string2 = zipEntry.getName();
                        if (!string2.endsWith(".proj3")) {
                            list.add(string2);
                        }
                        zipEntry = zipInputStream.getNextEntry();
                    }
                    zipInputStream.close();
                }
                catch (IOException iOException) {
                    B.error((Object)("Some errors occured while reading zip file: " + string), (Throwable)iOException);
                }
            }
        }
        return list;
    }

    private List A(String string, boolean bl) throws IOException {
        List list = CollectionFactory.createArrayList();
        if (this.getProject().getUrl() == null) {
            return CollectionFactory.createArrayList();
        }
        String string2 = this.B();
        String string3 = '.' + string;
        ZipInputStream zipInputStream = new ZipInputStream(this.E(string2));
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        while (zipEntry != null) {
            String string4 = zipEntry.getName();
            if (string4.endsWith(string3)) {
                if (!bl) {
                    string4 = string4.substring(0, string4.length() - string3.length());
                }
                list.add(string4);
            }
            zipEntry = zipInputStream.getNextEntry();
        }
        zipInputStream.close();
        return list;
    }

    private BufferedInputStream E(String string) {
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(new File(string)));
        }
        catch (FileNotFoundException fileNotFoundException) {
            B.error((Object)("File not found: " + string), (Throwable)fileNotFoundException);
        }
        return bufferedInputStream;
    }

    private BufferedInputStream A(String string) {
        if (!this.B(string)) {
            return null;
        }
        String string2 = this.B();
        ZipInputStream zipInputStream = new ZipInputStream(this.E(string2));
        BufferedInputStream bufferedInputStream = null;
        try {
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                if (zipEntry.getName().equals(string)) {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    int n2 = 32768;
                    byte[] byArray = new byte[32768];
                    int n3 = zipInputStream.read(byArray, 0, 32768);
                    while (n3 > 0) {
                        byteArrayOutputStream.write(byArray, 0, n3);
                        n3 = zipInputStream.read(byArray, 0, 32768);
                    }
                    byte[] byArray2 = byteArrayOutputStream.toByteArray();
                    byteArrayOutputStream.close();
                    bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(byArray2));
                    break;
                }
                zipEntry = zipInputStream.getNextEntry();
            }
            zipInputStream.close();
        }
        catch (IOException iOException) {
            B.error((Object)("Some errors occured while reading zip file: " + string2), (Throwable)iOException);
        }
        return bufferedInputStream;
    }

    private String B() {
        return Utils.urlToFile((URL)this.getProject().getUrl()).getPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean B(String string) {
        if (Strings.isEmpty((String)string)) {
            return false;
        }
        String string2 = this.B();
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(string2);
            if (zipFile.getEntry(string) != null) {
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException iOException) {
            B.error((Object)("Some errors occured while reading zip file: " + string2), (Throwable)iOException);
        }
        finally {
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (IOException iOException) {
                B.error((Object)("Some errors occured while reading zip file: " + string2), (Throwable)iOException);
            }
        }
        return false;
    }

    public void cleanUpDeletedMembers() {
        List list = this.getProject().getMembers();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ProjectMember projectMember = (ProjectMember)iterator.next();
            if (!projectMember.isDeleted()) continue;
            iterator.remove();
        }
    }

    static {
        B = Logger.getLogger((String)"com.gentleware.poseidon.kernel.PoseidonProjectMemberManager");
    }
}

