/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.poseidon.kernel.settings;

import com.gentleware.openapi.configuration.Configuration;
import com.gentleware.poseidon.kernel.PoseidonProject;
import com.gentleware.poseidon.kernel.settings.CustomConfigurationSettings;

public class CustomMDLImportSettings
extends CustomConfigurationSettings {
    private static final String F = "mdlimportsettings/show_classifier_packages";
    private static final String H = "mdlimportsettings/create_diagrams";
    private static final String G = "mdlimportsettings/generate_root_view_nodes";
    private static final String J = "mdlimportsettings/scaling_factor";
    private static final String I = "mdlimportsettings/use_default_size_of_object";

    public CustomMDLImportSettings(PoseidonProject poseidonProject) {
        this.setProject(poseidonProject);
        this.resetToDefaults();
    }

    public CustomMDLImportSettings(PoseidonProject poseidonProject, String string, String string2, String string3, String string4) {
        this.setProject(poseidonProject);
        this.setShowClassifierPackages(string);
        this.setCreateDiagrams(string2);
        this.setGenerateRootViewNodes(string3);
        this.setScalingFactor(string4);
        this.setUseDefaultSizeOfObject(false);
    }

    public String getShowClassifierPackages() {
        return this.getConfiguration().getString(F);
    }

    public boolean isShowClassifierPackage() {
        return this.getConfiguration().getBoolean(F);
    }

    public void setShowClassifierPackages(String string) {
        this.getConfiguration().putString(F, string);
    }

    public void setShowClassifierPackages(boolean bl) {
        this.getConfiguration().putBoolean(F, bl);
    }

    public String getCreateDiagrams() {
        return this.getConfiguration().getString(H);
    }

    public boolean isCreateDiagrams() {
        return this.getConfiguration().getBoolean(H);
    }

    public void setCreateDiagrams(String string) {
        this.getConfiguration().putString(H, string);
    }

    public void setCreateDiagrams(boolean bl) {
        this.getConfiguration().putBoolean(H, bl);
    }

    public String getGenerateRootViewNodes() {
        return this.getConfiguration().getString(G);
    }

    public boolean isGenerateRootViewNodes() {
        return this.getConfiguration().getBoolean(G);
    }

    public void setGenerateRootViewNodes(String string) {
        this.getConfiguration().putString(G, string);
    }

    public void setGenerateRootViewNodes(boolean bl) {
        this.getConfiguration().putBoolean(G, bl);
    }

    public String getScalingFactor() {
        return this.getConfiguration().getString(J);
    }

    public void setScalingFactor(String string) {
        this.getConfiguration().putString(J, string);
    }

    public int getScalingFactorInt() {
        return this.getConfiguration().getInteger(J);
    }

    public void setScalingFactorInt(int n2) {
        this.getConfiguration().putInteger(J, n2);
    }

    public boolean isUseDefaultSizeOfObject() {
        return this.getConfiguration().getBoolean(I);
    }

    public void setUseDefaultSizeOfObject(boolean bl) {
        this.getConfiguration().putBoolean(I, bl);
    }

    public void saveAsDefault() {
        Configuration configuration = this.getApplicationConfiguration();
        configuration.putBoolean(F, this.isShowClassifierPackage());
        configuration.putBoolean(H, this.isCreateDiagrams());
        configuration.putBoolean(G, this.isGenerateRootViewNodes());
        configuration.putBoolean(I, this.isUseDefaultSizeOfObject());
        configuration.putInteger(J, this.getScalingFactorInt());
    }

    public void resetToDefaults() {
        Configuration configuration = this.getApplicationConfiguration();
        this.setShowClassifierPackages(configuration.getBoolean(F, false));
        this.setCreateDiagrams(configuration.getBoolean(H, true));
        this.setGenerateRootViewNodes(configuration.getBoolean(G, false));
        this.setUseDefaultSizeOfObject(configuration.getBoolean(I, false));
        this.setScalingFactorInt(configuration.getInteger(J, 35));
    }
}

