/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.poseidon.license;

import com.gentleware.anvil.concurrent.ConcurrentLicenseCipherClient;
import com.gentleware.anvil.concurrent.ConcurrentLicenseServer;
import com.gentleware.anvil.kernel.LicenseData;
import com.gentleware.anvil.kernel.keymodel.KeyType;
import com.gentleware.anvil.kernel.keymodel.LicenseKey;
import com.gentleware.anvil.kernel.keymodel.TagAdditionalConcurrentLicenseInformation;
import com.gentleware.anvil.kernel.utils.LicenseException;
import com.gentleware.anvil.kernel.utils.LicenseUtils;
import com.gentleware.locksmith.client.LicenseKeys;
import com.gentleware.openapi.configuration.Configuration;
import com.gentleware.openapi.configuration.Services;
import com.gentleware.openapi.util.BuildPropertiesBasic;
import com.gentleware.openapi.util.CollectionFactory;
import com.gentleware.openapi.util.Strings;
import com.gentleware.poseidon.BuildProperties;
import com.gentleware.poseidon.license.B;
import com.gentleware.poseidon.ui.ExitHandler;
import com.gentleware.poseidon.util.PoseidonUtils;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;

public class ConcurrentLicenseClient {
    private static final Logger N = Logger.getLogger((String)"com.gentleware.poseidon.license.ConcurrentLicenseClient");
    private String Q;
    private String C;
    private ConcurrentLicenseServer O;
    private LicenseKey J;
    private String K;
    private long P;
    private long L;
    private LicenseData G;
    private final Object M = new Object();
    private boolean H;
    private _A A;
    private Timer D = new Timer();
    private static boolean B = ConcurrentLicenseClient.H();
    protected static Map _licenseData2FloatingLicenseClient = CollectionFactory.createHashMap();
    private boolean F;
    private B E;
    public static long REQUEST_LICENSE_PERIOD = 1800000L;
    public static String OFFLINE_FLOATING_LICENSE_RING_FILE_NAME = "offline-floating-license-keys.txt";
    private String R;
    private VetoableChangeListener I = new VetoableChangeListener(){

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) {
            if ("AppClosed".equals(propertyChangeEvent.getPropertyName())) {
                while (ConcurrentLicenseClient.this.A.D()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        N.error((Object)interruptedException);
                    }
                }
                ConcurrentLicenseClient.this.A.cancel();
                ExitHandler.getInstance().acknowledgeExit();
            }
        }
    };

    public static synchronized ConcurrentLicenseClient getInstance(LicenseData licenseData) throws LicenseException {
        ConcurrentLicenseClient concurrentLicenseClient = (ConcurrentLicenseClient)_licenseData2FloatingLicenseClient.get(licenseData);
        if (concurrentLicenseClient == null) {
            concurrentLicenseClient = ConcurrentLicenseClient.A(licenseData);
        }
        return concurrentLicenseClient;
    }

    public static synchronized ConcurrentLicenseClient getInstance() throws LicenseException {
        LicenseData licenseData = LicenseKeys.getInstance().getPoseidonLicenseData(BuildProperties.getPoseidonProduct());
        ConcurrentLicenseClient concurrentLicenseClient = (ConcurrentLicenseClient)_licenseData2FloatingLicenseClient.get(licenseData);
        if (concurrentLicenseClient == null) {
            concurrentLicenseClient = ConcurrentLicenseClient.A(licenseData);
        }
        return concurrentLicenseClient;
    }

    protected ConcurrentLicenseClient(LicenseData licenseData) throws LicenseException {
        this(licenseData, OFFLINE_FLOATING_LICENSE_RING_FILE_NAME);
    }

    protected ConcurrentLicenseClient(LicenseData licenseData, String string) throws LicenseException {
        this.G = licenseData;
        if (this.R == null) {
            this.R = PoseidonUtils.getConfigDir();
        }
        this.E = com.gentleware.poseidon.license.B.B(this.R, string);
        this.I();
    }

    public void setConfigDir(String string) {
        this.R = string;
    }

    private void I() {
        this.J = this.E.B(this.G);
        this.K = null;
        this.resetLicenseInformation();
        if (this.J != null) {
            this.K = this.J.getRsaAscii();
            this.E();
        }
    }

    private static ConcurrentLicenseClient A(LicenseData licenseData) throws LicenseException {
        ConcurrentLicenseClient concurrentLicenseClient = new ConcurrentLicenseClient(licenseData);
        _licenseData2FloatingLicenseClient.put(licenseData, concurrentLicenseClient);
        return concurrentLicenseClient;
    }

    String getHostNameOfFloatingLicenseServer() {
        return this.Q;
    }

    String getPort() {
        return this.C;
    }

    LicenseKey getLicenseContainerKey() {
        return this.J;
    }

    public Long getLicenseEndTime() {
        if (this.L == 0L) {
            return null;
        }
        return new Long(this.L);
    }

    public static void setRequestLicensePeriod_TEST_ONLY(long l2) {
        REQUEST_LICENSE_PERIOD = l2;
    }

    public void reloadFloatingServerRMIObject() throws MalformedURLException, NotBoundException, RemoteException {
        String string = this.getUrlToConcurrentLicenseServer();
        if (string == null) {
            return;
        }
        this.O = null;
        this.O = (ConcurrentLicenseServer)Naming.lookup(string);
        if (this.O != null) {
            N.info((Object)("Concurrent License Server RMI Information: " + this.O.toString()));
        }
    }

    String getUrlToConcurrentLicenseServer() {
        Configuration configuration = Services.getInstance().getConfiguration();
        this.Q = configuration.get(configuration.makeKey("floating/server/host"), "localhost");
        this.C = configuration.get(configuration.makeKey("floating/server/port"), "6262");
        if (Strings.isEmpty((String)this.Q) || Strings.isEmpty((String)this.C)) {
            N.error((Object)"Hostname and Port are empty or null.");
            return null;
        }
        String string = "//" + this.Q + ":" + this.C + "/" + "//www.gentleware.com/floating_license_server";
        return string;
    }

    public boolean isFloatingServerAvailable() {
        return this.O != null;
    }

    public boolean hasServerSameSoftwareVersion() {
        return this.H;
    }

    private void A(boolean bl) {
        this.H = bl;
    }

    private void D() {
        this.O = null;
        this.K = null;
    }

    private boolean G() throws RemoteException {
        String string;
        String string2 = BuildPropertiesBasic.getVersionString();
        try {
            string = this.O.getSoftwareVersion();
        }
        catch (RemoteException remoteException) {
            this.A(false);
            throw remoteException;
        }
        boolean bl = this.A(string2, string);
        this.A(bl);
        if (!this.hasServerSameSoftwareVersion()) {
            N.error((Object)("Server-version (" + string + ") and client-version (" + string2 + ") do not match!"));
            this.D();
        }
        return this.H;
    }

    private boolean A(String string, String string2) {
        String string3;
        if (Strings.isEmpty((String)string) || Strings.isEmpty((String)string2)) {
            N.error((Object)("One of the Product-Versions does not have the correct format: " + string + " , " + string2));
            return false;
        }
        String string4 = string.substring(0, string.lastIndexOf("."));
        if (string4.equals(string3 = string2.substring(0, string2.lastIndexOf(".")))) {
            if (!string.equals(string2)) {
                N.warn((Object)("The Micro-Version differs: client " + string + " server " + string2 + "."));
            }
            return true;
        }
        return false;
    }

    public boolean licenseAvailable(boolean bl) {
        boolean bl2;
        boolean bl3;
        if (bl && ConcurrentLicenseClient.isInEvaluationPeriod()) {
            return true;
        }
        if (this.A == null) {
            this.A();
        }
        if (bl3 = this.isFloatingServerAvailable()) {
            if (!this.hasServerSameSoftwareVersion()) {
                return false;
            }
        } else {
            this.I();
        }
        if (!(bl2 = this.C())) {
            this.resetTimer();
            this.A();
            bl2 = this.C();
            if (!bl2) {
                this.E.removeKey(this.J);
            }
        }
        return bl2;
    }

    private void A() {
        this.A = new _A();
        double d2 = this.B();
        this.D.scheduleAtFixedRate((TimerTask)this.A, (long)d2, (long)d2);
        ExitHandler exitHandler = ExitHandler.getInstance();
        exitHandler.addVetoableChangeListener(this.I);
        this.A.run();
    }

    private double B() {
        return (double)REQUEST_LICENSE_PERIOD * 0.8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean C() {
        boolean bl;
        long l2 = System.currentTimeMillis();
        Object object = this.M;
        synchronized (object) {
            boolean bl2 = l2 >= this.P;
            boolean bl3 = l2 <= this.L;
            bl = bl2 && bl3;
        }
        return bl;
    }

    private boolean F() {
        boolean bl = this.E.B(this.G, this.J);
        if (!bl) {
            N.error((Object)"Renewing local license key fails. License is returned to server");
            this.returnLicenseToFloatingLicenseServer();
        }
        return bl;
    }

    public boolean ping() throws MalformedURLException, NotBoundException, RemoteException {
        if (this.O == null) {
            this.reloadFloatingServerRMIObject();
        }
        if (!this.isFloatingServerAvailable()) {
            N.error((Object)"Concurrent Server not available");
            return false;
        }
        this.O.ping();
        return true;
    }

    public void shutdownFloatingLicenseServer() throws MalformedURLException, NotBoundException, RemoteException {
        if (!this.isFloatingServerAvailable()) {
            this.reloadFloatingServerRMIObject();
        }
        this.returnLicenseToFloatingLicenseServer();
        this.O.shutdown();
    }

    LicenseData getLicenseData() {
        return this.G;
    }

    protected void returnLicenseToFloatingLicenseServer() {
        try {
            if (ConcurrentLicenseClient.isInEvaluationPeriod()) {
                return;
            }
            if (this.K != null) {
                if (!this.isFloatingServerAvailable()) {
                    this.reloadFloatingServerRMIObject();
                }
                this.O.returnLicense(this.K);
                this.E.removeKey(this.J);
            }
            this.resetLicenseInformation();
            this.resetTimer();
        }
        catch (RemoteException remoteException) {
            N.error((Object)"Error returning license", (Throwable)remoteException);
        }
        catch (MalformedURLException malformedURLException) {
            N.error((Object)"Error returning license", (Throwable)malformedURLException);
        }
        catch (NotBoundException notBoundException) {
            N.error((Object)"Error returning license", (Throwable)notBoundException);
        }
    }

    void resetTimer() {
        this.K = null;
        this.J = null;
        if (this.A != null) {
            this.A.cancel();
            this.A = null;
            ExitHandler.getInstance().removeVetoableChangeListener(this.I);
        }
        if (this.D != null) {
            this.D.cancel();
            this.D = new Timer();
        }
    }

    public static boolean isInEvaluationPeriod() {
        return B;
    }

    public static void setInEvaluationPeriod(boolean bl) {
        B = bl;
    }

    private static boolean H() {
        if (!BuildProperties.getPoseidonEdition().isTeamAware()) {
            return false;
        }
        Configuration configuration = Services.getInstance().getConfiguration();
        String string = configuration.makeKey("version.Uid.key");
        String string2 = configuration.getDecrypted(string);
        Date date = new Date();
        if (!Strings.isEmpty((String)string2)) {
            long l2 = Long.parseLong(string2);
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTimeInMillis(l2);
            gregorianCalendar.add(5, 3);
            return gregorianCalendar.getTimeInMillis() > date.getTime();
        }
        Long l3 = new Long(date.getTime());
        configuration.putEncrypted(string, l3.toString());
        return true;
    }

    public static ConcurrentLicenseClient clearInstanceVariable_TEST_ONLY(LicenseData licenseData) {
        ConcurrentLicenseClient concurrentLicenseClient = (ConcurrentLicenseClient)_licenseData2FloatingLicenseClient.remove(licenseData);
        return concurrentLicenseClient;
    }

    public static void clearInstance_TEST_ONLY() {
        ConcurrentLicenseClient.returnAllLicenses();
        _licenseData2FloatingLicenseClient.clear();
    }

    public boolean hasEvaluationLicense() {
        return this.K != null && this.F;
    }

    public static void returnAllLicenses() {
        Collection collection = _licenseData2FloatingLicenseClient.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ConcurrentLicenseClient concurrentLicenseClient = (ConcurrentLicenseClient)iterator.next();
            concurrentLicenseClient.returnLicenseToFloatingLicenseServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void E() {
        Object object;
        if (this.J == null || this.K == null) {
            N.error((Object)"Can' set license information. I return.");
            return;
        }
        TagAdditionalConcurrentLicenseInformation tagAdditionalConcurrentLicenseInformation = LicenseUtils.getAdditionalConcurrentLicenseInformation((LicenseKey)this.J);
        LicenseKey licenseKey = LicenseUtils.getConcurrentKey((LicenseKey)this.J);
        if (licenseKey != null) {
            object = licenseKey.getType();
            this.F = KeyType.EVALUATION.equals(object);
        }
        object = this.M;
        synchronized (object) {
            this.P = tagAdditionalConcurrentLicenseInformation.getStartTimeMilliseconds();
            this.L = tagAdditionalConcurrentLicenseInformation.getEndTimeMilliseconds();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetLicenseInformation() {
        Object object = this.M;
        synchronized (object) {
            this.P = 0L;
            this.L = 0L;
        }
    }

    private class _A
    extends TimerTask {
        long B;
        long C;
        volatile boolean A;

        protected _A() {
        }

        public boolean D() {
            return this.A;
        }

        public void run() {
            try {
                this.A = true;
                this.A();
                this.B = System.currentTimeMillis();
                this.B();
                this.A = false;
            }
            catch (RemoteException remoteException) {
                N.info((Object)("Concurrent license server is not available: " + remoteException.getMessage()));
                this.A = false;
            }
        }

        private long A() {
            double d2;
            long l2 = System.currentTimeMillis() - this.B;
            if ((double)l2 * 1.1 < (d2 = ConcurrentLicenseClient.this.B())) {
                long l3 = l2 / 1000L;
                long l4 = l2 - l3 * 1000L;
                N.info((Object)("differenceBetweenNowAndLastCall < REQUEST_LICENSE_PERIOD! difference in s: " + l3 + "." + l4));
                ++this.C;
            } else {
                long l5 = this.C = this.C < 0L ? 0L : this.C - 1L;
            }
            if (this.C >= 10L) {
                this.C = 0L;
                N.error((Object)"Timer is going wild... I cancel it.");
                ConcurrentLicenseClient.this.A = null;
                ConcurrentLicenseClient.this.D.cancel();
                ConcurrentLicenseClient.this.D = new Timer();
            }
            return l2;
        }

        public boolean cancel() {
            ConcurrentLicenseClient.this.A = null;
            return super.cancel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void B() throws RemoteException {
            this.C();
            if (ConcurrentLicenseClient.this.O == null) {
                return;
            }
            ConcurrentLicenseClient.this.G.setDate(new Date());
            try {
                if (!ConcurrentLicenseClient.this.G()) {
                    return;
                }
                Object object = ConcurrentLicenseClient.this.M;
                synchronized (object) {
                    ConcurrentLicenseClient.this.K = ConcurrentLicenseClient.this.O.requestLicense(ConcurrentLicenseClient.this.G, ConcurrentLicenseClient.this.K);
                    if (ConcurrentLicenseClient.this.K != null) {
                        ConcurrentLicenseCipherClient concurrentLicenseCipherClient = ConcurrentLicenseCipherClient.getInstance();
                        ConcurrentLicenseClient.this.J = concurrentLicenseCipherClient.decryptKeyFromServer(ConcurrentLicenseClient.this.K);
                        LicenseKey licenseKey = LicenseUtils.getConcurrentKey((LicenseKey)ConcurrentLicenseClient.this.J);
                        boolean bl = this.A(licenseKey);
                        if (bl) {
                            ConcurrentLicenseClient.this.E();
                        }
                    } else {
                        ConcurrentLicenseClient.this.resetLicenseInformation();
                    }
                }
            }
            catch (RemoteException remoteException) {
                N.warn((Object)"Cannot request license from server", (Throwable)remoteException);
                ConcurrentLicenseClient.this.D();
                throw remoteException;
            }
            catch (LicenseException licenseException) {
                ConcurrentLicenseClient.this.K = null;
                N.warn((Object)"Unable to decrypt key. Maybe the server is in evaluation period.");
            }
        }

        private boolean A(LicenseKey licenseKey) throws RemoteException {
            boolean bl;
            if (licenseKey != null) {
                bl = ConcurrentLicenseClient.this.F();
            } else {
                B = ConcurrentLicenseClient.this.O.isInEvaluationPeriod();
                bl = true;
            }
            return bl;
        }

        private void C() throws RemoteException {
            if (ConcurrentLicenseClient.this.O == null) {
                try {
                    ConcurrentLicenseClient.this.reloadFloatingServerRMIObject();
                }
                catch (MalformedURLException malformedURLException) {
                    N.error((Object)"Malformed URL of server.", (Throwable)malformedURLException);
                }
                catch (NotBoundException notBoundException) {
                    N.warn((Object)("Cannot connect to concurrent server: " + notBoundException.getClass().getName()));
                }
            }
        }
    }
}

