/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.poseidon.merging;

import com.gentleware.anvil.kernel.LicenseData;
import com.gentleware.anvil.kernel.ProductEditionImpl;
import com.gentleware.locksmith.client.LicenseChecker;
import com.gentleware.locksmith.client.LicenseKeys;
import com.gentleware.openapi.util.CollectionFactory;
import com.gentleware.poseidon.BuildProperties;
import com.gentleware.poseidon.kernel.PoseidonProject;
import com.gentleware.poseidon.merging.ProjectReaderWriter;
import java.util.Iterator;
import java.util.Map;

public class ProjectReaderWriterManager {
    private Map B = CollectionFactory.createHashMap();
    private static ProjectReaderWriterManager A = new ProjectReaderWriterManager();

    private ProjectReaderWriterManager() {
    }

    public static ProjectReaderWriterManager getInstance() {
        return A;
    }

    public void registerProjectReaderWriter(String string, ProjectReaderWriter projectReaderWriter) {
        if (!this.B.containsKey(string)) {
            this.B.put(string, projectReaderWriter);
        }
    }

    public void deregisterProjectReaderWriter(String string) {
        this.B.remove(string);
    }

    public void deregisterProjectReaderWriter(ProjectReaderWriter projectReaderWriter) {
        Iterator iterator = this.B.keySet().iterator();
        while (iterator.hasNext()) {
            Object k2 = iterator.next();
            if (!projectReaderWriter.equals(this.B.get(k2))) continue;
            this.deregisterProjectReaderWriter((String)k2);
        }
    }

    public ProjectReaderWriter getProjectReaderWriter(String string) {
        return (ProjectReaderWriter)this.B.get(string);
    }

    public boolean allowedToSave(PoseidonProject poseidonProject) {
        LicenseData licenseData = LicenseKeys.getInstance().getPoseidonLicenseData(BuildProperties.getPoseidonProduct());
        boolean bl = licenseData.getApplication().getEdition() == ProductEditionImpl.CE;
        boolean bl2 = LicenseChecker.getInstance().runsAsEvaluation(licenseData);
        boolean bl3 = poseidonProject.getDiagrams().size() > 8;
        return bl || !bl2 || !bl3;
    }
}

