/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.poseidon.model_management;

import com.gentleware.jboogie.util.JBoogieUtils;
import com.gentleware.mdr.MdrFacade;
import com.gentleware.mdr.ProjectTypeMdrFacade;
import com.gentleware.openapi.configuration.Configuration;
import com.gentleware.openapi.configuration.Services;
import com.gentleware.openapi.jboogie.Project;
import com.gentleware.openapi.swingx.Localizer;
import com.gentleware.openapi.swingx.ResourceId;
import com.gentleware.openapi.util.CollectionFactory;
import com.gentleware.poseidon.kernel.PoseidonProject;
import com.gentleware.poseidon.merging.LoadException;
import com.gentleware.poseidon.model_management.Profile;
import com.gentleware.poseidon.model_management.ProfileException;
import com.gentleware.poseidon.openapi.PoseidonUIConnector;
import com.gentleware.poseidon.ui.MenuResourceBundle;
import java.awt.Component;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefPackage;
import org.apache.log4j.Logger;

public abstract class ProfileRegistry {
    private static final Logger H = Logger.getLogger((String)"com.gentleware.poseidon.model_management.ProfileRegistry");
    public static final String LOADED_PROFILE_PROPERTY = "LoadedProfileProperty";
    public static final String ACTIVE_PROFILE_PROPERTY = "ActiveProfileProperty";
    public static final String DEACTIVATE_ALL_PROFILES = "DeactivateAllProfiles";
    private static final String F = "CustomProfile";
    private final PropertyChangeSupport B;
    private final Map I = CollectionFactory.createHashMap();
    private final Map D = CollectionFactory.createHashMap();
    private final Configuration G;
    private final RefPackage E;
    private final PoseidonProject C;
    private final String A;

    protected abstract Profile createProfile(String var1, String var2, PoseidonProject var3, ClassLoader var4, String var5, String var6, ResourceId var7);

    protected abstract String getProfileExtentPackageName();

    protected abstract RefPackage createProfileExtentPackage(String var1);

    protected abstract Collection getProfileExtentPackageModels();

    protected abstract boolean isTopLevelModel(RefObject var1);

    protected abstract void loadProfileIntoExtentPackage(PoseidonProject var1, InputStream var2, RefPackage var3) throws LoadException;

    public ProfileRegistry(PoseidonProject poseidonProject) {
        this.C = poseidonProject;
        this.C.setProfileProject(true);
        this.G = Services.getInstance().getConfiguration();
        this.A = this.G.makeKey(F);
        this.B = new PropertyChangeSupport(this);
        String string = this.getProfileExtentPackageName();
        this.E = this.B(string);
        this.A(this.A);
    }

    public final Profile getProfile(String string) throws ProfileException {
        if (!this.I.containsKey(string)) {
            throw new ProfileException("Profile not registered: " + string);
        }
        return (Profile)this.I.get(string);
    }

    public final boolean isRegistered(String string) {
        return this.I.containsKey(string);
    }

    public final Profile getProfileByModuleName(String string) {
        Collection collection = this.getRegisteredProfiles();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Profile profile = (Profile)iterator.next();
            String string2 = profile.getModuleName();
            if (string2 == null || !string2.equals(string)) continue;
            return profile;
        }
        return null;
    }

    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.B.addPropertyChangeListener(propertyChangeListener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.B.removePropertyChangeListener(propertyChangeListener);
    }

    public final void saveCustomProfilePathToConfiguration(String string) {
        String string2 = "";
        if (this.G.containsKey(this.A)) {
            string2 = this.G.getString(this.A);
        }
        string2 = string2 + string + File.pathSeparator;
        this.G.putString(this.A, string2);
    }

    public final void removeCustomProfilePathFromConfiguration(String string) {
        String string2 = this.G.getString(this.A);
        boolean bl = false;
        String string3 = "";
        int n2 = string2.indexOf(File.pathSeparator);
        while (0 != string2.length() && n2 > 0) {
            String string4 = string2.substring(0, n2);
            if (!string4.equals(string)) {
                string3 = string3 + string4 + File.pathSeparator;
            }
            string2 = string2.substring(n2 + 1, string2.length());
            n2 = string2.indexOf(File.pathSeparator);
        }
        this.G.putString(this.A, string3);
    }

    public final Collection getActiveProfiles() {
        Collection collection = this.getRegisteredProfiles();
        List list = CollectionFactory.createArrayList();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Profile profile = (Profile)iterator.next();
            if (!profile.isActive()) continue;
            list.add(profile);
        }
        return list;
    }

    public final void setProfileActive(String string, boolean bl) throws ProfileException {
        Profile profile = this.getProfile(string);
        if (bl && !profile.isLoaded()) {
            throw new ProfileException("Unable to activate profile \"" + string + "\" because it is not loaded yet.");
        }
        boolean bl2 = profile.isActive();
        if (bl2 != bl) {
            profile.setActive(bl);
            if (bl) {
                this.fireProfileChange(ACTIVE_PROFILE_PROPERTY, null, profile);
            } else {
                this.fireProfileChange(ACTIVE_PROFILE_PROPERTY, profile, null);
            }
        }
    }

    public final void deactivateAllProfiles() {
        List list = CollectionFactory.createArrayList((Collection)this.getActiveProfiles());
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Profile profile = (Profile)list.get(i2);
            profile.setActive(false);
            this.fireProfileChange(DEACTIVATE_ALL_PROFILES, profile, null);
        }
    }

    public final Collection getLoadedProfiles() {
        Collection collection = this.getRegisteredProfiles();
        List list = CollectionFactory.createArrayList();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Profile profile = (Profile)iterator.next();
            if (!profile.isLoaded()) continue;
            list.add(profile);
        }
        return list;
    }

    public final void loadProfile(String string) throws ProfileException {
        Profile profile = this.getProfile(string);
        boolean bl = profile.isLoaded();
        if (!bl) {
            Collection collection = this.getProfileExtentPackageModels();
            RefPackage refPackage = this.E;
            InputStream inputStream = profile.getLocationStream();
            try {
                this.loadProfileIntoExtentPackage(this.C, inputStream, refPackage);
                RefObject refObject = this.A(collection, string);
                profile.setProfileModel(refObject);
            }
            catch (LoadException loadException) {
                throw new ProfileException("Profile " + string + " (" + profile.getLocation() + ") is invalid and could not be loaded.", loadException);
            }
            this.fireProfileChange(LOADED_PROFILE_PROPERTY, null, profile);
        }
    }

    public final void unloadProfile(String string) throws ProfileException {
        Profile profile;
        try {
            profile = this.getProfile(string);
        }
        catch (ProfileException profileException) {
            throw new ProfileException("Unable to unload profile: Profile is not registered.", profileException);
        }
        boolean bl = profile.isLoaded();
        if (bl) {
            this.setProfileActive(string, false);
            RefObject refObject = profile.getProfileModel();
            if (refObject != null) {
                refObject.refDelete();
                profile.setProfileModel(null);
                this.fireProfileChange(LOADED_PROFILE_PROPERTY, profile, null);
            } else {
                H.warn((Object)("Possible bug in profile-handling (" + profile.getClass() + "): Profile signals to be loaded although it has no model."));
            }
        }
    }

    public final Collection getRegisteredProfiles() {
        return Collections.unmodifiableCollection(this.I.values());
    }

    public final boolean isRegistered(Profile profile) {
        return this.I.containsValue(profile);
    }

    public final synchronized void registerProfile(ResourceId resourceId, String string, String string2) throws ProfileException {
        this.registerProfile(resourceId, string, string2, null);
    }

    public final synchronized void registerProfile(ResourceId resourceId, String string, String string2, ClassLoader classLoader) throws ProfileException {
        this.registerProfile(resourceId, string, string2, classLoader, null, null);
    }

    public final synchronized void registerProfile(ResourceId resourceId, String string, String string2, ClassLoader classLoader, String string3) throws ProfileException {
        this.registerProfile(resourceId, string, string2, classLoader, string3, null);
    }

    public final synchronized void registerProfile(ResourceId resourceId, String string, String string2, ClassLoader classLoader, String string3, String string4) throws ProfileException {
        if (!this.isRegistered(string)) {
            if (resourceId == null) {
                H.warn((Object)("Could not register profile because of missing resource id: " + string));
                throw new ProfileException("Missing resource id for profile " + string);
            }
            Profile profile = this.createProfile(string, string2, this.C, classLoader, string3, string4, resourceId);
            this.I.put(string, profile);
            this.D.put(string, resourceId);
        }
    }

    public final synchronized void deregisterProfile(String string) {
        try {
            this.unloadProfile(string);
        }
        catch (ProfileException profileException) {
            H.warn((Object)"Error while unloading profile.", (Throwable)profileException);
        }
        this.I.remove(string);
        this.D.remove(string);
    }

    public final synchronized void deregisterAllProfiles() {
        List list = CollectionFactory.createArrayList(this.I.keySet());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.deregisterProfile(string);
        }
    }

    public final Project getProfileProject() {
        return this.C;
    }

    protected final RefPackage getProfileExtentPackage() {
        return this.E;
    }

    protected final void fireProfileChange(String string, Object object, Object object2) {
        this.B.firePropertyChange(new PropertyChangeEvent(this, string, object, object2));
    }

    private void A(String string) {
        if (this.G.containsKey(string)) {
            String string2 = this.G.getString(string);
            String string3 = File.pathSeparator;
            while (string2.length() != 0) {
                boolean bl;
                int n2 = string2.indexOf(string3);
                boolean bl2 = bl = n2 > 0;
                if (bl) {
                    String string4 = string2.substring(0, n2);
                    this.C(string4);
                }
                if (n2 >= 0) {
                    string2 = string2.substring(n2 + string3.length(), string2.length());
                    continue;
                }
                string2 = "";
            }
        }
    }

    private void C(String string) {
        int n2 = string.lastIndexOf("/");
        int n3 = string.lastIndexOf(".");
        String string2 = string.substring(n2 + 1, n3);
        try {
            ResourceId resourceId = (ResourceId)this.D.get(string2);
            this.registerProfile(resourceId, string2, string);
            this.loadProfile(string2);
        }
        catch (ProfileException profileException) {
            Frame frame = PoseidonUIConnector.getApplicationWindow();
            String string3 = Localizer.localize((ResourceId)MenuResourceBundle.MissingProfilePath);
            String string4 = Localizer.localize((ResourceId)MenuResourceBundle.MissingProfilePathText);
            String string5 = string4 + " " + string;
            boolean bl = false;
            JBoogieUtils.showMessageDialog((Component)frame, (Object)string5, (String)string3, (int)0);
            H.warn((Object)("Failed to load profile \"" + string + "\". Ignoring profile."), (Throwable)profileException);
            this.removeCustomProfilePathFromConfiguration(string);
        }
    }

    private RefPackage B(String string) {
        ProjectTypeMdrFacade projectTypeMdrFacade = this.C.getMdrFacade();
        MdrFacade mdrFacade = projectTypeMdrFacade.getRepositoryCreator();
        RefPackage refPackage = mdrFacade.getRepositoryExtent(string);
        if (refPackage == null) {
            refPackage = this.createProfileExtentPackage(string);
        }
        return refPackage;
    }

    private RefObject A(Collection collection, String string) {
        Collection collection2 = this.getProfileExtentPackageModels();
        RefObject refObject = null;
        Iterator iterator = collection2.iterator();
        while (iterator.hasNext()) {
            RefObject refObject2 = (RefObject)iterator.next();
            if (!this.isTopLevelModel(refObject2) || collection.contains(refObject2)) continue;
            if (refObject == null) {
                refObject = refObject2;
                continue;
            }
            H.warn((Object)("Profile \"" + string + "\" contained more than one top-level-model. Only using the first one."));
        }
        return refObject;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.E.refDelete();
    }
}

