/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.poseidon.openapi;

import com.gentleware.jboogie.kernel.ProjectImpl;
import com.gentleware.openapi.jboogie.DiCommandFactory;
import com.gentleware.openapi.jboogie.Project;
import com.gentleware.poseidon.jboogie.PoseidonApplicationState;
import com.gentleware.poseidon.kernel.PoseidonProject;
import com.gentleware.poseidon.model_management.MdrChangeListenerHelper;
import com.gentleware.poseidon.openapi.PoseidonUIConnector;
import com.gentleware.poseidon.ui.ActionExportProjectToXmi;
import com.gentleware.poseidon.ui.ActionSaveProject;
import com.gentleware.poseidon.util.PoseidonUtils;
import com.gentleware.poseidon.util.UmlFunctions;
import java.awt.Cursor;
import java.awt.Frame;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import javax.jmi.reflect.RefObject;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.netbeans.api.mdr.events.MDRChangeListener;

public final class PoseidonProjectConnector {
    private static final Logger A = Logger.getLogger((String)"com.gentleware.poseidon.openapi.PoseidonProjectConnector");

    private PoseidonProjectConnector() {
    }

    public static PoseidonProject getCurrentProject() {
        PoseidonProject poseidonProject = PoseidonApplicationState.getInstance().getCurrentProject();
        return poseidonProject;
    }

    public static boolean getNeedsSave() {
        PoseidonProject poseidonProject = PoseidonApplicationState.getInstance().getCurrentProject();
        if (poseidonProject != null) {
            return poseidonProject.needsSave();
        }
        return false;
    }

    public static URL getFile() {
        PoseidonProject poseidonProject = PoseidonApplicationState.getInstance().getCurrentProject();
        if (poseidonProject == null) {
            return null;
        }
        return poseidonProject.getUrl();
    }

    public static String getFilename() {
        PoseidonProject poseidonProject = PoseidonApplicationState.getInstance().getCurrentProject();
        return poseidonProject.getName() + ".zuml";
    }

    public static RefObject getModel() {
        PoseidonProject poseidonProject = PoseidonApplicationState.getInstance().getCurrentProject();
        if (poseidonProject == null) {
            return null;
        }
        return poseidonProject.getFirstModel();
    }

    public static Collection getModels() {
        PoseidonProject poseidonProject = PoseidonApplicationState.getInstance().getCurrentProject();
        if (poseidonProject == null) {
            return null;
        }
        return poseidonProject.getModels();
    }

    public static Project makeEmptyProject() {
        if (PoseidonUtils.checkProjectSaved()) {
            return PoseidonUtils.createEmptyProject("zuml");
        }
        return null;
    }

    public static void openProject(String string) {
        PoseidonProjectConnector.openProject(string, true);
    }

    public static void openProject(final String string, final boolean bl) {
        if (!PoseidonUtils.checkProjectSaved()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Frame frame = PoseidonUIConnector.getApplicationWindow();
                try {
                    if (ProjectImpl.isGuiMode()) {
                        frame.setCursor(Cursor.getPredefinedCursor(3));
                    }
                    UmlFunctions.openProjectFile(new File(string), bl);
                }
                finally {
                    if (ProjectImpl.isGuiMode()) {
                        frame.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
            }
        });
    }

    public static Collection getDiagrams() {
        PoseidonProject poseidonProject = PoseidonApplicationState.getInstance().getCurrentProject();
        if (poseidonProject == null) {
            return null;
        }
        return poseidonProject.getDiagrams();
    }

    public static void addMDRListener(RefObject refObject, MDRChangeListener mDRChangeListener) {
        MdrChangeListenerHelper.addMdrChangeListener(refObject, mDRChangeListener);
    }

    public static void removeMDRListener(RefObject refObject, MDRChangeListener mDRChangeListener) {
        MdrChangeListenerHelper.addMdrChangeListener(refObject, mDRChangeListener);
    }

    public static DiCommandFactory getCommandDiFactory() {
        return PoseidonProjectConnector.getCurrentProject().getDiCommandFactory();
    }

    public static void saveProject(String string) {
        PoseidonProject poseidonProject = PoseidonProjectConnector.getCurrentProject();
        if (poseidonProject != null) {
            ActionSaveProject actionSaveProject = new ActionSaveProject((Project)poseidonProject);
            A.info((Object)("Save project to " + string));
            actionSaveProject.trySave(string);
        }
    }

    public static void exportXmi() {
        PoseidonProject poseidonProject = PoseidonProjectConnector.getCurrentProject();
        if (poseidonProject != null) {
            ActionExportProjectToXmi actionExportProjectToXmi = new ActionExportProjectToXmi((Project)poseidonProject);
            A.info((Object)"export project xmi");
            actionExportProjectToXmi.doExport();
        }
    }
}

