/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.poseidon.ui;

import com.gentleware.openapi.jboogie.GlobalAction;
import com.gentleware.openapi.swingx.Localizer;
import com.gentleware.openapi.swingx.ResourceId;
import com.gentleware.openapi.util.Files;
import com.gentleware.poseidon.jboogie.PoseidonApplicationState;
import com.gentleware.poseidon.kernel.PoseidonProject;
import com.gentleware.poseidon.merging.ProjectReaderWriter;
import com.gentleware.poseidon.merging.ProjectReaderWriterManager;
import com.gentleware.poseidon.openapi.PoseidonUIConnector;
import com.gentleware.poseidon.ui.MenuResourceBundle;
import com.gentleware.poseidon.ui.a;
import com.gentleware.poseidon.util.FileFilters;
import com.gentleware.swingx.ProgressDialog;
import com.gentleware.swingx.SuffixFileFilter;
import com.gentleware.swingx.SwingWorker;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.zip.ZipFile;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class ActionImportProject
extends GlobalAction {
    private static final Logger G = Logger.getLogger((String)"com.gentleware.poseidon.ui.ActionImportProject");

    public ActionImportProject() {
        super(MenuResourceBundle.ImportProject);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        PoseidonApplicationState poseidonApplicationState = PoseidonApplicationState.getInstance();
        Frame frame = PoseidonUIConnector.getApplicationWindow();
        final PoseidonProject poseidonProject = poseidonApplicationState.getCurrentProject();
        poseidonProject.updateProjectBeforeAction();
        try {
            String string = PoseidonApplicationState.getLastImportDirectory();
            JFileChooser jFileChooser = new JFileChooser(string);
            SuffixFileFilter suffixFileFilter = FileFilters.getFilter("zuml");
            jFileChooser.setFileSelectionMode(2);
            jFileChooser.setDialogTitle(Localizer.localize((ResourceId)MenuResourceBundle.ImportProject));
            jFileChooser.addChoosableFileFilter((FileFilter)suffixFileFilter);
            jFileChooser.addChoosableFileFilter((FileFilter)FileFilters.getFilter("proj3"));
            jFileChooser.addChoosableFileFilter((FileFilter)FileFilters.getFilter("zargo"));
            jFileChooser.addChoosableFileFilter((FileFilter)FileFilters.getFilter("xmi"));
            jFileChooser.removeChoosableFileFilter(jFileChooser.getAcceptAllFileFilter());
            jFileChooser.setFileFilter((FileFilter)suffixFileFilter);
            jFileChooser.setAccessory(a.A());
            Dimension dimension = jFileChooser.getPreferredSize();
            dimension.width += 100;
            jFileChooser.setPreferredSize(dimension);
            int n2 = jFileChooser.showOpenDialog(frame);
            if (n2 == 0) {
                File file = jFileChooser.getSelectedFile();
                final FileFilter fileFilter = jFileChooser.getFileFilter();
                if (file != null) {
                    final ProgressDialog progressDialog = new ProgressDialog(PoseidonUIConnector.getApplicationWindow(), MenuResourceBundle.ImportProject);
                    int n3 = file.getName().endsWith(".zuml") ? new ZipFile(file).size() : 10;
                    String string2 = file.getParent();
                    PoseidonApplicationState.setLastImportDirectory(string2);
                    final URL uRL = Files.toUrl((File)file);
                    SwingWorker swingWorker = new SwingWorker("import-project"){

                        public Object construct() {
                            G.debug((Object)("current project = " + poseidonProject));
                            ProjectReaderWriter projectReaderWriter = ProjectReaderWriterManager.getInstance().getProjectReaderWriter(fileFilter.toString());
                            if (projectReaderWriter != null) {
                                projectReaderWriter.mergeProjects(poseidonProject, uRL, progressDialog);
                                poseidonProject.getLayoutValidator().validate(null);
                            }
                            return poseidonProject;
                        }

                        public void finished() {
                            PoseidonUIConnector.showStatus("Imported " + uRL.toString());
                            PoseidonUIConnector.getApplicationWindow().setCursor(Cursor.getPredefinedCursor(0));
                            progressDialog.hideProgressDialog();
                        }
                    };
                    if (uRL != null) {
                        swingWorker.start();
                        progressDialog.showProgressDialog(Localizer.localize((ResourceId)MenuResourceBundle.ImportFrom) + file.toString(), (Component)frame, n3 + 1);
                    }
                }
            }
        }
        catch (IOException iOException) {
            G.warn((Object)"got an IOException in ActionImportProject", (Throwable)iOException);
        }
    }
}

