/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.poseidon.ui;

import com.gentleware.jboogie.model_management.JBoogieTransferable;
import com.gentleware.openapi.configuration.Services;
import com.gentleware.openapi.jboogie.GlobalAction;
import com.gentleware.openapi.swingx.Localizer;
import com.gentleware.openapi.swingx.ResourceId;
import com.gentleware.poseidon.jboogie.PoseidonApplicationState;
import com.gentleware.poseidon.openapi.PoseidonUIConnector;
import com.gentleware.poseidon.ui.MenuResourceBundle;
import com.gentleware.poseidon.util.FileFilters;
import com.gentleware.poseidon.util.PoseidonUtils;
import com.gentleware.poseidon.util.UmlFunctions;
import com.gentleware.swingx.SuffixFileFilter;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class ActionOpenProject
extends GlobalAction {
    public static final String separator = System.getProperty("file.separator");

    public ActionOpenProject() {
        super(MenuResourceBundle.OpenProject);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (PoseidonUtils.checkProjectSaved()) {
            this.B();
        }
    }

    private void B() {
        int n2;
        String string = Services.getInstance().getConfiguration().getString("poseidon/default/project/dir");
        if ("".equals(string)) {
            string = PoseidonApplicationState.getLastProjectDirectory();
        }
        JFileChooser jFileChooser = string == null ? new JFileChooser() : new JFileChooser(string);
        jFileChooser.setName("OpenProject");
        jFileChooser.setDialogTitle(Localizer.localize((ResourceId)MenuResourceBundle.OpenProjectTitle));
        SuffixFileFilter suffixFileFilter = FileFilters.getFilter("zuml");
        jFileChooser.addChoosableFileFilter((FileFilter)suffixFileFilter);
        jFileChooser.addChoosableFileFilter((FileFilter)FileFilters.getFilter("zargo"));
        jFileChooser.addChoosableFileFilter((FileFilter)FileFilters.getFilter("proj3"));
        jFileChooser.addChoosableFileFilter((FileFilter)FileFilters.getFilter("xmi"));
        jFileChooser.removeChoosableFileFilter(jFileChooser.getAcceptAllFileFilter());
        jFileChooser.setFileFilter((FileFilter)suffixFileFilter);
        Dimension dimension = jFileChooser.getPreferredSize();
        if (dimension.height <= 400) {
            dimension.height += 200;
            jFileChooser.setPreferredSize(dimension);
        }
        if ((n2 = jFileChooser.showOpenDialog(PoseidonUIConnector.getApplicationWindow())) == 0) {
            JBoogieTransferable jBoogieTransferable = PoseidonApplicationState.getInstance().getCurrentProject().createTransferable(null);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents((Transferable)jBoogieTransferable, (ClipboardOwner)jBoogieTransferable);
            File file = jFileChooser.getSelectedFile();
            UmlFunctions.openProjectFile(file);
            PoseidonUIConnector.getApplicationWindow().validate();
        }
    }
}

