/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.poseidon.ui;

import com.gentleware.jboogie.kernel.TargetManager;
import com.gentleware.jboogie.ui.DiagramPanel;
import com.gentleware.jboogie.util.JBoogieUtils;
import com.gentleware.jboogie.util.RenderingQuality;
import com.gentleware.jboogie.util.graphicswriter.GraphicsWriter;
import com.gentleware.openapi.configuration.Services;
import com.gentleware.openapi.jboogie.Project;
import com.gentleware.openapi.jboogie.ProjectAction;
import com.gentleware.openapi.jboogie.Target;
import com.gentleware.openapi.swingx.Localizer;
import com.gentleware.openapi.swingx.ResourceId;
import com.gentleware.openapi.util.Files;
import com.gentleware.openapi.util.Utils;
import com.gentleware.poseidon.jboogie.PoseidonApplicationState;
import com.gentleware.poseidon.kernel.PoseidonProject;
import com.gentleware.poseidon.openapi.PoseidonUIConnector;
import com.gentleware.poseidon.ui.CoreResourceBundle;
import com.gentleware.poseidon.ui.FileChooserFixer;
import com.gentleware.poseidon.ui.MenuResourceBundle;
import com.gentleware.poseidon.ui.ProjectPanel;
import edu.umd.cs.piccolo.PCanvas;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import javax.jmi.reflect.RefObject;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;
import org.netbeans.jmiimpl.omg.uml2.diagraminterchange.DiagramImpl;
import org.omg.uml2.diagraminterchange.Diagram;

public class ActionSaveGraphics
extends ProjectAction {
    private static final Logger I = Logger.getLogger((String)"com.gentleware.poseidon.ui.ActionSaveGraphics");
    private JFileChooser J;

    public ActionSaveGraphics(Project project) {
        super(project, MenuResourceBundle.SaveGraphics);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.B();
        this.trySave(false);
    }

    private void B() {
        TargetManager targetManager = this.getProject().getTargetManager();
        Diagram diagram = targetManager.getActiveDiagram();
        targetManager.setSelectedElement((RefObject)diagram);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean trySave(boolean bl) {
        block19: {
            PoseidonProject poseidonProject = (PoseidonProject)this.getProject();
            Diagram diagram = poseidonProject.getTargetManager().getTarget().getActiveDiagram();
            if (diagram != null) {
                String string = diagram.getName();
                string = Utils.stripJunk((String)string);
                Frame frame = PoseidonUIConnector.getApplicationWindow();
                ProjectPanel projectPanel = ProjectPanel.getCurrentPanel();
                try {
                    int n2;
                    Object object;
                    GraphicsWriter.GraphicsFileFilter graphicsFileFilter;
                    Object object2;
                    GraphicsWriter[] graphicsWriterArray;
                    String string2 = PoseidonApplicationState.getLastGraphicsDirectory();
                    try {
                        if (string2 == null && poseidonProject != null && poseidonProject.getUrl() != null && poseidonProject.getUrl().getFile().length() > 0 && !(graphicsWriterArray = poseidonProject.getUrl().getFile()).startsWith("/FILE1/+/")) {
                            string2 = graphicsWriterArray;
                        }
                        this.J = new JFileChooser(string2);
                        new FileChooserFixer(this.J);
                        this.J.setAcceptAllFileFilterUsed(false);
                    }
                    catch (Exception exception) {
                        I.error((Object)"exception in opening JFileChooser", (Throwable)exception);
                    }
                    if (this.J == null) {
                        this.J = new JFileChooser();
                        new FileChooserFixer(this.J);
                        this.J.setAcceptAllFileFilterUsed(false);
                    }
                    this.J.setDialogTitle("Save Diagram as Graphics: " + string);
                    graphicsWriterArray = GraphicsWriter.getAll();
                    for (int i2 = 0; i2 < graphicsWriterArray.length; ++i2) {
                        object2 = graphicsWriterArray[i2];
                        graphicsFileFilter = object2.getFileChooserFilter();
                        this.J.addChoosableFileFilter((FileFilter)graphicsFileFilter);
                    }
                    String string3 = Services.getInstance().getConfiguration().get("poseidon/export/format");
                    if (string3 != null && (object2 = GraphicsWriter.get((String)string3)) != null) {
                        graphicsFileFilter = object2.getFileChooserFilter();
                        this.J.setFileFilter((FileFilter)graphicsFileFilter);
                    }
                    object2 = new File(string2, string);
                    this.J.setSelectedFile((File)object2);
                    this.J.addPropertyChangeListener(new PropertyChangeListener(){

                        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                            int n2;
                            String string;
                            File file;
                            String string2 = propertyChangeEvent.getPropertyName();
                            if (string2.equals("SelectedFileChangedProperty") && (file = ActionSaveGraphics.this.J.getSelectedFile()) != null && (string = file.getName()) != null && (n2 = string.lastIndexOf(46)) > -1) {
                                String string3 = string.substring(n2 + 1, string.length());
                                for (int i2 = 0; i2 < graphicsWriterArray.length; ++i2) {
                                    GraphicsWriter graphicsWriter = graphicsWriterArray[i2];
                                    String string4 = graphicsWriter.getDefaultFileSuffix();
                                    if (!string4.equals(string3)) continue;
                                    GraphicsWriter.GraphicsFileFilter graphicsFileFilter = graphicsWriter.getFileChooserFilter();
                                    ActionSaveGraphics.this.J.setFileFilter((FileFilter)graphicsFileFilter);
                                }
                            }
                        }
                    });
                    int n3 = this.J.showSaveDialog(frame);
                    if (n3 != 0) break block19;
                    File file = this.J.getSelectedFile();
                    GraphicsWriter.GraphicsFileFilter graphicsFileFilter2 = (GraphicsWriter.GraphicsFileFilter)this.J.getFileFilter();
                    GraphicsWriter graphicsWriter = graphicsFileFilter2.getWriter();
                    Services.getInstance().getConfiguration().put("poseidon/export/format", graphicsWriter.getFormatName());
                    if (file == null) break block19;
                    String string4 = file.getParent();
                    String string5 = file.getName();
                    PoseidonApplicationState.setLastGraphicsDirectory(string4);
                    String string6 = Files.getSuffix((String)string5);
                    if (!graphicsWriter.isFileSuffix(string6)) {
                        object = graphicsWriter.getDefaultFileSuffix();
                        string5 = string5 + "." + (String)object;
                        file = new File(string4, string5);
                    }
                    if (!string4.endsWith(File.separator)) {
                        string4 = string4 + File.separator;
                    }
                    PoseidonUIConnector.showStatus("Writing " + string4 + string5 + "...");
                    if (file.exists() && !bl && (n2 = JBoogieUtils.showConfirmDialog((Component)frame, (Object)(object = "Overwrite " + string4 + string5), (String)object, (int)0)) == 1) {
                        return false;
                    }
                    object = new BufferedOutputStream(new FileOutputStream(file), 8192);
                    DiagramPanel diagramPanel = projectPanel.getCurrentDiagramPanel();
                    try {
                        DiagramImpl diagramImpl = diagramPanel.getDiagram();
                        PCanvas pCanvas = JBoogieUtils.getExportCanvas((Diagram)diagramImpl, (RenderingQuality)RenderingQuality.GRAPHICS_EXPORT, (Project)this.getProject(), (int)10);
                        graphicsWriter.write((OutputStream)object, pCanvas);
                        JBoogieUtils.clearExportCanvas((PCanvas)pCanvas);
                        PoseidonUIConnector.showStatus("Wrote " + string4 + string5);
                    }
                    catch (GraphicsWriter.WriteException writeException) {
                        String string7 = Localizer.localize((ResourceId)CoreResourceBundle.GraphicsWriteExceptionText);
                        String string8 = writeException.getMessage();
                        String string9 = MessageFormat.format(string7, string4 + string5, string8);
                        JBoogieUtils.showMessageDialog((Component)frame, (Object)string9, (String)Localizer.localize((ResourceId)CoreResourceBundle.GraphicsWriteExceptionTitle), (int)0);
                    }
                    finally {
                        ((OutputStream)object).close();
                    }
                    return true;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    I.error((Object)"got a FileNotFoundException", (Throwable)fileNotFoundException);
                }
                catch (IOException iOException) {
                    I.debug((Object)"got an IOException", (Throwable)iOException);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    String string10 = "Out of memory! Please increase the memory given to Poseidon by using the batch/shell-script provided in the bin-directory, and increasing the parameter -Xmx96m to something bigger, for example to -Xmx192m.";
                    I.error((Object)"Out of memory! Please increase the memory given to Poseidon by using the batch/shell-script provided in the bin-directory, and increasing the parameter -Xmx96m to something bigger, for example to -Xmx192m.");
                    JBoogieUtils.showMessageFrame((Frame)frame, (String)"Out of memory! Please increase the memory given to Poseidon by using the batch/shell-script provided in the bin-directory, and increasing the parameter -Xmx96m to something bigger, for example to -Xmx192m.", (ResourceId)MenuResourceBundle.OutOfMemory, (boolean)false);
                }
            }
        }
        return false;
    }

    public void updateEnabled() {
        TargetManager targetManager = this.getProject().getTargetManager();
        Target target = targetManager.getTarget();
        DiagramImpl diagramImpl = (DiagramImpl)target.getActiveDiagram();
        this.setEnabled(diagramImpl != null);
    }
}

